"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var SerialAPIStartedRequest_exports = {};
__export(SerialAPIStartedRequest_exports, {
  SerialAPIStartedRequest: () => SerialAPIStartedRequest,
  SerialAPIWakeUpReason: () => SerialAPIWakeUpReason
});
module.exports = __toCommonJS(SerialAPIStartedRequest_exports);
var import_core = require("@zwave-js/core");
var import_serial = require("@zwave-js/serial");
var import_shared = require("@zwave-js/shared");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var SerialAPIWakeUpReason;
(function(SerialAPIWakeUpReason2) {
  SerialAPIWakeUpReason2[SerialAPIWakeUpReason2["Reset"] = 0] = "Reset";
  SerialAPIWakeUpReason2[SerialAPIWakeUpReason2["WakeUpTimer"] = 1] = "WakeUpTimer";
  SerialAPIWakeUpReason2[SerialAPIWakeUpReason2["WakeUpBeam"] = 2] = "WakeUpBeam";
  SerialAPIWakeUpReason2[SerialAPIWakeUpReason2["WatchdogReset"] = 3] = "WatchdogReset";
  SerialAPIWakeUpReason2[SerialAPIWakeUpReason2["ExternalInterrupt"] = 4] = "ExternalInterrupt";
  SerialAPIWakeUpReason2[SerialAPIWakeUpReason2["PowerUp"] = 5] = "PowerUp";
  SerialAPIWakeUpReason2[SerialAPIWakeUpReason2["USBSuspend"] = 6] = "USBSuspend";
  SerialAPIWakeUpReason2[SerialAPIWakeUpReason2["SoftwareReset"] = 7] = "SoftwareReset";
  SerialAPIWakeUpReason2[SerialAPIWakeUpReason2["EmergencyWatchdogReset"] = 8] = "EmergencyWatchdogReset";
  SerialAPIWakeUpReason2[SerialAPIWakeUpReason2["BrownoutCircuit"] = 9] = "BrownoutCircuit";
  SerialAPIWakeUpReason2[SerialAPIWakeUpReason2["Unknown"] = 255] = "Unknown";
})(SerialAPIWakeUpReason || (SerialAPIWakeUpReason = {}));
let SerialAPIStartedRequest = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Request, import_serial.FunctionType.SerialAPIStarted), (0, import_serial.priority)(import_core.MessagePriority.Normal)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var SerialAPIStartedRequest2 = class extends _classSuper {
    static {
      __name(this, "SerialAPIStartedRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPIStartedRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.wakeUpReason = options.wakeUpReason;
      this.watchdogEnabled = options.watchdogEnabled;
      this.isListening = options.isListening;
      this.genericDeviceClass = options.genericDeviceClass;
      this.specificDeviceClass = options.specificDeviceClass;
      this.supportedCCs = options.supportedCCs;
      this.controlledCCs = options.controlledCCs;
      this.supportsLongRange = options.supportsLongRange;
    }
    static from(raw) {
      const wakeUpReason = raw.payload[0];
      const watchdogEnabled = raw.payload[1] === 1;
      const deviceOption = raw.payload[2];
      const isListening = !!(deviceOption & 128);
      const genericDeviceClass = raw.payload[3];
      const specificDeviceClass = raw.payload[4];
      const numCCBytes = raw.payload[5];
      const ccBytes = raw.payload.subarray(6, 6 + numCCBytes);
      const ccList = (0, import_core.parseCCList)(ccBytes);
      const supportedCCs = ccList.supportedCCs;
      const controlledCCs = ccList.controlledCCs;
      let supportsLongRange = false;
      if (raw.payload.length >= 6 + numCCBytes + 1) {
        const protocols = raw.payload[6 + numCCBytes];
        supportsLongRange = !!(protocols & 1);
      }
      return new this({
        wakeUpReason,
        watchdogEnabled,
        isListening,
        genericDeviceClass,
        specificDeviceClass,
        supportedCCs,
        controlledCCs,
        supportsLongRange
      });
    }
    wakeUpReason;
    watchdogEnabled;
    genericDeviceClass;
    specificDeviceClass;
    /** Whether this node is always listening or not */
    isListening;
    supportedCCs;
    controlledCCs;
    supportsLongRange = false;
    serialize(ctx) {
      const ccList = (0, import_core.encodeCCList)(this.supportedCCs, this.controlledCCs);
      const numCCBytes = ccList.length;
      this.payload = new import_shared.Bytes(6 + numCCBytes + 1);
      this.payload[0] = this.wakeUpReason;
      this.payload[1] = this.watchdogEnabled ? 1 : 0;
      this.payload[2] = this.isListening ? 128 : 0;
      this.payload[3] = this.genericDeviceClass;
      this.payload[4] = this.specificDeviceClass;
      this.payload[5] = numCCBytes;
      this.payload.set(ccList, 6);
      this.payload[6 + numCCBytes] = this.supportsLongRange ? 1 : 0;
      return super.serialize(ctx);
    }
    toLogEntry() {
      return {
        ...super.toLogEntry(),
        message: {
          "wake up reason": (0, import_shared.getEnumMemberName)(SerialAPIWakeUpReason, this.wakeUpReason),
          "watchdog enabled": this.watchdogEnabled,
          "generic device class": (0, import_shared.num2hex)(this.genericDeviceClass),
          "specific device class": (0, import_shared.num2hex)(this.specificDeviceClass),
          "always listening": this.isListening,
          // Not sure why this information is needed here. At the very least it stretches the log
          // "supported CCs": this.supportedCCs
          // 	.map((cc) => `\n· ${getCCName(cc)}`)
          // 	.join(""),
          // "controlled CCs": this.controlledCCs
          // 	.map((cc) => `\n· ${getCCName(cc)}`)
          // 	.join(""),
          "supports Long Range": this.supportsLongRange
        }
      };
    }
  };
  return SerialAPIStartedRequest2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  SerialAPIStartedRequest,
  SerialAPIWakeUpReason
});
//# sourceMappingURL=SerialAPIStartedRequest.js.map
