import { type ProtocolType } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageParsingContext, type MessageRaw } from "@zwave-js/serial";
export declare class GetProtocolVersionRequest extends Message {
}
export interface GetProtocolVersionResponseOptions {
    protocolType: ProtocolType;
    protocolVersion: string;
    applicationFrameworkBuildNumber?: number;
    gitCommitHash?: string;
}
export declare class GetProtocolVersionResponse extends Message {
    constructor(options: GetProtocolVersionResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): GetProtocolVersionResponse;
    readonly protocolType: ProtocolType;
    readonly protocolVersion: string;
    readonly applicationFrameworkBuildNumber?: number;
    readonly gitCommitHash?: string;
}
//# sourceMappingURL=GetProtocolVersionMessages.d.ts.map