"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var SerialAPISetupMessages_exports = {};
__export(SerialAPISetupMessages_exports, {
  SerialAPISetupCommand: () => SerialAPISetupCommand,
  SerialAPISetupRequest: () => SerialAPISetupRequest,
  SerialAPISetupResponse: () => SerialAPISetupResponse,
  SerialAPISetup_CommandUnsupportedResponse: () => SerialAPISetup_CommandUnsupportedResponse,
  SerialAPISetup_GetLongRangeMaximumPayloadSizeRequest: () => SerialAPISetup_GetLongRangeMaximumPayloadSizeRequest,
  SerialAPISetup_GetLongRangeMaximumPayloadSizeResponse: () => SerialAPISetup_GetLongRangeMaximumPayloadSizeResponse,
  SerialAPISetup_GetLongRangeMaximumTxPowerRequest: () => SerialAPISetup_GetLongRangeMaximumTxPowerRequest,
  SerialAPISetup_GetLongRangeMaximumTxPowerResponse: () => SerialAPISetup_GetLongRangeMaximumTxPowerResponse,
  SerialAPISetup_GetMaximumPayloadSizeRequest: () => SerialAPISetup_GetMaximumPayloadSizeRequest,
  SerialAPISetup_GetMaximumPayloadSizeResponse: () => SerialAPISetup_GetMaximumPayloadSizeResponse,
  SerialAPISetup_GetPowerlevel16BitRequest: () => SerialAPISetup_GetPowerlevel16BitRequest,
  SerialAPISetup_GetPowerlevel16BitResponse: () => SerialAPISetup_GetPowerlevel16BitResponse,
  SerialAPISetup_GetPowerlevelRequest: () => SerialAPISetup_GetPowerlevelRequest,
  SerialAPISetup_GetPowerlevelResponse: () => SerialAPISetup_GetPowerlevelResponse,
  SerialAPISetup_GetRFRegionRequest: () => SerialAPISetup_GetRFRegionRequest,
  SerialAPISetup_GetRFRegionResponse: () => SerialAPISetup_GetRFRegionResponse,
  SerialAPISetup_GetRegionInfoRequest: () => SerialAPISetup_GetRegionInfoRequest,
  SerialAPISetup_GetRegionInfoResponse: () => SerialAPISetup_GetRegionInfoResponse,
  SerialAPISetup_GetSupportedCommandsRequest: () => SerialAPISetup_GetSupportedCommandsRequest,
  SerialAPISetup_GetSupportedCommandsResponse: () => SerialAPISetup_GetSupportedCommandsResponse,
  SerialAPISetup_GetSupportedRegionsRequest: () => SerialAPISetup_GetSupportedRegionsRequest,
  SerialAPISetup_GetSupportedRegionsResponse: () => SerialAPISetup_GetSupportedRegionsResponse,
  SerialAPISetup_SetLongRangeMaximumTxPowerRequest: () => SerialAPISetup_SetLongRangeMaximumTxPowerRequest,
  SerialAPISetup_SetLongRangeMaximumTxPowerResponse: () => SerialAPISetup_SetLongRangeMaximumTxPowerResponse,
  SerialAPISetup_SetNodeIDTypeRequest: () => SerialAPISetup_SetNodeIDTypeRequest,
  SerialAPISetup_SetNodeIDTypeResponse: () => SerialAPISetup_SetNodeIDTypeResponse,
  SerialAPISetup_SetPowerlevel16BitRequest: () => SerialAPISetup_SetPowerlevel16BitRequest,
  SerialAPISetup_SetPowerlevel16BitResponse: () => SerialAPISetup_SetPowerlevel16BitResponse,
  SerialAPISetup_SetPowerlevelRequest: () => SerialAPISetup_SetPowerlevelRequest,
  SerialAPISetup_SetPowerlevelResponse: () => SerialAPISetup_SetPowerlevelResponse,
  SerialAPISetup_SetRFRegionRequest: () => SerialAPISetup_SetRFRegionRequest,
  SerialAPISetup_SetRFRegionResponse: () => SerialAPISetup_SetRFRegionResponse,
  SerialAPISetup_SetTXStatusReportRequest: () => SerialAPISetup_SetTXStatusReportRequest,
  SerialAPISetup_SetTXStatusReportResponse: () => SerialAPISetup_SetTXStatusReportResponse
});
module.exports = __toCommonJS(SerialAPISetupMessages_exports);
var import_core = require("@zwave-js/core");
var import_reflection = require("@zwave-js/core/reflection");
var import_serial = require("@zwave-js/serial");
var import_shared = require("@zwave-js/shared");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var SerialAPISetupCommand;
(function(SerialAPISetupCommand2) {
  SerialAPISetupCommand2[SerialAPISetupCommand2["Unsupported"] = 0] = "Unsupported";
  SerialAPISetupCommand2[SerialAPISetupCommand2["GetSupportedCommands"] = 1] = "GetSupportedCommands";
  SerialAPISetupCommand2[SerialAPISetupCommand2["SetTxStatusReport"] = 2] = "SetTxStatusReport";
  SerialAPISetupCommand2[SerialAPISetupCommand2["SetLongRangeMaximumTxPower"] = 3] = "SetLongRangeMaximumTxPower";
  SerialAPISetupCommand2[SerialAPISetupCommand2["SetPowerlevel"] = 4] = "SetPowerlevel";
  SerialAPISetupCommand2[SerialAPISetupCommand2["GetLongRangeMaximumTxPower"] = 5] = "GetLongRangeMaximumTxPower";
  SerialAPISetupCommand2[SerialAPISetupCommand2["GetPowerlevel"] = 8] = "GetPowerlevel";
  SerialAPISetupCommand2[SerialAPISetupCommand2["GetMaximumPayloadSize"] = 16] = "GetMaximumPayloadSize";
  SerialAPISetupCommand2[SerialAPISetupCommand2["GetRFRegion"] = 32] = "GetRFRegion";
  SerialAPISetupCommand2[SerialAPISetupCommand2["SetRFRegion"] = 64] = "SetRFRegion";
  SerialAPISetupCommand2[SerialAPISetupCommand2["SetNodeIDType"] = 128] = "SetNodeIDType";
  SerialAPISetupCommand2[SerialAPISetupCommand2["GetLongRangeMaximumPayloadSize"] = 17] = "GetLongRangeMaximumPayloadSize";
  SerialAPISetupCommand2[SerialAPISetupCommand2["SetPowerlevel16Bit"] = 18] = "SetPowerlevel16Bit";
  SerialAPISetupCommand2[SerialAPISetupCommand2["GetPowerlevel16Bit"] = 19] = "GetPowerlevel16Bit";
  SerialAPISetupCommand2[SerialAPISetupCommand2["GetSupportedRegions"] = 21] = "GetSupportedRegions";
  SerialAPISetupCommand2[SerialAPISetupCommand2["GetRegionInfo"] = 22] = "GetRegionInfo";
})(SerialAPISetupCommand || (SerialAPISetupCommand = {}));
const { decorator: subCommandRequest, lookupConstructor: getSubCommandRequestConstructor, lookupValue: getSubCommandForRequest } = (0, import_reflection.createSimpleReflectionDecorator)({
  name: "subCommandRequest"
});
const { decorator: subCommandResponse, lookupConstructor: getSubCommandResponseConstructor, lookupValue: getSubCommandForResponse } = (0, import_reflection.createSimpleReflectionDecorator)({
  name: "subCommandResponse"
});
function testResponseForSerialAPISetupRequest(sent, received) {
  if (!(received instanceof SerialAPISetupResponse))
    return false;
  return sent.command === received.command;
}
__name(testResponseForSerialAPISetupRequest, "testResponseForSerialAPISetupRequest");
let SerialAPISetupRequest = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Request, import_serial.FunctionType.SerialAPISetup), (0, import_serial.priority)(import_core.MessagePriority.Controller), (0, import_serial.expectedResponse)(testResponseForSerialAPISetupRequest)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var SerialAPISetupRequest2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetupRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetupRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options = {}) {
      super(options);
      this.command = options.command ?? getSubCommandForRequest(this);
    }
    static from(raw, ctx) {
      const command = raw.payload[0];
      const payload = raw.payload.subarray(1);
      const CommandConstructor = getSubCommandRequestConstructor(command);
      if (CommandConstructor) {
        return CommandConstructor.from(raw.withPayload(payload), ctx);
      }
      const ret = new SerialAPISetupRequest2({
        command
      });
      ret.payload = payload;
      return ret;
    }
    command;
    serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.command]),
        this.payload
      ]);
      return super.serialize(ctx);
    }
    toLogEntry() {
      const message = {
        command: (0, import_shared.getEnumMemberName)(SerialAPISetupCommand, this.command)
      };
      if (this.payload.length > 0) {
        message.payload = `0x${this.payload.toString("hex")}`;
      }
      return {
        ...super.toLogEntry(),
        message
      };
    }
  };
  return SerialAPISetupRequest2 = _classThis;
})();
let SerialAPISetupResponse = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Response, import_serial.FunctionType.SerialAPISetup)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var SerialAPISetupResponse2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetupResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetupResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.command = options.command ?? getSubCommandForResponse(this);
    }
    static from(raw, ctx) {
      const command = raw.payload[0];
      const payload = raw.payload.subarray(1);
      const CommandConstructor = getSubCommandResponseConstructor(command);
      if (CommandConstructor) {
        return CommandConstructor.from(raw.withPayload(payload), ctx);
      }
      const ret = new SerialAPISetupResponse2({
        command
      });
      ret.payload = payload;
      return ret;
    }
    command;
    toLogEntry() {
      const message = {
        command: (0, import_shared.getEnumMemberName)(SerialAPISetupCommand, this.command)
      };
      if (this.payload.length > 0) {
        message.payload = `0x${this.payload.toString("hex")}`;
      }
      return {
        ...super.toLogEntry(),
        message
      };
    }
  };
  return SerialAPISetupResponse2 = _classThis;
})();
let SerialAPISetup_CommandUnsupportedResponse = (() => {
  let _classDecorators = [subCommandResponse(0)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupResponse;
  var SerialAPISetup_CommandUnsupportedResponse2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_CommandUnsupportedResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_CommandUnsupportedResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.command = options.command;
    }
    static from(raw, _ctx) {
      const command = raw.payload[0];
      return new this({
        command
      });
    }
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = ret.message;
      message.error = "unsupported command";
      message.command = (0, import_shared.getEnumMemberName)(SerialAPISetupCommand, this.command);
      delete message.payload;
      return ret;
    }
  };
  return SerialAPISetup_CommandUnsupportedResponse2 = _classThis;
})();
let SerialAPISetup_GetSupportedCommandsRequest = (() => {
  let _classDecorators = [subCommandRequest(SerialAPISetupCommand.GetSupportedCommands)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupRequest;
  var SerialAPISetup_GetSupportedCommandsRequest2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_GetSupportedCommandsRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_GetSupportedCommandsRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return SerialAPISetup_GetSupportedCommandsRequest2 = _classThis;
})();
let SerialAPISetup_GetSupportedCommandsResponse = (() => {
  let _classDecorators = [subCommandResponse(SerialAPISetupCommand.GetSupportedCommands)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupResponse;
  var SerialAPISetup_GetSupportedCommandsResponse2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_GetSupportedCommandsResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_GetSupportedCommandsResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.supportedCommands = options.supportedCommands;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      let supportedCommands;
      if (raw.payload.length > 1) {
        supportedCommands = (0, import_core.parseBitMask)(
          raw.payload.subarray(1),
          // According to the Host API specification, the first bit (bit 0) should be GetSupportedCommands
          // However, in Z-Wave SDK < 7.19.1, the entire bitmask is shifted by 1 bit and
          // GetSupportedCommands is encoded in the second bit (bit 1)
          (0, import_core.sdkVersionLt)(ctx.sdkVersion, "7.19.1") ? SerialAPISetupCommand.Unsupported : SerialAPISetupCommand.GetSupportedCommands
        );
      } else {
        supportedCommands = [];
        for (const cmd of [
          SerialAPISetupCommand.GetSupportedCommands,
          SerialAPISetupCommand.SetTxStatusReport,
          SerialAPISetupCommand.SetPowerlevel,
          SerialAPISetupCommand.GetPowerlevel,
          SerialAPISetupCommand.GetMaximumPayloadSize,
          SerialAPISetupCommand.GetRFRegion,
          SerialAPISetupCommand.SetRFRegion,
          SerialAPISetupCommand.SetNodeIDType
        ]) {
          if (!!(raw.payload[0] & cmd))
            supportedCommands.push(cmd);
        }
      }
      if (!supportedCommands.includes(SerialAPISetupCommand.GetSupportedCommands)) {
        supportedCommands.unshift(SerialAPISetupCommand.GetSupportedCommands);
      }
      return new this({
        supportedCommands
      });
    }
    supportedCommands;
  };
  return SerialAPISetup_GetSupportedCommandsResponse2 = _classThis;
})();
let SerialAPISetup_SetTXStatusReportRequest = (() => {
  let _classDecorators = [subCommandRequest(SerialAPISetupCommand.SetTxStatusReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupRequest;
  var SerialAPISetup_SetTXStatusReportRequest2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_SetTXStatusReportRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_SetTXStatusReportRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.enabled = options.enabled;
    }
    static from(raw, _ctx) {
      const enabled = raw.payload[0] === 255;
      return new this({
        enabled
      });
    }
    enabled;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.enabled ? 255 : 0]);
      return super.serialize(ctx);
    }
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = ret.message;
      message.enabled = this.enabled;
      delete message.payload;
      return ret;
    }
  };
  return SerialAPISetup_SetTXStatusReportRequest2 = _classThis;
})();
let SerialAPISetup_SetTXStatusReportResponse = (() => {
  let _classDecorators = [subCommandResponse(SerialAPISetupCommand.SetTxStatusReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupResponse;
  var SerialAPISetup_SetTXStatusReportResponse2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_SetTXStatusReportResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_SetTXStatusReportResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.success = options.success;
    }
    static from(raw, _ctx) {
      const success = raw.payload[0] !== 0;
      return new this({
        success
      });
    }
    isOK() {
      return this.success;
    }
    success;
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = ret.message;
      message.success = this.success;
      delete message.payload;
      return ret;
    }
  };
  return SerialAPISetup_SetTXStatusReportResponse2 = _classThis;
})();
let SerialAPISetup_SetNodeIDTypeRequest = (() => {
  let _classDecorators = [subCommandRequest(SerialAPISetupCommand.SetNodeIDType)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupRequest;
  var SerialAPISetup_SetNodeIDTypeRequest2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_SetNodeIDTypeRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_SetNodeIDTypeRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.nodeIdType = options.nodeIdType;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    nodeIdType;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.nodeIdType]);
      return super.serialize(ctx);
    }
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = ret.message;
      message["node ID type"] = this.nodeIdType === import_core.NodeIDType.Short ? "8 bit" : "16 bit";
      delete message.payload;
      return ret;
    }
  };
  return SerialAPISetup_SetNodeIDTypeRequest2 = _classThis;
})();
let SerialAPISetup_SetNodeIDTypeResponse = (() => {
  let _classDecorators = [subCommandResponse(SerialAPISetupCommand.SetNodeIDType)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupResponse;
  var SerialAPISetup_SetNodeIDTypeResponse2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_SetNodeIDTypeResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_SetNodeIDTypeResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.success = options.success;
    }
    static from(raw, _ctx) {
      const success = raw.payload[0] !== 0;
      return new this({
        success
      });
    }
    isOK() {
      return this.success;
    }
    success;
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = ret.message;
      message.success = this.success;
      delete message.payload;
      return ret;
    }
  };
  return SerialAPISetup_SetNodeIDTypeResponse2 = _classThis;
})();
let SerialAPISetup_GetRFRegionRequest = (() => {
  let _classDecorators = [subCommandRequest(SerialAPISetupCommand.GetRFRegion)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupRequest;
  var SerialAPISetup_GetRFRegionRequest2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_GetRFRegionRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_GetRFRegionRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return SerialAPISetup_GetRFRegionRequest2 = _classThis;
})();
let SerialAPISetup_GetRFRegionResponse = (() => {
  let _classDecorators = [subCommandResponse(SerialAPISetupCommand.GetRFRegion)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupResponse;
  var SerialAPISetup_GetRFRegionResponse2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_GetRFRegionResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_GetRFRegionResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.region = options.region;
    }
    static from(raw, _ctx) {
      const region = raw.payload[0];
      return new this({
        region
      });
    }
    region;
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = ret.message;
      message.region = (0, import_shared.getEnumMemberName)(import_core.RFRegion, this.region);
      delete message.payload;
      return ret;
    }
  };
  return SerialAPISetup_GetRFRegionResponse2 = _classThis;
})();
let SerialAPISetup_SetRFRegionRequest = (() => {
  let _classDecorators = [subCommandRequest(SerialAPISetupCommand.SetRFRegion)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupRequest;
  var SerialAPISetup_SetRFRegionRequest2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_SetRFRegionRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_SetRFRegionRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.region = options.region;
    }
    static from(raw, _ctx) {
      const region = raw.payload[0];
      return new this({
        region
      });
    }
    region;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.region]);
      return super.serialize(ctx);
    }
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = ret.message;
      message.region = (0, import_shared.getEnumMemberName)(import_core.RFRegion, this.region);
      delete message.payload;
      return ret;
    }
  };
  return SerialAPISetup_SetRFRegionRequest2 = _classThis;
})();
let SerialAPISetup_SetRFRegionResponse = (() => {
  let _classDecorators = [subCommandResponse(SerialAPISetupCommand.SetRFRegion)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupResponse;
  var SerialAPISetup_SetRFRegionResponse2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_SetRFRegionResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_SetRFRegionResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.success = options.success;
    }
    static from(raw, _ctx) {
      const success = raw.payload[0] !== 0;
      return new this({
        success
      });
    }
    isOK() {
      return this.success;
    }
    success;
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = ret.message;
      message.success = this.success;
      delete message.payload;
      return ret;
    }
  };
  return SerialAPISetup_SetRFRegionResponse2 = _classThis;
})();
let SerialAPISetup_GetPowerlevelRequest = (() => {
  let _classDecorators = [subCommandRequest(SerialAPISetupCommand.GetPowerlevel)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupRequest;
  var SerialAPISetup_GetPowerlevelRequest2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_GetPowerlevelRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_GetPowerlevelRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return SerialAPISetup_GetPowerlevelRequest2 = _classThis;
})();
let SerialAPISetup_GetPowerlevelResponse = (() => {
  let _classDecorators = [subCommandResponse(SerialAPISetupCommand.GetPowerlevel)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupResponse;
  var SerialAPISetup_GetPowerlevelResponse2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_GetPowerlevelResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_GetPowerlevelResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.powerlevel = options.powerlevel;
      this.measured0dBm = options.measured0dBm;
    }
    static from(raw, _ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const powerlevel = raw.payload.readInt8(0) / 10;
      const measured0dBm = raw.payload.readInt8(1) / 10;
      return new this({
        powerlevel,
        measured0dBm
      });
    }
    /** The configured normal powerlevel in dBm */
    powerlevel;
    /** The measured output power in dBm for a normal output powerlevel of 0 */
    measured0dBm;
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = {
        ...ret.message,
        "normal powerlevel": `${this.powerlevel.toFixed(1)} dBm`,
        "output power at 0 dBm": `${this.measured0dBm.toFixed(1)} dBm`
      };
      delete message.payload;
      ret.message = message;
      return ret;
    }
  };
  return SerialAPISetup_GetPowerlevelResponse2 = _classThis;
})();
let SerialAPISetup_SetPowerlevelRequest = (() => {
  let _classDecorators = [subCommandRequest(SerialAPISetupCommand.SetPowerlevel)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupRequest;
  var SerialAPISetup_SetPowerlevelRequest2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_SetPowerlevelRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_SetPowerlevelRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if (options.powerlevel < -12.8 || options.powerlevel > 12.7) {
        throw new import_core.ZWaveError(`The normal powerlevel must be between -12.8 and +12.7 dBm`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      if (options.measured0dBm < -12.8 || options.measured0dBm > 12.7) {
        throw new import_core.ZWaveError(`The measured output power at 0 dBm must be between -12.8 and +12.7 dBm`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      this.powerlevel = options.powerlevel;
      this.measured0dBm = options.measured0dBm;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    powerlevel;
    measured0dBm;
    serialize(ctx) {
      this.payload = new import_shared.Bytes(2);
      this.payload.writeInt8(Math.round(this.powerlevel * 10), 0);
      this.payload.writeInt8(Math.round(this.measured0dBm * 10), 1);
      return super.serialize(ctx);
    }
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = {
        ...ret.message,
        "normal powerlevel": `${this.powerlevel.toFixed(1)} dBm`,
        "output power at 0 dBm": `${this.measured0dBm.toFixed(1)} dBm`
      };
      delete message.payload;
      ret.message = message;
      return ret;
    }
  };
  return SerialAPISetup_SetPowerlevelRequest2 = _classThis;
})();
let SerialAPISetup_SetPowerlevelResponse = (() => {
  let _classDecorators = [subCommandResponse(SerialAPISetupCommand.SetPowerlevel)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupResponse;
  var SerialAPISetup_SetPowerlevelResponse2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_SetPowerlevelResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_SetPowerlevelResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.success = options.success;
    }
    static from(raw, _ctx) {
      const success = raw.payload[0] !== 0;
      return new this({
        success
      });
    }
    isOK() {
      return this.success;
    }
    success;
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = ret.message;
      message.success = this.success;
      delete message.payload;
      return ret;
    }
  };
  return SerialAPISetup_SetPowerlevelResponse2 = _classThis;
})();
let SerialAPISetup_GetPowerlevel16BitRequest = (() => {
  let _classDecorators = [subCommandRequest(SerialAPISetupCommand.GetPowerlevel16Bit)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupRequest;
  var SerialAPISetup_GetPowerlevel16BitRequest2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_GetPowerlevel16BitRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_GetPowerlevel16BitRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return SerialAPISetup_GetPowerlevel16BitRequest2 = _classThis;
})();
let SerialAPISetup_GetPowerlevel16BitResponse = (() => {
  let _classDecorators = [subCommandResponse(SerialAPISetupCommand.GetPowerlevel16Bit)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupResponse;
  var SerialAPISetup_GetPowerlevel16BitResponse2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_GetPowerlevel16BitResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_GetPowerlevel16BitResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.powerlevel = options.powerlevel;
      this.measured0dBm = options.measured0dBm;
    }
    static from(raw, _ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 4);
      const powerlevel = raw.payload.readInt16BE(0) / 10;
      const measured0dBm = raw.payload.readInt16BE(2) / 10;
      return new this({
        powerlevel,
        measured0dBm
      });
    }
    /** The configured normal powerlevel in dBm */
    powerlevel;
    /** The measured output power in dBm for a normal output powerlevel of 0 */
    measured0dBm;
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = {
        ...ret.message,
        "normal powerlevel": `${this.powerlevel.toFixed(1)} dBm`,
        "output power at 0 dBm": `${this.measured0dBm.toFixed(1)} dBm`
      };
      delete message.payload;
      ret.message = message;
      return ret;
    }
  };
  return SerialAPISetup_GetPowerlevel16BitResponse2 = _classThis;
})();
let SerialAPISetup_SetPowerlevel16BitRequest = (() => {
  let _classDecorators = [subCommandRequest(SerialAPISetupCommand.SetPowerlevel16Bit)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupRequest;
  var SerialAPISetup_SetPowerlevel16BitRequest2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_SetPowerlevel16BitRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_SetPowerlevel16BitRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if (options.powerlevel < -10 || options.powerlevel > 20) {
        throw new import_core.ZWaveError(`The normal powerlevel must be between -10.0 and +20.0 dBm`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      if (options.measured0dBm < -10 || options.measured0dBm > 10) {
        throw new import_core.ZWaveError(`The measured output power at 0 dBm must be between -10.0 and +10.0 dBm`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      this.powerlevel = options.powerlevel;
      this.measured0dBm = options.measured0dBm;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    powerlevel;
    measured0dBm;
    serialize(ctx) {
      this.payload = new import_shared.Bytes(4);
      this.payload.writeInt16BE(Math.round(this.powerlevel * 10), 0);
      this.payload.writeInt16BE(Math.round(this.measured0dBm * 10), 2);
      return super.serialize(ctx);
    }
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = {
        ...ret.message,
        "normal powerlevel": `${this.powerlevel.toFixed(1)} dBm`,
        "output power at 0 dBm": `${this.measured0dBm.toFixed(1)} dBm`
      };
      delete message.payload;
      ret.message = message;
      return ret;
    }
  };
  return SerialAPISetup_SetPowerlevel16BitRequest2 = _classThis;
})();
let SerialAPISetup_SetPowerlevel16BitResponse = (() => {
  let _classDecorators = [subCommandResponse(SerialAPISetupCommand.SetPowerlevel16Bit)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupResponse;
  var SerialAPISetup_SetPowerlevel16BitResponse2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_SetPowerlevel16BitResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_SetPowerlevel16BitResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.success = options.success;
    }
    static from(raw, _ctx) {
      const success = raw.payload[0] !== 0;
      return new this({
        success
      });
    }
    isOK() {
      return this.success;
    }
    success;
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = ret.message;
      message.success = this.success;
      delete message.payload;
      return ret;
    }
  };
  return SerialAPISetup_SetPowerlevel16BitResponse2 = _classThis;
})();
let SerialAPISetup_GetLongRangeMaximumTxPowerRequest = (() => {
  let _classDecorators = [subCommandRequest(SerialAPISetupCommand.GetLongRangeMaximumTxPower)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupRequest;
  var SerialAPISetup_GetLongRangeMaximumTxPowerRequest2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_GetLongRangeMaximumTxPowerRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_GetLongRangeMaximumTxPowerRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return SerialAPISetup_GetLongRangeMaximumTxPowerRequest2 = _classThis;
})();
let SerialAPISetup_GetLongRangeMaximumTxPowerResponse = (() => {
  let _classDecorators = [subCommandResponse(SerialAPISetupCommand.GetLongRangeMaximumTxPower)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupResponse;
  var SerialAPISetup_GetLongRangeMaximumTxPowerResponse2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_GetLongRangeMaximumTxPowerResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_GetLongRangeMaximumTxPowerResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.limit = options.limit;
    }
    static from(raw, _ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const limit = raw.payload.readInt16BE(0) / 10;
      return new this({
        limit
      });
    }
    /** The maximum LR TX power in dBm */
    limit;
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = {
        ...ret.message,
        "max. TX power (LR)": `${this.limit.toFixed(1)} dBm`
      };
      delete message.payload;
      ret.message = message;
      return ret;
    }
  };
  return SerialAPISetup_GetLongRangeMaximumTxPowerResponse2 = _classThis;
})();
let SerialAPISetup_SetLongRangeMaximumTxPowerRequest = (() => {
  let _classDecorators = [subCommandRequest(SerialAPISetupCommand.SetLongRangeMaximumTxPower)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupRequest;
  var SerialAPISetup_SetLongRangeMaximumTxPowerRequest2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_SetLongRangeMaximumTxPowerRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_SetLongRangeMaximumTxPowerRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if (options.limit < -10 || options.limit > 20) {
        throw new import_core.ZWaveError(`The maximum LR TX power must be between -10.0 and +20.0 dBm`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      this.limit = options.limit;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    /** The maximum LR TX power in dBm */
    limit;
    serialize(ctx) {
      this.payload = new import_shared.Bytes(2);
      this.payload.writeInt16BE(Math.round(this.limit * 10), 0);
      return super.serialize(ctx);
    }
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = {
        ...ret.message,
        "max. TX power (LR)": `${this.limit.toFixed(1)} dBm`
      };
      delete message.payload;
      ret.message = message;
      return ret;
    }
  };
  return SerialAPISetup_SetLongRangeMaximumTxPowerRequest2 = _classThis;
})();
let SerialAPISetup_SetLongRangeMaximumTxPowerResponse = (() => {
  let _classDecorators = [subCommandResponse(SerialAPISetupCommand.SetLongRangeMaximumTxPower)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupResponse;
  var SerialAPISetup_SetLongRangeMaximumTxPowerResponse2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_SetLongRangeMaximumTxPowerResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_SetLongRangeMaximumTxPowerResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.success = options.success;
    }
    static from(raw, _ctx) {
      const success = raw.payload[0] !== 0;
      return new this({
        success
      });
    }
    isOK() {
      return this.success;
    }
    success;
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = ret.message;
      message.success = this.success;
      delete message.payload;
      return ret;
    }
  };
  return SerialAPISetup_SetLongRangeMaximumTxPowerResponse2 = _classThis;
})();
let SerialAPISetup_GetMaximumPayloadSizeRequest = (() => {
  let _classDecorators = [subCommandRequest(SerialAPISetupCommand.GetMaximumPayloadSize)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupRequest;
  var SerialAPISetup_GetMaximumPayloadSizeRequest2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_GetMaximumPayloadSizeRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_GetMaximumPayloadSizeRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return SerialAPISetup_GetMaximumPayloadSizeRequest2 = _classThis;
})();
let SerialAPISetup_GetMaximumPayloadSizeResponse = (() => {
  let _classDecorators = [subCommandResponse(SerialAPISetupCommand.GetMaximumPayloadSize)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupResponse;
  var SerialAPISetup_GetMaximumPayloadSizeResponse2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_GetMaximumPayloadSizeResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_GetMaximumPayloadSizeResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.maxPayloadSize = options.maxPayloadSize;
    }
    static from(raw, _ctx) {
      const maxPayloadSize = raw.payload[0];
      return new this({
        maxPayloadSize
      });
    }
    maxPayloadSize;
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = ret.message;
      message["maximum payload size"] = `${this.maxPayloadSize} bytes`;
      delete message.payload;
      return ret;
    }
  };
  return SerialAPISetup_GetMaximumPayloadSizeResponse2 = _classThis;
})();
let SerialAPISetup_GetLongRangeMaximumPayloadSizeRequest = (() => {
  let _classDecorators = [subCommandRequest(SerialAPISetupCommand.GetLongRangeMaximumPayloadSize)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupRequest;
  var SerialAPISetup_GetLongRangeMaximumPayloadSizeRequest2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_GetLongRangeMaximumPayloadSizeRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_GetLongRangeMaximumPayloadSizeRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return SerialAPISetup_GetLongRangeMaximumPayloadSizeRequest2 = _classThis;
})();
let SerialAPISetup_GetLongRangeMaximumPayloadSizeResponse = (() => {
  let _classDecorators = [subCommandResponse(SerialAPISetupCommand.GetLongRangeMaximumPayloadSize)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupResponse;
  var SerialAPISetup_GetLongRangeMaximumPayloadSizeResponse2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_GetLongRangeMaximumPayloadSizeResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_GetLongRangeMaximumPayloadSizeResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.maxPayloadSize = options.maxPayloadSize;
    }
    static from(raw, _ctx) {
      const maxPayloadSize = raw.payload[0];
      return new this({
        maxPayloadSize
      });
    }
    maxPayloadSize;
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = ret.message;
      message["maximum payload size"] = `${this.maxPayloadSize} bytes`;
      delete message.payload;
      return ret;
    }
  };
  return SerialAPISetup_GetLongRangeMaximumPayloadSizeResponse2 = _classThis;
})();
let SerialAPISetup_GetSupportedRegionsRequest = (() => {
  let _classDecorators = [subCommandRequest(SerialAPISetupCommand.GetSupportedRegions)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupRequest;
  var SerialAPISetup_GetSupportedRegionsRequest2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_GetSupportedRegionsRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_GetSupportedRegionsRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return SerialAPISetup_GetSupportedRegionsRequest2 = _classThis;
})();
let SerialAPISetup_GetSupportedRegionsResponse = (() => {
  let _classDecorators = [subCommandResponse(SerialAPISetupCommand.GetSupportedRegions)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupResponse;
  var SerialAPISetup_GetSupportedRegionsResponse2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_GetSupportedRegionsResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_GetSupportedRegionsResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.supportedRegions = options.supportedRegions;
    }
    static from(raw, _ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const numRegions = raw.payload[0];
      (0, import_core.validatePayload)(numRegions > 0, raw.payload.length >= 1 + numRegions);
      const supportedRegions = [
        ...raw.payload.subarray(1, 1 + numRegions)
      ];
      return new this({
        supportedRegions
      });
    }
    supportedRegions;
  };
  return SerialAPISetup_GetSupportedRegionsResponse2 = _classThis;
})();
let SerialAPISetup_GetRegionInfoRequest = (() => {
  let _classDecorators = [subCommandRequest(SerialAPISetupCommand.GetRegionInfo)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupRequest;
  var SerialAPISetup_GetRegionInfoRequest2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_GetRegionInfoRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_GetRegionInfoRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.region = options.region;
    }
    static from(raw, _ctx) {
      const region = raw.payload[0];
      return new this({
        region
      });
    }
    region;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.region]);
      return super.serialize(ctx);
    }
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = {
        ...ret.message,
        region: (0, import_shared.getEnumMemberName)(import_core.RFRegion, this.region)
      };
      delete message.payload;
      ret.message = message;
      return ret;
    }
  };
  return SerialAPISetup_GetRegionInfoRequest2 = _classThis;
})();
let SerialAPISetup_GetRegionInfoResponse = (() => {
  let _classDecorators = [subCommandResponse(SerialAPISetupCommand.GetRegionInfo)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SerialAPISetupResponse;
  var SerialAPISetup_GetRegionInfoResponse2 = class extends _classSuper {
    static {
      __name(this, "SerialAPISetup_GetRegionInfoResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SerialAPISetup_GetRegionInfoResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.region = options.region;
      this.supportsZWave = options.supportsZWave;
      this.supportsLongRange = options.supportsLongRange;
      this.includesRegion = options.includesRegion;
    }
    static from(raw, _ctx) {
      const region = raw.payload[0];
      const supportsZWave = !!(raw.payload[1] & 1);
      const supportsLongRange = !!(raw.payload[1] & 2);
      let includesRegion;
      if (raw.payload.length > 2) {
        includesRegion = raw.payload[2];
        if (includesRegion === import_core.RFRegion.Unknown) {
          includesRegion = void 0;
        }
      }
      return new this({
        region,
        supportsZWave,
        supportsLongRange,
        includesRegion
      });
    }
    region;
    supportsZWave;
    supportsLongRange;
    includesRegion;
    toLogEntry() {
      const ret = { ...super.toLogEntry() };
      const message = {
        ...ret.message,
        region: (0, import_shared.getEnumMemberName)(import_core.RFRegion, this.region),
        "supports Z-Wave": this.supportsZWave,
        "supports Long Range": this.supportsLongRange
      };
      if (this.includesRegion != void 0) {
        message["includes region"] = (0, import_shared.getEnumMemberName)(import_core.RFRegion, this.includesRegion);
      }
      delete message.payload;
      ret.message = message;
      return ret;
    }
  };
  return SerialAPISetup_GetRegionInfoResponse2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  SerialAPISetupCommand,
  SerialAPISetupRequest,
  SerialAPISetupResponse,
  SerialAPISetup_CommandUnsupportedResponse,
  SerialAPISetup_GetLongRangeMaximumPayloadSizeRequest,
  SerialAPISetup_GetLongRangeMaximumPayloadSizeResponse,
  SerialAPISetup_GetLongRangeMaximumTxPowerRequest,
  SerialAPISetup_GetLongRangeMaximumTxPowerResponse,
  SerialAPISetup_GetMaximumPayloadSizeRequest,
  SerialAPISetup_GetMaximumPayloadSizeResponse,
  SerialAPISetup_GetPowerlevel16BitRequest,
  SerialAPISetup_GetPowerlevel16BitResponse,
  SerialAPISetup_GetPowerlevelRequest,
  SerialAPISetup_GetPowerlevelResponse,
  SerialAPISetup_GetRFRegionRequest,
  SerialAPISetup_GetRFRegionResponse,
  SerialAPISetup_GetRegionInfoRequest,
  SerialAPISetup_GetRegionInfoResponse,
  SerialAPISetup_GetSupportedCommandsRequest,
  SerialAPISetup_GetSupportedCommandsResponse,
  SerialAPISetup_GetSupportedRegionsRequest,
  SerialAPISetup_GetSupportedRegionsResponse,
  SerialAPISetup_SetLongRangeMaximumTxPowerRequest,
  SerialAPISetup_SetLongRangeMaximumTxPowerResponse,
  SerialAPISetup_SetNodeIDTypeRequest,
  SerialAPISetup_SetNodeIDTypeResponse,
  SerialAPISetup_SetPowerlevel16BitRequest,
  SerialAPISetup_SetPowerlevel16BitResponse,
  SerialAPISetup_SetPowerlevelRequest,
  SerialAPISetup_SetPowerlevelResponse,
  SerialAPISetup_SetRFRegionRequest,
  SerialAPISetup_SetRFRegionResponse,
  SerialAPISetup_SetTXStatusReportRequest,
  SerialAPISetup_SetTXStatusReportResponse
});
//# sourceMappingURL=SerialAPISetupMessages.js.map
