import { type MessageOrCCLogEntry, TransmitStatus } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw, type SuccessIndicator } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
export declare class AssignSUCReturnRouteRequestBase extends Message {
    static from(raw: MessageRaw, ctx: MessageParsingContext): AssignSUCReturnRouteRequestBase;
}
export interface AssignSUCReturnRouteRequestOptions {
    nodeId: number;
    disableCallbackFunctionTypeCheck?: boolean;
}
export declare class AssignSUCReturnRouteRequest extends AssignSUCReturnRouteRequestBase {
    constructor(options: AssignSUCReturnRouteRequestOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): AssignSUCReturnRouteRequest;
    nodeId: number;
    readonly disableCallbackFunctionTypeCheck?: boolean;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
}
export interface AssignSUCReturnRouteResponseOptions {
    wasExecuted: boolean;
}
export declare class AssignSUCReturnRouteResponse extends Message implements SuccessIndicator {
    constructor(options: AssignSUCReturnRouteResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): AssignSUCReturnRouteResponse;
    isOK(): boolean;
    wasExecuted: boolean;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface AssignSUCReturnRouteRequestTransmitReportOptions {
    transmitStatus: TransmitStatus;
}
export declare class AssignSUCReturnRouteRequestTransmitReport extends AssignSUCReturnRouteRequestBase implements SuccessIndicator {
    constructor(options: AssignSUCReturnRouteRequestTransmitReportOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): AssignSUCReturnRouteRequestTransmitReport;
    isOK(): boolean;
    transmitStatus: TransmitStatus;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
//# sourceMappingURL=AssignSUCReturnRouteMessages.d.ts.map