import { type MessageOrCCLogEntry, TransmitStatus } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw, type SuccessIndicator } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
export declare class DeleteSUCReturnRouteRequestBase extends Message {
    static from(raw: MessageRaw, ctx: MessageParsingContext): DeleteSUCReturnRouteRequestBase;
}
export interface DeleteSUCReturnRouteRequestOptions {
    nodeId: number;
    disableCallbackFunctionTypeCheck?: boolean;
}
export declare class DeleteSUCReturnRouteRequest extends DeleteSUCReturnRouteRequestBase {
    constructor(options: DeleteSUCReturnRouteRequestOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): DeleteSUCReturnRouteRequest;
    nodeId: number;
    readonly disableCallbackFunctionTypeCheck?: boolean;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
}
export interface DeleteSUCReturnRouteResponseOptions {
    wasExecuted: boolean;
}
export declare class DeleteSUCReturnRouteResponse extends Message implements SuccessIndicator {
    constructor(options: DeleteSUCReturnRouteResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): DeleteSUCReturnRouteResponse;
    isOK(): boolean;
    readonly wasExecuted: boolean;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface DeleteSUCReturnRouteRequestTransmitReportOptions {
    transmitStatus: TransmitStatus;
}
export declare class DeleteSUCReturnRouteRequestTransmitReport extends DeleteSUCReturnRouteRequestBase implements SuccessIndicator {
    constructor(options: DeleteSUCReturnRouteRequestTransmitReportOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): DeleteSUCReturnRouteRequestTransmitReport;
    isOK(): boolean;
    readonly transmitStatus: TransmitStatus;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
//# sourceMappingURL=DeleteSUCReturnRouteMessages.d.ts.map