"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var GetNodeProtocolInfoMessages_exports = {};
__export(GetNodeProtocolInfoMessages_exports, {
  GetNodeProtocolInfoRequest: () => GetNodeProtocolInfoRequest,
  GetNodeProtocolInfoResponse: () => GetNodeProtocolInfoResponse
});
module.exports = __toCommonJS(GetNodeProtocolInfoMessages_exports);
var import_core = require("@zwave-js/core");
var import_serial = require("@zwave-js/serial");
var import_shared = require("@zwave-js/shared");
var import_typeguards = require("alcalzone-shared/typeguards");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
let GetNodeProtocolInfoRequest = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Request, import_serial.FunctionType.GetNodeProtocolInfo), (0, import_serial.expectedResponse)(import_serial.FunctionType.GetNodeProtocolInfo), (0, import_serial.priority)(import_core.MessagePriority.Controller)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var GetNodeProtocolInfoRequest2 = class extends _classSuper {
    static {
      __name(this, "GetNodeProtocolInfoRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      GetNodeProtocolInfoRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.requestedNodeId = options.requestedNodeId;
    }
    static from(raw, ctx) {
      const requestedNodeId = (0, import_core.parseNodeID)(raw.payload, ctx.nodeIdType, 0).nodeId;
      return new this({
        requestedNodeId
      });
    }
    // This must not be called nodeId or the message will be treated as a node query
    // but this is a message to the controller
    requestedNodeId;
    serialize(ctx) {
      this.payload = (0, import_core.encodeNodeID)(this.requestedNodeId, ctx.nodeIdType);
      return super.serialize(ctx);
    }
  };
  return GetNodeProtocolInfoRequest2 = _classThis;
})();
let GetNodeProtocolInfoResponse = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Response, import_serial.FunctionType.GetNodeProtocolInfo)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var GetNodeProtocolInfoResponse2 = class extends _classSuper {
    static {
      __name(this, "GetNodeProtocolInfoResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      GetNodeProtocolInfoResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.isListening = options.isListening;
      this.isFrequentListening = options.isFrequentListening;
      this.isRouting = options.isRouting;
      this.supportedDataRates = options.supportedDataRates;
      this.protocolVersion = options.protocolVersion;
      this.optionalFunctionality = options.optionalFunctionality;
      this.nodeType = options.nodeType;
      this.supportsSecurity = options.supportsSecurity;
      this.supportsBeaming = options.supportsBeaming;
      this.basicDeviceClass = options.basicDeviceClass;
      this.genericDeviceClass = options.genericDeviceClass;
      this.specificDeviceClass = options.specificDeviceClass;
    }
    static from(raw, ctx) {
      let isLongRange = false;
      const requestContext = ctx.requestStorage?.get(import_serial.FunctionType.GetNodeProtocolInfo);
      if ((0, import_typeguards.isObject)(requestContext) && "nodeId" in requestContext && typeof requestContext.nodeId === "number") {
        isLongRange = (0, import_core.isLongRangeNodeId)(requestContext.nodeId);
      }
      const { hasSpecificDeviceClass, ...rest } = (0, import_core.parseNodeProtocolInfo)(raw.payload, 0, isLongRange);
      const isListening = rest.isListening;
      const isFrequentListening = rest.isFrequentListening;
      const isRouting = rest.isRouting;
      const supportedDataRates = rest.supportedDataRates;
      const protocolVersion = rest.protocolVersion;
      const optionalFunctionality = rest.optionalFunctionality;
      const nodeType = rest.nodeType;
      const supportsSecurity = rest.supportsSecurity;
      const supportsBeaming = rest.supportsBeaming;
      const basicDeviceClass = raw.payload[3];
      const genericDeviceClass = raw.payload[4];
      const specificDeviceClass = hasSpecificDeviceClass ? raw.payload[5] : 0;
      return new this({
        isListening,
        isFrequentListening,
        isRouting,
        supportedDataRates,
        protocolVersion,
        optionalFunctionality,
        nodeType,
        supportsSecurity,
        supportsBeaming,
        basicDeviceClass,
        genericDeviceClass,
        specificDeviceClass
      });
    }
    /** Whether this node is always listening or not */
    isListening;
    /** Indicates the wakeup interval if this node is a FLiRS node. `false` if it isn't. */
    isFrequentListening;
    /** Whether the node supports routing/forwarding messages. */
    isRouting;
    supportedDataRates;
    protocolVersion;
    /** Whether this node supports additional CCs besides the mandatory minimum */
    optionalFunctionality;
    /** Whether this node is a controller (can calculate routes) or an end node (relies on route info) */
    nodeType;
    /** Whether this node supports security (S0 or S2) */
    supportsSecurity;
    /** Whether this node can issue wakeup beams to FLiRS nodes */
    supportsBeaming;
    basicDeviceClass;
    genericDeviceClass;
    specificDeviceClass;
    serialize(ctx) {
      const protocolInfo = (0, import_core.encodeNodeProtocolInfo)({
        isListening: this.isListening,
        isFrequentListening: this.isFrequentListening,
        isRouting: this.isRouting,
        supportedDataRates: this.supportedDataRates,
        protocolVersion: this.protocolVersion,
        optionalFunctionality: this.optionalFunctionality,
        nodeType: this.nodeType,
        supportsSecurity: this.supportsSecurity,
        supportsBeaming: this.supportsBeaming,
        hasSpecificDeviceClass: this.specificDeviceClass !== 0
      });
      this.payload = import_shared.Bytes.concat([
        protocolInfo,
        import_shared.Bytes.from([
          this.basicDeviceClass,
          this.genericDeviceClass,
          this.specificDeviceClass
        ])
      ]);
      return super.serialize(ctx);
    }
  };
  return GetNodeProtocolInfoResponse2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  GetNodeProtocolInfoRequest,
  GetNodeProtocolInfoResponse
});
//# sourceMappingURL=GetNodeProtocolInfoMessages.js.map
