"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var GetPriorityRouteMessages_exports = {};
__export(GetPriorityRouteMessages_exports, {
  GetPriorityRouteRequest: () => GetPriorityRouteRequest,
  GetPriorityRouteResponse: () => GetPriorityRouteResponse
});
module.exports = __toCommonJS(GetPriorityRouteMessages_exports);
var import_core = require("@zwave-js/core");
var import_serial = require("@zwave-js/serial");
var import_shared = require("@zwave-js/shared");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
let GetPriorityRouteRequest = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Request, import_serial.FunctionType.GetPriorityRoute), (0, import_serial.priority)(import_core.MessagePriority.Normal), (0, import_serial.expectedResponse)(import_serial.FunctionType.GetPriorityRoute)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var GetPriorityRouteRequest2 = class extends _classSuper {
    static {
      __name(this, "GetPriorityRouteRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      GetPriorityRouteRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.destinationNodeId = options.destinationNodeId;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    destinationNodeId;
    serialize(ctx) {
      this.payload = (0, import_core.encodeNodeID)(this.destinationNodeId, ctx.nodeIdType);
      return super.serialize(ctx);
    }
    toLogEntry() {
      return {
        ...super.toLogEntry(),
        message: {
          "node ID": this.destinationNodeId
        }
      };
    }
  };
  return GetPriorityRouteRequest2 = _classThis;
})();
let GetPriorityRouteResponse = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Response, import_serial.FunctionType.GetPriorityRoute)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var GetPriorityRouteResponse2 = class extends _classSuper {
    static {
      __name(this, "GetPriorityRouteResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      GetPriorityRouteResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.destinationNodeId = options.destinationNodeId;
      this.routeKind = options.routeKind;
      this.repeaters = options.repeaters;
      this.routeSpeed = options.routeSpeed;
    }
    static from(raw, ctx) {
      let offset = 0;
      const { nodeId, bytesRead: nodeIdBytes } = (0, import_core.parseNodeID)(raw.payload, ctx.nodeIdType, offset);
      offset += nodeIdBytes;
      const destinationNodeId = nodeId;
      const routeKind = raw.payload[offset++];
      let repeaters;
      let routeSpeed;
      if (routeKind) {
        repeaters = [
          ...raw.payload.subarray(offset, offset + import_core.MAX_REPEATERS)
        ].filter((id) => id > 0);
        routeSpeed = raw.payload[offset + import_core.MAX_REPEATERS];
      }
      return new this({
        destinationNodeId,
        routeKind,
        repeaters,
        routeSpeed
      });
    }
    destinationNodeId;
    routeKind;
    repeaters;
    routeSpeed;
    toLogEntry() {
      let message = {
        "node ID": this.destinationNodeId
      };
      if (this.routeKind !== import_core.RouteKind.None) {
        message = {
          ...message,
          "route kind": (0, import_shared.getEnumMemberName)(import_core.RouteKind, this.routeKind),
          repeaters: this.repeaters?.length ? this.repeaters.join(" -> ") : "none",
          "route speed": (0, import_shared.getEnumMemberName)(import_core.ZWaveDataRate, this.routeSpeed)
        };
      } else {
        message = {
          ...message,
          route: "(not set)"
        };
      }
      return {
        ...super.toLogEntry(),
        message
      };
    }
  };
  return GetPriorityRouteResponse2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  GetPriorityRouteRequest,
  GetPriorityRouteResponse
});
//# sourceMappingURL=GetPriorityRouteMessages.js.map
