import { type MessageOrCCLogEntry } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
export interface ExtNVMWriteLongByteRequestOptions {
    offset: number;
    byte: number;
}
export declare class ExtNVMWriteLongByteRequest extends Message {
    constructor(options: ExtNVMWriteLongByteRequestOptions & MessageBaseOptions);
    static from(_raw: MessageRaw, _ctx: MessageParsingContext): ExtNVMWriteLongByteRequest;
    offset: number;
    byte: number;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface ExtNVMWriteLongByteResponseOptions {
    success: boolean;
}
export declare class ExtNVMWriteLongByteResponse extends Message {
    constructor(options: ExtNVMWriteLongByteResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): ExtNVMWriteLongByteResponse;
    readonly success: boolean;
    isOK(): boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
//# sourceMappingURL=ExtNVMWriteLongByteMessages.d.ts.map