"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var GetNVMIdMessages_exports = {};
__export(GetNVMIdMessages_exports, {
  GetNVMIdRequest: () => GetNVMIdRequest,
  GetNVMIdResponse: () => GetNVMIdResponse,
  NVMSize: () => NVMSize,
  NVMType: () => NVMType,
  nvmSizeToBufferSize: () => nvmSizeToBufferSize
});
module.exports = __toCommonJS(GetNVMIdMessages_exports);
var import_core = require("@zwave-js/core");
var import_serial = require("@zwave-js/serial");
var import_shared = require("@zwave-js/shared");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var NVMType;
(function(NVMType2) {
  NVMType2[NVMType2["Flash"] = 128] = "Flash";
  NVMType2[NVMType2["DataFlash"] = 129] = "DataFlash";
  NVMType2[NVMType2["EEPROM"] = 255] = "EEPROM";
})(NVMType || (NVMType = {}));
var NVMSize;
(function(NVMSize2) {
  NVMSize2[NVMSize2["16KB"] = 14] = "16KB";
  NVMSize2[NVMSize2["32KB"] = 15] = "32KB";
  NVMSize2[NVMSize2["64KB"] = 16] = "64KB";
  NVMSize2[NVMSize2["128KB"] = 17] = "128KB";
  NVMSize2[NVMSize2["256KB"] = 18] = "256KB";
  NVMSize2[NVMSize2["512KB"] = 19] = "512KB";
  NVMSize2[NVMSize2["1MB"] = 20] = "1MB";
  NVMSize2[NVMSize2["2MB"] = 21] = "2MB";
  NVMSize2[NVMSize2["4MB"] = 22] = "4MB";
  NVMSize2[NVMSize2["8MB"] = 23] = "8MB";
  NVMSize2[NVMSize2["16MB"] = 24] = "16MB";
  NVMSize2[NVMSize2["Unknown"] = 255] = "Unknown";
})(NVMSize || (NVMSize = {}));
function nvmSizeToBufferSize(size) {
  switch (size) {
    case NVMSize["16KB"]:
      return 16 * 1024;
    case NVMSize["32KB"]:
      return 32 * 1024;
    case NVMSize["64KB"]:
      return 64 * 1024;
    case NVMSize["128KB"]:
      return 128 * 1024;
    case NVMSize["256KB"]:
      return 256 * 1024;
    case NVMSize["512KB"]:
      return 512 * 1024;
    case NVMSize["1MB"]:
      return 1 * 1024 * 1024;
    case NVMSize["2MB"]:
      return 2 * 1024 * 1024;
    case NVMSize["4MB"]:
      return 4 * 1024 * 1024;
    case NVMSize["8MB"]:
      return 8 * 1024 * 1024;
    case NVMSize["16MB"]:
      return 16 * 1024 * 1024;
    default:
      return void 0;
  }
}
__name(nvmSizeToBufferSize, "nvmSizeToBufferSize");
let GetNVMIdRequest = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Request, import_serial.FunctionType.GetNVMId), (0, import_serial.expectedResponse)(import_serial.FunctionType.GetNVMId), (0, import_serial.priority)(import_core.MessagePriority.Controller)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var GetNVMIdRequest2 = class extends _classSuper {
    static {
      __name(this, "GetNVMIdRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      GetNVMIdRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return GetNVMIdRequest2 = _classThis;
})();
let GetNVMIdResponse = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Response, import_serial.FunctionType.GetNVMId)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var GetNVMIdResponse2 = class extends _classSuper {
    static {
      __name(this, "GetNVMIdResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      GetNVMIdResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.nvmManufacturerId = options.nvmManufacturerId;
      this.memoryType = options.memoryType;
      this.memorySize = options.memorySize;
    }
    static from(raw, _ctx) {
      const nvmManufacturerId = raw.payload[1];
      const memoryType = raw.payload[2];
      const memorySize = raw.payload[3];
      return new this({
        nvmManufacturerId,
        memoryType,
        memorySize
      });
    }
    nvmManufacturerId;
    memoryType;
    memorySize;
    toLogEntry() {
      return {
        ...super.toLogEntry(),
        message: {
          manufacturer: (0, import_shared.num2hex)(this.nvmManufacturerId),
          "memory type": (0, import_shared.getEnumMemberName)(NVMType, this.memoryType),
          "memory size": (0, import_shared.getEnumMemberName)(NVMSize, this.memorySize)
        }
      };
    }
  };
  return GetNVMIdResponse2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  GetNVMIdRequest,
  GetNVMIdResponse,
  NVMSize,
  NVMType,
  nvmSizeToBufferSize
});
//# sourceMappingURL=GetNVMIdMessages.js.map
