import { type MessageOrCCLogEntry } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw, type SuccessIndicator } from "@zwave-js/serial";
import { Bytes, type BytesView } from "@zwave-js/shared";
export declare enum NVMOperationsCommand {
    Open = 0,
    Read = 1,
    Write = 2,
    Close = 3
}
export declare enum NVMOperationStatus {
    OK = 0,
    Error = 1,
    Error_OperationMismatch = 2,
    Error_OperationInterference = 3,
    EndOfFile = 255
}
export declare class NVMOperationsRequest extends Message {
    command: NVMOperationsCommand;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class NVMOperationsOpenRequest extends NVMOperationsRequest {
    constructor(options?: MessageBaseOptions);
}
export declare class NVMOperationsCloseRequest extends NVMOperationsRequest {
    constructor(options?: MessageBaseOptions);
}
export interface NVMOperationsReadRequestOptions {
    length: number;
    offset: number;
}
export declare class NVMOperationsReadRequest extends NVMOperationsRequest {
    constructor(options: NVMOperationsReadRequestOptions & MessageBaseOptions);
    static from(_raw: MessageRaw, _ctx: MessageParsingContext): NVMOperationsReadRequest;
    length: number;
    offset: number;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface NVMOperationsWriteRequestOptions {
    offset: number;
    buffer: BytesView;
}
export declare class NVMOperationsWriteRequest extends NVMOperationsRequest {
    constructor(options: NVMOperationsWriteRequestOptions & MessageBaseOptions);
    static from(_raw: MessageRaw, _ctx: MessageParsingContext): NVMOperationsWriteRequest;
    offset: number;
    buffer: BytesView;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface NVMOperationsResponseOptions {
    status: NVMOperationStatus;
    offsetOrSize: number;
    buffer: BytesView;
}
export declare class NVMOperationsResponse extends Message implements SuccessIndicator {
    constructor(options: NVMOperationsResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): NVMOperationsResponse;
    isOK(): boolean;
    readonly status: NVMOperationStatus;
    readonly offsetOrSize: number;
    readonly buffer: BytesView;
    toLogEntry(): MessageOrCCLogEntry;
}
//# sourceMappingURL=NVMOperationsMessages.d.ts.map