"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var SendDataMessages_exports = {};
__export(SendDataMessages_exports, {
  MAX_SEND_ATTEMPTS: () => MAX_SEND_ATTEMPTS,
  SendDataAbort: () => SendDataAbort,
  SendDataMulticastRequest: () => SendDataMulticastRequest,
  SendDataMulticastRequestBase: () => SendDataMulticastRequestBase,
  SendDataMulticastRequestTransmitReport: () => SendDataMulticastRequestTransmitReport,
  SendDataMulticastResponse: () => SendDataMulticastResponse,
  SendDataRequest: () => SendDataRequest,
  SendDataRequestBase: () => SendDataRequestBase,
  SendDataRequestTransmitReport: () => SendDataRequestTransmitReport,
  SendDataResponse: () => SendDataResponse
});
module.exports = __toCommonJS(SendDataMessages_exports);
var import_core = require("@zwave-js/core");
var import_serial = require("@zwave-js/serial");
var import_shared = require("@zwave-js/shared");
var import_math = require("alcalzone-shared/math");
var import_ApplicationCommandRequest = require("../application/ApplicationCommandRequest.js");
var import_BridgeApplicationCommandRequest = require("../application/BridgeApplicationCommandRequest.js");
var import_utils = require("../utils.js");
var import_SendDataShared = require("./SendDataShared.js");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
const MAX_SEND_ATTEMPTS = 5;
let SendDataRequestBase = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Request, import_serial.FunctionType.SendData), (0, import_serial.priority)(import_core.MessagePriority.Normal)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var SendDataRequestBase2 = class extends _classSuper {
    static {
      __name(this, "SendDataRequestBase");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SendDataRequestBase2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    static from(raw, ctx) {
      if (ctx.origin === import_serial.MessageOrigin.Host) {
        return SendDataRequest.from(raw, ctx);
      } else {
        return SendDataRequestTransmitReport.from(raw, ctx);
      }
    }
  };
  return SendDataRequestBase2 = _classThis;
})();
let SendDataRequest = (() => {
  let _classDecorators = [(0, import_serial.expectedResponse)(import_serial.FunctionType.SendData), (0, import_serial.expectedCallback)(import_serial.FunctionType.SendData)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SendDataRequestBase;
  var SendDataRequest2 = class extends _classSuper {
    static {
      __name(this, "SendDataRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SendDataRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if ("command" in options) {
        if (!options.command.isSinglecast() && !options.command.isBroadcast()) {
          throw new import_core.ZWaveError(`SendDataRequest can only be used for singlecast and broadcast CCs`, import_core.ZWaveErrorCodes.Argument_Invalid);
        }
        this.command = options.command;
        this._nodeId = this.command.nodeId;
      } else {
        this._nodeId = options.nodeId;
        this.serializedCC = options.serializedCC;
      }
      this.transmitOptions = options.transmitOptions ?? import_core.TransmitOptions.DEFAULT;
      if (options.maxSendAttempts != void 0) {
        this.maxSendAttempts = options.maxSendAttempts;
      }
    }
    static from(raw, ctx) {
      let offset = 0;
      const { nodeId, bytesRead: nodeIdBytes } = (0, import_core.parseNodeID)(raw.payload, ctx.nodeIdType, offset);
      offset += nodeIdBytes;
      const serializedCCLength = raw.payload[offset++];
      const transmitOptions = raw.payload[offset + serializedCCLength];
      const callbackId = raw.payload[offset + 1 + serializedCCLength];
      const serializedCC = raw.payload.subarray(offset, offset + serializedCCLength);
      return new this({
        transmitOptions,
        callbackId,
        nodeId,
        serializedCC
      });
    }
    /** The command this message contains */
    command;
    /** Options regarding the transmission of the message */
    transmitOptions;
    _maxSendAttempts = 1;
    /** The number of times the driver may try to send this message */
    get maxSendAttempts() {
      return this._maxSendAttempts;
    }
    set maxSendAttempts(value) {
      this._maxSendAttempts = (0, import_math.clamp)(value, 1, MAX_SEND_ATTEMPTS);
    }
    _nodeId;
    getNodeId() {
      return this.command?.nodeId ?? this._nodeId;
    }
    serializedCC;
    async serializeCC(ctx) {
      if (!this.serializedCC) {
        if (!this.command) {
          throw new import_core.ZWaveError(`Cannot serialize a ${this.constructor.name} without a command`, import_core.ZWaveErrorCodes.Argument_Invalid);
        }
        this.serializedCC = await this.command.serialize(ctx);
      }
      return this.serializedCC;
    }
    prepareRetransmission() {
      this.command?.prepareRetransmission();
      this.serializedCC = void 0;
      this.callbackId = void 0;
    }
    async serialize(ctx) {
      this.assertCallbackId();
      const nodeId = (0, import_core.encodeNodeID)(this.command?.nodeId ?? this._nodeId, ctx.nodeIdType);
      const serializedCC = await this.serializeCC(ctx);
      this.payload = import_shared.Bytes.concat([
        nodeId,
        import_shared.Bytes.from([serializedCC.length]),
        serializedCC,
        import_shared.Bytes.from([this.transmitOptions, this.callbackId])
      ]);
      return super.serialize(ctx);
    }
    toLogEntry() {
      return {
        ...super.toLogEntry(),
        message: {
          "transmit options": (0, import_shared.num2hex)(this.transmitOptions),
          "callback id": this.callbackId ?? "(not set)"
        }
      };
    }
    expectsNodeUpdate() {
      return (
        // We can only answer this if the command is known
        this.command != void 0 && this.command.isSinglecast() && this.command.expectsCCResponse()
      );
    }
    isExpectedNodeUpdate(msg) {
      return (
        // We can only answer this if the command is known
        this.command != void 0 && (msg instanceof import_ApplicationCommandRequest.ApplicationCommandRequest || msg instanceof import_BridgeApplicationCommandRequest.BridgeApplicationCommandRequest) && (0, import_utils.containsCC)(msg) && this.command.isExpectedCCResponse(msg.command)
      );
    }
  };
  return SendDataRequest2 = _classThis;
})();
class SendDataRequestTransmitReport extends SendDataRequestBase {
  static {
    __name(this, "SendDataRequestTransmitReport");
  }
  constructor(options) {
    super(options);
    this.callbackId = options.callbackId;
    this.transmitStatus = options.transmitStatus;
    this.txReport = options.txReport && (0, import_SendDataShared.serializableTXReportToTXReport)(options.txReport);
  }
  static from(raw, _ctx) {
    const callbackId = raw.payload[0];
    const transmitStatus = raw.payload[1];
    const txReport = (0, import_SendDataShared.parseTXReport)(transmitStatus !== import_core.TransmitStatus.NoAck, raw.payload.subarray(2));
    return new this({
      callbackId,
      transmitStatus,
      txReport
    });
  }
  transmitStatus;
  txReport;
  serialize(ctx) {
    this.assertCallbackId();
    this.payload = import_shared.Bytes.from([
      this.callbackId,
      this.transmitStatus
    ]);
    if (this.txReport) {
      this.payload = import_shared.Bytes.concat([
        this.payload,
        (0, import_SendDataShared.encodeTXReport)(this.txReport)
      ]);
    }
    return super.serialize(ctx);
  }
  isOK() {
    return this.transmitStatus === import_core.TransmitStatus.OK;
  }
  toLogEntry() {
    return {
      ...super.toLogEntry(),
      message: {
        "callback id": this.callbackId ?? "(not set)",
        "transmit status": (0, import_shared.getEnumMemberName)(import_core.TransmitStatus, this.transmitStatus) + (this.txReport ? `, took ${this.txReport.txTicks * 10} ms` : ""),
        // Show TX report fields for OK and NoAck (NoAck still provides useful routing info)
        ...this.txReport && (this.transmitStatus === import_core.TransmitStatus.OK || this.transmitStatus === import_core.TransmitStatus.NoAck) ? (0, import_SendDataShared.txReportToMessageRecord)(this.txReport) : {}
      }
    };
  }
}
let SendDataResponse = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Response, import_serial.FunctionType.SendData)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var SendDataResponse2 = class extends _classSuper {
    static {
      __name(this, "SendDataResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SendDataResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.wasSent = options.wasSent;
    }
    static from(raw, _ctx) {
      const wasSent = raw.payload[0] !== 0;
      return new this({
        wasSent
      });
    }
    wasSent;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.wasSent ? 1 : 0]);
      return super.serialize(ctx);
    }
    isOK() {
      return this.wasSent;
    }
    toLogEntry() {
      return {
        ...super.toLogEntry(),
        message: { "was sent": this.wasSent }
      };
    }
  };
  return SendDataResponse2 = _classThis;
})();
let SendDataMulticastRequestBase = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Request, import_serial.FunctionType.SendDataMulticast), (0, import_serial.priority)(import_core.MessagePriority.Normal)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var SendDataMulticastRequestBase2 = class extends _classSuper {
    static {
      __name(this, "SendDataMulticastRequestBase");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SendDataMulticastRequestBase2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    static from(raw, ctx) {
      if (ctx.origin === import_serial.MessageOrigin.Host) {
        return SendDataMulticastRequest.from(raw, ctx);
      } else {
        return SendDataMulticastRequestTransmitReport.from(raw, ctx);
      }
    }
  };
  return SendDataMulticastRequestBase2 = _classThis;
})();
let SendDataMulticastRequest = (() => {
  let _classDecorators = [(0, import_serial.expectedResponse)(import_serial.FunctionType.SendDataMulticast), (0, import_serial.expectedCallback)(import_serial.FunctionType.SendDataMulticast)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = SendDataMulticastRequestBase;
  var SendDataMulticastRequest2 = class extends _classSuper {
    static {
      __name(this, "SendDataMulticastRequest");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SendDataMulticastRequest2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if ("command" in options) {
        if (!options.command.isMulticast()) {
          throw new import_core.ZWaveError(`SendDataMulticastRequest can only be used for multicast CCs`, import_core.ZWaveErrorCodes.Argument_Invalid);
        } else if (options.command.nodeId.length === 0) {
          throw new import_core.ZWaveError(`At least one node must be targeted`, import_core.ZWaveErrorCodes.Argument_Invalid);
        } else if (options.command.nodeId.some((n) => n < 1 || n > import_core.MAX_NODES)) {
          throw new import_core.ZWaveError(`All node IDs must be between 1 and ${import_core.MAX_NODES}!`, import_core.ZWaveErrorCodes.Argument_Invalid);
        }
        this.command = options.command;
        this.nodeIds = this.command.nodeId;
      } else {
        this.nodeIds = options.nodeIds;
        this.serializedCC = options.serializedCC;
      }
      this.transmitOptions = options.transmitOptions ?? import_core.TransmitOptions.DEFAULT;
      if (options.maxSendAttempts != void 0) {
        this.maxSendAttempts = options.maxSendAttempts;
      }
    }
    static from(raw, ctx) {
      const numNodeIDs = raw.payload[0];
      let offset = 1;
      const nodeIds = [];
      for (let i = 0; i < numNodeIDs; i++) {
        const { nodeId, bytesRead } = (0, import_core.parseNodeID)(raw.payload, ctx.nodeIdType, offset);
        nodeIds.push(nodeId);
        offset += bytesRead;
      }
      const serializedCCLength = raw.payload[offset];
      offset++;
      const serializedCC = raw.payload.subarray(offset, offset + serializedCCLength);
      offset += serializedCCLength;
      const transmitOptions = raw.payload[offset];
      offset++;
      const callbackId = raw.payload[offset];
      return new this({
        transmitOptions,
        callbackId,
        nodeIds,
        serializedCC
      });
    }
    /** The command this message contains */
    command;
    /** Options regarding the transmission of the message */
    transmitOptions;
    _maxSendAttempts = 1;
    /** The number of times the driver may try to send this message */
    get maxSendAttempts() {
      return this._maxSendAttempts;
    }
    set maxSendAttempts(value) {
      this._maxSendAttempts = (0, import_math.clamp)(value, 1, MAX_SEND_ATTEMPTS);
    }
    nodeIds;
    getNodeId() {
      return void 0;
    }
    serializedCC;
    async serializeCC(ctx) {
      if (!this.serializedCC) {
        if (!this.command) {
          throw new import_core.ZWaveError(`Cannot serialize a ${this.constructor.name} without a command`, import_core.ZWaveErrorCodes.Argument_Invalid);
        }
        this.serializedCC = await this.command.serialize(ctx);
      }
      return this.serializedCC;
    }
    prepareRetransmission() {
      this.command?.prepareRetransmission();
      this.serializedCC = void 0;
      this.callbackId = void 0;
    }
    async serialize(ctx) {
      this.assertCallbackId();
      const serializedCC = await this.serializeCC(ctx);
      const destinationNodeIDs = (this.command?.nodeId ?? this.nodeIds).map((id) => (0, import_core.encodeNodeID)(id, ctx.nodeIdType));
      this.payload = import_shared.Bytes.concat([
        // # of target nodes, not # of bytes
        import_shared.Bytes.from([destinationNodeIDs.length]),
        ...destinationNodeIDs,
        import_shared.Bytes.from([serializedCC.length]),
        // payload
        serializedCC,
        import_shared.Bytes.from([this.transmitOptions, this.callbackId])
      ]);
      return super.serialize(ctx);
    }
    toLogEntry() {
      return {
        ...super.toLogEntry(),
        message: {
          "target nodes": (this.command?.nodeId ?? this.nodeIds).join(", "),
          "transmit options": (0, import_shared.num2hex)(this.transmitOptions),
          "callback id": this.callbackId ?? "(not set)"
        }
      };
    }
  };
  return SendDataMulticastRequest2 = _classThis;
})();
class SendDataMulticastRequestTransmitReport extends SendDataMulticastRequestBase {
  static {
    __name(this, "SendDataMulticastRequestTransmitReport");
  }
  constructor(options) {
    super(options);
    this.callbackId = options.callbackId;
    this.transmitStatus = options.transmitStatus;
  }
  static from(raw, _ctx) {
    const callbackId = raw.payload[0];
    const transmitStatus = raw.payload[1];
    return new this({
      callbackId,
      transmitStatus
    });
  }
  transmitStatus;
  serialize(ctx) {
    this.assertCallbackId();
    this.payload = import_shared.Bytes.from([this.callbackId, this.transmitStatus]);
    return super.serialize(ctx);
  }
  isOK() {
    return this.transmitStatus === import_core.TransmitStatus.OK;
  }
  toLogEntry() {
    return {
      ...super.toLogEntry(),
      message: {
        "callback id": this.callbackId ?? "(not set)",
        "transmit status": (0, import_shared.getEnumMemberName)(import_core.TransmitStatus, this.transmitStatus)
      }
    };
  }
}
let SendDataMulticastResponse = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Response, import_serial.FunctionType.SendDataMulticast)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var SendDataMulticastResponse2 = class extends _classSuper {
    static {
      __name(this, "SendDataMulticastResponse");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SendDataMulticastResponse2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.wasSent = options.wasSent;
    }
    static from(raw, _ctx) {
      const wasSent = raw.payload[0] !== 0;
      return new this({
        wasSent
      });
    }
    wasSent;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.wasSent ? 1 : 0]);
      return super.serialize(ctx);
    }
    isOK() {
      return this.wasSent;
    }
    toLogEntry() {
      return {
        ...super.toLogEntry(),
        message: { "was sent": this.wasSent }
      };
    }
  };
  return SendDataMulticastResponse2 = _classThis;
})();
let SendDataAbort = (() => {
  let _classDecorators = [(0, import_serial.messageTypes)(import_serial.MessageType.Request, import_serial.FunctionType.SendDataAbort), (0, import_serial.priority)(import_core.MessagePriority.Controller)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_serial.Message;
  var SendDataAbort2 = class extends _classSuper {
    static {
      __name(this, "SendDataAbort");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      SendDataAbort2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return SendDataAbort2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  MAX_SEND_ATTEMPTS,
  SendDataAbort,
  SendDataMulticastRequest,
  SendDataMulticastRequestBase,
  SendDataMulticastRequestTransmitReport,
  SendDataMulticastResponse,
  SendDataRequest,
  SendDataRequestBase,
  SendDataRequestTransmitReport,
  SendDataResponse
});
//# sourceMappingURL=SendDataMessages.js.map
