"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var SendDataShared_exports = {};
__export(SendDataShared_exports, {
  encodeTXReport: () => encodeTXReport,
  hasTXReport: () => hasTXReport,
  isAnySendDataResponse: () => isAnySendDataResponse,
  isSendData: () => isSendData,
  isSendDataMulticast: () => isSendDataMulticast,
  isSendDataSinglecast: () => isSendDataSinglecast,
  isSendDataTransmitReport: () => isSendDataTransmitReport,
  isTransmitReport: () => isTransmitReport,
  parseRSSI: () => parseRSSI,
  parseTXReport: () => parseTXReport,
  serializableTXReportToTXReport: () => serializableTXReportToTXReport,
  tryParseRSSI: () => tryParseRSSI,
  txReportToMessageRecord: () => txReportToMessageRecord
});
module.exports = __toCommonJS(SendDataShared_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_AssignPriorityReturnRouteMessages = require("../network-mgmt/AssignPriorityReturnRouteMessages.js");
var import_AssignPrioritySUCReturnRouteMessages = require("../network-mgmt/AssignPrioritySUCReturnRouteMessages.js");
var import_AssignReturnRouteMessages = require("../network-mgmt/AssignReturnRouteMessages.js");
var import_AssignSUCReturnRouteMessages = require("../network-mgmt/AssignSUCReturnRouteMessages.js");
var import_DeleteReturnRouteMessages = require("../network-mgmt/DeleteReturnRouteMessages.js");
var import_DeleteSUCReturnRouteMessages = require("../network-mgmt/DeleteSUCReturnRouteMessages.js");
var import_SendDataBridgeMessages = require("./SendDataBridgeMessages.js");
var import_SendDataMessages = require("./SendDataMessages.js");
function parseRSSI(payload, offset = 0) {
  const ret = import_shared.Bytes.view(payload).readInt8(offset);
  return ret;
}
__name(parseRSSI, "parseRSSI");
function tryParseRSSI(payload, offset = 0) {
  if (payload.length <= offset)
    return;
  return parseRSSI(payload, offset);
}
__name(tryParseRSSI, "tryParseRSSI");
function parseTXPower(payload, offset = 0) {
  if (payload.length <= offset)
    return;
  const ret = import_shared.Bytes.view(payload).readInt8(offset);
  if (ret >= -127 && ret <= 126)
    return ret;
}
__name(parseTXPower, "parseTXPower");
function parseTXReport(includeACK, payload) {
  const buffer = import_shared.Bytes.view(payload);
  if (buffer.length < 17)
    return;
  const numRepeaters = buffer[2];
  const ret = {
    txTicks: buffer.readUInt16BE(0),
    ackRSSI: includeACK ? parseRSSI(buffer, 3) : void 0,
    ackRepeaterRSSI: includeACK ? [
      parseRSSI(buffer, 4),
      parseRSSI(buffer, 5),
      parseRSSI(buffer, 6),
      parseRSSI(buffer, 7)
    ] : void 0,
    ackChannelNo: includeACK ? buffer[8] : void 0,
    txChannelNo: buffer[9],
    routeSchemeState: buffer[10],
    repeaterNodeIds: [buffer[11], buffer[12], buffer[13], buffer[14]],
    beam1000ms: !!(buffer[15] & 64),
    beam250ms: !!(buffer[15] & 32),
    routeSpeed: buffer[15] & 7,
    routingAttempts: buffer[16],
    // These might be missing:
    failedRouteLastFunctionalNodeId: buffer[17],
    failedRouteFirstNonFunctionalNodeId: buffer[18]
  };
  if (ret.txChannelNo >= 3) {
    ret.txPower = parseTXPower(buffer, 19);
    ret.measuredNoiseFloor = tryParseRSSI(buffer, 20);
    if (includeACK) {
      ret.destinationAckTxPower = parseTXPower(buffer, 21);
      ret.destinationAckMeasuredRSSI = tryParseRSSI(buffer, 22);
      ret.destinationAckMeasuredNoiseFloor = tryParseRSSI(buffer, 23);
    }
  }
  ret.repeaterNodeIds = ret.repeaterNodeIds.slice(0, numRepeaters);
  if (ret.ackRepeaterRSSI) {
    ret.ackRepeaterRSSI = ret.ackRepeaterRSSI.slice(0, numRepeaters);
  }
  if (ret.ackRSSI === import_core.RssiError.NotAvailable) {
    delete ret.ackRSSI;
    delete ret.ackChannelNo;
  }
  return (0, import_core.stripUndefined)(ret);
}
__name(parseTXReport, "parseTXReport");
function serializableTXReportToTXReport(report) {
  return {
    txTicks: report.txTicks,
    ackRSSI: report.ackRSSI,
    ackRepeaterRSSI: report.ackRepeaterRSSI,
    ackChannelNo: report.ackChannelNo,
    txChannelNo: report.txChannelNo ?? 0,
    routeSchemeState: report.routeSchemeState ?? 0,
    repeaterNodeIds: report.repeaterNodeIds ?? [],
    beam1000ms: report.beam1000ms ?? false,
    beam250ms: report.beam250ms ?? false,
    routeSpeed: report.routeSpeed ?? import_core.ProtocolDataRate.ZWave_100k,
    routingAttempts: report.routingAttempts ?? 1,
    failedRouteLastFunctionalNodeId: report.failedRouteLastFunctionalNodeId,
    failedRouteFirstNonFunctionalNodeId: report.failedRouteFirstNonFunctionalNodeId,
    txPower: report.txPower,
    measuredNoiseFloor: report.measuredNoiseFloor,
    destinationAckTxPower: report.destinationAckTxPower,
    destinationAckMeasuredRSSI: report.destinationAckMeasuredRSSI,
    destinationAckMeasuredNoiseFloor: report.destinationAckMeasuredNoiseFloor
  };
}
__name(serializableTXReportToTXReport, "serializableTXReportToTXReport");
function encodeTXReport(report) {
  const ret = new import_shared.Bytes(24).fill(0);
  ret.writeUInt16BE(report.txTicks, 0);
  ret[2] = report.repeaterNodeIds?.length ?? 0;
  ret.writeInt8(report.ackRSSI ?? import_core.RssiError.NotAvailable, 3);
  for (let i = 0; i < 4; i++) {
    ret.writeInt8(report.ackRepeaterRSSI?.[i] ?? import_core.RssiError.NotAvailable, 4 + i);
  }
  ret[8] = report.ackChannelNo ?? 0;
  ret[9] = report.txChannelNo ?? 0;
  ret[10] = report.routeSchemeState ?? 0;
  ret[11] = report.repeaterNodeIds?.[0] ?? 0;
  ret[12] = report.repeaterNodeIds?.[1] ?? 0;
  ret[13] = report.repeaterNodeIds?.[2] ?? 0;
  ret[14] = report.repeaterNodeIds?.[3] ?? 0;
  ret[15] = (report.beam1000ms ? 64 : 0) | (report.beam250ms ? 32 : 0) | report.routeSpeed;
  ret[16] = report.routingAttempts ?? 1;
  ret[17] = report.failedRouteLastFunctionalNodeId ?? 0;
  ret[18] = report.failedRouteFirstNonFunctionalNodeId ?? 0;
  ret.writeInt8(report.txPower ?? 0, 19);
  ret.writeInt8(report.measuredNoiseFloor ?? import_core.RssiError.NotAvailable, 20);
  ret.writeInt8(report.destinationAckTxPower ?? 0, 21);
  ret.writeInt8(report.destinationAckMeasuredRSSI ?? import_core.RssiError.NotAvailable, 22);
  ret.writeInt8(report.destinationAckMeasuredNoiseFloor ?? import_core.RssiError.NotAvailable, 23);
  return ret;
}
__name(encodeTXReport, "encodeTXReport");
function txReportToMessageRecord(report) {
  const ret = (0, import_core.stripUndefined)({
    // This is included in the parent command's transmit status line
    // "TX duration": `${report.txTicks * 10} ms`,
    // Number of repeaters isn't interesting if it is duplicated by the node IDs
    // repeaters: report.numRepeaters,
    ...report.repeaterNodeIds.length ? {
      "repeater node IDs": report.repeaterNodeIds.join(", ")
    } : {},
    "routing attempts": report.routingAttempts,
    "protocol & route speed": (0, import_core.protocolDataRateToString)(report.routeSpeed),
    "routing scheme": (0, import_core.routingSchemeToString)(report.routeSchemeState),
    "ACK RSSI": report.ackRSSI != void 0 ? (0, import_core.rssiToString)(report.ackRSSI) : void 0,
    ...report.ackRepeaterRSSI?.length ? {
      "ACK RSSI on repeaters": report.ackRepeaterRSSI.map((rssi) => (0, import_core.rssiToString)(rssi)).join(", ")
    } : {},
    "ACK channel no.": report.ackChannelNo,
    "TX channel no.": report.txChannelNo,
    // This isn't really interesting without knowing what it means
    // "route scheme state": report.routeSchemeState,
    beam: report.beam1000ms ? "1000 ms" : report.beam250ms ? "250 ms" : void 0
  });
  if (report.failedRouteLastFunctionalNodeId && report.failedRouteFirstNonFunctionalNodeId) {
    ret["route failed here"] = `${report.failedRouteLastFunctionalNodeId} -> ${report.failedRouteFirstNonFunctionalNodeId}`;
  }
  if (report.txPower != void 0)
    ret["TX power"] = `${report.txPower} dBm`;
  if (report.measuredNoiseFloor != void 0 && report.measuredNoiseFloor !== import_core.RssiError.NotAvailable) {
    ret["measured noise floor"] = (0, import_core.rssiToString)(report.measuredNoiseFloor);
  }
  if (report.destinationAckTxPower != void 0) {
    ret["ACK TX power by destination"] = `${report.destinationAckTxPower} dBm`;
  }
  if (report.destinationAckMeasuredRSSI != void 0 && report.destinationAckMeasuredRSSI !== import_core.RssiError.NotAvailable) {
    ret["measured RSSI of ACK from destination"] = (0, import_core.rssiToString)(report.destinationAckMeasuredRSSI);
  }
  if (report.destinationAckMeasuredNoiseFloor != void 0 && report.destinationAckMeasuredNoiseFloor !== import_core.RssiError.NotAvailable) {
    ret["measured noise floor by destination"] = (0, import_core.rssiToString)(report.destinationAckMeasuredNoiseFloor);
  }
  return ret;
}
__name(txReportToMessageRecord, "txReportToMessageRecord");
function isSendData(msg) {
  if (!msg)
    return false;
  return msg instanceof import_SendDataMessages.SendDataRequest || msg instanceof import_SendDataMessages.SendDataMulticastRequest || msg instanceof import_SendDataBridgeMessages.SendDataBridgeRequest || msg instanceof import_SendDataBridgeMessages.SendDataMulticastBridgeRequest;
}
__name(isSendData, "isSendData");
function isAnySendDataResponse(msg) {
  if (!msg)
    return false;
  return msg instanceof import_SendDataMessages.SendDataResponse || msg instanceof import_SendDataMessages.SendDataMulticastResponse || msg instanceof import_SendDataBridgeMessages.SendDataBridgeResponse || msg instanceof import_SendDataBridgeMessages.SendDataMulticastBridgeResponse;
}
__name(isAnySendDataResponse, "isAnySendDataResponse");
function isSendDataSinglecast(msg) {
  if (!msg)
    return false;
  return msg instanceof import_SendDataMessages.SendDataRequest || msg instanceof import_SendDataBridgeMessages.SendDataBridgeRequest;
}
__name(isSendDataSinglecast, "isSendDataSinglecast");
function isSendDataMulticast(msg) {
  if (!msg)
    return false;
  return msg instanceof import_SendDataMessages.SendDataMulticastRequest || msg instanceof import_SendDataBridgeMessages.SendDataMulticastBridgeRequest;
}
__name(isSendDataMulticast, "isSendDataMulticast");
function isSendDataTransmitReport(msg) {
  if (!msg)
    return false;
  return msg instanceof import_SendDataMessages.SendDataRequestTransmitReport || msg instanceof import_SendDataMessages.SendDataMulticastRequestTransmitReport || msg instanceof import_SendDataBridgeMessages.SendDataBridgeRequestTransmitReport || msg instanceof import_SendDataBridgeMessages.SendDataMulticastBridgeRequestTransmitReport;
}
__name(isSendDataTransmitReport, "isSendDataTransmitReport");
function isTransmitReport(msg) {
  if (!msg)
    return false;
  return isSendDataTransmitReport(msg) || msg instanceof import_AssignReturnRouteMessages.AssignReturnRouteRequestTransmitReport || msg instanceof import_AssignSUCReturnRouteMessages.AssignSUCReturnRouteRequestTransmitReport || msg instanceof import_DeleteReturnRouteMessages.DeleteReturnRouteRequestTransmitReport || msg instanceof import_DeleteSUCReturnRouteMessages.DeleteSUCReturnRouteRequestTransmitReport || msg instanceof import_AssignPriorityReturnRouteMessages.AssignPriorityReturnRouteRequestTransmitReport || msg instanceof import_AssignPrioritySUCReturnRouteMessages.AssignPrioritySUCReturnRouteRequestTransmitReport;
}
__name(isTransmitReport, "isTransmitReport");
function hasTXReport(msg) {
  if (!msg)
    return false;
  return (msg instanceof import_SendDataMessages.SendDataRequestTransmitReport || msg instanceof import_SendDataBridgeMessages.SendDataBridgeRequestTransmitReport) && (msg.transmitStatus === import_core.TransmitStatus.OK || msg.transmitStatus === import_core.TransmitStatus.NoAck) && !!msg.txReport;
}
__name(hasTXReport, "hasTXReport");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  encodeTXReport,
  hasTXReport,
  isAnySendDataResponse,
  isSendData,
  isSendDataMulticast,
  isSendDataSinglecast,
  isSendDataTransmitReport,
  isTransmitReport,
  parseRSSI,
  parseTXReport,
  serializableTXReportToTXReport,
  tryParseRSSI,
  txReportToMessageRecord
});
//# sourceMappingURL=SendDataShared.js.map
