/**
 * Connects a readable stream and a writable stream
 * while allowing the writable stream to be temporarily disconnected
 * or un-writable.
 *
 * Data that is emitted while no writable stream is connected is discarded.
 */
export declare class Faucet<T> {
    #private;
    /** Creates a new Faucet. The data starts flowing immediately */
    constructor(readable: ReadableStream<T>, writable?: WritableStream<T>);
    /**
     * Connects a new writable to the faucet.
     * If a writable is already connected, it is replaced.
     */
    connect(writable: WritableStream<T>): void;
    /**
     * Disconnects the current writable from the faucet.
     */
    disconnect(): void;
    /** Closes the faucet and stops reading data */
    close(): void;
}
//# sourceMappingURL=Faucet.d.ts.map