var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { ControllerCapabilityFlags, MessagePriority } from "@zwave-js/core";
import { FunctionType, Message, MessageType, expectedResponse, messageTypes, priority, } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
let GetControllerCapabilitiesRequest = (() => {
    let _classDecorators = [messageTypes(MessageType.Request, FunctionType.GetControllerCapabilities), expectedResponse(FunctionType.GetControllerCapabilities), priority(MessagePriority.Controller)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var GetControllerCapabilitiesRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            GetControllerCapabilitiesRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return GetControllerCapabilitiesRequest = _classThis;
})();
export { GetControllerCapabilitiesRequest };
let GetControllerCapabilitiesResponse = (() => {
    let _classDecorators = [messageTypes(MessageType.Response, FunctionType.GetControllerCapabilities)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var GetControllerCapabilitiesResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            GetControllerCapabilitiesResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.isSecondary = options.isSecondary;
            this.isUsingHomeIdFromOtherNetwork =
                options.isUsingHomeIdFromOtherNetwork;
            this.isSISPresent = options.isSISPresent;
            this.wasRealPrimary = options.wasRealPrimary;
            this.isStaticUpdateController = options.isStaticUpdateController;
            this.noNodesIncluded = options.noNodesIncluded;
        }
        static from(raw, _ctx) {
            const capabilityFlags = raw.payload[0];
            const isSecondary = !!(capabilityFlags & ControllerCapabilityFlags.Secondary);
            const isUsingHomeIdFromOtherNetwork = !!(capabilityFlags & ControllerCapabilityFlags.OnOtherNetwork);
            const isSISPresent = !!(capabilityFlags & ControllerCapabilityFlags.SISPresent);
            const wasRealPrimary = !!(capabilityFlags & ControllerCapabilityFlags.WasRealPrimary);
            const isStaticUpdateController = !!(capabilityFlags & ControllerCapabilityFlags.SUC);
            const noNodesIncluded = !!(capabilityFlags & ControllerCapabilityFlags.NoNodesIncluded);
            return new this({
                isSecondary,
                isUsingHomeIdFromOtherNetwork,
                isSISPresent,
                wasRealPrimary,
                isStaticUpdateController,
                noNodesIncluded,
            });
        }
        isSecondary;
        isUsingHomeIdFromOtherNetwork;
        isSISPresent;
        wasRealPrimary;
        isStaticUpdateController;
        noNodesIncluded;
        serialize(ctx) {
            this.payload = Bytes.from([
                (this.isSecondary ? ControllerCapabilityFlags.Secondary : 0)
                    | (this.isUsingHomeIdFromOtherNetwork
                        ? ControllerCapabilityFlags.OnOtherNetwork
                        : 0)
                    | (this.isSISPresent ? ControllerCapabilityFlags.SISPresent : 0)
                    | (this.wasRealPrimary
                        ? ControllerCapabilityFlags.WasRealPrimary
                        : 0)
                    | (this.isStaticUpdateController
                        ? ControllerCapabilityFlags.SUC
                        : 0)
                    | (this.noNodesIncluded
                        ? ControllerCapabilityFlags.NoNodesIncluded
                        : 0),
            ]);
            return super.serialize(ctx);
        }
    };
    return GetControllerCapabilitiesResponse = _classThis;
})();
export { GetControllerCapabilitiesResponse };
//# sourceMappingURL=GetControllerCapabilitiesMessages.js.map