var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { MessagePriority, NUM_LR_NODEMASK_SEGMENT_BYTES, NUM_LR_NODES_PER_SEGMENT, encodeLongRangeNodeBitMask, parseLongRangeNodeBitMask, } from "@zwave-js/core";
import { FunctionType, Message, MessageType, expectedResponse, messageTypes, priority, } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
function getFirstNodeId(segmentNumber) {
    return 256 + NUM_LR_NODES_PER_SEGMENT * segmentNumber;
}
let GetLongRangeNodesRequest = (() => {
    let _classDecorators = [messageTypes(MessageType.Request, FunctionType.GetLongRangeNodes), expectedResponse(FunctionType.GetLongRangeNodes), priority(MessagePriority.Controller)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var GetLongRangeNodesRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            GetLongRangeNodesRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.segmentNumber = options.segmentNumber;
        }
        static from(raw, _ctx) {
            const segmentNumber = raw.payload[0];
            return new this({
                segmentNumber,
            });
        }
        segmentNumber;
        serialize(ctx) {
            this.payload = Bytes.from([this.segmentNumber]);
            return super.serialize(ctx);
        }
    };
    return GetLongRangeNodesRequest = _classThis;
})();
export { GetLongRangeNodesRequest };
let GetLongRangeNodesResponse = (() => {
    let _classDecorators = [messageTypes(MessageType.Response, FunctionType.GetLongRangeNodes)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var GetLongRangeNodesResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            GetLongRangeNodesResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.moreNodes = options.moreNodes;
            this.segmentNumber = options.segmentNumber;
            this.nodeIds = options.nodeIds;
        }
        static from(raw, _ctx) {
            const moreNodes = raw.payload[0] != 0;
            const segmentNumber = raw.payload[1];
            const listLength = raw.payload[2];
            const listStart = 3;
            const listEnd = listStart + listLength;
            let nodeIds;
            if (listEnd <= raw.payload.length) {
                const nodeBitMask = raw.payload.subarray(listStart, listEnd);
                nodeIds = parseLongRangeNodeBitMask(nodeBitMask, getFirstNodeId(segmentNumber));
            }
            else {
                nodeIds = [];
            }
            return new this({
                moreNodes,
                segmentNumber,
                nodeIds,
            });
        }
        moreNodes;
        segmentNumber;
        nodeIds;
        serialize(ctx) {
            this.payload = new Bytes(3 + NUM_LR_NODEMASK_SEGMENT_BYTES);
            this.payload[0] = this.moreNodes ? 1 : 0;
            this.payload[1] = this.segmentNumber;
            this.payload[2] = NUM_LR_NODEMASK_SEGMENT_BYTES;
            const nodeBitMask = encodeLongRangeNodeBitMask(this.nodeIds, getFirstNodeId(this.segmentNumber));
            this.payload.set(nodeBitMask, 3);
            return super.serialize(ctx);
        }
    };
    return GetLongRangeNodesResponse = _classThis;
})();
export { GetLongRangeNodesResponse };
//# sourceMappingURL=GetLongRangeNodesMessages.js.map