import { type MessageOrCCLogEntry } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw, type SuccessIndicator } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
export interface SetRFReceiveModeRequestOptions {
    /** Whether the stick should receive (true) or not (false) */
    enabled: boolean;
}
export declare class SetRFReceiveModeRequest extends Message {
    constructor(options: SetRFReceiveModeRequestOptions & MessageBaseOptions);
    static from(_raw: MessageRaw, _ctx: MessageParsingContext): SetRFReceiveModeRequest;
    enabled: boolean;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface SetRFReceiveModeResponseOptions {
    success: boolean;
}
export declare class SetRFReceiveModeResponse extends Message implements SuccessIndicator {
    constructor(options: SetRFReceiveModeResponseOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): SetRFReceiveModeResponse;
    isOK(): boolean;
    readonly success: boolean;
    toLogEntry(): MessageOrCCLogEntry;
}
//# sourceMappingURL=SetRFReceiveModeMessages.d.ts.map