import { type BasicDeviceClass, type CommandClasses, type GetAllNodes, type ListenBehavior, type MessageOrCCLogEntry, type NodeId, NodeType, type NodeUpdatePayload, Protocols } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw, type SuccessIndicator } from "@zwave-js/serial";
import { Bytes, type BytesView } from "@zwave-js/shared";
export declare enum AddNodeType {
    Any = 1,
    Controller = 2,
    Slave = 3,
    Existing = 4,
    Stop = 5,
    StopControllerReplication = 6,
    SmartStartDSK = 8,
    SmartStartListen = 9
}
export declare enum AddNodeStatus {
    Ready = 1,
    NodeFound = 2,
    AddingSlave = 3,
    AddingController = 4,
    ProtocolDone = 5,
    Done = 6,
    Failed = 7
}
export interface AddNodeToNetworkRequestOptions {
    addNodeType?: AddNodeType;
    highPower?: boolean;
    networkWide?: boolean;
}
export interface AddNodeDSKToNetworkRequestOptions {
    nwiHomeId: BytesView;
    authHomeId: BytesView;
    highPower?: boolean;
    networkWide?: boolean;
    protocol?: Protocols;
}
export declare function computeNeighborDiscoveryTimeout(host: GetAllNodes<NodeId & ListenBehavior>, nodeType: NodeType): number;
export declare class AddNodeToNetworkRequestBase extends Message {
    static from(raw: MessageRaw, ctx: MessageParsingContext): AddNodeToNetworkRequestBase;
}
export declare class AddNodeToNetworkRequest extends AddNodeToNetworkRequestBase {
    constructor(options: AddNodeToNetworkRequestOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): AddNodeToNetworkRequest;
    /** The type of node to add */
    addNodeType: AddNodeType | undefined;
    /** Whether to use high power */
    highPower: boolean;
    /** Whether to include network wide */
    networkWide: boolean;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class EnableSmartStartListenRequest extends AddNodeToNetworkRequestBase {
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class AddNodeDSKToNetworkRequest extends AddNodeToNetworkRequestBase {
    constructor(options: AddNodeDSKToNetworkRequestOptions & MessageBaseOptions);
    /** The home IDs of node to add */
    nwiHomeId: BytesView;
    authHomeId: BytesView;
    /** Whether to use high power */
    highPower: boolean;
    /** Whether to include network wide */
    networkWide: boolean;
    /** Whether to include as long-range or not */
    protocol: Protocols;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export type AddNodeToNetworkRequestStatusReportOptions = {
    status: AddNodeStatus.Ready | AddNodeStatus.NodeFound | AddNodeStatus.ProtocolDone | AddNodeStatus.Failed;
} | {
    status: AddNodeStatus.Done;
    nodeId: number;
} | {
    status: AddNodeStatus.AddingController | AddNodeStatus.AddingSlave;
    nodeInfo: NodeUpdatePayload;
};
export declare class AddNodeToNetworkRequestStatusReport extends AddNodeToNetworkRequestBase implements SuccessIndicator {
    constructor(options: AddNodeToNetworkRequestStatusReportOptions & MessageBaseOptions);
    static from(raw: MessageRaw, ctx: MessageParsingContext): AddNodeToNetworkRequestStatusReport;
    isOK(): boolean;
    readonly status: AddNodeStatus;
    readonly statusContext: AddNodeStatusContext | undefined;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface AddNodeStatusContext {
    nodeId: number;
    basicDeviceClass?: BasicDeviceClass;
    genericDeviceClass?: number;
    specificDeviceClass?: number;
    supportedCCs?: CommandClasses[];
    controlledCCs?: CommandClasses[];
}
//# sourceMappingURL=AddNodeToNetworkRequest.d.ts.map