var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { MessagePriority, encodeNodeID, encodeNodeProtocolInfo, isLongRangeNodeId, parseNodeID, parseNodeProtocolInfo, } from "@zwave-js/core";
import { FunctionType, Message, MessageType, expectedResponse, messageTypes, priority, } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
import { isObject } from "alcalzone-shared/typeguards";
let GetNodeProtocolInfoRequest = (() => {
    let _classDecorators = [messageTypes(MessageType.Request, FunctionType.GetNodeProtocolInfo), expectedResponse(FunctionType.GetNodeProtocolInfo), priority(MessagePriority.Controller)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var GetNodeProtocolInfoRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            GetNodeProtocolInfoRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.requestedNodeId = options.requestedNodeId;
        }
        static from(raw, ctx) {
            const requestedNodeId = parseNodeID(raw.payload, ctx.nodeIdType, 0).nodeId;
            return new this({
                requestedNodeId,
            });
        }
        // This must not be called nodeId or the message will be treated as a node query
        // but this is a message to the controller
        requestedNodeId;
        serialize(ctx) {
            this.payload = encodeNodeID(this.requestedNodeId, ctx.nodeIdType);
            return super.serialize(ctx);
        }
    };
    return GetNodeProtocolInfoRequest = _classThis;
})();
export { GetNodeProtocolInfoRequest };
let GetNodeProtocolInfoResponse = (() => {
    let _classDecorators = [messageTypes(MessageType.Response, FunctionType.GetNodeProtocolInfo)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var GetNodeProtocolInfoResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            GetNodeProtocolInfoResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.isListening = options.isListening;
            this.isFrequentListening = options.isFrequentListening;
            this.isRouting = options.isRouting;
            this.supportedDataRates = options.supportedDataRates;
            this.protocolVersion = options.protocolVersion;
            this.optionalFunctionality = options.optionalFunctionality;
            this.nodeType = options.nodeType;
            this.supportsSecurity = options.supportsSecurity;
            this.supportsBeaming = options.supportsBeaming;
            this.basicDeviceClass = options.basicDeviceClass;
            this.genericDeviceClass = options.genericDeviceClass;
            this.specificDeviceClass = options.specificDeviceClass;
        }
        static from(raw, ctx) {
            // The context should contain the node ID the protocol info was requested for.
            // We use it here to determine whether the node is long range.
            let isLongRange = false;
            const requestContext = ctx.requestStorage?.get(FunctionType.GetNodeProtocolInfo);
            if (isObject(requestContext)
                && "nodeId" in requestContext
                && typeof requestContext.nodeId === "number") {
                isLongRange = isLongRangeNodeId(requestContext.nodeId);
            }
            const { hasSpecificDeviceClass, ...rest } = parseNodeProtocolInfo(raw.payload, 0, isLongRange);
            const isListening = rest.isListening;
            const isFrequentListening = rest.isFrequentListening;
            const isRouting = rest.isRouting;
            const supportedDataRates = rest.supportedDataRates;
            const protocolVersion = rest.protocolVersion;
            const optionalFunctionality = rest.optionalFunctionality;
            const nodeType = rest.nodeType;
            const supportsSecurity = rest.supportsSecurity;
            const supportsBeaming = rest.supportsBeaming;
            // parse the device class
            const basicDeviceClass = raw.payload[3];
            const genericDeviceClass = raw.payload[4];
            const specificDeviceClass = hasSpecificDeviceClass
                ? raw.payload[5]
                : 0x00;
            return new this({
                isListening,
                isFrequentListening,
                isRouting,
                supportedDataRates,
                protocolVersion,
                optionalFunctionality,
                nodeType,
                supportsSecurity,
                supportsBeaming,
                basicDeviceClass,
                genericDeviceClass,
                specificDeviceClass,
            });
        }
        /** Whether this node is always listening or not */
        isListening;
        /** Indicates the wakeup interval if this node is a FLiRS node. `false` if it isn't. */
        isFrequentListening;
        /** Whether the node supports routing/forwarding messages. */
        isRouting;
        supportedDataRates;
        protocolVersion;
        /** Whether this node supports additional CCs besides the mandatory minimum */
        optionalFunctionality;
        /** Whether this node is a controller (can calculate routes) or an end node (relies on route info) */
        nodeType;
        /** Whether this node supports security (S0 or S2) */
        supportsSecurity;
        /** Whether this node can issue wakeup beams to FLiRS nodes */
        supportsBeaming;
        basicDeviceClass;
        genericDeviceClass;
        specificDeviceClass;
        serialize(ctx) {
            const protocolInfo = encodeNodeProtocolInfo({
                isListening: this.isListening,
                isFrequentListening: this.isFrequentListening,
                isRouting: this.isRouting,
                supportedDataRates: this.supportedDataRates,
                protocolVersion: this.protocolVersion,
                optionalFunctionality: this.optionalFunctionality,
                nodeType: this.nodeType,
                supportsSecurity: this.supportsSecurity,
                supportsBeaming: this.supportsBeaming,
                hasSpecificDeviceClass: this.specificDeviceClass !== 0,
            });
            this.payload = Bytes.concat([
                protocolInfo,
                Bytes.from([
                    this.basicDeviceClass,
                    this.genericDeviceClass,
                    this.specificDeviceClass,
                ]),
            ]);
            return super.serialize(ctx);
        }
    };
    return GetNodeProtocolInfoResponse = _classThis;
})();
export { GetNodeProtocolInfoResponse };
//# sourceMappingURL=GetNodeProtocolInfoMessages.js.map