var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { MAX_REPEATERS, MessagePriority, RouteKind, ZWaveDataRate, ZWaveError, ZWaveErrorCodes, encodeNodeID, parseNodeID, } from "@zwave-js/core";
import { FunctionType, Message, MessageType, expectedResponse, messageTypes, priority, } from "@zwave-js/serial";
import { getEnumMemberName } from "@zwave-js/shared";
let GetPriorityRouteRequest = (() => {
    let _classDecorators = [messageTypes(MessageType.Request, FunctionType.GetPriorityRoute), priority(MessagePriority.Normal), expectedResponse(FunctionType.GetPriorityRoute)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var GetPriorityRouteRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            GetPriorityRouteRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            this.destinationNodeId = options.destinationNodeId;
        }
        static from(_raw, _ctx) {
            throw new ZWaveError(`${this.name}: deserialization not implemented`, ZWaveErrorCodes.Deserialization_NotImplemented);
            // return new GetPriorityRouteRequest({});
        }
        destinationNodeId;
        serialize(ctx) {
            this.payload = encodeNodeID(this.destinationNodeId, ctx.nodeIdType);
            return super.serialize(ctx);
        }
        toLogEntry() {
            return {
                ...super.toLogEntry(),
                message: {
                    "node ID": this.destinationNodeId,
                },
            };
        }
    };
    return GetPriorityRouteRequest = _classThis;
})();
export { GetPriorityRouteRequest };
let GetPriorityRouteResponse = (() => {
    let _classDecorators = [messageTypes(MessageType.Response, FunctionType.GetPriorityRoute)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var GetPriorityRouteResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            GetPriorityRouteResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            // TODO: Check implementation:
            this.destinationNodeId = options.destinationNodeId;
            this.routeKind = options.routeKind;
            this.repeaters = options.repeaters;
            this.routeSpeed = options.routeSpeed;
        }
        static from(raw, ctx) {
            let offset = 0;
            const { nodeId, bytesRead: nodeIdBytes } = parseNodeID(raw.payload, ctx.nodeIdType, offset);
            offset += nodeIdBytes;
            const destinationNodeId = nodeId;
            const routeKind = raw.payload[offset++];
            let repeaters;
            let routeSpeed;
            if (routeKind) {
                repeaters = [
                    ...raw.payload.subarray(offset, offset + MAX_REPEATERS),
                ].filter((id) => id > 0);
                routeSpeed = raw.payload[offset + MAX_REPEATERS];
            }
            return new this({
                destinationNodeId,
                routeKind,
                repeaters,
                routeSpeed,
            });
        }
        destinationNodeId;
        routeKind;
        repeaters;
        routeSpeed;
        toLogEntry() {
            let message = {
                "node ID": this.destinationNodeId,
            };
            if (this.routeKind !== RouteKind.None) {
                message = {
                    ...message,
                    "route kind": getEnumMemberName(RouteKind, this.routeKind),
                    repeaters: this.repeaters?.length
                        ? this.repeaters.join(" -> ")
                        : "none",
                    "route speed": getEnumMemberName(ZWaveDataRate, this.routeSpeed),
                };
            }
            else {
                message = {
                    ...message,
                    route: "(not set)",
                };
            }
            return {
                ...super.toLogEntry(),
                message,
            };
        }
    };
    return GetPriorityRouteResponse = _classThis;
})();
export { GetPriorityRouteResponse };
//# sourceMappingURL=GetPriorityRouteMessages.js.map