import { type MessageOrCCLogEntry } from "@zwave-js/core";
import { Message, type MessageBaseOptions, type MessageEncodingContext, type MessageParsingContext, type MessageRaw, type MultiStageCallback, type SuccessIndicator } from "@zwave-js/serial";
import { Bytes } from "@zwave-js/shared";
export declare enum NodeNeighborUpdateStatus {
    UpdateStarted = 33,
    UpdateDone = 34,
    UpdateFailed = 35
}
export declare class RequestNodeNeighborUpdateRequestBase extends Message {
    static from(raw: MessageRaw, ctx: MessageParsingContext): RequestNodeNeighborUpdateRequestBase;
}
export interface RequestNodeNeighborUpdateRequestOptions {
    nodeId: number;
    /** This must be determined with {@link computeNeighborDiscoveryTimeout} */
    discoveryTimeout: number;
}
export declare class RequestNodeNeighborUpdateRequest extends RequestNodeNeighborUpdateRequestBase {
    constructor(options: RequestNodeNeighborUpdateRequestOptions & MessageBaseOptions);
    nodeId: number;
    discoveryTimeout: number;
    serialize(ctx: MessageEncodingContext): Promise<Bytes>;
    getCallbackTimeout(): number | undefined;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface RequestNodeNeighborUpdateReportOptions {
    updateStatus: NodeNeighborUpdateStatus;
}
export declare class RequestNodeNeighborUpdateReport extends RequestNodeNeighborUpdateRequestBase implements SuccessIndicator, MultiStageCallback {
    constructor(options: RequestNodeNeighborUpdateReportOptions & MessageBaseOptions);
    static from(raw: MessageRaw, _ctx: MessageParsingContext): RequestNodeNeighborUpdateReport;
    isOK(): boolean;
    isFinal(): boolean;
    updateStatus: NodeNeighborUpdateStatus;
    toLogEntry(): MessageOrCCLogEntry;
}
//# sourceMappingURL=RequestNodeNeighborUpdateMessages.d.ts.map