var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { MessagePriority, ZWaveError, ZWaveErrorCodes, } from "@zwave-js/core";
import { FunctionType, Message, MessageType, expectedResponse, messageTypes, priority, } from "@zwave-js/serial";
import { Bytes, num2hex } from "@zwave-js/shared";
let ExtNVMReadLongBufferRequest = (() => {
    let _classDecorators = [messageTypes(MessageType.Request, FunctionType.ExtNVMReadLongBuffer), priority(MessagePriority.Controller), expectedResponse(FunctionType.ExtNVMReadLongBuffer)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var ExtNVMReadLongBufferRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ExtNVMReadLongBufferRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            if (options.offset < 0 || options.offset > 0xffffff) {
                throw new ZWaveError("The offset must be a 24-bit number!", ZWaveErrorCodes.Argument_Invalid);
            }
            if (options.length < 1 || options.length > 0xffff) {
                throw new ZWaveError("The length must be between 1 and 65535", ZWaveErrorCodes.Argument_Invalid);
            }
            this.offset = options.offset;
            this.length = options.length;
        }
        static from(_raw, _ctx) {
            throw new ZWaveError(`${this.name}: deserialization not implemented`, ZWaveErrorCodes.Deserialization_NotImplemented);
            // return new ExtNVMReadLongBufferRequest({});
        }
        offset;
        length;
        serialize(ctx) {
            this.payload = new Bytes(5);
            this.payload.writeUIntBE(this.offset, 0, 3);
            this.payload.writeUInt16BE(this.length, 3);
            return super.serialize(ctx);
        }
        toLogEntry() {
            return {
                ...super.toLogEntry(),
                message: {
                    offset: num2hex(this.offset),
                    length: this.length,
                },
            };
        }
    };
    return ExtNVMReadLongBufferRequest = _classThis;
})();
export { ExtNVMReadLongBufferRequest };
let ExtNVMReadLongBufferResponse = (() => {
    let _classDecorators = [messageTypes(MessageType.Response, FunctionType.ExtNVMReadLongBuffer)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var ExtNVMReadLongBufferResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            ExtNVMReadLongBufferResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            // TODO: Check implementation:
            this.buffer = options.buffer;
        }
        static from(raw, _ctx) {
            return new this({
                buffer: raw.payload,
            });
        }
        buffer;
        toLogEntry() {
            return {
                ...super.toLogEntry(),
                message: {
                    buffer: `(${this.buffer.length} byte${this.buffer.length === 1 ? "" : "s"})`,
                },
            };
        }
    };
    return ExtNVMReadLongBufferResponse = _classThis;
})();
export { ExtNVMReadLongBufferResponse };
//# sourceMappingURL=ExtNVMReadLongBufferMessages.js.map