var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
import { MAX_NODES, MessagePriority, TransmitOptions, TransmitStatus, ZWaveError, ZWaveErrorCodes, encodeNodeID, parseNodeID, } from "@zwave-js/core";
import { FunctionType, Message, MessageOrigin, MessageType, expectedCallback, expectedResponse, messageTypes, priority, } from "@zwave-js/serial";
import { Bytes, getEnumMemberName, num2hex, } from "@zwave-js/shared";
import { clamp } from "alcalzone-shared/math";
import { ApplicationCommandRequest } from "../application/ApplicationCommandRequest.js";
import { BridgeApplicationCommandRequest } from "../application/BridgeApplicationCommandRequest.js";
import { containsCC } from "../utils.js";
import { MAX_SEND_ATTEMPTS } from "./SendDataMessages.js";
import { encodeTXReport, parseTXReport, txReportToMessageRecord, } from "./SendDataShared.js";
let SendDataBridgeRequestBase = (() => {
    let _classDecorators = [messageTypes(MessageType.Request, FunctionType.SendDataBridge), priority(MessagePriority.Normal)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var SendDataBridgeRequestBase = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SendDataBridgeRequestBase = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        static from(raw, ctx) {
            if (ctx.origin === MessageOrigin.Host) {
                return SendDataBridgeRequest.from(raw, ctx);
            }
            else {
                return SendDataBridgeRequestTransmitReport.from(raw, ctx);
            }
        }
    };
    return SendDataBridgeRequestBase = _classThis;
})();
export { SendDataBridgeRequestBase };
let SendDataBridgeRequest = (() => {
    let _classDecorators = [expectedResponse(FunctionType.SendDataBridge), expectedCallback(FunctionType.SendDataBridge)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SendDataBridgeRequestBase;
    var SendDataBridgeRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SendDataBridgeRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            if ("command" in options) {
                if (!options.command.isSinglecast()
                    && !options.command.isBroadcast()) {
                    throw new ZWaveError(`SendDataBridgeRequest can only be used for singlecast and broadcast CCs`, ZWaveErrorCodes.Argument_Invalid);
                }
                this.command = options.command;
                this._nodeId = options.command.nodeId;
            }
            else {
                this._nodeId = options.nodeId;
                this.serializedCC = options.serializedCC;
            }
            this.sourceNodeId = options.sourceNodeId;
            this.transmitOptions = options.transmitOptions
                ?? TransmitOptions.DEFAULT;
            if (options.maxSendAttempts != undefined) {
                this.maxSendAttempts = options.maxSendAttempts;
            }
        }
        static from(raw, ctx) {
            let offset = 0;
            let parseResult = parseNodeID(raw.payload, ctx.nodeIdType);
            const sourceNodeId = parseResult.nodeId;
            offset += parseResult.bytesRead;
            parseResult = parseNodeID(raw.payload, ctx.nodeIdType, offset);
            const destinationNodeId = parseResult.nodeId;
            offset += parseResult.bytesRead;
            const ccLength = raw.payload[offset++];
            const serializedCC = raw.payload.slice(offset, offset + ccLength);
            offset += ccLength;
            const transmitOptions = raw.payload[offset++];
            // The route field is unused
            offset += 4;
            const callbackId = raw.payload[offset++];
            return new this({
                sourceNodeId,
                nodeId: destinationNodeId,
                serializedCC,
                transmitOptions,
                callbackId,
            });
        }
        /** Which Node ID this command originates from */
        sourceNodeId;
        /** The command this message contains */
        command;
        /** Options regarding the transmission of the message */
        transmitOptions;
        _maxSendAttempts = 1;
        /** The number of times the driver may try to send this message */
        get maxSendAttempts() {
            return this._maxSendAttempts;
        }
        set maxSendAttempts(value) {
            this._maxSendAttempts = clamp(value, 1, MAX_SEND_ATTEMPTS);
        }
        _nodeId;
        getNodeId() {
            return this.command?.nodeId ?? this._nodeId;
        }
        serializedCC;
        async serializeCC(ctx) {
            if (!this.serializedCC) {
                if (!this.command) {
                    throw new ZWaveError(`Cannot serialize a ${this.constructor.name} without a command`, ZWaveErrorCodes.Argument_Invalid);
                }
                this.serializedCC = await this.command.serialize(ctx);
            }
            return this.serializedCC;
        }
        prepareRetransmission() {
            this.command?.prepareRetransmission();
            this.serializedCC = undefined;
            this.callbackId = undefined;
        }
        async serialize(ctx) {
            this.assertCallbackId();
            const sourceNodeId = encodeNodeID(this.sourceNodeId, ctx.nodeIdType);
            const destinationNodeId = encodeNodeID(this.command?.nodeId ?? this._nodeId, ctx.nodeIdType);
            const serializedCC = await this.serializeCC(ctx);
            this.payload = Bytes.concat([
                sourceNodeId,
                destinationNodeId,
                Bytes.from([serializedCC.length]),
                serializedCC,
                Bytes.from([this.transmitOptions, 0, 0, 0, 0, this.callbackId]),
            ]);
            return super.serialize(ctx);
        }
        toLogEntry() {
            return {
                ...super.toLogEntry(),
                message: {
                    "source node id": this.sourceNodeId,
                    "transmit options": num2hex(this.transmitOptions),
                    "callback id": this.callbackId ?? "(not set)",
                },
            };
        }
        expectsNodeUpdate() {
            return (
            // We can only answer this if the command is known
            this.command != undefined
                // Only true singlecast commands may expect a response
                && this.command.isSinglecast()
                // ... and only if the command expects a response
                && this.command.expectsCCResponse());
        }
        isExpectedNodeUpdate(msg) {
            return (
            // We can only answer this if the command is known
            this.command != undefined
                && (msg instanceof ApplicationCommandRequest
                    || msg instanceof BridgeApplicationCommandRequest)
                && containsCC(msg)
                && this.command.isExpectedCCResponse(msg.command));
        }
    };
    return SendDataBridgeRequest = _classThis;
})();
export { SendDataBridgeRequest };
export class SendDataBridgeRequestTransmitReport extends SendDataBridgeRequestBase {
    constructor(options) {
        super(options);
        this.callbackId = options.callbackId;
        this.transmitStatus = options.transmitStatus;
        this.txReport = options.txReport;
    }
    static from(raw, _ctx) {
        const callbackId = raw.payload[0];
        const transmitStatus = raw.payload[1];
        // TODO: Consider NOT parsing this for transmit status other than OK or NoACK
        const txReport = parseTXReport(transmitStatus !== TransmitStatus.NoAck, raw.payload.subarray(2));
        return new this({
            callbackId,
            transmitStatus,
            txReport,
        });
    }
    transmitStatus;
    txReport;
    isOK() {
        return this.transmitStatus === TransmitStatus.OK;
    }
    serialize(ctx) {
        this.assertCallbackId();
        this.payload = Bytes.from([this.callbackId, this.transmitStatus]);
        if (this.txReport) {
            this.payload = Bytes.concat([
                this.payload,
                encodeTXReport(this.txReport),
            ]);
        }
        return super.serialize(ctx);
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "callback id": this.callbackId ?? "(not set)",
                "transmit status": getEnumMemberName(TransmitStatus, this.transmitStatus)
                    + (this.txReport
                        ? `, took ${this.txReport.txTicks * 10} ms`
                        : ""),
                // Show TX report fields for OK and NoAck (NoAck still provides useful routing info)
                ...(this.txReport && (this.transmitStatus === TransmitStatus.OK
                    || this.transmitStatus === TransmitStatus.NoAck)
                    ? txReportToMessageRecord(this.txReport)
                    : {}),
            },
        };
    }
}
let SendDataBridgeResponse = (() => {
    let _classDecorators = [messageTypes(MessageType.Response, FunctionType.SendDataBridge)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var SendDataBridgeResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SendDataBridgeResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            // TODO: Check implementation:
            this.wasSent = options.wasSent;
        }
        static from(raw, _ctx) {
            const wasSent = raw.payload[0] !== 0;
            return new this({
                wasSent,
            });
        }
        isOK() {
            return this.wasSent;
        }
        wasSent;
        toLogEntry() {
            return {
                ...super.toLogEntry(),
                message: { "was sent": this.wasSent },
            };
        }
    };
    return SendDataBridgeResponse = _classThis;
})();
export { SendDataBridgeResponse };
let SendDataMulticastBridgeRequestBase = (() => {
    let _classDecorators = [messageTypes(MessageType.Request, FunctionType.SendDataMulticastBridge), priority(MessagePriority.Normal)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var SendDataMulticastBridgeRequestBase = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SendDataMulticastBridgeRequestBase = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        static from(raw, ctx) {
            if (ctx.origin === MessageOrigin.Host) {
                return SendDataMulticastBridgeRequest.from(raw, ctx);
            }
            else {
                return SendDataMulticastBridgeRequestTransmitReport.from(raw, ctx);
            }
        }
    };
    return SendDataMulticastBridgeRequestBase = _classThis;
})();
export { SendDataMulticastBridgeRequestBase };
let SendDataMulticastBridgeRequest = (() => {
    let _classDecorators = [expectedResponse(FunctionType.SendDataMulticastBridge), expectedCallback(FunctionType.SendDataMulticastBridge)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = SendDataMulticastBridgeRequestBase;
    var SendDataMulticastBridgeRequest = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SendDataMulticastBridgeRequest = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            if ("command" in options) {
                if (!options.command.isMulticast()) {
                    throw new ZWaveError(`SendDataMulticastBridgeRequest can only be used for multicast CCs`, ZWaveErrorCodes.Argument_Invalid);
                }
                else if (options.command.nodeId.length === 0) {
                    throw new ZWaveError(`At least one node must be targeted`, ZWaveErrorCodes.Argument_Invalid);
                }
                else if (options.command.nodeId.some((n) => n < 1 || n > MAX_NODES)) {
                    throw new ZWaveError(`All node IDs must be between 1 and ${MAX_NODES}!`, ZWaveErrorCodes.Argument_Invalid);
                }
                this.command = options.command;
                this.nodeIds = this.command.nodeId;
            }
            else {
                this.nodeIds = options.nodeIds;
                this.serializedCC = options.serializedCC;
            }
            this.sourceNodeId = options.sourceNodeId;
            this.transmitOptions = options.transmitOptions
                ?? TransmitOptions.DEFAULT;
            if (options.maxSendAttempts != undefined) {
                this.maxSendAttempts = options.maxSendAttempts;
            }
        }
        static from(raw, ctx) {
            const { nodeId: sourceNodeId, bytesRead } = parseNodeID(raw.payload, ctx.nodeIdType);
            let offset = bytesRead;
            const destinationNodeIdCount = raw.payload[offset++];
            const nodeIds = [];
            for (let i = 0; i < destinationNodeIdCount; i++) {
                const { nodeId, bytesRead } = parseNodeID(raw.payload, ctx.nodeIdType, offset);
                nodeIds.push(nodeId);
                offset += bytesRead;
            }
            const ccLength = raw.payload[offset++];
            const serializedCC = raw.payload.slice(offset, offset + ccLength);
            offset += ccLength;
            const transmitOptions = raw.payload[offset++];
            const callbackId = raw.payload[offset++];
            return new this({
                sourceNodeId,
                nodeIds: nodeIds,
                serializedCC,
                transmitOptions,
                callbackId,
            });
        }
        /** Which Node ID this command originates from */
        sourceNodeId;
        /** The command this message contains */
        command;
        /** Options regarding the transmission of the message */
        transmitOptions;
        _maxSendAttempts = 1;
        /** The number of times the driver may try to send this message */
        get maxSendAttempts() {
            return this._maxSendAttempts;
        }
        set maxSendAttempts(value) {
            this._maxSendAttempts = clamp(value, 1, MAX_SEND_ATTEMPTS);
        }
        nodeIds;
        getNodeId() {
            // This is multicast, getNodeId must return undefined here
            return undefined;
        }
        serializedCC;
        async serializeCC(ctx) {
            if (!this.serializedCC) {
                if (!this.command) {
                    throw new ZWaveError(`Cannot serialize a ${this.constructor.name} without a command`, ZWaveErrorCodes.Argument_Invalid);
                }
                this.serializedCC = await this.command.serialize(ctx);
            }
            return this.serializedCC;
        }
        prepareRetransmission() {
            this.command?.prepareRetransmission();
            this.serializedCC = undefined;
            this.callbackId = undefined;
        }
        async serialize(ctx) {
            this.assertCallbackId();
            const serializedCC = await this.serializeCC(ctx);
            const sourceNodeId = encodeNodeID(this.sourceNodeId, ctx.nodeIdType);
            const destinationNodeIDs = (this.command?.nodeId ?? this.nodeIds)
                .map((id) => encodeNodeID(id, ctx.nodeIdType));
            this.payload = Bytes.concat([
                sourceNodeId,
                // # of target nodes, not # of bytes
                Bytes.from([destinationNodeIDs.length]),
                ...destinationNodeIDs,
                Bytes.from([serializedCC.length]),
                // payload
                serializedCC,
                Bytes.from([this.transmitOptions, this.callbackId]),
            ]);
            return super.serialize(ctx);
        }
        toLogEntry() {
            return {
                ...super.toLogEntry(),
                message: {
                    "source node id": this.sourceNodeId,
                    "target nodes": (this.command?.nodeId ?? this.nodeIds).join(", "),
                    "transmit options": num2hex(this.transmitOptions),
                    "callback id": this.callbackId ?? "(not set)",
                },
            };
        }
    };
    return SendDataMulticastBridgeRequest = _classThis;
})();
export { SendDataMulticastBridgeRequest };
export class SendDataMulticastBridgeRequestTransmitReport extends SendDataMulticastBridgeRequestBase {
    constructor(options) {
        super(options);
        this.callbackId = options.callbackId;
        this.transmitStatus = options.transmitStatus;
    }
    static from(raw, _ctx) {
        const callbackId = raw.payload[0];
        const transmitStatus = raw.payload[1];
        return new this({
            callbackId,
            transmitStatus,
        });
    }
    transmitStatus;
    isOK() {
        return this.transmitStatus === TransmitStatus.OK;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "callback id": this.callbackId ?? "(not set)",
                "transmit status": getEnumMemberName(TransmitStatus, this.transmitStatus),
            },
        };
    }
}
let SendDataMulticastBridgeResponse = (() => {
    let _classDecorators = [messageTypes(MessageType.Response, FunctionType.SendDataMulticastBridge)];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = Message;
    var SendDataMulticastBridgeResponse = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            SendDataMulticastBridgeResponse = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
            __runInitializers(_classThis, _classExtraInitializers);
        }
        constructor(options) {
            super(options);
            // TODO: Check implementation:
            this.wasSent = options.wasSent;
        }
        static from(raw, _ctx) {
            const wasSent = raw.payload[0] !== 0;
            return new this({
                wasSent,
            });
        }
        isOK() {
            return this.wasSent;
        }
        wasSent;
        toLogEntry() {
            return {
                ...super.toLogEntry(),
                message: { "was sent": this.wasSent },
            };
        }
    };
    return SendDataMulticastBridgeResponse = _classThis;
})();
export { SendDataMulticastBridgeResponse };
//# sourceMappingURL=SendDataBridgeMessages.js.map