"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var common_exports = {};
__export(common_exports, {
  firmwareUpdateOutgoingMessage: () => firmwareUpdateOutgoingMessage,
  getRawConfigParameterValue: () => getRawConfigParameterValue,
  setRawConfigParameterValue: () => setRawConfigParameterValue,
  setValueOutgoingMessage: () => setValueOutgoingMessage
});
module.exports = __toCommonJS(common_exports);
var import_zwave_js = require("zwave-js");
var import_error = require("./error.js");
function setValueOutgoingMessage(result, schemaVersion) {
  if (schemaVersion < 29) {
    return {
      success: [
        import_zwave_js.SetValueStatus.Working,
        import_zwave_js.SetValueStatus.Success,
        import_zwave_js.SetValueStatus.SuccessUnsupervised
      ].includes(result.status)
    };
  }
  return { result };
}
function firmwareUpdateOutgoingMessage(result, schemaVersion) {
  if (schemaVersion < 29) {
    return {
      success: result.success
    };
  }
  return { result };
}
async function setRawConfigParameterValue(message, nodeOrEndpoint) {
  if (message.valueSize !== void 0 && message.valueFormat === void 0 || message.valueSize === void 0 && message.valueFormat !== void 0) {
    throw new import_error.InvalidParamsPassedToCommandError("valueFormat and valueSize must be used in combination or not at all");
  }
  if (message.valueSize !== void 0 && message.bitMask !== void 0) {
    throw new import_error.InvalidParamsPassedToCommandError("bitMask cannot be used in combination with valueFormat and valueSize");
  }
  let options;
  if (message.bitMask !== void 0) {
    options = {
      parameter: message.parameter,
      bitMask: message.bitMask,
      value: message.value
    };
  } else {
    options = {
      parameter: message.parameter,
      valueFormat: message.valueFormat,
      valueSize: message.valueSize,
      value: message.value
    };
  }
  const result = await nodeOrEndpoint.commandClasses.Configuration.set(options);
  return { result };
}
async function getRawConfigParameterValue(message, nodeOrEndpoint) {
  const value = await nodeOrEndpoint.commandClasses.Configuration.get(message.parameter, {
    valueBitMask: message.bitMask
  });
  return { value };
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  firmwareUpdateOutgoingMessage,
  getRawConfigParameterValue,
  setRawConfigParameterValue,
  setValueOutgoingMessage
});
//# sourceMappingURL=common.js.map
