"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var message_handler_exports = {};
__export(message_handler_exports, {
  DriverMessageHandler: () => DriverMessageHandler
});
module.exports = __toCommonJS(message_handler_exports);
var import_zwave_js = require("zwave-js");
var import_error = require("../error.js");
var import_command = require("./command.js");
var import_state = require("../state.js");
class DriverMessageHandler {
  remoteController;
  clientsController;
  logger;
  driver;
  client;
  constructor(remoteController, clientsController, logger, driver, client) {
    this.remoteController = remoteController;
    this.clientsController = clientsController;
    this.logger = logger;
    this.driver = driver;
    this.client = client;
  }
  async handle(message) {
    const { command } = message;
    switch (message.command) {
      case import_command.DriverCommand.getConfig: {
        const config = (0, import_state.dumpDriver)(this.driver, this.client.schemaVersion);
        return { config };
      }
      case import_command.DriverCommand.disableStatistics: {
        this.driver.disableStatistics();
        return {};
      }
      case import_command.DriverCommand.enableStatistics: {
        this.driver.enableStatistics({
          applicationName: message.applicationName,
          applicationVersion: message.applicationVersion
        });
        return {};
      }
      case import_command.DriverCommand.getLogConfig: {
        const config = (0, import_state.dumpLogConfig)(this.driver, this.client.schemaVersion);
        return { config };
      }
      case import_command.DriverCommand.updateLogConfig: {
        this.driver.updateLogConfig(message.config);
        this.clientsController.restartLoggingEventForwarderIfNeeded();
        this.clientsController.clients.forEach((cl) => {
          cl.sendEvent({
            source: "driver",
            event: "log config updated",
            config: (0, import_state.dumpLogConfig)(this.driver, cl.schemaVersion)
          });
        });
        return {};
      }
      case import_command.DriverCommand.isStatisticsEnabled: {
        const statisticsEnabled = this.driver.statisticsEnabled;
        return { statisticsEnabled };
      }
      case import_command.DriverCommand.startListeningLogs: {
        this.client.receiveLogs = true;
        this.clientsController.configureLoggingEventForwarder(message.filter);
        return {};
      }
      case import_command.DriverCommand.stopListeningLogs: {
        this.client.receiveLogs = false;
        this.clientsController.cleanupLoggingEventForwarder();
        return {};
      }
      case import_command.DriverCommand.checkForConfigUpdates: {
        const installedVersion = this.driver.configVersion;
        const newVersion = await this.driver.checkForConfigUpdates();
        const updateAvailable = newVersion !== void 0;
        return { installedVersion, updateAvailable, newVersion };
      }
      case import_command.DriverCommand.installConfigUpdate: {
        const success = await this.driver.installConfigUpdate();
        return { success };
      }
      case import_command.DriverCommand.setPreferredScales: {
        this.driver.setPreferredScales(message.scales);
        return {};
      }
      case import_command.DriverCommand.enableErrorReporting: {
        this.logger.warn("Z-Wave JS no longer supports enabling error reporting. If you are using an application that integrates with Z-Wave JS and you receive this error, you may need to update the application.");
        return {};
      }
      case import_command.DriverCommand.softReset: {
        await this.driver.softReset();
        return {};
      }
      case import_command.DriverCommand.trySoftReset: {
        await this.driver.trySoftReset();
        return {};
      }
      case import_command.DriverCommand.hardReset: {
        setTimeout(() => this.remoteController.hardResetController(), 1);
        return {};
      }
      case import_command.DriverCommand.shutdown: {
        const success = await this.driver.shutdown();
        return { success };
      }
      case import_command.DriverCommand.updateOptions: {
        this.driver.updateOptions(message.options);
        return {};
      }
      case import_command.DriverCommand.sendTestFrame: {
        const status = await this.driver.sendTestFrame(message.nodeId, message.powerlevel);
        return { status };
      }
      case import_command.DriverCommand.firmwareUpdateOTW: {
        let result;
        if ("updateInfo" in message) {
          result = await this.driver.firmwareUpdateOTW(message.updateInfo);
        } else {
          const file = Buffer.from(message.file, "base64");
          const { data } = await (0, import_zwave_js.extractFirmware)(file, message.fileFormat ?? (0, import_zwave_js.guessFirmwareFileFormat)(message.filename, file));
          result = await this.driver.firmwareUpdateOTW(data);
        }
        return { result };
      }
      case import_command.DriverCommand.isOTWFirmwareUpdateInProgress: {
        const progress = this.driver.isOTWFirmwareUpdateInProgress();
        return { progress };
      }
      default: {
        throw new import_error.UnknownCommandError(command);
      }
    }
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  DriverMessageHandler
});
//# sourceMappingURL=message_handler.js.map
