import { SetValueStatus, } from "zwave-js";
import { InvalidParamsPassedToCommandError } from "./error.js";
export function setValueOutgoingMessage(result, schemaVersion) {
    if (schemaVersion < 29) {
        return {
            success: [
                SetValueStatus.Working,
                SetValueStatus.Success,
                SetValueStatus.SuccessUnsupervised,
            ].includes(result.status),
        };
    }
    return { result };
}
export function firmwareUpdateOutgoingMessage(result, schemaVersion) {
    if (schemaVersion < 29) {
        return {
            success: result.success,
        };
    }
    return { result };
}
export async function setRawConfigParameterValue(message, nodeOrEndpoint) {
    if ((message.valueSize !== undefined && message.valueFormat === undefined) ||
        (message.valueSize === undefined && message.valueFormat !== undefined)) {
        throw new InvalidParamsPassedToCommandError("valueFormat and valueSize must be used in combination or not at all");
    }
    if (message.valueSize !== undefined && message.bitMask !== undefined) {
        throw new InvalidParamsPassedToCommandError("bitMask cannot be used in combination with valueFormat and valueSize");
    }
    let options;
    if (message.bitMask !== undefined) {
        options = {
            parameter: message.parameter,
            bitMask: message.bitMask,
            value: message.value,
        };
    }
    else {
        options = {
            parameter: message.parameter,
            valueFormat: message.valueFormat,
            valueSize: message.valueSize,
            value: message.value,
        };
    }
    const result = await nodeOrEndpoint.commandClasses.Configuration.set(options);
    return { result };
}
export async function getRawConfigParameterValue(message, nodeOrEndpoint) {
    const value = await nodeOrEndpoint.commandClasses.Configuration.get(message.parameter, {
        valueBitMask: message.bitMask,
    });
    return { value };
}
