import { Driver } from "zwave-js";
import { Client, ClientsController } from "../server.js";
import { ZnifferCommand } from "./command.js";
import { IncomingMessageZniffer } from "./incoming_message.js";
import { ZnifferResultTypes } from "./outgoing_message.js";
import { OutgoingEvent } from "../outgoing_message.js";
import { MessageHandler } from "../message_handler.js";
export declare class ZnifferMessageHandler implements MessageHandler {
    private driver;
    private clientsController;
    private zniffer?;
    constructor(driver: Driver, clientsController: ClientsController);
    forwardEvent(data: OutgoingEvent, minSchemaVersion?: number): void;
    sendEvent(client: Client, data: OutgoingEvent, minSchemaVersion?: number): void;
    handle(message: IncomingMessageZniffer): Promise<ZnifferResultTypes[ZnifferCommand]>;
}
