import type { PresetModuleLoader, UnknownPresetCreatorParams, UnknownPreset, PresetParams } from './types.js';
/**
 * Creates preset loader.
 * @param moduleLoader - Function that loads module.
 * @returns Function that loads preset.
 */
export declare function createPresetLoader(moduleLoader: PresetModuleLoader): <Preset = UnknownPreset, PresetCreatorParams extends UnknownPresetCreatorParams = UnknownPresetCreatorParams>(presetOrParams: PresetParams<PresetCreatorParams>) => Promise<Preset>;
/**
 * Load and create preset.
 */
export declare const loadPreset: <Preset = UnknownPreset, PresetCreatorParams extends UnknownPresetCreatorParams = UnknownPresetCreatorParams>(presetOrParams: PresetParams<PresetCreatorParams>) => Promise<Preset>;
//# sourceMappingURL=presetLoader.d.ts.map