'use strict';

const path = require('node:path');
function hyphenate(/* istanbul ignore next */
str = '') {
  return str.replace(/\B([A-Z])/g, '-$1').toLowerCase();
}
function classify(str) {
  return str.replace(/(?:^|[-_])(\w)/g, c => c.toUpperCase()).replace(/[-_]/g, '');
}
const specialAttrs = ['style', 'class', 'id', 'contenteditable', 'draggable', 'spellcheck', 'key', 'ref', 'slot', 'is', 'slot-scope'];
function isBuiltinAttribute(name) {
  return specialAttrs.includes(name) || name.startsWith('data-') || name.startsWith('aria-');
}
function getAttributes(element) {
  const attrs = [];
  element.startTag.attributes.forEach(node => {
    if (node.directive && (node.key.name.name !== 'bind' || !node.key.argument)) return;
    const name = hyphenate(node.directive ? node.key.argument.name : node.key.rawName);
    if (!isBuiltinAttribute(name)) attrs.push({
      name,
      node
    });
  });
  return attrs;
}
function isObject(obj) {
  return obj !== null && typeof obj === 'object';
}
function mergeDeep(source, target) {
  for (const key in target) {
    const sourceProperty = source[key];
    const targetProperty = target[key];

    // Only continue deep merging if
    // both properties are objects
    if (isObject(sourceProperty) && isObject(targetProperty)) {
      source[key] = mergeDeep(sourceProperty, targetProperty);
      continue;
    }
    source[key] = targetProperty;
  }
  return source;
}
function isVueTemplate(context) {
  if (context.sourceCode.parserServices.defineTemplateBodyVisitor == null) {
    return path.extname(context.getFilename()) === '.vue';
  }
  return true;
}
module.exports = {
  hyphenate,
  classify,
  isBuiltinAttribute,
  getAttributes,
  isObject,
  mergeDeep,
  isVueTemplate
};