"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Manager = void 0;
const node_fs_1 = require("node:fs");
const node_os_1 = require("node:os");
const node_path_1 = require("node:path");
const store_1 = require("./store");
class Manager {
    incoming;
    outgoing;
    constructor(path, options) {
        if (!path) {
            path = (0, node_path_1.join)((0, node_os_1.homedir)(), ".mqtt-jsonl-store");
            (0, node_fs_1.mkdirSync)(path);
        }
        else {
            // check path exists and is a directory
            const stat = (0, node_fs_1.statSync)(path);
            if (!stat.isDirectory()) {
                throw new Error(`Path ${path} is not a directory`);
            }
        }
        const incomingOptions = options?.incoming || options;
        const outgoingOptions = options?.outgoing || options;
        this.incoming = new store_1.MqttJsonlStore((0, node_path_1.join)(path, "incoming.jsonl"), incomingOptions);
        this.outgoing = new store_1.MqttJsonlStore((0, node_path_1.join)(path, "outgoing.jsonl"), outgoingOptions);
    }
    async open() {
        await Promise.all([this.incoming.open(), this.outgoing.open()]);
        return {
            incoming: this.incoming,
            outgoing: this.outgoing,
        };
    }
    async close() {
        await Promise.all([this.incoming.closeAsync(), this.outgoing.closeAsync()]);
    }
}
exports.Manager = Manager;
//# sourceMappingURL=manager.js.map