"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Controller_exports = {};
__export(Controller_exports, {
  ZWaveController: () => ZWaveController
});
module.exports = __toCommonJS(Controller_exports);
var import_cc = require("@zwave-js/cc");
var import_core = require("@zwave-js/core");
var import_nvmedit = require("@zwave-js/nvmedit");
var import_serial = require("@zwave-js/serial");
var import_serialapi = require("@zwave-js/serial/serialapi");
var import_shared = require("@zwave-js/shared");
var import_waddle = require("@zwave-js/waddle");
var import_arrays = require("alcalzone-shared/arrays");
var import_async = require("alcalzone-shared/async");
var import_deferred_promise = require("alcalzone-shared/deferred-promise");
var import_typeguards = require("alcalzone-shared/typeguards");
var import_NetworkCache = require("../driver/NetworkCache.js");
var import_Task = require("../driver/Task.js");
var import_DeviceClass = require("../node/DeviceClass.js");
var import_Node = require("../node/Node.js");
var import_VirtualNode = require("../node/VirtualNode.js");
var import_Types = require("../node/_Types.js");
var import_ControllerStatistics = require("./ControllerStatistics.js");
var import_Features = require("./Features.js");
var import_FirmwareUpdateService = require("./FirmwareUpdateService.js");
var import_Inclusion = require("./Inclusion.js");
var import_NVMIO = require("./NVMIO.js");
var import_NodeInformationFrame = require("./NodeInformationFrame.js");
var import_Proprietary = require("./Proprietary.js");
var import_ProxyInclusionMachine = require("./ProxyInclusionMachine.js");
var import_ZWaveSDKVersions = require("./ZWaveSDKVersions.js");
var import_utils = require("./utils.js");
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
let ZWaveController = (() => {
  let _classDecorators = [(0, import_shared.Mixin)([import_ControllerStatistics.ControllerStatisticsHost])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_shared.TypedEventTarget;
  var ZWaveController2 = class extends _classSuper {
    static {
      __name(this, "ZWaveController");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ZWaveController2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    /** @internal */
    constructor(driver) {
      super();
      this.driver = driver;
      this._nodes = (0, import_shared.createThrowingMap)((nodeId) => {
        throw new import_core.ZWaveError(`Node ${nodeId} was not found!`, import_core.ZWaveErrorCodes.Controller_NodeNotFound, nodeId);
      });
      driver.registerRequestHandler(import_serial.FunctionType.SetLearnMode, this.handleLearnModeCallback.bind(this));
    }
    driver;
    _type;
    get type() {
      return this._type;
    }
    _protocolVersion;
    get protocolVersion() {
      return this._protocolVersion;
    }
    _sdkVersion;
    get sdkVersion() {
      return this._sdkVersion;
    }
    _zwaveApiVersion;
    get zwaveApiVersion() {
      return this._zwaveApiVersion;
    }
    _zwaveChipType;
    get zwaveChipType() {
      return this._zwaveChipType;
    }
    _homeId;
    /** A 32bit number identifying the current network */
    get homeId() {
      return this._homeId;
    }
    _ownNodeId;
    /** The ID of the controller in the current network */
    get ownNodeId() {
      return this._ownNodeId;
    }
    _dsk;
    /**
     * The device specific key (DSK) of the controller in binary format.
     */
    async getDSK() {
      if (this._dsk == void 0) {
        const { publicKey } = await this.driver.getLearnModeAuthenticatedKeyPair();
        this._dsk = publicKey.subarray(0, 16);
      }
      return this._dsk;
    }
    /** @deprecated Use {@link role} instead */
    get isPrimary() {
      switch (this.role) {
        case import_core.NOT_KNOWN:
          return import_core.NOT_KNOWN;
        case import_core.ControllerRole.Primary:
          return true;
        default:
          return false;
      }
    }
    // This seems odd, but isPrimary comes from the Serial API init data command,
    // while isSecondary comes from the GetControllerCapabilities command. They don't really do what their name implies
    // and sometimes contradict each other...
    _isPrimary;
    _isSecondary;
    _isUsingHomeIdFromOtherNetwork;
    /** @deprecated Use {@link role} instead */
    get isUsingHomeIdFromOtherNetwork() {
      return this._isUsingHomeIdFromOtherNetwork;
    }
    _isSISPresent;
    get isSISPresent() {
      return this._isSISPresent;
    }
    _wasRealPrimary;
    /** @deprecated Use {@link role} instead */
    get wasRealPrimary() {
      return this._wasRealPrimary;
    }
    _isSIS;
    get isSIS() {
      return this._isSIS;
    }
    _isSUC;
    get isSUC() {
      return this._isSUC;
    }
    _noNodesIncluded;
    _nodeType;
    get nodeType() {
      return this._nodeType;
    }
    /** Checks if the SDK version is greater than the given one */
    sdkVersionGt(version) {
      return (0, import_core.sdkVersionGt)(this._sdkVersion, version);
    }
    /** Checks if the SDK version is greater than or equal to the given one */
    sdkVersionGte(version) {
      return (0, import_core.sdkVersionGte)(this._sdkVersion, version);
    }
    /** Checks if the SDK version is lower than the given one */
    sdkVersionLt(version) {
      return (0, import_core.sdkVersionLt)(this._sdkVersion, version);
    }
    /** Checks if the SDK version is lower than or equal to the given one */
    sdkVersionLte(version) {
      return (0, import_core.sdkVersionLte)(this._sdkVersion, version);
    }
    _manufacturerId;
    get manufacturerId() {
      return this._manufacturerId;
    }
    _productType;
    get productType() {
      return this._productType;
    }
    _productId;
    get productId() {
      return this._productId;
    }
    _firmwareVersion;
    get firmwareVersion() {
      return this._firmwareVersion;
    }
    _supportedFunctionTypes;
    get supportedFunctionTypes() {
      return this._supportedFunctionTypes;
    }
    _status = import_core.ControllerStatus.Ready;
    /**
     * Which status the controller is believed to be in
     */
    get status() {
      return this._status;
    }
    /**
     * @internal
     */
    setStatus(newStatus) {
      if (newStatus === this._status)
        return;
      const oldStatus = this._status;
      this._status = newStatus;
      if (newStatus === import_core.ControllerStatus.Jammed) {
        this.driver.controllerLog.print("The controller is jammed", "warn");
      } else if (newStatus === import_core.ControllerStatus.Unresponsive) {
        this.driver.controllerLog.print("The controller is unresponsive", "warn");
      } else if (newStatus === import_core.ControllerStatus.Ready) {
        if (oldStatus === import_core.ControllerStatus.Jammed) {
          this.driver.controllerLog.print("The controller is no longer jammed", "warn");
        } else if (oldStatus === import_core.ControllerStatus.Unresponsive) {
          this.driver.controllerLog.print("The controller is no longer unresponsive", "warn");
        } else {
          this.driver.controllerLog.print("The controller is ready");
        }
      }
      this.emit("status changed", newStatus);
    }
    /**
     * Checks if a given Z-Wave function type is supported by this controller.
     * Returns `NOT_KNOWN`/`undefined` if this information isn't known yet.
     */
    isFunctionSupported(functionType) {
      if (!this._supportedFunctionTypes)
        return import_core.NOT_KNOWN;
      return this._supportedFunctionTypes.includes(functionType);
    }
    _supportedSerialAPISetupCommands;
    get supportedSerialAPISetupCommands() {
      return this._supportedSerialAPISetupCommands;
    }
    /**
     * Checks if a given Serial API setup command is supported by this controller.
     * Returns `NOT_KNOWN`/`undefined` if this information isn't known yet.
     */
    isSerialAPISetupCommandSupported(command) {
      if (!this._supportedSerialAPISetupCommands)
        return import_core.NOT_KNOWN;
      return this._supportedSerialAPISetupCommands.includes(command);
    }
    /**
     * Tests if the controller supports a certain feature.
     * Returns `undefined` if this information isn't known yet.
     */
    supportsFeature(feature) {
      switch (feature) {
        case import_Features.ZWaveFeature.SmartStart:
          return this.sdkVersionGte(import_Features.minFeatureVersions[feature]);
      }
    }
    /** Throws if the controller does not support a certain feature */
    assertFeature(feature) {
      if (!this.supportsFeature(feature)) {
        throw new import_core.ZWaveError(`The controller does not support the ${(0, import_shared.getEnumMemberName)(import_Features.ZWaveFeature, feature)} feature`, import_core.ZWaveErrorCodes.Controller_NotSupported);
      }
    }
    _sucNodeId;
    get sucNodeId() {
      return this._sucNodeId;
    }
    _supportsTimers;
    get supportsTimers() {
      return this._supportsTimers;
    }
    _supportedRegions;
    /** Which RF regions are supported by the controller, including information about them */
    get supportedRegions() {
      return this._supportedRegions;
    }
    _rfRegion;
    /** Which RF region the controller is currently set to, or `undefined` if it could not be determined (yet). This value is cached and can be changed through {@link setRFRegion}. */
    get rfRegion() {
      return this._rfRegion;
    }
    _txPower;
    /** The transmit power used for Z-Wave mesh, or `undefined` if it could not be determined (yet). This value is cached and can be changed through {@link setPowerlevel}. */
    get txPower() {
      return this._txPower;
    }
    _powerlevelCalibration;
    /** The calibration value for the transmit power, or `undefined` if it could not be determined (yet). This value is cached and can be changed through {@link setPowerlevel}. */
    get powerlevelCalibration() {
      return this._powerlevelCalibration;
    }
    _supportsLongRange;
    /** Whether the controller supports the Z-Wave Long Range protocol */
    get supportsLongRange() {
      return this._supportsLongRange;
    }
    _maxLongRangePowerlevel;
    /** The maximum powerlevel to use for Z-Wave Long Range, or `undefined` if it could not be determined (yet). This value is cached and can be changed through {@link setMaxLongRangePowerlevel}. */
    get maxLongRangePowerlevel() {
      return this._maxLongRangePowerlevel;
    }
    _longRangeChannel;
    /** The channel to use for Z-Wave Long Range, or `undefined` if it could not be determined (yet). This value is cached and can be changed through {@link setLongRangeChannel}. */
    get longRangeChannel() {
      return this._longRangeChannel;
    }
    _supportsLongRangeAutoChannelSelection;
    /** Whether automatic LR channel selection is supported, or `undefined` if it could not be determined (yet). */
    get supportsLongRangeAutoChannelSelection() {
      return this._supportsLongRangeAutoChannelSelection;
    }
    _maxPayloadSize;
    /** The maximum payload size that can be transmitted with a Z-Wave explorer frame */
    get maxPayloadSize() {
      return this._maxPayloadSize;
    }
    _maxPayloadSizeLR;
    /** The maximum payload size that can be transmitted with a Z-Wave Long Range frame */
    get maxPayloadSizeLR() {
      return this._maxPayloadSizeLR;
    }
    _nodes;
    /** A dictionary of the nodes connected to this controller */
    get nodes() {
      return this._nodes;
    }
    _nodeIdType = import_core.NodeIDType.Short;
    /** Whether the controller is configured to use 8 or 16 bit node IDs */
    get nodeIdType() {
      return this._nodeIdType;
    }
    /** @internal */
    set nodeIdType(value) {
      this._nodeIdType = value;
    }
    /** Returns the node with the given DSK */
    getNodeByDSK(dsk) {
      try {
        if (typeof dsk === "string")
          dsk = (0, import_core.dskFromString)(dsk);
      } catch (e) {
        if ((0, import_core.isZWaveError)(e) && e.code === import_core.ZWaveErrorCodes.Argument_Invalid) {
          return void 0;
        }
        throw e;
      }
      for (const node of this._nodes.values()) {
        if (node.dsk && import_shared.Bytes.view(node.dsk).equals(dsk))
          return node;
      }
    }
    /** Returns the controller node's value DB */
    get valueDB() {
      return this._nodes.get(this._ownNodeId).valueDB;
    }
    /** @internal Which associations are currently configured */
    get associations() {
      return this.driver.cacheGet(import_NetworkCache.cacheKeys.controller.associations(1)) ?? [];
    }
    /** @internal */
    set associations(value) {
      this.driver.cacheSet(import_NetworkCache.cacheKeys.controller.associations(1), value);
    }
    _powerlevel;
    /**
     * @internal
     * Remembers which powerlevel was set by another node.
     */
    get powerlevel() {
      return this._powerlevel ?? {
        powerlevel: import_cc.Powerlevel["Normal Power"],
        until: /* @__PURE__ */ new Date()
      };
    }
    /** @internal */
    set powerlevel(value) {
      this._powerlevel = value;
    }
    /** The role of the controller on the network */
    get role() {
      if (this._wasRealPrimary)
        return import_core.ControllerRole.Primary;
      if (this._isPrimary && this._isSIS && this._isSecondary === false) {
        return import_core.ControllerRole.Primary;
      }
      switch (this._isSecondary) {
        case true:
          return import_core.ControllerRole.Secondary;
        case false:
          return import_core.ControllerRole.Inclusion;
        default:
          return import_core.NOT_KNOWN;
      }
    }
    /** Returns whether learn mode may be enabled on this controller */
    get isLearnModePermitted() {
      if (this.role === import_core.ControllerRole.Primary) {
        return !!this._noNodesIncluded;
      } else {
        return this._isSUC === false;
      }
    }
    /**
     * @internal
     * Remembers the indicator values set by another node
     */
    indicatorValues = /* @__PURE__ */ new Map();
    /** Returns whether the routes are currently being rebuilt for one or more nodes. */
    get isRebuildingRoutes() {
      return !!this.driver.scheduler.findTask(import_utils.isRebuildRoutesTask);
    }
    /**
     * Returns a reference to the (virtual) broadcast node, which allows sending commands to all nodes.
     * This automatically groups nodes by security class, ignores nodes that cannot be controlled via multicast/broadcast, and will fall back to multicast(s) if necessary.
     */
    getBroadcastNode() {
      return new import_VirtualNode.VirtualNode(import_core.NODE_ID_BROADCAST, this.driver, this.nodes.values());
    }
    /**
     * Returns a reference to the (virtual) broadcast node for Z-Wave Long Range, which allows sending commands to all LR nodes.
     * This automatically groups nodes by security class, ignores nodes that cannot be controlled via multicast/broadcast, and will fall back to multicast(s) if necessary.
     */
    getBroadcastNodeLR() {
      return new import_VirtualNode.VirtualNode(import_core.NODE_ID_BROADCAST_LR, this.driver, this.nodes.values());
    }
    /**
     * Creates a virtual node that can be used to send one or more multicast commands to several nodes.
     * This automatically groups nodes by security class and ignores nodes that cannot be controlled via multicast.
     */
    getMulticastGroup(nodeIDs) {
      if (nodeIDs.length === 0) {
        throw new import_core.ZWaveError("Cannot create an empty multicast group", import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      const nodes = nodeIDs.map((id) => this._nodes.getOrThrow(id));
      return new import_VirtualNode.VirtualNode(void 0, this.driver, nodes);
    }
    /** @internal */
    get provisioningList() {
      return this.driver.cacheGet(import_NetworkCache.cacheKeys.controller.provisioningList) ?? [];
    }
    set provisioningList(value) {
      this.driver.cacheSet(import_NetworkCache.cacheKeys.controller.provisioningList, value);
    }
    /** @internal Tracks the number of failed SmartStart inclusion attempts per DSK */
    _smartStartFailedAttempts = /* @__PURE__ */ new Map();
    /** @internal Resets the SmartStart inclusion failure counter for the given DSK */
    resetSmartStartFailureCount(dsk) {
      this._smartStartFailedAttempts.delete(dsk);
    }
    /** Adds the given entry (DSK and security classes) to the controller's SmartStart provisioning list or replaces an existing entry */
    provisionSmartStartNode(entry) {
      this.assertFeature(import_Features.ZWaveFeature.SmartStart);
      (0, import_utils.assertProvisioningEntry)(entry);
      const provisioningList = [...this.provisioningList];
      const index = provisioningList.findIndex((e) => e.dsk === entry.dsk);
      if (index === -1) {
        provisioningList.push(entry);
      } else {
        provisioningList[index] = entry;
      }
      this.provisioningList = provisioningList;
      this.resetSmartStartFailureCount(entry.dsk);
      this.autoProvisionSmartStart();
    }
    /**
     * Removes the given DSK or node ID from the controller's SmartStart provisioning list.
     *
     * **Note:** If this entry corresponds to an included node, it will **NOT** be excluded
     */
    unprovisionSmartStartNode(dskOrNodeId) {
      const provisioningList = [...this.provisioningList];
      const entry = this.getProvisioningEntryInternal(dskOrNodeId);
      if (!entry)
        return;
      const index = provisioningList.indexOf(entry);
      if (index >= 0) {
        provisioningList.splice(index, 1);
        this.provisioningList = provisioningList;
        this.resetSmartStartFailureCount(entry.dsk);
        this.autoProvisionSmartStart();
      }
    }
    getProvisioningEntryInternal(dskOrNodeId) {
      if (typeof dskOrNodeId === "string") {
        return this.provisioningList.find((e) => e.dsk === dskOrNodeId);
      } else {
        let ret = this.provisioningList.find((e) => "nodeId" in e && e.nodeId === dskOrNodeId);
        if (!ret) {
          const dsk = this.nodes.get(dskOrNodeId)?.dsk;
          if (dsk) {
            ret = this.provisioningList.find((e) => e.dsk === (0, import_core.dskToString)(dsk));
          }
        }
        return ret;
      }
    }
    /**
     * Returns the entry for the given DSK or node ID from the controller's SmartStart provisioning list.
     */
    getProvisioningEntry(dskOrNodeId) {
      const entry = this.getProvisioningEntryInternal(dskOrNodeId);
      if (entry) {
        const ret = {
          ...entry
        };
        const node = typeof dskOrNodeId === "string" ? this.getNodeByDSK(dskOrNodeId) : this.nodes.get(dskOrNodeId);
        if (node)
          ret.nodeId = node.id;
        return ret;
      }
    }
    /**
     * Returns all entries from the controller's SmartStart provisioning list.
     */
    getProvisioningEntries() {
      const dskNodeMap = /* @__PURE__ */ new Map();
      for (const node of this.nodes.values()) {
        if (node.dsk)
          dskNodeMap.set((0, import_core.dskToString)(node.dsk), node.id);
      }
      return this.provisioningList.map((e) => {
        const { dsk, securityClasses, nodeId, ...rest } = e;
        return {
          dsk,
          securityClasses: [...securityClasses],
          ...dskNodeMap.has(dsk) ? { nodeId: dskNodeMap.get(dsk) } : {},
          ...rest
        };
      });
    }
    /** Returns whether the SmartStart provisioning list contains active entries that have not been included yet */
    hasPlannedProvisioningEntries() {
      return this.provisioningList.some((e) => (e.status == void 0 || e.status === import_Inclusion.ProvisioningEntryStatus.Active) && !this.getNodeByDSK(e.dsk));
    }
    /**
     * @internal
     * Automatically starts smart start inclusion if there are nodes pending inclusion.
     */
    autoProvisionSmartStart() {
      if (!this.supportsFeature(import_Features.ZWaveFeature.SmartStart))
        return;
      if (this.hasPlannedProvisioningEntries()) {
        void this.enableSmartStart().catch(import_shared.noop);
      } else {
        void this.disableSmartStart().catch(import_shared.noop);
      }
    }
    /**
     * @internal
     * Queries the controller / serial API capabilities.
     * Returns a list of Z-Wave classic node IDs that are currently in the network.
     */
    async queryCapabilities() {
      this.driver.controllerLog.print(`querying Serial API capabilities...`);
      const apiCaps = await this.driver.sendMessage(new import_serialapi.GetSerialApiCapabilitiesRequest(), {
        supportCheck: false
      });
      this._firmwareVersion = apiCaps.firmwareVersion;
      this._manufacturerId = apiCaps.manufacturerId;
      this._productType = apiCaps.productType;
      this._productId = apiCaps.productId;
      this._supportedFunctionTypes = apiCaps.supportedFunctionTypes;
      this.driver.controllerLog.print(`received API capabilities:
  firmware version:    ${this._firmwareVersion}
  manufacturer ID:     ${(0, import_shared.num2hex)(this._manufacturerId)}
  product type:        ${(0, import_shared.num2hex)(this._productType)}
  product ID:          ${(0, import_shared.num2hex)(this._productId)}
  supported functions: ${this._supportedFunctionTypes.map((fn) => `
  \xB7 ${import_serial.FunctionType[fn]} (${(0, import_shared.num2hex)(fn)})`).join("")}`);
      const initData = await this.getSerialApiInitData();
      this.driver.controllerLog.print(`querying version info...`);
      const version = await this.driver.sendMessage(new import_serialapi.GetControllerVersionRequest(), {
        supportCheck: false
      });
      this._protocolVersion = version.libraryVersion;
      this._type = version.controllerType;
      this.driver.controllerLog.print(`received version info:
  controller type: ${(0, import_shared.getEnumMemberName)(import_core.ZWaveLibraryTypes, this._type)}
  library version: ${this._protocolVersion}`);
      if (this.isFunctionSupported(import_serial.FunctionType.GetProtocolVersion)) {
        this.driver.controllerLog.print(`querying protocol version info...`);
        const protocol = await this.driver.sendMessage(new import_serialapi.GetProtocolVersionRequest());
        this._protocolVersion = protocol.protocolVersion;
        let message = `received protocol version info:
  protocol type:             ${(0, import_shared.getEnumMemberName)(import_core.ProtocolType, protocol.protocolType)}
  protocol version:          ${protocol.protocolVersion}`;
        if (protocol.applicationFrameworkBuildNumber) {
          message += `
  appl. framework build no.: ${protocol.applicationFrameworkBuildNumber}`;
        }
        if (protocol.gitCommitHash) {
          message += `
  git commit hash:           ${protocol.gitCommitHash}`;
        }
        this.driver.controllerLog.print(message);
      }
      this._sdkVersion = (0, import_ZWaveSDKVersions.protocolVersionToSDKVersion)(this._protocolVersion);
      await this.getControllerCapabilities();
      if (this.isFunctionSupported(import_serial.FunctionType.SerialAPISetup)) {
        this.driver.controllerLog.print(`querying serial API setup capabilities...`);
        const setupCaps = await this.driver.sendMessage(new import_serialapi.SerialAPISetup_GetSupportedCommandsRequest());
        this._supportedSerialAPISetupCommands = setupCaps.supportedCommands;
        this.driver.controllerLog.print(`supported serial API setup commands:${this._supportedSerialAPISetupCommands.map((cmd) => `
\xB7 ${(0, import_shared.getEnumMemberName)(import_serialapi.SerialAPISetupCommand, cmd)}`).join("")}`);
      } else {
        this._supportedSerialAPISetupCommands = [];
      }
      if (this.isSerialAPISetupCommandSupported(import_serialapi.SerialAPISetupCommand.GetMaximumPayloadSize)) {
        this.driver.controllerLog.print(`querying max. payload size...`);
        this._maxPayloadSize = await this.getMaxPayloadSize();
        this.driver.controllerLog.print(`maximum payload size: ${this._maxPayloadSize} bytes`);
      }
      if (!this.isLongRangeCapable()) {
        this._supportsLongRange = false;
        this._supportsLongRangeAutoChannelSelection = false;
      }
      this.driver.controllerLog.print(`supported Z-Wave features: ${Object.keys(import_Features.ZWaveFeature).filter((k) => /^\d+$/.test(k)).map((k) => parseInt(k)).filter((feat) => this.supportsFeature(feat)).map((feat) => `
  \xB7 ${(0, import_shared.getEnumMemberName)(import_Features.ZWaveFeature, feat)}`).join("")}`);
      return {
        nodeIds: initData.nodeIds
      };
    }
    /**
     * @internal
     * Queries the controller's capabilities in regards to Z-Wave Long Range.
     * Returns the list of Long Range node IDs
     */
    async queryLongRangeCapabilities() {
      this.driver.controllerLog.print(`querying Z-Wave Long Range capabilities...`);
      const lrNodeIds = await this.getLongRangeNodes();
      if (this.isSerialAPISetupCommandSupported(import_serialapi.SerialAPISetupCommand.GetLongRangeMaximumPayloadSize)) {
        this._maxPayloadSizeLR = await this.getMaxPayloadSizeLongRange();
      }
      this.driver.controllerLog.print(`received Z-Wave Long Range capabilities:
  max. payload size: ${this._maxPayloadSizeLR} bytes
  nodes:             ${lrNodeIds.join(", ")}`);
      return {
        lrNodeIds
      };
    }
    isLongRangeCapable() {
      return this.isSerialAPISetupCommandSupported(import_serialapi.SerialAPISetupCommand.SetNodeIDType);
    }
    /**
     * Helper function to determine whether the controller is capable of EU Long Range,
     * possibly without advertising it
     */
    isEULongRangeCapable() {
      return this.isLongRangeCapable() && typeof this._zwaveChipType === "string" && (0, import_core.getChipTypeAndVersion)(this._zwaveChipType)?.type === 8 && this.sdkVersionGte("7.22");
    }
    /** Tries to determine the LR capable replacement of the given region. If none is found, the given region is returned. */
    tryGetLRCapableRegion(region) {
      if (this._supportedRegions) {
        if (this._supportedRegions.get(region)?.supportsLongRange) {
          return region;
        }
        for (const info of this._supportedRegions.values()) {
          if (info.supportsLongRange && info.includesRegion === region) {
            return info.region;
          }
        }
      }
      if (region === import_core.RFRegion.USA && this.isLongRangeCapable()) {
        return import_core.RFRegion["USA (Long Range)"];
      }
      if (region === import_core.RFRegion.Europe && this.isEULongRangeCapable()) {
        return import_core.RFRegion["Europe (Long Range)"];
      }
      return region;
    }
    /**
     * @internal
     * Queries the region and powerlevel settings and configures them if necessary
     */
    async queryAndConfigureRF() {
      if (this.isSerialAPISetupCommandSupported(import_serialapi.SerialAPISetupCommand.GetSupportedRegions)) {
        this.driver.controllerLog.print(`Querying supported RF regions and their information...`);
        const supportedRegions = await this.querySupportedRFRegions().catch(() => []);
        this._supportedRegions = /* @__PURE__ */ new Map();
        for (const region of supportedRegions) {
          try {
            const info = await this.queryRFRegionInfo(region);
            if (info.region === import_core.RFRegion.Unknown)
              continue;
            this._supportedRegions.set(region, info);
          } catch {
            continue;
          }
        }
        this.driver.controllerLog.print(`supported regions:${[...this._supportedRegions.values()].map((info) => {
          let ret = `
\xB7 ${(0, import_shared.getEnumMemberName)(import_core.RFRegion, info.region)}`;
          if (info.includesRegion != void 0) {
            ret += ` \xB7 superset of ${(0, import_shared.getEnumMemberName)(import_core.RFRegion, info.includesRegion)}`;
          }
          if (info.supportsLongRange) {
            ret += " \xB7 ZWLR";
            if (!info.supportsZWave) {
              ret += " only";
            }
          }
          return ret;
        }).join("")}`);
      }
      if (this.isSerialAPISetupCommandSupported(import_serialapi.SerialAPISetupCommand.GetRFRegion)) {
        this.driver.controllerLog.print(`Querying configured RF region...`);
        const resp = await this.getRFRegion().catch(() => void 0);
        if (resp != void 0) {
          this.driver.controllerLog.print(`The controller is using RF region ${(0, import_shared.getEnumMemberName)(import_core.RFRegion, resp)}`);
        } else {
          this.driver.controllerLog.print(`Querying the RF region failed!`, "warn");
        }
      }
      if (this.isSerialAPISetupCommandSupported(import_serialapi.SerialAPISetupCommand.GetPowerlevel)) {
        this.driver.controllerLog.print(`Querying configured powerlevel...`);
        const resp = await this.getPowerlevel().catch(() => void 0);
        if (resp != void 0) {
          this.driver.controllerLog.print(`The powerlevel is ${resp.powerlevel} dBm (${resp.measured0dBm} dBm calibration)`);
        } else {
          this.driver.controllerLog.print(`Querying the powerlevel failed!`, "warn");
        }
      }
      if (this.isSerialAPISetupCommandSupported(import_serialapi.SerialAPISetupCommand.GetLongRangeMaximumTxPower)) {
        this.driver.controllerLog.print(`Querying configured max. Long Range powerlevel...`);
        const resp = await this.getMaxLongRangePowerlevel().catch(() => void 0);
        if (resp != void 0) {
          this.driver.controllerLog.print(`The max. LR powerlevel is ${resp.toFixed(1)} dBm`);
        } else {
          this.driver.controllerLog.print(`Querying the max. Long Range powerlevel failed!`, "warn");
        }
      }
      let desiredRFRegion;
      if (this.driver.options.rf?.region != void 0) {
        desiredRFRegion = this.driver.options.rf.region;
      }
      if (this.driver.options.rf?.preferLRRegion !== false) {
        desiredRFRegion ??= this.rfRegion;
        if (desiredRFRegion != void 0) {
          desiredRFRegion = this.tryGetLRCapableRegion(desiredRFRegion);
        }
      }
      if (this.isSerialAPISetupCommandSupported(import_serialapi.SerialAPISetupCommand.SetRFRegion) && desiredRFRegion != void 0 && this.rfRegion != desiredRFRegion) {
        this.driver.controllerLog.print(`Current RF region (${(0, import_shared.getEnumMemberName)(import_core.RFRegion, this.rfRegion ?? import_core.RFRegion.Unknown)}) differs from desired region (${(0, import_shared.getEnumMemberName)(import_core.RFRegion, desiredRFRegion)}), configuring it...`);
        const isRegionActuallyDifferent = this.tryGetLRCapableRegion(this.rfRegion ?? import_core.RFRegion.Unknown) !== this.tryGetLRCapableRegion(desiredRFRegion);
        const resp = await this.setRFRegionInternal(
          desiredRFRegion,
          // Do not soft reset here, we'll do it later
          false
        ).catch((e) => e.message);
        if (resp === true) {
          this.driver.controllerLog.print(`Changed RF region to ${(0, import_shared.getEnumMemberName)(import_core.RFRegion, desiredRFRegion)}`);
        } else {
          this.driver.controllerLog.print(`Changing the RF region failed!${resp ? ` Reason: ${resp}` : ""}`, "warn");
        }
        if (resp === true && isRegionActuallyDifferent) {
          await this.applyLegalPowerlevelLimits(desiredRFRegion, this.driver.options.rf?.txPower?.powerlevel === "auto", this.driver.options.rf?.maxLongRangePowerlevel === "auto");
        }
      }
      let desiredTXPowerlevelMesh;
      let desiredTXPowerlevelLR;
      if (typeof this.driver.options.rf?.txPower?.powerlevel === "number") {
        desiredTXPowerlevelMesh = this.driver.options.rf.txPower.powerlevel;
      }
      if (typeof this.driver.options.rf?.maxLongRangePowerlevel === "number") {
        desiredTXPowerlevelLR = this.driver.options.rf.maxLongRangePowerlevel;
      }
      if (desiredTXPowerlevelMesh != void 0) {
        await this.applyDesiredPowerlevelMesh(desiredTXPowerlevelMesh);
      }
      if (desiredTXPowerlevelLR != void 0) {
        await this.applyDesiredPowerlevelLR(desiredTXPowerlevelLR);
      }
      if (this.driver.options.rf?.txPower?.powerlevel === "auto" && this._rfRegion != void 0 && this._txPower === 20 && this._maxLongRangePowerlevel === 20) {
        const legalPowerlevelMesh = (0, import_core.getLegalPowerlevelMesh)(this._rfRegion);
        const legalPowerlevelLR = (0, import_core.getLegalPowerlevelLR)(this._rfRegion);
        if (legalPowerlevelMesh != void 0 || legalPowerlevelLR != void 0) {
          this.driver.controllerLog.print(`The controller is set to incorrect powerlevel defaults, correcting them...`);
        }
        if (legalPowerlevelMesh != void 0) {
          await this.setPowerlevel(legalPowerlevelMesh, this._powerlevelCalibration ?? 0).catch(import_shared.noop);
        }
        if (legalPowerlevelLR != void 0) {
          await this.setMaxLongRangePowerlevel(legalPowerlevelLR).catch(import_shared.noop);
        }
      }
      if (this.isFunctionSupported(import_serial.FunctionType.GetLongRangeChannel)) {
        this.driver.controllerLog.print(`Querying configured Long Range channel information...`);
        const resp = await this.getLongRangeChannel().catch(() => void 0);
        if (resp != void 0) {
          this.driver.controllerLog.print(`received Z-Wave Long Range channel information:
  channel:                         ${resp.channel != void 0 ? (0, import_shared.getEnumMemberName)(import_core.LongRangeChannel, resp.channel) : "(unknown)"}
  supports auto channel selection: ${resp.supportsAutoChannelSelection}
`);
        } else {
          this.driver.controllerLog.print(`Querying the Long Range channel information failed!`, "warn");
        }
      } else {
        this._supportsLongRangeAutoChannelSelection = false;
      }
      if (this.isFunctionSupported(import_serial.FunctionType.SetLongRangeChannel) && this.driver.options.rf?.longRangeChannel != void 0 && this.longRangeChannel !== this.driver.options.rf.longRangeChannel) {
        const desired = this.driver.options.rf.longRangeChannel;
        if (desired === import_core.LongRangeChannel.Auto && !this._supportsLongRangeAutoChannelSelection) {
          this.driver.controllerLog.print(`Cannot set desired LR channel to Auto because the controller does not support it!`, "warn");
        } else {
          this.driver.controllerLog.print(`Current LR channel ${this.longRangeChannel != void 0 ? (0, import_shared.getEnumMemberName)(import_core.LongRangeChannel, this.longRangeChannel) : "(unknown)"} differs from desired channel ${(0, import_shared.getEnumMemberName)(import_core.LongRangeChannel, desired)}, configuring it...`);
          const resp = await this.setLongRangeChannel(desired).catch((e) => e.message);
          if (resp === true) {
            this.driver.controllerLog.print(`LR channel updated`);
          } else {
            this.driver.controllerLog.print(`Changing the LR channel failed!${resp ? ` Reason: ${resp}` : ""}`, "warn");
          }
        }
      }
    }
    /**
     * @internal
     * Queries the home and node id of the controller
     */
    async identify() {
      this.driver.controllerLog.print(`querying controller IDs...`);
      const ids = await this.driver.sendMessage(new import_serialapi.GetControllerIdRequest(), { supportCheck: false });
      this._homeId = ids.homeId;
      this._ownNodeId = ids.ownNodeId;
      this.driver.controllerLog.print(`received controller IDs:
  home ID:     ${(0, import_shared.num2hex)(this._homeId)}
  own node ID: ${this._ownNodeId}`);
    }
    /**
     * @internal
     * Performs additional controller configuration
     */
    async configure() {
      if (this.isSerialAPISetupCommandSupported(import_serialapi.SerialAPISetupCommand.SetTxStatusReport)) {
        this.driver.controllerLog.print(`Enabling TX status report...`);
        const resp = await this.driver.sendMessage(new import_serialapi.SerialAPISetup_SetTXStatusReportRequest({
          enabled: true
        }));
        this.driver.controllerLog.print(`Enabling TX status report ${resp.success ? "successful" : "failed"}...`);
      }
      this.driver.controllerLog.print(`finding SUC...`);
      const suc = await this.driver.sendMessage(new import_serialapi.GetSUCNodeIdRequest(), { supportCheck: false });
      this._sucNodeId = suc.sucNodeId;
      if (this._sucNodeId === 0) {
        this.driver.controllerLog.print(`No SUC present in the network`);
      } else if (this._sucNodeId === this._ownNodeId) {
        this.driver.controllerLog.print(`This is the SUC`);
      } else {
        this.driver.controllerLog.print(`SUC has node ID ${this.sucNodeId}`);
      }
      if (this.role === import_core.ControllerRole.Primary && this._noNodesIncluded && this._sucNodeId === 0 && !this._isSUC && !this._isSISPresent) {
        this.driver.controllerLog.print(`There is no SUC/SIS in the network - promoting ourselves...`);
        try {
          const result = await this.configureSUC(this._ownNodeId, true, true);
          if (result) {
            this._sucNodeId = this._ownNodeId;
            this._isSUC = true;
            this._isSISPresent = true;
          }
          this.driver.controllerLog.print(`Promotion to SUC/SIS ${result ? "succeeded" : "failed"}.`, result ? void 0 : "warn");
        } catch (e) {
          this.driver.controllerLog.print(`Error while promoting to SUC/SIS: ${(0, import_shared.getErrorMessage)(e)}`, "error");
        }
      }
      if (this.type !== import_core.ZWaveLibraryTypes["Bridge Controller"] && this.isFunctionSupported(import_serial.FunctionType.SetSerialApiTimeouts)) {
        const { ack, byte } = this.driver.options.timeouts;
        this.driver.controllerLog.print(`setting serial API timeouts: ack = ${ack} ms, byte = ${byte} ms`);
        const resp = await this.driver.sendMessage(new import_serialapi.SetSerialApiTimeoutsRequest({
          ackTimeout: ack,
          byteTimeout: byte
        }));
        this.driver.controllerLog.print(`serial API timeouts overwritten. The old values were: ack = ${resp.oldAckTimeout} ms, byte = ${resp.oldByteTimeout} ms`);
      }
    }
    /** @internal */
    async interviewProprietary() {
      for (const impl of Object.values(this.proprietary)) {
        if (typeof impl.interview === "function") {
          await impl.interview();
        }
      }
    }
    /** @internal */
    async handleUnsolictedProprietaryCommand(msg) {
      for (const impl of Object.values(this.proprietary)) {
        if (typeof impl.handleUnsolicited === "function") {
          if (await impl.handleUnsolicited(msg)) {
            return true;
          }
        }
      }
      return false;
    }
    /**
     * @internal
     * Interviews the controller for the necessary information.
     * @param restoreFromCache Asynchronous callback for the driver to restore the network from cache after nodes are created
     */
    async initNodes(classicNodeIds, lrNodeIds, restoreFromCache) {
      const valueDBIndexes = (0, import_core.indexDBsByNode)([
        this.driver.valueDB,
        this.driver.metadataDB
      ]);
      const nodeIds = [...classicNodeIds];
      if (nodeIds.length === 0) {
        this.driver.controllerLog.print(`Controller reports no nodes in its network. This could be an indication of a corrupted controller memory.`, "warn");
        nodeIds.unshift(this._ownNodeId);
      }
      nodeIds.push(...lrNodeIds);
      for (const nodeId of nodeIds) {
        this._nodes.set(nodeId, new import_Node.ZWaveNode(
          nodeId,
          this.driver,
          void 0,
          void 0,
          void 0,
          // Use the previously created index to avoid doing extra work when creating the value DB
          this.createValueDBForNode(nodeId, valueDBIndexes.get(nodeId))
        ));
      }
      await restoreFromCache();
      const controllerValueDB = this.valueDB;
      controllerValueDB.setMetadata(import_cc.ManufacturerSpecificCCValues.manufacturerId.id, import_cc.ManufacturerSpecificCCValues.manufacturerId.meta);
      controllerValueDB.setMetadata(import_cc.ManufacturerSpecificCCValues.productType.id, import_cc.ManufacturerSpecificCCValues.productType.meta);
      controllerValueDB.setMetadata(import_cc.ManufacturerSpecificCCValues.productId.id, import_cc.ManufacturerSpecificCCValues.productId.meta);
      controllerValueDB.setValue(import_cc.ManufacturerSpecificCCValues.manufacturerId.id, this._manufacturerId);
      controllerValueDB.setValue(import_cc.ManufacturerSpecificCCValues.productType.id, this._productType);
      controllerValueDB.setValue(import_cc.ManufacturerSpecificCCValues.productId.id, this._productId);
      controllerValueDB.setMetadata(import_cc.VersionCCValues.firmwareVersions.id, import_cc.VersionCCValues.firmwareVersions.meta);
      controllerValueDB.setValue(import_cc.VersionCCValues.firmwareVersions.id, [
        this._firmwareVersion
      ]);
      controllerValueDB.setMetadata(import_cc.VersionCCValues.zWaveProtocolVersion.id, import_cc.VersionCCValues.zWaveProtocolVersion.meta);
      controllerValueDB.setValue(import_cc.VersionCCValues.zWaveProtocolVersion.id, this._protocolVersion);
      controllerValueDB.setMetadata(import_cc.VersionCCValues.sdkVersion.id, import_cc.VersionCCValues.sdkVersion.meta);
      controllerValueDB.setValue(import_cc.VersionCCValues.sdkVersion.id, this._sdkVersion);
      await this.nodes.get(this._ownNodeId)?.["loadDeviceConfig"]();
    }
    createValueDBForNode(nodeId, ownKeys) {
      return new import_core.ValueDB(nodeId, this.driver.valueDB, this.driver.metadataDB, ownKeys);
    }
    /**
     * Gets the list of long range nodes from the controller.
     */
    async getLongRangeNodes() {
      const nodeIds = [];
      if (this.supportsLongRange) {
        for (let segment = 0; ; segment++) {
          const nodesResponse = await this.driver.sendMessage(new import_serialapi.GetLongRangeNodesRequest({
            segmentNumber: segment
          }));
          nodeIds.push(...nodesResponse.nodeIds);
          if (!nodesResponse.moreNodes)
            break;
        }
      }
      return nodeIds;
    }
    /**
     * Sets the NIF of the controller to the Gateway device type and to include the CCs supported by Z-Wave JS.
     * Warning: This only works when followed up by a hard-reset, so don't call this directly
     * @internal
     */
    async setControllerNIF() {
      this.driver.controllerLog.print("Updating the controller NIF...");
      await this.driver.sendMessage(new import_serialapi.SetApplicationNodeInformationRequest({
        isListening: true,
        ...(0, import_NodeInformationFrame.determineNIF)()
      }));
    }
    /**
     * Performs a hard reset on the controller. This wipes out all configuration!
     * Warning: The driver needs to re-interview the controller, so don't call this directly
     * @internal
     */
    async hardReset() {
      try {
        const associations = this.associations;
        if (associations?.length) {
          this.driver.controllerLog.print("Notifying associated nodes about reset...");
          const nodeIdDestinations = (0, import_arrays.distinct)(associations.map(({ nodeId }) => nodeId));
          for (const nodeId of nodeIdDestinations) {
            const node = this.nodes.get(nodeId);
            if (!node)
              continue;
            await node.sendResetLocallyNotification().catch(import_shared.noop);
          }
        }
        this.driver.controllerLog.print("performing hard reset...");
        await this.driver.sendMessage(new import_serialapi.HardResetRequest(), {
          supportCheck: false
        });
        this.driver.controllerLog.print(`hard reset succeeded`);
        this._nodes.forEach((node) => node.removeAllListeners());
        this._nodes.clear();
      } catch (e) {
        this.driver.controllerLog.print(`hard reset failed: ${(0, import_shared.getErrorMessage)(e)}`, "error");
        throw e;
      }
    }
    /**
     * @internal
     */
    async shutdown() {
      try {
        this.driver.controllerLog.print("Shutting down the Z-Wave API...");
        const response = await this.driver.sendMessage(new import_serialapi.ShutdownRequest());
        if (response.success) {
          this.driver.controllerLog.print("Z-Wave API was shut down");
        } else {
          this.driver.controllerLog.print("Failed to shut down the Z-Wave API");
        }
        return response.success;
      } catch (e) {
        this.driver.controllerLog.print(`shutdown failed: ${(0, import_shared.getErrorMessage)(e)}`, "error");
        throw e;
      }
    }
    /**
     * Starts the hardware watchdog on supporting 700+ series controllers.
     * Returns whether the operation was successful.
     */
    async startWatchdog() {
      if (this.sdkVersionGte("7.0") && this.isFunctionSupported(import_serial.FunctionType.StartWatchdog)) {
        try {
          this.driver.controllerLog.print("Starting hardware watchdog...");
          await this.driver.sendMessage(new import_serialapi.StartWatchdogRequest());
          return true;
        } catch (e) {
          this.driver.controllerLog.print(`Starting the hardware watchdog failed: ${(0, import_shared.getErrorMessage)(e)}`, "error");
        }
      }
      return false;
    }
    /**
     * Stops the hardware watchdog on supporting controllers.
     * Returns whether the operation was successful.
     */
    async stopWatchdog() {
      if (this.isFunctionSupported(import_serial.FunctionType.StopWatchdog)) {
        try {
          this.driver.controllerLog.print("Stopping hardware watchdog...");
          await this.driver.sendMessage(new import_serialapi.StopWatchdogRequest());
          return true;
        } catch (e) {
          this.driver.controllerLog.print(`Stopping the hardware watchdog failed: ${(0, import_shared.getErrorMessage)(e)}`, "error");
        }
      }
      return false;
    }
    _inclusionState = import_Inclusion.InclusionState.Idle;
    get inclusionState() {
      return this._inclusionState;
    }
    /** @internal */
    setInclusionState(state) {
      if (this._inclusionState === state)
        return;
      this._inclusionState = state;
      this.emit("inclusion state changed", state);
      if (state === import_Inclusion.InclusionState.Idle && this._smartStartEnabled && this.supportsFeature(import_Features.ZWaveFeature.SmartStart)) {
        this.enableSmartStart().catch(import_shared.noop);
      }
    }
    _smartStartEnabled = false;
    /**
     * Starts the inclusion process of new nodes.
     * Resolves to true when the process was started, and false if the inclusion was already active.
     *
     * @param options Defines the inclusion strategy to use.
     */
    async beginInclusion(options = {
      strategy: import_Inclusion.InclusionStrategy.Insecure
    }) {
      if (this._inclusionState === import_Inclusion.InclusionState.Including || this._inclusionState === import_Inclusion.InclusionState.Excluding || this._inclusionState === import_Inclusion.InclusionState.Busy) {
        return false;
      }
      if (!(options.strategy in import_Inclusion.InclusionStrategy) || options.strategy === import_Inclusion.InclusionStrategy.SmartStart) {
        throw new import_core.ZWaveError(`Invalid inclusion strategy: ${options.strategy}`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      const startedPromise = (0, import_deferred_promise.createDeferredPromise)();
      void this.driver.scheduler.queueTask(this.getBeginClassicInclusionTask(startedPromise, options)).catch(import_shared.noop);
      await startedPromise;
      return true;
    }
    /**
     * Returns the task to handle the complete classic inclusion process
     */
    getBeginClassicInclusionTask(startedPromise, options) {
      const self = this;
      const abortWaiting = new AbortController();
      return {
        priority: import_Task.TaskPriority.Normal,
        tag: { id: "inclusion" },
        group: { id: "inclusion-exclusion" },
        task: /* @__PURE__ */ __name(async function* classicInclusionTask() {
          yield* (0, import_waddle.waitFor)(self.pauseSmartStart());
          self.setInclusionState(import_Inclusion.InclusionState.Including);
          self.driver.controllerLog.print(`Starting inclusion process with strategy ${(0, import_shared.getEnumMemberName)(import_Inclusion.InclusionStrategy, options.strategy)}...`);
          let callbackId;
          try {
            const msg = new import_serialapi.AddNodeToNetworkRequest({
              addNodeType: import_serialapi.AddNodeType.Any,
              highPower: true,
              networkWide: true
            });
            yield* (0, import_waddle.waitFor)(self.driver.sendMessage(msg));
            callbackId = msg.callbackId;
            self.driver.controllerLog.print(`The controller is now ready to add nodes`);
            self.emit("inclusion started", options.strategy);
            startedPromise.resolve();
          } catch (e) {
            self.setInclusionState(import_Inclusion.InclusionState.Idle);
            if ((0, import_core.isZWaveError)(e) && e.code === import_core.ZWaveErrorCodes.Controller_CallbackNOK) {
              self.driver.controllerLog.print(`Starting the inclusion failed`, "error");
              startedPromise.reject(new import_core.ZWaveError("The inclusion could not be started.", import_core.ZWaveErrorCodes.Controller_InclusionFailed));
            } else {
              startedPromise.reject(e);
            }
            return;
          }
          yield* self.performInclusion(callbackId, options, abortWaiting.signal);
        }, "classicInclusionTask"),
        // eslint-disable-next-line @typescript-eslint/require-await
        async cleanup() {
          abortWaiting.abort();
        }
      };
    }
    /** @internal */
    async beginInclusionSmartStart(provisioningEntry) {
      if (this._inclusionState === import_Inclusion.InclusionState.Including || this._inclusionState === import_Inclusion.InclusionState.Excluding || this._inclusionState === import_Inclusion.InclusionState.Busy) {
        return false;
      }
      const startedPromise = (0, import_deferred_promise.createDeferredPromise)();
      void this.driver.scheduler.queueTask(this.getBeginSmartStartInclusionTask(startedPromise, provisioningEntry)).catch(import_shared.noop);
      await startedPromise;
      return true;
    }
    /**
     * Returns the task to handle the complete classic inclusion process
     */
    getBeginSmartStartInclusionTask(startedPromise, provisioningEntry) {
      const self = this;
      const abortWaiting = new AbortController();
      const options = {
        strategy: import_Inclusion.InclusionStrategy.SmartStart,
        provisioning: provisioningEntry
      };
      return {
        priority: import_Task.TaskPriority.Normal,
        tag: { id: "inclusion" },
        group: { id: "inclusion-exclusion" },
        task: /* @__PURE__ */ __name(async function* smartStartInclusionTask() {
          yield* (0, import_waddle.waitFor)(self.pauseSmartStart());
          self.setInclusionState(import_Inclusion.InclusionState.Including);
          let callbackId;
          try {
            const dskBuffer = (0, import_core.dskFromString)(provisioningEntry.dsk);
            const protocol = provisioningEntry.protocol ?? provisioningEntry.supportedProtocols?.[0] ?? import_core.Protocols.ZWave;
            self.driver.controllerLog.print(`Including SmartStart node with DSK ${provisioningEntry.dsk}${protocol == import_core.Protocols.ZWaveLongRange ? " using Z-Wave Long Range" : ""}`);
            const msg = new import_serialapi.AddNodeDSKToNetworkRequest({
              nwiHomeId: (0, import_core.nwiHomeIdFromDSK)(dskBuffer),
              authHomeId: (0, import_core.authHomeIdFromDSK)(dskBuffer),
              protocol,
              highPower: true,
              networkWide: true
            });
            yield* (0, import_waddle.waitFor)(self.driver.sendMessage(msg));
            callbackId = msg.callbackId;
            self.emit("inclusion started", import_Inclusion.InclusionStrategy.SmartStart);
            startedPromise.resolve();
          } catch (e) {
            self.setInclusionState(import_Inclusion.InclusionState.Idle);
            startedPromise.reject(e);
            return;
          }
          yield* self.performInclusion(callbackId, options, abortWaiting.signal);
        }, "smartStartInclusionTask"),
        // eslint-disable-next-line @typescript-eslint/require-await
        async cleanup() {
          abortWaiting.abort();
        }
      };
    }
    async *performInclusion(callbackId, opts, abortWaiting) {
      const self = this;
      async function* awaitStatusReport() {
        const msg = yield* (0, import_waddle.waitFor)(self.driver.waitForMessage(
          (msg2) => msg2 instanceof import_serialapi.AddNodeToNetworkRequestStatusReport && msg2.callbackId === callbackId,
          void 0,
          // Wait indefinitely
          void 0,
          abortWaiting
        ));
        if (msg.status === import_serialapi.AddNodeStatus.Failed) {
          self.driver.controllerLog.print(`Adding the node failed`, "error");
          self.emit("inclusion failed");
          try {
            yield* (0, import_waddle.waitFor)(self.stopInclusionInternal());
          } catch {
          }
          return;
        }
        return msg;
      }
      __name(awaitStatusReport, "awaitStatusReport");
      async function* abortInclusion(status, expected) {
        let message = `Unexpected status during inclusion: ${(0, import_shared.getEnumMemberName)(import_serialapi.AddNodeStatus, status)}, expected `;
        if (expected.length === 1) {
          message += (0, import_shared.getEnumMemberName)(import_serialapi.AddNodeStatus, expected[0]);
        } else {
          message += `one of: ${expected.map((s) => (0, import_shared.getEnumMemberName)(import_serialapi.AddNodeStatus, s)).join(", ")}`;
        }
        self.driver.controllerLog.print(message, "error");
        yield* (0, import_waddle.waitFor)(self.stopInclusionInternal());
      }
      __name(abortInclusion, "abortInclusion");
      {
        const msg = yield* awaitStatusReport();
        if (!msg)
          return;
        if (msg.status !== import_serialapi.AddNodeStatus.NodeFound) {
          yield* abortInclusion(msg.status, [import_serialapi.AddNodeStatus.NodeFound]);
          return;
        }
      }
      let newNodeIsController = false;
      let nodePendingInclusion;
      {
        const msg = yield* awaitStatusReport();
        if (!msg)
          return;
        if (msg.status !== import_serialapi.AddNodeStatus.AddingController && msg.status !== import_serialapi.AddNodeStatus.AddingSlave) {
          yield* abortInclusion(msg.status, [
            import_serialapi.AddNodeStatus.AddingController,
            import_serialapi.AddNodeStatus.AddingSlave
          ]);
          return;
        }
        newNodeIsController = msg.status === import_serialapi.AddNodeStatus.AddingController;
        nodePendingInclusion = new import_Node.ZWaveNode(
          msg.statusContext.nodeId,
          this.driver,
          new import_DeviceClass.DeviceClass(msg.statusContext.basicDeviceClass, msg.statusContext.genericDeviceClass, msg.statusContext.specificDeviceClass),
          msg.statusContext.supportedCCs,
          msg.statusContext.controlledCCs,
          // Create an empty value DB and specify that it contains no values
          // to avoid indexing the existing values
          this.createValueDBForNode(msg.statusContext.nodeId, /* @__PURE__ */ new Set())
        );
      }
      {
        const msg = yield* awaitStatusReport();
        if (!msg)
          return;
        if (msg.status !== import_serialapi.AddNodeStatus.ProtocolDone) {
          yield* abortInclusion(msg.status, [
            import_serialapi.AddNodeStatus.ProtocolDone
          ]);
          return;
        }
      }
      let nodeId;
      try {
        nodeId = yield* (0, import_waddle.waitFor)(this.finishInclusion());
      } catch {
      }
      try {
        yield* (0, import_waddle.waitFor)(this.stopInclusionNoCallback());
      } catch {
      }
      if (!nodeId) {
        this.setInclusionState(import_Inclusion.InclusionState.Idle);
        return;
      } else if (nodeId === import_core.NODE_ID_BROADCAST || nodeId === import_core.NODE_ID_BROADCAST_LR) {
        this.driver.controllerLog.print(`Cannot add a node with the broadcast node ID, aborting...`, "warn");
        this.setInclusionState(import_Inclusion.InclusionState.Idle);
        return;
      } else if (this._nodes.has(nodeId)) {
        this.driver.controllerLog.print(`Cannot add node ${nodeId} as it is already part of the network. Aborting...`, "warn");
        this.setInclusionState(import_Inclusion.InclusionState.Idle);
        return;
      }
      this.setInclusionState(import_Inclusion.InclusionState.Busy);
      const newNode = nodePendingInclusion;
      const supportedCCs = [
        ...newNode.implementedCommandClasses.entries()
      ].filter(([, info]) => info.isSupported).map(([cc]) => cc);
      const controlledCCs = [
        ...newNode.implementedCommandClasses.entries()
      ].filter(([, info]) => info.isControlled).map(([cc]) => cc);
      this.emit("node found", {
        id: newNode.id,
        deviceClass: newNode.deviceClass,
        supportedCCs,
        controlledCCs
      });
      this.driver.controllerLog.print(`finished adding node ${newNode.id}:${newNode.deviceClass ? `
  basic device class:    ${(0, import_shared.getEnumMemberName)(import_core.BasicDeviceClass, newNode.deviceClass.basic)}
  generic device class:  ${newNode.deviceClass.generic.label}
  specific device class: ${newNode.deviceClass.specific.label}` : ""}
  supported CCs: ${supportedCCs.map((cc) => `
  \xB7 ${import_core.CommandClasses[cc]} (${(0, import_shared.num2hex)(cc)})`).join("")}
  controlled CCs: ${controlledCCs.map((cc) => `
  \xB7 ${import_core.CommandClasses[cc]} (${(0, import_shared.num2hex)(cc)})`).join("")}`);
      this._nodes.set(newNode.id, newNode);
      newNode.markAsAlive();
      if (newNode.protocol == import_core.Protocols.ZWave) {
        newNode.hasSUCReturnRoute = yield* (0, import_waddle.waitFor)(self.assignSUCReturnRoutes(newNode.id));
      }
      let bootstrapFailure;
      let smartStartFailed = false;
      let forceAddedS2Support = false;
      if (opts.strategy === import_Inclusion.InclusionStrategy.SmartStart && !newNode.supportsCC(import_core.CommandClasses["Security 2"])) {
        this.driver.controllerLog.logNode(newNode.id, {
          message: "does not list S2 as supported, but was included using SmartStart which implies S2 support.",
          level: "warn"
        });
        forceAddedS2Support = true;
        newNode.addCC(import_core.CommandClasses["Security 2"], {
          isSupported: true,
          version: 1
        });
      }
      if (newNode.supportsCC(import_core.CommandClasses["Security 2"]) && (opts.strategy === import_Inclusion.InclusionStrategy.Default || opts.strategy === import_Inclusion.InclusionStrategy.Security_S2 || opts.strategy === import_Inclusion.InclusionStrategy.SmartStart)) {
        bootstrapFailure = yield* (0, import_waddle.waitFor)(this.secureBootstrapS2(newNode, opts));
        const actualSecurityClass = newNode.getHighestSecurityClass();
        if (bootstrapFailure == void 0) {
          if (actualSecurityClass == import_core.SecurityClass.S0_Legacy) {
            bootstrapFailure = import_Inclusion.SecurityBootstrapFailure.S0Downgrade;
            this.driver.controllerLog.logNode(newNode.id, {
              message: "Possible S0 downgrade attack detected!",
              level: "warn"
            });
          } else if (!(0, import_core.securityClassIsS2)(actualSecurityClass)) {
            bootstrapFailure = import_Inclusion.SecurityBootstrapFailure.Unknown;
          }
        } else if (opts.strategy === import_Inclusion.InclusionStrategy.SmartStart) {
          smartStartFailed = true;
        }
        if (forceAddedS2Support && !(0, import_core.securityClassIsS2)(actualSecurityClass)) {
          newNode.removeCC(import_core.CommandClasses["Security 2"]);
        }
      } else if (newNode.supportsCC(import_core.CommandClasses.Security) && (opts.strategy === import_Inclusion.InclusionStrategy.Security_S0 || opts.strategy === import_Inclusion.InclusionStrategy.Default && (opts.forceSecurity || (newNode.deviceClass?.specific ?? newNode.deviceClass?.generic)?.requiresSecurity))) {
        bootstrapFailure = yield* (0, import_waddle.waitFor)(this.secureBootstrapS0(newNode, newNodeIsController));
        if (bootstrapFailure == void 0) {
          const actualSecurityClass = newNode.getHighestSecurityClass();
          if (actualSecurityClass == import_core.SecurityClass.S0_Legacy) {
            if (opts.strategy !== import_Inclusion.InclusionStrategy.Security_S0) {
              const nif = yield* (0, import_waddle.waitFor)(newNode.requestNodeInfo().catch(() => void 0));
              if (nif?.supportedCCs.includes(import_core.CommandClasses["Security 2"])) {
                bootstrapFailure = import_Inclusion.SecurityBootstrapFailure.S0Downgrade;
                this.driver.controllerLog.logNode(newNode.id, {
                  message: "Possible S0 downgrade attack detected!",
                  level: "warn"
                });
              }
            }
          } else {
            bootstrapFailure = import_Inclusion.SecurityBootstrapFailure.Unknown;
          }
        }
      } else {
        for (const secClass of import_core.securityClassOrder) {
          newNode.securityClasses.set(secClass, false);
        }
      }
      if (smartStartFailed) {
        if (opts.strategy === import_Inclusion.InclusionStrategy.SmartStart && opts.provisioning?.dsk) {
          const dsk = opts.provisioning.dsk;
          const maxAttempts = this.driver.options.attempts.smartStartInclusion;
          const currentAttempts = this._smartStartFailedAttempts.get(dsk) || 0;
          const newAttempts = currentAttempts + 1;
          this._smartStartFailedAttempts.set(dsk, newAttempts);
          this.driver.controllerLog.logNode(newNode.id, {
            message: `SmartStart inclusion failed for DSK ${dsk} (attempt ${newAttempts}/${maxAttempts}).`,
            level: "warn"
          });
          if (newAttempts >= maxAttempts) {
            const provisioningList = [...this.provisioningList];
            const entryIndex = provisioningList.findIndex((e) => e.dsk === dsk);
            if (entryIndex >= 0) {
              provisioningList[entryIndex] = {
                ...provisioningList[entryIndex],
                status: import_Inclusion.ProvisioningEntryStatus.Inactive
              };
              this.provisioningList = provisioningList;
              this.resetSmartStartFailureCount(dsk);
              this.driver.controllerLog.logNode(newNode.id, {
                message: `Provisioning entry for DSK ${dsk} has been disabled after ${maxAttempts} failed inclusion attempts.`,
                level: "warn"
              });
            }
          }
        }
        try {
          this.driver.controllerLog.logNode(newNode.id, {
            message: "SmartStart inclusion failed. Checking if the node needs to be removed.",
            level: "warn"
          });
          yield* (0, import_waddle.waitFor)(this.removeFailedNodeInternal(newNode.id, import_Inclusion.RemoveNodeReason.SmartStartFailed));
          this.driver.controllerLog.logNode(newNode.id, {
            message: "was removed"
          });
          this.setInclusionState(import_Inclusion.InclusionState.Idle);
          return;
        } catch {
          this.driver.controllerLog.logNode(newNode.id, {
            message: "The node is still part of the network, continuing with insecure communication.",
            level: "warn"
          });
        }
      }
      this.setInclusionState(import_Inclusion.InclusionState.Idle);
      const result = bootstrapFailure != void 0 ? {
        lowSecurity: true,
        lowSecurityReason: bootstrapFailure
      } : { lowSecurity: false };
      if (opts.strategy === import_Inclusion.InclusionStrategy.SmartStart && opts.provisioning?.dsk) {
        const dsk = opts.provisioning.dsk;
        if (this._smartStartFailedAttempts.has(dsk)) {
          this._smartStartFailedAttempts.delete(dsk);
        }
      }
      this.emit("node added", newNode, result);
    }
    /**
     * Is used internally to stop an active inclusion process without waiting for a confirmation
     * @internal
     */
    async stopInclusionNoCallback() {
      await this.driver.sendMessage(new import_serialapi.AddNodeToNetworkRequest({
        callbackId: 0,
        // disable callbacks
        addNodeType: import_serialapi.AddNodeType.Stop,
        highPower: true,
        networkWide: true
      }));
      this.driver.controllerLog.print(`The inclusion process was stopped`);
      this.emit("inclusion stopped");
    }
    /**
     * Finishes an inclusion process. This must only be called after the ProtocolDone status is received.
     * Returns the ID of the newly added node.
     */
    async finishInclusion() {
      this.driver.controllerLog.print(`finishing inclusion process...`);
      const response = await this.driver.sendMessage(new import_serialapi.AddNodeToNetworkRequest({
        addNodeType: import_serialapi.AddNodeType.Stop,
        highPower: true,
        networkWide: true
      }));
      if (response.status === import_serialapi.AddNodeStatus.Done) {
        return response.statusContext.nodeId;
      }
      this.driver.controllerLog.print(`Finishing the inclusion failed`, "error");
      throw new import_core.ZWaveError("Finishing the inclusion failed", import_core.ZWaveErrorCodes.Controller_InclusionFailed);
    }
    /**
     * Stops an active inclusion process. Resolves to true when the controller leaves inclusion mode,
     * and false if the inclusion was not active.
     */
    async stopInclusion() {
      const result = await this.stopInclusionInternal();
      if (result) {
        await this.driver.scheduler.removeTasks((t) => t.tag?.id === "inclusion" || t.tag?.id === "replace-failed-node");
      }
      return result;
    }
    /**
     * Stops an active inclusion process, but does not remove the corresponding task.
     * This should only be used from within an inclusion task, or other methods that
     * handle task removal
     */
    async stopInclusionInternal() {
      if (this._inclusionState !== import_Inclusion.InclusionState.Including) {
        return false;
      }
      this.driver.controllerLog.print(`stopping inclusion process...`);
      try {
        await this.driver.sendMessage(new import_serialapi.AddNodeToNetworkRequest({
          addNodeType: import_serialapi.AddNodeType.Stop,
          highPower: true,
          networkWide: true
        }));
        this.driver.controllerLog.print(`The inclusion process was stopped`);
        this.emit("inclusion stopped");
        this.setInclusionState(import_Inclusion.InclusionState.Idle);
        return true;
      } catch (e) {
        if ((0, import_core.isZWaveError)(e) && e.code === import_core.ZWaveErrorCodes.Controller_CallbackNOK) {
          this.driver.controllerLog.print(`Stopping the inclusion failed`, "error");
          throw new import_core.ZWaveError("The inclusion could not be stopped.", import_core.ZWaveErrorCodes.Controller_InclusionFailed);
        }
        throw e;
      }
    }
    /**
     * Puts the controller into listening mode for Smart Start inclusion.
     * Whenever a node on the provisioning list announces itself, it will automatically be added.
     *
     * Resolves to `true` when the listening mode is started or was active, and `false` if it is scheduled for later activation.
     */
    async enableSmartStart() {
      if (!this.supportsFeature(import_Features.ZWaveFeature.SmartStart)) {
        this.driver.controllerLog.print(`Smart Start is not supported by this controller, NOT enabling listening mode...`, "warn");
      }
      this._smartStartEnabled = true;
      if (this._inclusionState === import_Inclusion.InclusionState.Idle) {
        this.setInclusionState(import_Inclusion.InclusionState.SmartStart);
        this.driver.controllerLog.print(`Enabling Smart Start listening mode...`);
        try {
          await this.driver.sendMessage(new import_serialapi.EnableSmartStartListenRequest({}));
          this.driver.controllerLog.print(`Smart Start listening mode enabled`);
          return true;
        } catch (e) {
          this.setInclusionState(import_Inclusion.InclusionState.Idle);
          this.driver.controllerLog.print(`Smart Start listening mode could not be enabled: ${(0, import_shared.getErrorMessage)(e)}`, "error");
          throw e;
        }
      } else if (this._inclusionState === import_Inclusion.InclusionState.SmartStart) {
        return true;
      } else {
        this.driver.controllerLog.print(`Smart Start listening mode scheduled for later activation...`);
        return false;
      }
    }
    /**
     * Disables the listening mode for Smart Start inclusion.
     *
     * Resolves to `true` when the listening mode is stopped, and `false` if was not active.
     */
    async disableSmartStart() {
      if (!this.supportsFeature(import_Features.ZWaveFeature.SmartStart))
        return true;
      this._smartStartEnabled = false;
      if (this._inclusionState === import_Inclusion.InclusionState.SmartStart) {
        this.setInclusionState(import_Inclusion.InclusionState.Idle);
        this.driver.controllerLog.print(`disabling Smart Start listening mode...`);
        try {
          await this.driver.sendMessage(new import_serialapi.AddNodeToNetworkRequest({
            callbackId: 0,
            // disable callbacks
            addNodeType: import_serialapi.AddNodeType.Stop,
            highPower: true,
            networkWide: true
          }));
          this.driver.controllerLog.print(`Smart Start listening mode disabled`);
          return true;
        } catch (e) {
          this.setInclusionState(import_Inclusion.InclusionState.SmartStart);
          this.driver.controllerLog.print(`Smart Start listening mode could not be disabled: ${(0, import_shared.getErrorMessage)(e)}`, "error");
          throw e;
        }
      } else if (this._inclusionState === import_Inclusion.InclusionState.Idle) {
        return true;
      } else {
        this.driver.controllerLog.print(`Smart Start listening mode disabled`);
        return true;
      }
    }
    async pauseSmartStart() {
      if (!this.supportsFeature(import_Features.ZWaveFeature.SmartStart))
        return true;
      if (this._inclusionState === import_Inclusion.InclusionState.SmartStart) {
        this.driver.controllerLog.print(`Leaving Smart Start listening mode...`);
        try {
          await this.driver.sendMessage(new import_serialapi.AddNodeToNetworkRequest({
            callbackId: 0,
            // disable callbacks
            addNodeType: import_serialapi.AddNodeType.Stop,
            highPower: true,
            networkWide: true
          }));
          this.driver.controllerLog.print(`Left Smart Start listening mode`);
          return true;
        } catch (e) {
          this.driver.controllerLog.print(`Smart Start listening mode could not be left: ${(0, import_shared.getErrorMessage)(e)}`, "error");
          throw e;
        }
      } else {
        return true;
      }
    }
    /**
     * Starts the exclusion process of new nodes.
     * Resolves to true when the process was started, and false if an inclusion or exclusion process was already active.
     *
     * @param options Influences the exclusion process and what happens with the Smart Start provisioning list.
     */
    async beginExclusion(options = {
      strategy: import_Inclusion.ExclusionStrategy.DisableProvisioningEntry
    }) {
      if (this._inclusionState === import_Inclusion.InclusionState.Including || this._inclusionState === import_Inclusion.InclusionState.Excluding || this._inclusionState === import_Inclusion.InclusionState.Busy) {
        return false;
      }
      const startedPromise = (0, import_deferred_promise.createDeferredPromise)();
      void this.driver.scheduler.queueTask(this.getExclusionTask(startedPromise, options)).catch(import_shared.noop);
      await startedPromise;
      return true;
    }
    /**
     * Is used internally to stop an active exclusion process without waiting for confirmation
     * @internal
     */
    async stopExclusionNoCallback() {
      await this.driver.sendMessage(new import_serialapi.RemoveNodeFromNetworkRequest({
        callbackId: 0,
        // disable callbacks
        removeNodeType: import_serialapi.RemoveNodeType.Stop,
        highPower: true,
        networkWide: true
      }));
      this.driver.controllerLog.print(`the exclusion process was stopped`);
      this.emit("exclusion stopped");
    }
    /**
     * Stops an active exclusion process. Resolves to true when the controller leaves exclusion mode,
     * and false if the exclusion was not active.
     */
    async stopExclusion() {
      const result = await this.stopExclusionInternal();
      if (result) {
        await this.driver.scheduler.removeTasks((t) => t.tag?.id === "exclusion");
      }
      return result;
    }
    /**
     * Stops an active exclusion process, but does not remove the corresponding task.
     * This should only be used from within an exclusion task, or other methods that
     * handle task removal
     */
    async stopExclusionInternal() {
      if (this._inclusionState !== import_Inclusion.InclusionState.Excluding) {
        return false;
      }
      this.driver.controllerLog.print(`stopping exclusion process...`);
      try {
        await this.driver.sendMessage(new import_serialapi.RemoveNodeFromNetworkRequest({
          removeNodeType: import_serialapi.RemoveNodeType.Stop,
          highPower: true,
          networkWide: true
        }));
        this.driver.controllerLog.print(`the exclusion process was stopped`);
        this.emit("exclusion stopped");
        this.setInclusionState(import_Inclusion.InclusionState.Idle);
        return true;
      } catch (e) {
        if ((0, import_core.isZWaveError)(e) && e.code === import_core.ZWaveErrorCodes.Controller_CallbackNOK) {
          this.driver.controllerLog.print(`Stopping the exclusion failed`, "error");
          throw new import_core.ZWaveError("The exclusion could not be stopped.", import_core.ZWaveErrorCodes.Controller_ExclusionFailed);
        }
        throw e;
      }
    }
    /**
     * Returns the task to handle the complete exclusion process
     */
    getExclusionTask(startedPromise, options) {
      const self = this;
      const abortWaiting = new AbortController();
      return {
        priority: import_Task.TaskPriority.Normal,
        tag: { id: "exclusion" },
        group: { id: "inclusion-exclusion" },
        task: /* @__PURE__ */ __name(async function* exclusionTask() {
          yield* (0, import_waddle.waitFor)(self.pauseSmartStart());
          self.setInclusionState(import_Inclusion.InclusionState.Excluding);
          self.driver.controllerLog.print(`starting exclusion process...`);
          let callbackId;
          try {
            const msg = new import_serialapi.RemoveNodeFromNetworkRequest({
              removeNodeType: import_serialapi.RemoveNodeType.Any,
              highPower: true,
              networkWide: true
            });
            yield* (0, import_waddle.waitFor)(self.driver.sendMessage(msg));
            callbackId = msg.callbackId;
            self.driver.controllerLog.print(`The controller is now ready to remove nodes`);
            self.emit("exclusion started");
            startedPromise.resolve();
          } catch (e) {
            self.setInclusionState(import_Inclusion.InclusionState.Idle);
            if ((0, import_core.isZWaveError)(e) && e.code === import_core.ZWaveErrorCodes.Controller_CallbackNOK) {
              self.driver.controllerLog.print(`Starting the exclusion failed`, "error");
              startedPromise.reject(new import_core.ZWaveError("The exclusion could not be started.", import_core.ZWaveErrorCodes.Controller_ExclusionFailed));
            } else {
              startedPromise.reject(e);
            }
            return;
          }
          yield* self.performExclusion(callbackId, options, abortWaiting.signal);
        }, "exclusionTask"),
        // eslint-disable-next-line @typescript-eslint/require-await
        async cleanup() {
          abortWaiting.abort();
        }
      };
    }
    async *performExclusion(callbackId, options, abortWaiting) {
      const self = this;
      async function* awaitStatusReport() {
        const msg = yield* (0, import_waddle.waitFor)(self.driver.waitForMessage(
          (msg2) => msg2 instanceof import_serialapi.RemoveNodeFromNetworkRequestStatusReport && msg2.callbackId === callbackId,
          void 0,
          // Wait indefinitely
          void 0,
          abortWaiting
        ));
        if (msg.status === import_serialapi.RemoveNodeStatus.Failed) {
          self.driver.controllerLog.print(`Removing the node failed`, "error");
          self.emit("exclusion failed");
          try {
            yield* (0, import_waddle.waitFor)(self.stopExclusionInternal());
          } catch {
          }
          return;
        }
        return msg;
      }
      __name(awaitStatusReport, "awaitStatusReport");
      async function* abortExclusion(status, expected) {
        let message = `Unexpected status during exclusion: ${(0, import_shared.getEnumMemberName)(import_serialapi.RemoveNodeStatus, status)}, expected `;
        if (expected.length === 1) {
          message += (0, import_shared.getEnumMemberName)(import_serialapi.RemoveNodeStatus, expected[0]);
        } else {
          message += `one of: ${expected.map((s) => (0, import_shared.getEnumMemberName)(import_serialapi.RemoveNodeStatus, s)).join(", ")}`;
        }
        self.driver.controllerLog.print(message, "error");
        yield* (0, import_waddle.waitFor)(self.stopExclusionInternal());
      }
      __name(abortExclusion, "abortExclusion");
      {
        const msg = yield* awaitStatusReport();
        if (!msg)
          return;
        if (msg.status !== import_serialapi.RemoveNodeStatus.NodeFound) {
          yield* abortExclusion(msg.status, [
            import_serialapi.RemoveNodeStatus.NodeFound
          ]);
          return;
        }
      }
      let nodePendingExclusion;
      {
        const msg = yield* awaitStatusReport();
        if (!msg)
          return;
        if (msg.status !== import_serialapi.RemoveNodeStatus.RemovingController && msg.status !== import_serialapi.RemoveNodeStatus.RemovingSlave) {
          yield* abortExclusion(msg.status, [
            import_serialapi.RemoveNodeStatus.RemovingController,
            import_serialapi.RemoveNodeStatus.RemovingSlave
          ]);
          return;
        }
        nodePendingExclusion = this.nodes.get(msg.statusContext.nodeId);
      }
      let wasRemoved = false;
      {
        const msg = yield* awaitStatusReport();
        if (!msg)
          return;
        if (msg.status !== import_serialapi.RemoveNodeStatus.Reserved_0x05 && msg.status !== import_serialapi.RemoveNodeStatus.Done) {
          yield* abortExclusion(msg.status, [
            import_serialapi.RemoveNodeStatus.Reserved_0x05,
            import_serialapi.RemoveNodeStatus.Done
          ]);
          return;
        }
        wasRemoved = msg.status === import_serialapi.RemoveNodeStatus.Done;
      }
      try {
        yield* (0, import_waddle.waitFor)(this.stopExclusionNoCallback());
      } catch {
      }
      if (!wasRemoved || !nodePendingExclusion) {
        this.setInclusionState(import_Inclusion.InclusionState.Idle);
        return;
      }
      const nodeId = nodePendingExclusion.id;
      this.driver.controllerLog.print(`Node ${nodeId} was removed`);
      switch (options.strategy) {
        case import_Inclusion.ExclusionStrategy.Unprovision:
          this.unprovisionSmartStartNode(nodeId);
          break;
        case import_Inclusion.ExclusionStrategy.DisableProvisioningEntry: {
          const entry = this.getProvisioningEntryInternal(nodeId);
          if (entry) {
            entry.status = import_Inclusion.ProvisioningEntryStatus.Inactive;
            this.provisionSmartStartNode(entry);
          }
          break;
        }
      }
      this.emit("node removed", nodePendingExclusion, import_Inclusion.RemoveNodeReason.Excluded);
      this._nodes.delete(nodeId);
      this.setInclusionState(import_Inclusion.InclusionState.Idle);
    }
    _proxyInclusionMachine;
    _proxyInclusionInitiateTimeout;
    async updateProxyInclusionMachine(input) {
      this._proxyInclusionMachine ??= (0, import_ProxyInclusionMachine.createProxyInclusionMachine)();
      const newState = this._proxyInclusionMachine.next(input)?.newState;
      if (!newState)
        return;
      this._proxyInclusionMachine.transition(newState);
      switch (newState.value) {
        case "hasNIF": {
          this.setInclusionState(import_Inclusion.InclusionState.Busy);
          this.driver.controllerLog.logNode(newState.nodeInfo.nodeId, "Waiting for initiate command to bootstrap node...");
          if (this._proxyInclusionInitiateTimeout) {
            clearTimeout(this._proxyInclusionInitiateTimeout);
          }
          this._proxyInclusionInitiateTimeout = setTimeout(() => {
            void this.updateProxyInclusionMachine({
              value: "INITIATE_TIMEOUT"
            }).catch(import_shared.noop);
          }, 1e4).unref();
          return;
        }
        case "hasInitiate": {
          this.setInclusionState(import_Inclusion.InclusionState.Busy);
          if (this._proxyInclusionInitiateTimeout) {
            clearTimeout(this._proxyInclusionInitiateTimeout);
          }
          this._proxyInclusionInitiateTimeout = setTimeout(() => {
            void this.updateProxyInclusionMachine({
              value: "NIF_TIMEOUT"
            }).catch(import_shared.noop);
          }, 1e4).unref();
          return;
        }
        case "bootstrapping": {
          if (this._proxyInclusionInitiateTimeout) {
            clearTimeout(this._proxyInclusionInitiateTimeout);
            this._proxyInclusionInitiateTimeout = void 0;
          }
          const nodeId = newState.includedNodeId;
          let newNode = newState.newNode ?? new import_Node.ZWaveNode(nodeId, this.driver);
          this._nodes.set(nodeId, newNode);
          const inclCtrlr = this.nodes.getOrThrow(newState.inclusionControllerNodeId);
          this.driver.controllerLog.logNode(nodeId, `Initiate command received from node ${inclCtrlr.id}`);
          newNode.hasSUCReturnRoute = true;
          const nodeInfo = await newNode.requestNodeInfo().catch(() => void 0);
          if (nodeInfo) {
            if (newState.newNode) {
              newNode.updateNodeInfo(nodeInfo);
            } else {
              const deviceClass = new import_DeviceClass.DeviceClass(nodeInfo.basicDeviceClass, nodeInfo.genericDeviceClass, nodeInfo.specificDeviceClass);
              newNode = new import_Node.ZWaveNode(
                nodeId,
                this.driver,
                deviceClass,
                nodeInfo.supportedCCs,
                void 0,
                // Create an empty value DB and specify that it contains no values
                // to avoid indexing the existing values
                this.createValueDBForNode(nodeId, /* @__PURE__ */ new Set())
              );
              this._nodes.set(nodeId, newNode);
            }
          }
          newNode.markAsAlive();
          const bootstrapFailure = await this.proxyBootstrap(newNode, inclCtrlr);
          const result = bootstrapFailure != void 0 ? {
            lowSecurity: true,
            lowSecurityReason: bootstrapFailure
          } : { lowSecurity: false };
          this.setInclusionState(import_Inclusion.InclusionState.Idle);
          this.emit("node added", newNode, result);
          this._proxyInclusionMachine = void 0;
          if (inclCtrlr && newState.step != void 0) {
            const step = newState.step;
            newNode.once("ready", () => {
              this.driver.controllerLog.logNode(inclCtrlr.nodeId, `Notifying inclusion controller of finished inclusion`);
              const api = inclCtrlr.createAPI(import_core.CommandClasses["Inclusion Controller"], false);
              void api.completeStep(step, import_cc.InclusionControllerStatus.OK).catch(import_shared.noop);
            });
          }
          return;
        }
        case "interview": {
          this._proxyInclusionMachine = void 0;
          if (this._proxyInclusionInitiateTimeout) {
            clearTimeout(this._proxyInclusionInitiateTimeout);
            this._proxyInclusionInitiateTimeout = void 0;
          }
          this.setInclusionState(import_Inclusion.InclusionState.Idle);
          this.emit("node added", newState.newNode, {
            lowSecurity: false
          });
          this._proxyInclusionMachine = void 0;
          return;
        }
      }
    }
    /** @internal */
    async handleApplicationUpdateRequest(msg) {
      const nodeId = msg.getNodeId();
      let node;
      if (nodeId != void 0) {
        node = this.nodes.get(nodeId);
      }
      if (msg instanceof import_serialapi.ApplicationUpdateRequestNodeInfoReceived) {
        if (node) {
          this.driver.controllerLog.logNode(node.id, {
            message: "Received updated node info",
            direction: "inbound"
          });
          node.updateNodeInfo(msg.nodeInformation);
          node.lastSeen = /* @__PURE__ */ new Date();
          this.driver.resolvePendingPings(node.id);
          node.emit("node info received", node);
          if (node.canSleep && node.supportsCC(import_core.CommandClasses["Wake Up"])) {
            this.driver.debounceSendNodeToSleep(node);
          }
          return;
        }
      } else if (msg instanceof import_serialapi.ApplicationUpdateRequestSmartStartHomeIDReceived || msg instanceof import_serialapi.ApplicationUpdateRequestSmartStartLongRangeHomeIDReceived) {
        const isLongRange = msg instanceof import_serialapi.ApplicationUpdateRequestSmartStartLongRangeHomeIDReceived;
        this.driver.controllerLog.print(`Received Smart Start inclusion request${isLongRange ? " (Z-Wave Long Range)" : ""}`);
        if (this.inclusionState !== import_Inclusion.InclusionState.Idle && this.inclusionState !== import_Inclusion.InclusionState.SmartStart) {
          this.driver.controllerLog.print("Controller is busy and cannot handle this inclusion request right now...");
          return;
        }
        const entry = this.provisioningList.find((entry2) => {
          if (!(0, import_shared.areUint8ArraysEqual)((0, import_core.nwiHomeIdFromDSK)((0, import_core.dskFromString)(entry2.dsk)), msg.nwiHomeId)) {
            return false;
          }
          const entryProtocol = entry2.protocol ?? entry2.supportedProtocols?.[0] ?? import_core.Protocols.ZWave;
          return entryProtocol === import_core.Protocols.ZWaveLongRange === isLongRange;
        });
        if (!entry) {
          this.driver.controllerLog.print("NWI Home ID not found in provisioning list, ignoring request...");
          return;
        } else if (entry.status === import_Inclusion.ProvisioningEntryStatus.Inactive) {
          this.driver.controllerLog.print("The provisioning entry for this node is inactive, ignoring request...");
          return;
        }
        const provisioningEntry = (0, import_shared.cloneDeep)(entry);
        if (isLongRange) {
          provisioningEntry.securityClasses = provisioningEntry.securityClasses.filter((sc) => sc === import_core.SecurityClass.S2_AccessControl || sc === import_core.SecurityClass.S2_Authenticated);
        }
        const securityManager = isLongRange ? this.driver.securityManagerLR : this.driver.securityManager2;
        const missingKeys = provisioningEntry.securityClasses.filter((sc) => !securityManager?.hasKeysForSecurityClass(sc));
        if (missingKeys.length > 0) {
          this.driver.controllerLog.print(`Ignoring inclusion request because the following security classes were granted but have no key configured:${missingKeys.map((sc) => `
\xB7 ${(0, import_shared.getEnumMemberName)(import_core.SecurityClass, sc)}${isLongRange ? " (Long Range)" : ""}`).join("")}`, "error");
          return;
        }
        this.driver.controllerLog.print("NWI Home ID found in provisioning list, including node...");
        try {
          const result = await this.beginInclusionSmartStart(provisioningEntry);
          if (!result) {
            this.driver.controllerLog.print("Smart Start inclusion could not be started", "error");
          }
        } catch (e) {
          this.driver.controllerLog.print(`Smart Start inclusion could not be started: ${(0, import_shared.getErrorMessage)(e)}`, "error");
        }
      } else if (msg instanceof import_serialapi.ApplicationUpdateRequestNodeRemoved) {
        const node2 = this.nodes.get(msg.nodeId);
        if (node2) {
          this.driver.controllerLog.logNode(node2.id, "was removed from the network by another controller");
          this.emit("node removed", node2, import_Inclusion.RemoveNodeReason.ProxyExcluded);
        }
      } else if (msg instanceof import_serialapi.ApplicationUpdateRequestNodeAdded) {
        const nodeId2 = msg.nodeId;
        const nodeInfo = msg.nodeInformation;
        if (this._nodes.has(nodeId2)) {
          this.driver.controllerLog.print(`Node ${nodeId2} was (supposedly) included by another controller, but it is already part of the network. Ignoring the message...`, "warn");
          return;
        }
        const deviceClass = new import_DeviceClass.DeviceClass(nodeInfo.basicDeviceClass, nodeInfo.genericDeviceClass, nodeInfo.specificDeviceClass);
        const newNode = new import_Node.ZWaveNode(
          nodeId2,
          this.driver,
          deviceClass,
          nodeInfo.supportedCCs,
          void 0,
          // Create an empty value DB and specify that it contains no values
          // to avoid indexing the existing values
          this.createValueDBForNode(nodeId2, /* @__PURE__ */ new Set())
        );
        this._nodes.set(nodeId2, newNode);
        this.emit("node found", {
          id: nodeId2,
          deviceClass,
          supportedCCs: nodeInfo.supportedCCs
        });
        this.driver.controllerLog.print(`Node ${newNode.id} was included by another controller:${newNode.deviceClass ? `
  basic device class:    ${(0, import_shared.getEnumMemberName)(import_core.BasicDeviceClass, newNode.deviceClass.basic)}
  generic device class:  ${newNode.deviceClass.generic.label}
  specific device class: ${newNode.deviceClass.specific.label}` : ""}
  supported CCs: ${nodeInfo.supportedCCs.map((cc) => `
  \xB7 ${import_core.CommandClasses[cc]} (${(0, import_shared.num2hex)(cc)})`).join("")}`);
        await this.updateProxyInclusionMachine({
          value: "NIF",
          nodeInfo,
          newNode
        });
      } else if (msg instanceof import_serialapi.ApplicationUpdateRequestSUCIdChanged) {
        this._sucNodeId = msg.sucNodeID;
      }
    }
    /**
     * @internal
     * Handles proxy inclusion requests from an inclusion controller
     */
    handleInclusionControllerCCInitiateProxyInclusion(initiate) {
      if (initiate.step !== import_cc.InclusionControllerStep.ProxyInclusion) {
        throw new import_core.ZWaveError("Expected an inclusion controller proxy inclusion request, but got a different step", import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      void this.updateProxyInclusionMachine({
        value: "INITIATE",
        step: initiate.step,
        inclusionControllerNodeId: initiate.nodeId,
        includedNodeId: initiate.includedNodeId
      }).catch(import_shared.noop);
    }
    /**
     * @internal
     * Handles replace requests from an inclusion controller
     */
    handleInclusionControllerCCInitiateReplace(initiate) {
      if (initiate.step !== import_cc.InclusionControllerStep.ProxyInclusionReplace) {
        throw new import_core.ZWaveError("Expected an inclusion controller replace request, but got a different step", import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      this.setInclusionState(import_Inclusion.InclusionState.Busy);
      const inclCtrlr = this.nodes.getOrThrow(initiate.nodeId);
      const replacedNodeId = initiate.includedNodeId;
      const oldNode = this.nodes.get(replacedNodeId);
      if (oldNode) {
        this.emit("node removed", oldNode, import_Inclusion.RemoveNodeReason.ProxyReplaced);
        this._nodes.delete(oldNode.id);
      }
      const newNode = new import_Node.ZWaveNode(
        replacedNodeId,
        this.driver,
        void 0,
        void 0,
        void 0,
        // Create an empty value DB and specify that it contains no values
        // to avoid indexing the existing values
        this.createValueDBForNode(replacedNodeId, /* @__PURE__ */ new Set())
      );
      this._nodes.set(newNode.id, newNode);
      this.emit("node found", {
        id: newNode.id
      });
      newNode.markAsAlive();
      newNode.hasSUCReturnRoute = true;
      process.nextTick(async () => {
        const requestedNodeInfo = await newNode.requestNodeInfo().catch(() => void 0);
        if (requestedNodeInfo) {
          newNode.updateNodeInfo(requestedNodeInfo);
          newNode["deviceClass"] = new import_DeviceClass.DeviceClass(requestedNodeInfo.basicDeviceClass, requestedNodeInfo.genericDeviceClass, requestedNodeInfo.specificDeviceClass);
        }
        const bootstrapFailure = await this.proxyBootstrap(newNode, inclCtrlr);
        const result = bootstrapFailure != void 0 ? {
          lowSecurity: true,
          lowSecurityReason: bootstrapFailure
        } : { lowSecurity: false };
        this.setInclusionState(import_Inclusion.InclusionState.Idle);
        this.emit("node added", newNode, result);
        newNode.once("ready", () => {
          this.driver.controllerLog.logNode(inclCtrlr.nodeId, `Notifying inclusion controller of finished inclusion`);
          const api = inclCtrlr.createAPI(import_core.CommandClasses["Inclusion Controller"], false);
          void api.completeStep(initiate.step, import_cc.InclusionControllerStatus.OK).catch(import_shared.noop);
        });
      });
    }
    /**
     * Handles bootstrapping the security keys for a node that was included by an inclusion controller
     */
    async proxyBootstrap(newNode, inclCtrlr) {
      const deviceClass = newNode.deviceClass;
      let bootstrapFailure;
      if (newNode.supportsCC(import_core.CommandClasses["Security 2"])) {
        bootstrapFailure = await this.secureBootstrapS2(newNode);
        if (bootstrapFailure == void 0) {
          const actualSecurityClass = newNode.getHighestSecurityClass();
          if (actualSecurityClass == void 0 || actualSecurityClass < import_core.SecurityClass.S2_Unauthenticated) {
            bootstrapFailure = import_Inclusion.SecurityBootstrapFailure.Unknown;
          }
        }
      } else if (newNode.supportsCC(import_core.CommandClasses.Security) && (deviceClass.specific ?? deviceClass.generic).requiresSecurity) {
        this.driver.controllerLog.logNode(newNode.id, `Waiting for node ${inclCtrlr.id} to perform S0 bootstrapping...`);
        await inclCtrlr.commandClasses["Inclusion Controller"].initiateStep(newNode.id, import_cc.InclusionControllerStep.S0Inclusion);
        const s0result = await this.driver.waitForCommand((cc) => cc.nodeId === inclCtrlr.id && cc instanceof import_cc.InclusionControllerCCComplete && cc.step === import_cc.InclusionControllerStep.S0Inclusion, 6e4).catch(() => void 0);
        this.driver.controllerLog.logNode(newNode.id, `S0 bootstrapping ${s0result == void 0 ? "timed out" : s0result.status === import_cc.InclusionControllerStatus.OK ? "succeeded" : "failed"}`);
        bootstrapFailure = s0result == void 0 ? import_Inclusion.SecurityBootstrapFailure.Timeout : s0result.status === import_cc.InclusionControllerStatus.OK ? void 0 : import_Inclusion.SecurityBootstrapFailure.Unknown;
        for (const secClass of import_core.securityClassOrder) {
          if (secClass !== import_core.SecurityClass.S0_Legacy) {
            newNode.securityClasses.set(secClass, false);
          }
        }
        newNode.securityClasses.set(import_core.SecurityClass.S0_Legacy, s0result?.status === import_cc.InclusionControllerStatus.OK);
      } else {
        for (const secClass of import_core.securityClassOrder) {
          newNode.securityClasses.set(secClass, false);
        }
      }
      return bootstrapFailure;
    }
    async secureBootstrapS0(node, nodeIsController, assumeSupported = false) {
      for (const secClass of import_core.securityClassOrder) {
        if (secClass !== import_core.SecurityClass.S0_Legacy) {
          node.securityClasses.set(secClass, false);
        }
      }
      if (!this.driver.securityManager) {
        node.securityClasses.set(import_core.SecurityClass.S0_Legacy, false);
        return import_Inclusion.SecurityBootstrapFailure.NoKeysConfigured;
      }
      try {
        if (assumeSupported && !node.supportsCC(import_core.CommandClasses.Security)) {
          node.addCC(import_core.CommandClasses.Security, {
            secure: true,
            isSupported: true,
            version: 1
          });
        }
        const S0_TIMEOUT = 1e4;
        const api = node.commandClasses.Security.withOptions({
          reportTimeoutMs: S0_TIMEOUT
        });
        const tasks = [
          // Request security scheme (and ignore the result), because it is required by the specs
          () => api.getSecurityScheme(),
          // Request nonce (for network key) separately, so we can impose a timeout
          () => api.getNonce(),
          // send the network key
          () => api.setNetworkKey(this.driver.securityManager.networkKey)
        ];
        if (nodeIsController) {
          tasks.push(async () => {
            await api.getNonce();
            await api.inheritSecurityScheme();
          });
        }
        for (const task of tasks) {
          const result = await Promise.race([
            (0, import_async.wait)(S0_TIMEOUT, true).then(() => false),
            task().catch(() => false)
          ]);
          if (result === false) {
            throw new import_core.ZWaveError(`A secure inclusion timer has elapsed`, import_core.ZWaveErrorCodes.Controller_NodeTimeout);
          }
        }
        node.securityClasses.set(import_core.SecurityClass.S0_Legacy, true);
        this.driver.controllerLog.logNode(node.id, {
          message: `Security S0 bootstrapping successful`
        });
      } catch (e) {
        let errorMessage = `Security S0 bootstrapping failed, the node was not granted the S0 security class`;
        let failure = import_Inclusion.SecurityBootstrapFailure.Unknown;
        if (!(0, import_core.isZWaveError)(e)) {
          errorMessage += `: ${e}`;
        } else if (e.code !== import_core.ZWaveErrorCodes.Controller_MessageDropped && e.code !== import_core.ZWaveErrorCodes.Controller_NodeTimeout) {
          errorMessage += `: ${e.message}`;
          failure = import_Inclusion.SecurityBootstrapFailure.Timeout;
        }
        this.driver.controllerLog.logNode(node.id, errorMessage, "warn");
        node.securityClasses.set(import_core.SecurityClass.S0_Legacy, false);
        node.removeCC(import_core.CommandClasses.Security);
        return failure;
      }
    }
    _bootstrappingS2NodeId;
    /**
     * @internal
     * Returns which node is currently being bootstrapped with S2
     */
    get bootstrappingS2NodeId() {
      return this._bootstrappingS2NodeId;
    }
    cancelBootstrapS2Promise;
    cancelSecureBootstrapS2(reason) {
      if (this.cancelBootstrapS2Promise) {
        this.cancelBootstrapS2Promise.resolve(reason);
        this.cancelBootstrapS2Promise = void 0;
      }
    }
    async secureBootstrapS2(node, inclusionOptions, assumeSupported = false) {
      const unGrantSecurityClasses = /* @__PURE__ */ __name(() => {
        for (const secClass of import_core.securityClassOrder) {
          node.securityClasses.set(secClass, false);
        }
      }, "unGrantSecurityClasses");
      const securityManager = node.protocol === import_core.Protocols.ZWaveLongRange ? this.driver.securityManagerLR : this.driver.securityManager2;
      if (!securityManager) {
        unGrantSecurityClasses();
        return import_Inclusion.SecurityBootstrapFailure.NoKeysConfigured;
      }
      let userCallbacks;
      if (inclusionOptions && "provisioning" in inclusionOptions && !!inclusionOptions.provisioning) {
        const grantedSecurityClasses = inclusionOptions.provisioning.securityClasses;
        const fullDSK = inclusionOptions.provisioning.dsk;
        userCallbacks = {
          abort() {
          },
          grantSecurityClasses: /* @__PURE__ */ __name((requested) => {
            return Promise.resolve({
              clientSideAuth: false,
              securityClasses: requested.securityClasses.filter((r) => grantedSecurityClasses.includes(r))
            });
          }, "grantSecurityClasses"),
          validateDSKAndEnterPIN: /* @__PURE__ */ __name((dsk) => {
            const pin = fullDSK.slice(0, 5);
            if (pin + dsk !== fullDSK)
              return Promise.resolve(false);
            return Promise.resolve(pin);
          }, "validateDSKAndEnterPIN")
        };
      } else if (inclusionOptions && "userCallbacks" in inclusionOptions && !!inclusionOptions.userCallbacks) {
        userCallbacks = inclusionOptions.userCallbacks;
      } else if (this.driver.options.inclusionUserCallbacks) {
        userCallbacks = this.driver.options.inclusionUserCallbacks;
      } else {
        unGrantSecurityClasses();
        return import_Inclusion.SecurityBootstrapFailure.S2NoUserCallbacks;
      }
      if (assumeSupported && !node.supportsCC(import_core.CommandClasses["Security 2"])) {
        node.addCC(import_core.CommandClasses["Security 2"], {
          secure: true,
          isSupported: true,
          version: 1
        });
      }
      const deleteTempKey = /* @__PURE__ */ __name(() => {
        securityManager.deleteNonce(node.id);
        securityManager.tempKeys.delete(node.id);
      }, "deleteTempKey");
      this._bootstrappingS2NodeId = node.id;
      this.cancelBootstrapS2Promise = (0, import_deferred_promise.createDeferredPromise)();
      try {
        const api = node.commandClasses["Security 2"].withOptions({
          // Do not wait for Nonce Reports after SET-type commands.
          // Timing is critical here
          s2VerifyDelivery: false
        });
        const abort = /* @__PURE__ */ __name(async (failType) => {
          if (failType != void 0) {
            try {
              await api.abortKeyExchange(failType);
            } catch {
            }
          }
          unGrantSecurityClasses();
          deleteTempKey();
          this._bootstrappingS2NodeId = void 0;
          this.cancelBootstrapS2Promise = void 0;
        }, "abort");
        const abortUser = /* @__PURE__ */ __name(async () => {
          setImmediate(() => {
            try {
              userCallbacks.abort();
            } catch {
            }
          });
          await abort(import_cc.KEXFailType.BootstrappingCanceled);
          return import_Inclusion.SecurityBootstrapFailure.UserCanceled;
        }, "abortUser");
        const abortTimeout = /* @__PURE__ */ __name(async () => {
          this.driver.controllerLog.logNode(node.id, {
            message: `Security S2 bootstrapping failed: a secure inclusion timer has elapsed`,
            level: "warn"
          });
          await abort();
          return import_Inclusion.SecurityBootstrapFailure.Timeout;
        }, "abortTimeout");
        const kexParams = await api.withOptions({ reportTimeoutMs: import_cc.inclusionTimeouts.TA1 }).getKeyExchangeParameters();
        if (!kexParams) {
          this.driver.controllerLog.logNode(node.id, {
            message: `Security S2 bootstrapping failed: did not receive the node's desired security classes.`,
            level: "warn"
          });
          await abort();
          return import_Inclusion.SecurityBootstrapFailure.Timeout;
        }
        if (kexParams.echo) {
          this.driver.controllerLog.logNode(node.id, {
            message: `Security S2 bootstrapping failed: KEX Report unexpectedly has the echo flag set.`,
            level: "warn"
          });
          await abort(import_cc.KEXFailType.NoVerify);
          return import_Inclusion.SecurityBootstrapFailure.ParameterMismatch;
        }
        if (kexParams.supportedKEXSchemes.length !== 1 || !kexParams.supportedKEXSchemes.includes(import_cc.KEXSchemes.KEXScheme1)) {
          this.driver.controllerLog.logNode(node.id, {
            message: `Security S2 bootstrapping failed: No supported key exchange scheme or invalid list.`,
            level: "warn"
          });
          await abort(import_cc.KEXFailType.NoSupportedScheme);
          return import_Inclusion.SecurityBootstrapFailure.ParameterMismatch;
        } else if (kexParams.supportedECDHProfiles.length !== 1 || !kexParams.supportedECDHProfiles.includes(import_cc.ECDHProfiles.Curve25519)) {
          this.driver.controllerLog.logNode(node.id, {
            message: `Security S2 bootstrapping failed: No supported ECDH profile or invalid list.`,
            level: "warn"
          });
          await abort(import_cc.KEXFailType.NoSupportedCurve);
          return import_Inclusion.SecurityBootstrapFailure.ParameterMismatch;
        } else if (kexParams.requestCSA) {
          this.driver.controllerLog.logNode(node.id, {
            message: `Security S2 bootstrapping failed: CSA requested but not granted.`,
            level: "warn"
          });
          await abort(import_cc.KEXFailType.BootstrappingCanceled);
          return import_Inclusion.SecurityBootstrapFailure.ParameterMismatch;
        }
        const supportedKeys = kexParams.requestedKeys.filter((k) => import_core.securityClassOrder.includes(k));
        if (!supportedKeys.length) {
          this.driver.controllerLog.logNode(node.id, {
            message: `Security S2 bootstrapping failed: None of the requested security classes are supported.`,
            level: "warn"
          });
          await abort(import_cc.KEXFailType.NoKeyMatch);
          return import_Inclusion.SecurityBootstrapFailure.ParameterMismatch;
        }
        const grantResult = await Promise.race([
          (0, import_async.wait)(import_cc.inclusionTimeouts.TAI1, true).then(() => false),
          userCallbacks.grantSecurityClasses({
            securityClasses: supportedKeys,
            clientSideAuth: false
          }).catch(() => false)
        ]);
        if (grantResult === false) {
          this.driver.controllerLog.logNode(node.id, {
            message: `Security S2 bootstrapping failed: User rejected the requested security classes or interaction timed out.`,
            level: "warn"
          });
          return abortUser();
        }
        const grantedKeys = supportedKeys.filter((k) => grantResult.securityClasses.includes(k));
        if (!grantedKeys.length) {
          this.driver.controllerLog.logNode(node.id, {
            message: `Security S2 bootstrapping failed: None of the requested keys were granted by the user.`,
            level: "warn"
          });
          return abortUser();
        }
        await api.grantKeys({
          grantedKeys,
          permitCSA: false,
          selectedECDHProfile: import_cc.ECDHProfiles.Curve25519,
          selectedKEXScheme: import_cc.KEXSchemes.KEXScheme1
        });
        const pubKeyResponse = await this.driver.waitForCommand((cc) => cc instanceof import_cc.Security2CCPublicKeyReport || cc instanceof import_cc.Security2CCKEXFail, import_cc.inclusionTimeouts.TA2).catch(() => "timeout");
        if (pubKeyResponse === "timeout")
          return abortTimeout();
        if (pubKeyResponse instanceof import_cc.Security2CCKEXFail || pubKeyResponse.includingNode) {
          this.driver.controllerLog.logNode(node.id, {
            message: `The joining node canceled the Security S2 bootstrapping.`,
            direction: "inbound",
            level: "warn"
          });
          await abort();
          return import_Inclusion.SecurityBootstrapFailure.NodeCanceled;
        }
        const nodePublicKey = import_shared.Bytes.from(pubKeyResponse.publicKey);
        const timerStartTAI2 = Date.now();
        const keyPair = await (0, import_core.generateECDHKeyPair)();
        await api.sendPublicKey(keyPair.publicKey);
        if (grantedKeys.includes(import_core.SecurityClass.S2_AccessControl) || grantedKeys.includes(import_core.SecurityClass.S2_Authenticated)) {
          const dsk = (0, import_core.dskToString)(nodePublicKey.subarray(0, 16)).slice(5);
          const tai2RemainingMs2 = import_cc.inclusionTimeouts.TAI2 - (Date.now() - timerStartTAI2);
          let pinResult;
          if (inclusionOptions && "dsk" in inclusionOptions && typeof inclusionOptions.dsk === "string" && (0, import_core.isValidDSK)(inclusionOptions.dsk)) {
            pinResult = inclusionOptions.dsk.slice(0, 5);
          } else {
            pinResult = await Promise.race([
              (0, import_async.wait)(tai2RemainingMs2, true).then(() => false),
              userCallbacks.validateDSKAndEnterPIN(dsk).catch(() => false)
            ]);
          }
          if (typeof pinResult !== "string" || !/^\d{5}$/.test(pinResult)) {
            this.driver.controllerLog.logNode(node.id, {
              message: `Security S2 bootstrapping failed: User rejected the DSK, entered an invalid PIN or the interaction timed out.`,
              level: "warn"
            });
            return abortUser();
          }
          nodePublicKey.writeUInt16BE(parseInt(pinResult, 10), 0);
        }
        const sharedSecret = await (0, import_core.deriveSharedECDHSecret)({
          publicKey: nodePublicKey,
          privateKey: keyPair.privateKey
        });
        const tempKeys = await (0, import_core.deriveTempKeys)(await (0, import_core.computePRK)(sharedSecret, keyPair.publicKey, nodePublicKey));
        securityManager.deleteNonce(node.id);
        securityManager.tempKeys.set(node.id, {
          keyCCM: tempKeys.tempKeyCCM,
          personalizationString: tempKeys.tempPersonalizationString
        });
        const tai2RemainingMs = import_cc.inclusionTimeouts.TAI2 - (Date.now() - timerStartTAI2);
        if (tai2RemainingMs < 1) {
          this.driver.controllerLog.logNode(node.id, {
            message: `Security S2 bootstrapping failed: a secure inclusion timer has elapsed`,
            level: "warn"
          });
          return abortUser();
        }
        const kexSetEcho = await Promise.race([
          this.driver.waitForCommand((cc) => cc instanceof import_cc.Security2CCKEXSet || cc instanceof import_cc.Security2CCKEXFail, tai2RemainingMs).catch(() => "timeout"),
          this.cancelBootstrapS2Promise
        ]);
        if (kexSetEcho === "timeout")
          return abortTimeout();
        if (typeof kexSetEcho === "number") {
          await abort(kexSetEcho);
          return import_Inclusion.SecurityBootstrapFailure.S2IncorrectPIN;
        }
        if (kexSetEcho instanceof import_cc.Security2CCKEXFail) {
          this.driver.controllerLog.logNode(node.id, {
            message: `The joining node canceled the Security S2 bootstrapping.`,
            direction: "inbound",
            level: "warn"
          });
          await abort();
          return import_Inclusion.SecurityBootstrapFailure.NodeCanceled;
        } else if (!kexSetEcho.echo) {
          this.driver.controllerLog.logNode(node.id, {
            message: `Security S2 bootstrapping failed: KEXSet received without echo flag`,
            direction: "inbound",
            level: "warn"
          });
          await abort(import_cc.KEXFailType.WrongSecurityLevel);
          return import_Inclusion.SecurityBootstrapFailure.NodeCanceled;
        } else if (kexSetEcho._reserved !== 0) {
          this.driver.controllerLog.logNode(node.id, {
            message: `Security S2 bootstrapping failed: Invalid KEXSet received`,
            direction: "inbound",
            level: "warn"
          });
          await abort(import_cc.KEXFailType.WrongSecurityLevel);
          return import_Inclusion.SecurityBootstrapFailure.NodeCanceled;
        } else if (!kexSetEcho.isEncapsulatedWith(import_core.CommandClasses["Security 2"], import_cc.Security2Command.MessageEncapsulation)) {
          this.driver.controllerLog.logNode(node.id, {
            message: `Security S2 bootstrapping failed: Command received without encryption`,
            direction: "inbound",
            level: "warn"
          });
          await abort(import_cc.KEXFailType.WrongSecurityLevel);
          return import_Inclusion.SecurityBootstrapFailure.S2WrongSecurityLevel;
        } else if (kexSetEcho.grantedKeys.length !== grantedKeys.length || !kexSetEcho.grantedKeys.every((k) => grantedKeys.includes(k))) {
          this.driver.controllerLog.logNode(node.id, {
            message: `Security S2 bootstrapping failed: Granted key mismatch.`,
            level: "warn"
          });
          await abort(import_cc.KEXFailType.WrongSecurityLevel);
          return import_Inclusion.SecurityBootstrapFailure.S2WrongSecurityLevel;
        }
        await api.confirmRequestedKeys({
          requestCSA: kexParams.requestCSA,
          requestedKeys: [...kexParams.requestedKeys],
          supportedECDHProfiles: [...kexParams.supportedECDHProfiles],
          supportedKEXSchemes: [...kexParams.supportedKEXSchemes],
          _reserved: kexParams._reserved
        });
        for (let i = 0; i < grantedKeys.length; i++) {
          const keyRequest = await this.driver.waitForCommand((cc) => cc instanceof import_cc.Security2CCNetworkKeyGet || cc instanceof import_cc.Security2CCKEXFail, import_cc.inclusionTimeouts.TA3).catch(() => "timeout");
          if (keyRequest === "timeout") {
            return abortTimeout();
          } else if (keyRequest instanceof import_cc.Security2CCKEXFail) {
            this.driver.controllerLog.logNode(node.id, {
              message: `The joining node canceled the Security S2 bootstrapping.`,
              direction: "inbound",
              level: "warn"
            });
            await abort();
            return import_Inclusion.SecurityBootstrapFailure.NodeCanceled;
          } else if (!keyRequest.isEncapsulatedWith(import_core.CommandClasses["Security 2"], import_cc.Security2Command.MessageEncapsulation)) {
            this.driver.controllerLog.logNode(node.id, {
              message: `Security S2 bootstrapping failed: Command received without encryption`,
              direction: "inbound",
              level: "warn"
            });
            await abort(import_cc.KEXFailType.WrongSecurityLevel);
            return import_Inclusion.SecurityBootstrapFailure.S2WrongSecurityLevel;
          }
          const securityClass = keyRequest.requestedKey;
          if (!securityManager.hasUsedSecurityClass(node.id, import_core.SecurityClass.Temporary)) {
            this.driver.controllerLog.logNode(node.id, {
              message: `Security S2 bootstrapping failed: Node used wrong key to communicate.`,
              level: "warn"
            });
            await abort(import_cc.KEXFailType.WrongSecurityLevel);
            return import_Inclusion.SecurityBootstrapFailure.S2WrongSecurityLevel;
          } else if (!grantedKeys.includes(securityClass)) {
            this.driver.controllerLog.logNode(node.id, {
              message: `Security S2 bootstrapping failed: Node used key it was not granted.`,
              level: "warn"
            });
            await abort(import_cc.KEXFailType.KeyNotGranted);
            return import_Inclusion.SecurityBootstrapFailure.S2WrongSecurityLevel;
          }
          node.securityClasses.set(securityClass, true);
          await api.sendNetworkKey(securityClass, securityManager.getKeysForSecurityClass(securityClass).pnk);
          const verify = await this.driver.waitForCommand((cc) => cc instanceof import_cc.Security2CCNetworkKeyVerify || cc instanceof import_cc.Security2CCKEXFail, import_cc.inclusionTimeouts.TA4).catch(() => "timeout");
          if (verify === "timeout")
            return abortTimeout();
          if (verify instanceof import_cc.Security2CCKEXFail) {
            this.driver.controllerLog.logNode(node.id, {
              message: `The joining node canceled the Security S2 bootstrapping.`,
              direction: "inbound",
              level: "warn"
            });
            await abort();
            return import_Inclusion.SecurityBootstrapFailure.NodeCanceled;
          }
          if (!securityManager.hasUsedSecurityClass(node.id, securityClass)) {
            this.driver.controllerLog.logNode(node.id, {
              message: `Security S2 bootstrapping failed: Node used wrong key to communicate.`,
              level: "warn"
            });
            await abort(import_cc.KEXFailType.NoVerify);
            return import_Inclusion.SecurityBootstrapFailure.S2WrongSecurityLevel;
          }
          node.securityClasses.delete(securityClass);
          securityManager.deleteNonce(node.id);
          await api.confirmKeyVerification();
        }
        const transferEnd = await this.driver.waitForCommand((cc) => cc instanceof import_cc.Security2CCTransferEnd, import_cc.inclusionTimeouts.TA5).catch(() => "timeout");
        if (transferEnd === "timeout")
          return abortTimeout();
        if (!transferEnd.keyRequestComplete) {
          this.driver.controllerLog.logNode(node.id, {
            message: `Security S2 bootstrapping failed: Node did not confirm completion of the key exchange`,
            level: "warn"
          });
          await abort(import_cc.KEXFailType.NoVerify);
          return import_Inclusion.SecurityBootstrapFailure.Timeout;
        }
        for (const securityClass of import_core.securityClassOrder) {
          node.securityClasses.set(securityClass, grantedKeys.includes(securityClass));
        }
        node.dsk = nodePublicKey.subarray(0, 16);
        this.driver.controllerLog.logNode(node.id, {
          message: `Security S2 bootstrapping successful with these security classes:${[
            ...node.securityClasses.entries()
          ].filter(([, v]) => v).map(([k]) => `
\xB7 ${(0, import_shared.getEnumMemberName)(import_core.SecurityClass, k)}`).join("")}`
        });
      } catch (e) {
        let errorMessage = `Security S2 bootstrapping failed, the node was not granted any S2 security class`;
        let result = import_Inclusion.SecurityBootstrapFailure.Unknown;
        if (!(0, import_core.isZWaveError)(e)) {
          errorMessage += `: ${e}`;
        } else if (e.code === import_core.ZWaveErrorCodes.Controller_MessageExpired) {
          errorMessage += ": a secure inclusion timer has elapsed.";
          result = import_Inclusion.SecurityBootstrapFailure.Timeout;
        } else if (e.code !== import_core.ZWaveErrorCodes.Controller_MessageDropped && e.code !== import_core.ZWaveErrorCodes.Controller_NodeTimeout) {
          errorMessage += `: ${e.message}`;
        }
        this.driver.controllerLog.logNode(node.id, errorMessage, "warn");
        unGrantSecurityClasses();
        node.removeCC(import_core.CommandClasses["Security 2"]);
        return result;
      } finally {
        deleteTempKey();
        this._bootstrappingS2NodeId = void 0;
        this.cancelBootstrapS2Promise = void 0;
      }
    }
    _rebuildRoutesProgress = /* @__PURE__ */ new Map();
    /**
     * If routes are currently being rebuilt for the entire network, this returns the current progress.
     * The information is the same as in the `"rebuild routes progress"` event.
     */
    get rebuildRoutesProgress() {
      if (!this.isRebuildingRoutes)
        return void 0;
      return new Map(this._rebuildRoutesProgress);
    }
    /**
     * Starts the process of rebuilding routes for all alive nodes in the network,
     * requesting updated neighbor lists and assigning fresh routes to
     * association targets.
     *
     * Returns `true` if the process was started, otherwise `false`. Also returns
     * `false` if the process was already active.
     */
    beginRebuildingRoutes(options = {}) {
      const existingTask = this.driver.scheduler.findTask((t) => t.tag?.id === "rebuild-routes");
      if (existingTask)
        return false;
      options.includeSleeping ??= true;
      options.deletePriorityReturnRoutes ??= false;
      this.driver.controllerLog.print(`rebuilding routes${options.includeSleeping ? "" : " for mains-powered nodes"}...`);
      this._rebuildRoutesProgress.clear();
      for (const [id, node] of this._nodes) {
        if (id === this._ownNodeId)
          continue;
        if ((0, import_core.isLongRangeNodeId)(id))
          continue;
        if (
          // The node is known to be dead
          node.status === import_Types.NodeStatus.Dead || node.status === import_Types.NodeStatus.Asleep && node.interviewStage === import_Types.InterviewStage.ProtocolInfo
        ) {
          this.driver.controllerLog.logNode(id, `Skipping route rebuild because the node is not responding.`);
          this._rebuildRoutesProgress.set(id, "skipped");
        } else if (!options.includeSleeping && node.canSleep) {
          this.driver.controllerLog.logNode(id, `Skipping route rebuild because the node is sleeping.`);
          this._rebuildRoutesProgress.set(id, "skipped");
        } else if (!options.deletePriorityReturnRoutes && (this.getPrioritySUCReturnRouteCached(id) || Object.keys(this.getPriorityReturnRoutesCached(id)).length > 0)) {
          this.driver.controllerLog.logNode(id, `Skipping route rebuild because the node has priority return routes.`);
          this._rebuildRoutesProgress.set(id, "skipped");
        } else {
          this._rebuildRoutesProgress.set(id, "pending");
        }
      }
      void this.rebuildRoutesInternal(options).catch(import_shared.noop);
      this.emit("rebuild routes progress", new Map(this._rebuildRoutesProgress));
      return true;
    }
    rebuildRoutesInternal(options) {
      return this.driver.scheduler.queueTask(this.getRebuildRoutesTask(options));
    }
    getRebuildRoutesTask(options) {
      const pendingNodes = new Set([...this._rebuildRoutesProgress].filter(([, status]) => status === "pending").map(([nodeId]) => nodeId));
      const todoListening = [];
      const todoSleeping = [];
      const addTodo = /* @__PURE__ */ __name((nodeId) => {
        if ((0, import_core.isLongRangeNodeId)(nodeId))
          return;
        if (pendingNodes.has(nodeId)) {
          pendingNodes.delete(nodeId);
          const node = this.nodes.getOrThrow(nodeId);
          if (node.canSleep) {
            if (options.includeSleeping) {
              this.driver.controllerLog.logNode(nodeId, "added to route rebuilding queue for sleeping nodes");
              todoSleeping.push(nodeId);
            }
          } else {
            this.driver.controllerLog.logNode(nodeId, "added to route rebuilding queue for listening nodes");
            todoListening.push(nodeId);
          }
        }
      }, "addTodo");
      const self = this;
      return {
        priority: import_Task.TaskPriority.Lower,
        tag: { id: "rebuild-routes" },
        task: /* @__PURE__ */ __name(async function* rebuildRoutesTask() {
          try {
            const neighbors = await self.getNodeNeighbors(self._ownNodeId);
            neighbors.forEach((id) => addTodo(id));
          } catch {
          }
          yield;
          async function* doRebuildRoutes(nodeId) {
            let result;
            try {
              const node = self.nodes.getOrThrow(nodeId);
              result = yield* (0, import_waddle.waitFor)(self.getRebuildNodeRoutesTask(node));
            } catch {
              result = false;
            }
            self._rebuildRoutesProgress.set(nodeId, result ? "done" : "failed");
            self.emit("rebuild routes progress", new Map(self._rebuildRoutesProgress));
            yield;
            try {
              const neighbors = await self.getNodeNeighbors(nodeId);
              neighbors.forEach((id) => addTodo(id));
            } catch {
            }
            yield;
          }
          __name(doRebuildRoutes, "doRebuildRoutes");
          while (todoListening.length > 0) {
            const nodeId = todoListening.shift();
            yield* doRebuildRoutes(nodeId);
          }
          pendingNodes.forEach((nodeId) => addTodo(nodeId));
          while (todoListening.length > 0) {
            const nodeId = todoListening.shift();
            yield* doRebuildRoutes(nodeId);
          }
          if (options.includeSleeping) {
            self.driver.controllerLog.print("Rebuilding routes for sleeping nodes when they wake up");
            const sleepingNodes = todoSleeping.map((nodeId) => self.nodes.get(nodeId)).filter((node) => node != void 0);
            const wakeupPromises = new Map(sleepingNodes.map((node) => [
              node.id,
              node.waitForWakeup().then(() => node)
            ]));
            while (wakeupPromises.size > 0) {
              const wakeUpPromise = Promise.race(wakeupPromises.values());
              const wokenUpNode = yield* (0, import_waddle.waitFor)(wakeUpPromise);
              if (wokenUpNode.status === import_Types.NodeStatus.Asleep) {
                wakeupPromises.set(wokenUpNode.id, wokenUpNode.waitForWakeup().then(() => wokenUpNode));
                continue;
              }
              wakeupPromises.delete(wokenUpNode.id);
              yield* doRebuildRoutes(wokenUpNode.id);
            }
          }
          self.driver.controllerLog.print("rebuilding routes completed");
          self.emit("rebuild routes done", new Map(self._rebuildRoutesProgress));
          self._rebuildRoutesProgress.clear();
        }, "rebuildRoutesTask")
      };
    }
    /**
     * Stops the route rebuilding process. Resolves false if the process was not active, true otherwise.
     */
    stopRebuildingRoutes() {
      const hasTasks = !!this.driver.scheduler.findTask(import_utils.isRebuildRoutesTask);
      if (!hasTasks)
        return false;
      this.driver.controllerLog.print(`stopping route rebuilding process...`);
      void this.driver.scheduler.removeTasks(import_utils.isRebuildRoutesTask).then(() => {
        this.driver.controllerLog.print("rebuilding routes aborted");
      });
      void this.driver.rejectTransactions((t) => t.message instanceof import_serialapi.RequestNodeNeighborUpdateRequest || t.message instanceof import_serialapi.DeleteReturnRouteRequest || t.message instanceof import_serialapi.AssignReturnRouteRequest);
      this._rebuildRoutesProgress.clear();
      return true;
    }
    /**
     * Rebuilds routes for a single alive node in the network,
     * updating the neighbor list and assigning fresh routes to
     * association targets.
     *
     * Returns `true` if the process succeeded, `false` otherwise.
     */
    async rebuildNodeRoutes(nodeId) {
      if (nodeId === this._ownNodeId) {
        throw new import_core.ZWaveError(`Rebuilding routes for the controller itself is not possible!`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      const node = this.nodes.getOrThrow(nodeId);
      if (node.protocol == import_core.Protocols.ZWaveLongRange) {
        throw new import_core.ZWaveError(`Cannot rebuild routes for nodes using Z-Wave Long Range!`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      if (
        // The node is known to be dead
        node.status === import_Types.NodeStatus.Dead || node.status === import_Types.NodeStatus.Asleep && node.interviewStage === import_Types.InterviewStage.ProtocolInfo
      ) {
        if (!await node.ping(true)) {
          this.driver.controllerLog.logNode(nodeId, `Cannot rebuild routes because the node is not responding.`);
          return false;
        }
      }
      return this.rebuildNodeRoutesInternal(nodeId);
    }
    rebuildNodeRoutesInternal(nodeId) {
      const node = this.nodes.getOrThrow(nodeId);
      const task = this.getRebuildNodeRoutesTask(node);
      if (task instanceof Promise)
        return task;
      return this.driver.scheduler.queueTask(task);
    }
    getRebuildNodeRoutesTask(node) {
      const existingTask = this.driver.scheduler.findTask((t) => t.tag?.id === "rebuild-node-routes" && t.tag.nodeId === node.id);
      if (existingTask)
        return existingTask;
      const self = this;
      let keepAwake;
      return {
        // This task is executed by users and by the network-wide route rebuilding process.
        priority: import_Task.TaskPriority.Lower,
        tag: { id: "rebuild-node-routes", nodeId: node.id },
        task: /* @__PURE__ */ __name(async function* rebuildNodeRoutesTask() {
          keepAwake = node.keepAwake;
          node.keepAwake = true;
          if (node.canSleep && node.supportsCC(import_core.CommandClasses["Wake Up"])) {
            yield* (0, import_waddle.waitFor)(node.waitForWakeup());
          }
          self.driver.controllerLog.logNode(node.id, {
            message: `Rebuilding routes...`,
            direction: "none"
          });
          const maxAttempts = 5;
          for (let attempt = 1; attempt <= maxAttempts; attempt++) {
            yield;
            self.driver.controllerLog.logNode(node.id, {
              message: `refreshing neighbor list (attempt ${attempt})...`,
              direction: "outbound"
            });
            try {
              const result = await self.discoverNodeNeighbors(node.id);
              if (result) {
                self.driver.controllerLog.logNode(node.id, {
                  message: "neighbor list refreshed...",
                  direction: "inbound"
                });
                break;
              } else {
                self.driver.controllerLog.logNode(node.id, {
                  message: "refreshing neighbor list failed...",
                  direction: "inbound",
                  level: "warn"
                });
              }
            } catch (e) {
              self.driver.controllerLog.logNode(node.id, `refreshing neighbor list failed: ${(0, import_shared.getErrorMessage)(e)}`, "warn");
            }
            if (attempt === maxAttempts) {
              self.driver.controllerLog.logNode(node.id, {
                message: `rebuilding routes failed: could not update the neighbor list after ${maxAttempts} attempts`,
                level: "warn",
                direction: "none"
              });
              return false;
            }
          }
          yield;
          node.hasSUCReturnRoute = await self.assignSUCReturnRoutes(node.id);
          for (let attempt = 1; attempt <= maxAttempts; attempt++) {
            yield;
            self.driver.controllerLog.logNode(node.id, {
              message: `deleting return routes (attempt ${attempt})...`,
              direction: "outbound"
            });
            if (await self.deleteReturnRoutes(node.id)) {
              break;
            }
            if (attempt === maxAttempts) {
              self.driver.controllerLog.logNode(node.id, {
                message: `rebuilding routes failed: failed to delete return routes after ${maxAttempts} attempts`,
                level: "warn",
                direction: "none"
              });
              return false;
            }
          }
          let associatedNodes = [];
          try {
            associatedNodes = (0, import_arrays.distinct)([
              ...self.getAssociations({ nodeId: node.id }).values()
            ].flatMap((assocs) => assocs.map((a) => a.nodeId))).filter((id) => id !== self._ownNodeId).filter((id) => id !== node.id).filter((id) => id >= 1 && id <= import_core.MAX_NODES).filter((id) => self.nodes.has(id)).sort();
          } catch {
          }
          if (associatedNodes.length > 0) {
            self.driver.controllerLog.logNode(node.id, {
              message: `assigning return routes to the following nodes:
	${associatedNodes.join(", ")}`,
              direction: "outbound"
            });
            for (const destinationNodeId of associatedNodes) {
              for (let attempt = 1; attempt <= maxAttempts; attempt++) {
                yield;
                self.driver.controllerLog.logNode(node.id, {
                  message: `assigning return route to node ${destinationNodeId} (attempt ${attempt})...`,
                  direction: "outbound"
                });
                if (await self.assignReturnRoutes(node.id, destinationNodeId)) {
                  break;
                }
                if (attempt === maxAttempts) {
                  self.driver.controllerLog.logNode(node.id, {
                    message: `failed to assign return route to node ${destinationNodeId} after ${maxAttempts} attempts, continuing with other targets...`,
                    level: "warn",
                    direction: "none"
                  });
                }
              }
            }
          }
          self.driver.controllerLog.logNode(node.id, {
            message: `rebuilt routes successfully`,
            direction: "none"
          });
          return true;
        }, "rebuildNodeRoutesTask"),
        cleanup: /* @__PURE__ */ __name(() => {
          node.keepAwake = keepAwake;
          if (!keepAwake) {
            setImmediate(() => {
              this.driver.debounceSendNodeToSleep(node);
            });
          }
          return Promise.resolve();
        }, "cleanup")
      };
    }
    /** Configures the given Node to be SUC/SIS or not */
    async configureSUC(nodeId, enableSUC, enableSIS) {
      const result = await this.driver.sendMessage(new import_serialapi.SetSUCNodeIdRequest({
        ownNodeId: this.ownNodeId,
        sucNodeId: nodeId,
        enableSUC,
        enableSIS
      }));
      return result.isOK();
    }
    // After a lot of experimenting, it seems to make sense to document how assigning return routes works in the controller.
    // Each node has a list of 4 return routes per destination (and probably a separate list for the SUC):
    // - #0, repeaters..., speed, wakeup
    // - #1, repeaters..., speed, wakeup
    // - #2, repeaters..., speed, wakeup
    // - #3, repeaters..., speed, wakeup
    //
    // Empty slots are filled with 0 repeaters, 9.6kbit/s, no wakeup
    //
    // Calling assignReturnRoute will assign all 4 slots, some of which may be empty.
    // Calling deleteReturnRoute will assign an empty route to all 4 slots.
    //
    // Priority return routes are indicated by a separate "pointer" byte which tells the node which route is the priority.
    // Calling assignPriorityReturnRoute will first assign 4 routes, one of which is then marked as priority.
    // This is not fully understood yet, but it seems that the priority route is actually the last non-empty route.
    // If the priority byte points to an empty route, it is ignored.
    //
    // Calling assignReturnRoute after having assigned a priority return route will not clear that pointer byte. This
    // means that a previously-assigned priority route can randomly change if assignReturnRoute assigns enough routes.
    // deleteReturnRoute does also clear the priority byte.
    /**
     * Instructs the controller to assign static routes from the given end node to the SUC.
     * This will assign up to 4 routes, depending on the network topology (that the controller knows about).
     */
    async assignSUCReturnRoutes(nodeId) {
      if ((0, import_core.isLongRangeNodeId)(nodeId)) {
        this.driver.controllerLog.logNode(nodeId, `Cannot manage routes for nodes using Z-Wave Long Range!`, "error");
        return false;
      }
      this.driver.controllerLog.logNode(nodeId, {
        message: `Assigning SUC return route...`,
        direction: "outbound"
      });
      await this.deleteSUCReturnRoutes(nodeId);
      try {
        const disableCallbackFunctionTypeCheck = !!this.driver.getDeviceConfig?.(this.ownNodeId)?.compat?.disableCallbackFunctionTypeCheck?.includes(import_serial.FunctionType.AssignSUCReturnRoute);
        const result = await this.driver.sendMessage(new import_serialapi.AssignSUCReturnRouteRequest({
          nodeId,
          disableCallbackFunctionTypeCheck
        }));
        if (!(result instanceof import_serialapi.AssignSUCReturnRouteRequestTransmitReport)) {
          this.driver.controllerLog.logNode(nodeId, `Assigning SUC return route failed: Invalid callback received`, "error");
          return false;
        }
        const success = this.handleRouteAssignmentTransmitReport(result, nodeId);
        if (success) {
          this.setCustomSUCReturnRoutesCached(nodeId, void 0);
        }
        return success;
      } catch (e) {
        this.driver.controllerLog.logNode(nodeId, `Assigning SUC return route failed: ${(0, import_shared.getErrorMessage)(e)}`, "error");
        return false;
      }
    }
    /**
     * Returns which custom static routes are currently assigned from the given end node to the SUC.
     *
     * **Note:** This only considers routes that were assigned using {@link assignCustomSUCReturnRoutes}.
     * If another controller has assigned routes in the meantime, this information may be out of date.
     */
    getCustomSUCReturnRoutesCached(nodeId) {
      return this.driver.cacheGet(import_NetworkCache.cacheKeys.node(nodeId).customSUCReturnRoutes) ?? [];
    }
    setCustomSUCReturnRoutesCached(nodeId, routes) {
      this.driver.cacheSet(import_NetworkCache.cacheKeys.node(nodeId).customSUCReturnRoutes, routes);
    }
    /**
     * Assigns static routes from the given end node to the SUC. Unlike {@link assignSUCReturnRoutes}, this method assigns
     * the given routes instead of having the controller calculate them. At most 4 routes can be assigned. If less are
     * specified, the remaining routes are cleared.
     *
     * To mark a route as a priority route, pass it as the optional `priorityRoute` parameter. At most 3 routes of the
     * `routes` array will then be used as fallback routes.
     *
     * **Note:** Calling {@link assignSUCReturnRoutes} or {@link deleteSUCReturnRoutes} will override the custom routes.
     *
     * Returns `true` when the process was successful, or `false` if at least one step failed.
     */
    async assignCustomSUCReturnRoutes(nodeId, routes, priorityRoute) {
      if ((0, import_core.isLongRangeNodeId)(nodeId)) {
        this.driver.controllerLog.logNode(nodeId, `Cannot manage routes for nodes using Z-Wave Long Range!`, "error");
        return false;
      }
      this.driver.controllerLog.logNode(nodeId, {
        message: `Assigning custom SUC return routes...`,
        direction: "outbound"
      });
      await this.deleteSUCReturnRoutes(nodeId);
      let result = true;
      const MAX_ROUTES = 4;
      const assignedRoutes = new Array(MAX_ROUTES).fill(import_core.EMPTY_ROUTE);
      let priorityRouteIndex = -1;
      if (priorityRoute) {
        priorityRouteIndex = Math.min(MAX_ROUTES - 1, routes.length);
        routes[priorityRouteIndex] = priorityRoute;
      }
      for (let i = 0; i < MAX_ROUTES; i++) {
        const route = routes[i] ?? import_core.EMPTY_ROUTE;
        const isEmpty = (0, import_core.isEmptyRoute)(route);
        const targetWakeup = false;
        const cc = new import_cc.ZWaveProtocolCCAssignSUCReturnRoute({
          nodeId,
          // Empty routes are marked with a nodeId of 0
          destinationNodeId: isEmpty ? 0 : this.ownNodeId ?? 1,
          routeIndex: i,
          repeaters: route.repeaters,
          destinationSpeed: route.routeSpeed,
          destinationWakeUp: (0, import_cc.FLiRS2WakeUpTime)(targetWakeup ?? false)
        });
        try {
          await this.driver.sendZWaveProtocolCC(cc);
          if (i !== priorityRouteIndex)
            assignedRoutes[i] = route;
        } catch {
          this.driver.controllerLog.logNode(nodeId, {
            message: `Assigning custom SUC return route #${i} failed`,
            direction: "outbound",
            level: "warn"
          });
          result = false;
        }
      }
      if (priorityRouteIndex >= 0) {
        const cc = new import_cc.ZWaveProtocolCCAssignSUCReturnRoutePriority({
          nodeId,
          targetNodeId: this.ownNodeId ?? 1,
          routeNumber: priorityRouteIndex
        });
        try {
          await this.driver.sendZWaveProtocolCC(cc);
        } catch {
          this.driver.controllerLog.logNode(nodeId, {
            message: `Marking custom SUC return route as priority failed`,
            direction: "outbound",
            level: "warn"
          });
          result = false;
        }
      }
      while (assignedRoutes.length > 0 && (0, import_core.isEmptyRoute)(assignedRoutes.at(-1))) {
        assignedRoutes.pop();
      }
      this.setPrioritySUCReturnRouteCached(nodeId, priorityRoute);
      this.setCustomSUCReturnRoutesCached(nodeId, assignedRoutes);
      return result;
    }
    /**
     * Instructs the controller to assign static routes from the given end node to the SUC.
     * This will assign up to 4 routes, depending on the network topology (that the controller knows about).
     */
    async deleteSUCReturnRoutes(nodeId) {
      if ((0, import_core.isLongRangeNodeId)(nodeId)) {
        this.driver.controllerLog.logNode(nodeId, `Cannot manage routes for nodes using Z-Wave Long Range!`, "error");
        return false;
      }
      this.driver.controllerLog.logNode(nodeId, {
        message: `Deleting SUC return route...`,
        direction: "outbound"
      });
      try {
        const disableCallbackFunctionTypeCheck = !!this.driver.getDeviceConfig?.(this.ownNodeId)?.compat?.disableCallbackFunctionTypeCheck?.includes(import_serial.FunctionType.DeleteSUCReturnRoute);
        const result = await this.driver.sendMessage(new import_serialapi.DeleteSUCReturnRouteRequest({
          nodeId,
          disableCallbackFunctionTypeCheck
        }));
        if (!(result instanceof import_serialapi.DeleteSUCReturnRouteRequestTransmitReport)) {
          this.driver.controllerLog.logNode(nodeId, `Deleting SUC return route failed: Invalid callback received`, "error");
          return false;
        }
        const success = this.handleRouteAssignmentTransmitReport(result, nodeId);
        if (success) {
          this.setPrioritySUCReturnRouteCached(nodeId, void 0);
          this.setCustomSUCReturnRoutesCached(nodeId, void 0);
        }
        return success;
      } catch (e) {
        this.driver.controllerLog.logNode(nodeId, `Deleting SUC return route failed: ${(0, import_shared.getErrorMessage)(e)}`, "error");
        return false;
      }
    }
    /**
     * Returns which custom static routes are currently assigned between the given end nodes.
     *
     * **Note:** This only considers routes that were assigned using {@link assignCustomReturnRoutes}.
     * If another controller has assigned routes in the meantime, this information may be out of date.
     */
    getCustomReturnRoutesCached(nodeId, destinationNodeId) {
      return this.driver.cacheGet(import_NetworkCache.cacheKeys.node(nodeId).customReturnRoutes(destinationNodeId)) ?? [];
    }
    setCustomReturnRoutesCached(nodeId, destinationNodeId, routes) {
      this.driver.cacheSet(import_NetworkCache.cacheKeys.node(nodeId).customReturnRoutes(destinationNodeId), routes);
    }
    clearCustomReturnRoutesCached(nodeId) {
      for (let dest = 1; dest <= import_core.MAX_NODES; dest++) {
        this.setCustomReturnRoutesCached(nodeId, dest, void 0);
      }
    }
    /**
     * Instructs the controller to assign static routes between the two given end nodes.
     * This will assign up to 4 routes, depending on the network topology (that the controller knows about).
     */
    async assignReturnRoutes(nodeId, destinationNodeId) {
      if ((0, import_core.isLongRangeNodeId)(nodeId)) {
        this.driver.controllerLog.logNode(nodeId, `Cannot manage routes for nodes using Z-Wave Long Range!`, "error");
        return false;
      } else if ((0, import_core.isLongRangeNodeId)(destinationNodeId)) {
        this.driver.controllerLog.logNode(destinationNodeId, `Cannot manage routes for nodes using Z-Wave Long Range!`, "error");
        return false;
      }
      if (destinationNodeId === this.ownNodeId) {
        throw new import_core.ZWaveError(`To assign a return route to the SUC (node ID ${destinationNodeId}), assignSUCReturnRoutes() must be used!`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      this.driver.controllerLog.logNode(nodeId, {
        message: `Assigning return routes to node ${destinationNodeId}...`,
        direction: "outbound"
      });
      try {
        const result = await this.driver.sendMessage(new import_serialapi.AssignReturnRouteRequest({
          nodeId,
          destinationNodeId
        }));
        const success = this.handleRouteAssignmentTransmitReport(result, nodeId);
        if (success) {
          this.setCustomReturnRoutesCached(nodeId, destinationNodeId, void 0);
          if (this.hasPriorityReturnRouteCached(nodeId, destinationNodeId) !== false) {
            this.setPriorityReturnRouteCached(nodeId, destinationNodeId, import_core.UNKNOWN_STATE);
          }
        }
        return success;
      } catch (e) {
        this.driver.controllerLog.logNode(nodeId, `Assigning return routes failed: ${(0, import_shared.getErrorMessage)(e)}`, "error");
        return false;
      }
    }
    /**
     * Assigns static routes between the two given end nodes. Unlike {@link assignReturnRoutes}, this method assigns
     * the given routes instead of having the controller calculate them. At most 4 routes can be assigned. If less are
     * specified, the remaining routes are cleared.
     *
     * **Note:** Calling {@link assignReturnRoutes} or {@link deleteReturnRoutes} will override the custom routes.
     */
    async assignCustomReturnRoutes(nodeId, destinationNodeId, routes, priorityRoute) {
      if ((0, import_core.isLongRangeNodeId)(nodeId)) {
        this.driver.controllerLog.logNode(nodeId, `Cannot manage routes for nodes using Z-Wave Long Range!`, "error");
        return false;
      } else if ((0, import_core.isLongRangeNodeId)(destinationNodeId)) {
        this.driver.controllerLog.logNode(destinationNodeId, `Cannot manage routes for nodes using Z-Wave Long Range!`, "error");
        return false;
      }
      if (destinationNodeId === this.ownNodeId) {
        throw new import_core.ZWaveError(`To assign custom return routes to the SUC (node ID ${destinationNodeId}), assignCustomSUCReturnRoutes() must be used!`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      this.driver.controllerLog.logNode(nodeId, {
        message: `Assigning custom return routes to node ${destinationNodeId}...`,
        direction: "outbound"
      });
      let result = true;
      const MAX_ROUTES = 4;
      const assignedRoutes = new Array(MAX_ROUTES).fill(import_core.EMPTY_ROUTE);
      let priorityRouteIndex = -1;
      if (priorityRoute) {
        priorityRouteIndex = Math.min(MAX_ROUTES - 1, routes.length);
        routes[priorityRouteIndex] = priorityRoute;
      }
      for (let i = 0; i < MAX_ROUTES; i++) {
        const route = routes[i] ?? import_core.EMPTY_ROUTE;
        const isEmpty = (0, import_core.isEmptyRoute)(route);
        const targetWakeup = !isEmpty ? this.nodes.get(destinationNodeId)?.isFrequentListening : void 0;
        const cc = new import_cc.ZWaveProtocolCCAssignReturnRoute({
          nodeId,
          // Empty routes are marked with a nodeId of 0
          destinationNodeId: isEmpty ? 0 : destinationNodeId,
          routeIndex: i,
          repeaters: route.repeaters,
          destinationSpeed: route.routeSpeed,
          destinationWakeUp: (0, import_cc.FLiRS2WakeUpTime)(targetWakeup ?? false)
        });
        try {
          await this.driver.sendZWaveProtocolCC(cc);
          if (i !== priorityRouteIndex)
            assignedRoutes[i] = route;
        } catch {
          this.driver.controllerLog.logNode(nodeId, {
            message: `Assigning custom return route #${i} failed`,
            direction: "outbound",
            level: "warn"
          });
          result = false;
        }
      }
      if (priorityRouteIndex >= 0) {
        const cc = new import_cc.ZWaveProtocolCCAssignReturnRoutePriority({
          nodeId,
          targetNodeId: destinationNodeId,
          routeNumber: priorityRouteIndex
        });
        try {
          await this.driver.sendZWaveProtocolCC(cc);
        } catch {
          this.driver.controllerLog.logNode(nodeId, {
            message: `Marking custom return route as priority failed`,
            direction: "outbound",
            level: "warn"
          });
          result = false;
        }
      }
      while (assignedRoutes.length > 0 && (0, import_core.isEmptyRoute)(assignedRoutes.at(-1))) {
        assignedRoutes.pop();
      }
      this.setCustomReturnRoutesCached(nodeId, destinationNodeId, assignedRoutes);
      if (priorityRoute) {
        this.setPriorityReturnRouteCached(nodeId, destinationNodeId, priorityRoute);
      } else if (this.hasPriorityReturnRouteCached(nodeId, destinationNodeId) !== false) {
        this.setPriorityReturnRouteCached(nodeId, destinationNodeId, import_core.UNKNOWN_STATE);
      }
      return result;
    }
    /**
     * Instructs the controller to delete all static routes between the given node and all
     * other end nodes, including the priority return routes.
     */
    async deleteReturnRoutes(nodeId) {
      if ((0, import_core.isLongRangeNodeId)(nodeId)) {
        this.driver.controllerLog.logNode(nodeId, `Cannot manage routes for nodes using Z-Wave Long Range!`, "error");
        return false;
      }
      this.driver.controllerLog.logNode(nodeId, {
        message: `Deleting all return routes...`,
        direction: "outbound"
      });
      try {
        const result = await this.driver.sendMessage(new import_serialapi.DeleteReturnRouteRequest({
          nodeId
        }));
        const success = this.handleRouteAssignmentTransmitReport(result, nodeId);
        if (success) {
          this.clearPriorityReturnRoutesCached(nodeId);
          this.clearCustomReturnRoutesCached(nodeId);
        }
        return success;
      } catch (e) {
        this.driver.controllerLog.logNode(nodeId, `Deleting return routes failed: ${(0, import_shared.getErrorMessage)(e)}`, "error");
        return false;
      }
    }
    /**
     * Assigns a priority route between two end nodes. This route will always be used for the first transmission attempt.
     * @param nodeId The ID of the source node of the route
     * @param destinationNodeId The ID of the destination node of the route
     * @param repeaters The IDs of the nodes that should be used as repeaters, or an empty array for direct connection
     * @param routeSpeed The transmission speed to use for the route
     */
    async assignPriorityReturnRoute(nodeId, destinationNodeId, repeaters, routeSpeed) {
      if (destinationNodeId === this.ownNodeId) {
        throw new import_core.ZWaveError(`To assign a priority return route to the SUC (node ID ${destinationNodeId}), assignPrioritySUCReturnRoute() must be used!`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      this.driver.controllerLog.logNode(nodeId, {
        message: `Assigning priority return route to node ${destinationNodeId}...`,
        direction: "outbound"
      });
      try {
        const result = await this.driver.sendMessage(new import_serialapi.AssignPriorityReturnRouteRequest({
          nodeId,
          destinationNodeId,
          repeaters,
          routeSpeed
        }));
        const success = this.handleRouteAssignmentTransmitReport(result, nodeId);
        if (success) {
          this.setPriorityReturnRouteCached(nodeId, destinationNodeId, {
            repeaters,
            routeSpeed
          });
        }
        return success;
      } catch (e) {
        this.driver.controllerLog.logNode(nodeId, `Assigning priority return route failed: ${(0, import_shared.getErrorMessage)(e)}`, "error");
        return false;
      }
    }
    hasPriorityReturnRouteCached(nodeId, destinationNodeId) {
      const ret = this.driver.cacheGet(import_NetworkCache.cacheKeys.node(nodeId).priorityReturnRoute(destinationNodeId));
      if (ret === import_core.UNKNOWN_STATE)
        return import_core.UNKNOWN_STATE;
      return ret !== void 0;
    }
    setPriorityReturnRouteCached(nodeId, destinationNodeId, route) {
      this.driver.cacheSet(import_NetworkCache.cacheKeys.node(nodeId).priorityReturnRoute(destinationNodeId), route);
    }
    clearPriorityReturnRoutesCached(nodeId) {
      for (let dest = 1; dest <= import_core.MAX_NODES; dest++) {
        this.setPriorityReturnRouteCached(nodeId, dest, void 0);
      }
    }
    /**
     * Returns which priority route is currently assigned between the given end nodes.
     *
     * **Note:** This is using cached information, since there's no way to query priority routes from a node.
     * If another controller has assigned routes in the meantime, this information may be out of date.
     */
    getPriorityReturnRouteCached(nodeId, destinationNodeId) {
      return this.driver.cacheGet(import_NetworkCache.cacheKeys.node(nodeId).priorityReturnRoute(destinationNodeId));
    }
    /**
     * For the given node, returns all end node destinations and the priority routes to them.
     *
     * **Note:** This is using cached information, since there's no way to query priority routes from a node.
     * If another controller has assigned routes in the meantime, this information may be out of date.
     */
    getPriorityReturnRoutesCached(nodeId) {
      const ret = {};
      const routes = this.driver.cacheList(import_NetworkCache.cacheKeys.node(nodeId)._priorityReturnRouteBaseKey);
      for (const [key, route] of Object.entries(routes)) {
        const destination = import_NetworkCache.cacheKeyUtils.destinationFromPriorityReturnRouteKey(key);
        if (destination !== void 0)
          ret[destination] = route;
      }
      return ret;
    }
    /**
     * Assigns a priority route from an end node to the SUC. This route will always be used for the first transmission attempt.
     * @param nodeId The ID of the end node for which to assign the route
     * @param repeaters The IDs of the nodes that should be used as repeaters, or an empty array for direct connection
     * @param routeSpeed The transmission speed to use for the route
     */
    async assignPrioritySUCReturnRoute(nodeId, repeaters, routeSpeed) {
      this.driver.controllerLog.logNode(nodeId, {
        message: `Assigning priority SUC return route...`,
        direction: "outbound"
      });
      try {
        const result = await this.driver.sendMessage(new import_serialapi.AssignPrioritySUCReturnRouteRequest({
          nodeId,
          repeaters,
          routeSpeed
        }));
        const success = this.handleRouteAssignmentTransmitReport(result, nodeId);
        if (success) {
          this.setPrioritySUCReturnRouteCached(nodeId, {
            repeaters,
            routeSpeed
          });
          this.setCustomSUCReturnRoutesCached(nodeId, void 0);
        }
        return success;
      } catch (e) {
        this.driver.controllerLog.logNode(nodeId, `Assigning priority SUC return route failed: ${(0, import_shared.getErrorMessage)(e)}`, "error");
        return false;
      }
    }
    setPrioritySUCReturnRouteCached(nodeId, route) {
      this.driver.cacheSet(import_NetworkCache.cacheKeys.node(nodeId).prioritySUCReturnRoute, route);
    }
    /**
     * Returns which priority route is currently assigned from the given end node to the SUC.
     *
     * **Note:** This is using cached information, since there's no way to query priority routes from a node.
     * If another controller has assigned routes in the meantime, this information may be out of date.
     */
    getPrioritySUCReturnRouteCached(nodeId) {
      return this.driver.cacheGet(import_NetworkCache.cacheKeys.node(nodeId).prioritySUCReturnRoute);
    }
    handleRouteAssignmentTransmitReport(msg, nodeId) {
      switch (msg.transmitStatus) {
        case import_core.TransmitStatus.OK:
          return true;
        case import_core.TransmitStatus.NoAck:
          return false;
        case import_core.TransmitStatus.NoRoute:
          this.driver.controllerLog.logNode(nodeId, `Route resolution failed`, "warn");
          return false;
        default:
          return false;
      }
    }
    /**
     * Sets the priority route which will always be used for the first transmission attempt from the controller to the given node.
     * @param destinationNodeId The ID of the node that should be reached via the priority route
     * @param repeaters The IDs of the nodes that should be used as repeaters, or an empty array for direct connection
     * @param routeSpeed The transmission speed to use for the route
     */
    async setPriorityRoute(destinationNodeId, repeaters, routeSpeed) {
      await this.trySetNodeIDType(import_core.NodeIDType.Short);
      this.driver.controllerLog.print(`Setting priority route to node ${destinationNodeId}...`);
      let ret;
      try {
        const result = await this.driver.sendMessage(new import_serialapi.SetPriorityRouteRequest({
          destinationNodeId,
          repeaters,
          routeSpeed
        }));
        ret = result.isOK();
      } catch (e) {
        this.driver.controllerLog.print(`Setting priority route failed: ${(0, import_shared.getErrorMessage)(e)}`, "error");
        ret = false;
      }
      await this.trySetNodeIDType(import_core.NodeIDType.Long);
      return ret;
    }
    /**
     * Removes the priority route used for the first transmission attempt from the controller to the given node.
     * @param destinationNodeId The ID of the node that should be reached via the priority route
     */
    async removePriorityRoute(destinationNodeId) {
      this.driver.controllerLog.print(`Removing priority route to node ${destinationNodeId}...`);
      try {
        const result = await this.driver.sendMessage(new import_serialapi.SetPriorityRouteRequest({
          destinationNodeId
          // no repeaters = remove
        }));
        return result.isOK();
      } catch (e) {
        this.driver.controllerLog.print(`Removing priority route failed: ${(0, import_shared.getErrorMessage)(e)}`, "error");
        return false;
      }
    }
    /**
     * Returns the priority route which is currently set for a node.
     * If none is set, either the LWR or the NLWR is returned.
     * If no route is known yet, this returns `undefined`.
     *
     * @param destinationNodeId The ID of the node for which the priority route should be returned
     */
    async getPriorityRoute(destinationNodeId) {
      this.driver.controllerLog.print(`Retrieving priority route to node ${destinationNodeId}...`);
      try {
        const result = await this.driver.sendMessage(new import_serialapi.GetPriorityRouteRequest({
          destinationNodeId
        }));
        if (result.routeKind === import_core.RouteKind.None)
          return void 0;
        const node = this.nodes.get(destinationNodeId);
        if (node && (result.routeKind === import_core.RouteKind.LWR || result.routeKind === import_core.RouteKind.NLWR)) {
          const routeName = result.routeKind === import_core.RouteKind.LWR ? "lwr" : "nlwr";
          if (!node.statistics[routeName]) {
            node.updateStatistics((current) => {
              const ret = { ...current };
              ret[routeName] = {
                repeaters: result.repeaters,
                protocolDataRate: (
                  // ZWaveDataRate is a subset of ProtocolDataRate
                  result.routeSpeed
                )
              };
              return ret;
            });
          }
        }
        return {
          routeKind: result.routeKind,
          repeaters: result.repeaters,
          routeSpeed: result.routeSpeed
        };
      } catch (e) {
        this.driver.controllerLog.print(`Retrieving priority route failed: ${(0, import_shared.getErrorMessage)(e)}`, "error");
      }
    }
    /**
     * Returns a dictionary of all association groups of this node or endpoint and their information.
     * If no endpoint is given, the associations of the root device (endpoint 0) are returned.
     * This only works AFTER the interview process
     */
    getAssociationGroups(source) {
      const node = this.nodes.getOrThrow(source.nodeId);
      const endpoint = node.getEndpointOrThrow(source.endpoint ?? 0);
      return import_cc.utils.getAssociationGroups(this.driver, endpoint);
    }
    /**
     * Returns all association groups that exist on a node and all its endpoints.
     * The returned map uses the endpoint index as keys and its values are maps of group IDs to their definition
     */
    getAllAssociationGroups(nodeId) {
      const node = this.nodes.getOrThrow(nodeId);
      return import_cc.utils.getAllAssociationGroups(this.driver, node);
    }
    /**
     * Returns all associations (Multi Channel or normal) that are configured on the root device or an endpoint of a node.
     * If no endpoint is given, the associations of the root device (endpoint 0) are returned.
     */
    getAssociations(source) {
      const node = this.nodes.getOrThrow(source.nodeId);
      const endpoint = node.getEndpointOrThrow(source.endpoint ?? 0);
      return import_cc.utils.getAssociations(this.driver, endpoint);
    }
    /**
     * Returns all associations (Multi Channel or normal) that are configured on a node and all its endpoints.
     * The returned map uses the source node+endpoint as keys and its values are a map of association group IDs to target node+endpoint.
     */
    getAllAssociations(nodeId) {
      const node = this.nodes.getOrThrow(nodeId);
      return import_cc.utils.getAllAssociations(this.driver, node);
    }
    /**
     * Checks if a given association is allowed.
     */
    checkAssociation(source, group, destination) {
      const node = this.nodes.getOrThrow(source.nodeId);
      const endpoint = node.getEndpointOrThrow(source.endpoint ?? 0);
      return import_cc.utils.checkAssociation(this.driver, endpoint, group, destination);
    }
    /**
     * Adds associations to a node or endpoint.
     *
     * **Note:** This method will throw if:
     * * the source node, endpoint or association group does not exist,
     * * the source node is a ZWLR node and the destination is not the SIS
     * * the destination node is a ZWLR node
     * * the association is not allowed for other reasons. In this case, the error's
     * `context` property will contain an array with all forbidden destinations, each with an added `checkResult` property
     * which contains the reason why the association is forbidden:
     *     ```ts
     *     {
     *         checkResult: AssociationCheckResult;
     *         nodeId: number;
     *         endpoint?: number | undefined;
     *     }[]
     *     ```
     */
    async addAssociations(source, group, destinations) {
      const node = this.nodes.getOrThrow(source.nodeId);
      const endpoint = node.getEndpointOrThrow(source.endpoint ?? 0);
      await import_cc.utils.addAssociations(this.driver, endpoint, group, destinations);
      if ((0, import_core.isLongRangeNodeId)(source.nodeId))
        return;
      const destinationNodeIDs = (0, import_arrays.distinct)(destinations.map((d) => d.nodeId)).filter((id) => id !== this.ownNodeId);
      for (const id of destinationNodeIDs) {
        if (id === this._ownNodeId) {
          await this.assignSUCReturnRoutes(source.nodeId);
        } else {
          await this.assignReturnRoutes(source.nodeId, id);
        }
      }
    }
    /**
     * Removes the given associations from a node or endpoint
     */
    removeAssociations(source, group, destinations) {
      const node = this.nodes.getOrThrow(source.nodeId);
      const endpoint = node.getEndpointOrThrow(source.endpoint ?? 0);
      return import_cc.utils.removeAssociations(this.driver, endpoint, group, destinations);
    }
    /**
     * Removes a node from all other nodes' associations
     * WARNING: It is not recommended to await this method
     */
    async removeNodeFromAllAssociations(nodeId) {
      const tasks = [];
      for (const node of this.nodes.values()) {
        if (node.id === this._ownNodeId || node.id === nodeId)
          continue;
        if (node.interviewStage !== import_Types.InterviewStage.Complete)
          continue;
        for (const endpoint of node.getAllEndpoints()) {
          if (endpoint.commandClasses["Multi Channel Association"].isSupported()) {
            const existing = import_cc.MultiChannelAssociationCC.getAllDestinationsCached(this.driver, endpoint);
            if ([...existing.values()].some((dests) => dests.some((a) => a.nodeId === nodeId))) {
              tasks.push(endpoint.commandClasses["Multi Channel Association"].removeDestinations({
                nodeIds: [nodeId]
              }));
            }
          } else if (endpoint.commandClasses.Association.isSupported()) {
            const existing = import_cc.AssociationCC.getAllDestinationsCached(this.driver, endpoint);
            if ([...existing.values()].some((dests) => dests.some((a) => a.nodeId === nodeId))) {
              tasks.push(endpoint.commandClasses.Association.removeNodeIdsFromAllGroups([nodeId]));
            }
          }
        }
      }
      await Promise.all(tasks);
    }
    /**
     * Tests if a node is marked as failed in the controller's memory
     * @param nodeId The id of the node in question
     */
    async isFailedNode(nodeId) {
      const result = await this.driver.sendMessage(new import_serialapi.IsFailedNodeRequest({ failedNodeId: nodeId }));
      return result.result;
    }
    /**
     * Removes a failed node from the controller's memory. If the process fails, this will throw an exception with the details why.
     * @param nodeId The id of the node to remove
     */
    async removeFailedNode(nodeId) {
      await this.removeFailedNodeInternal(nodeId, import_Inclusion.RemoveNodeReason.RemoveFailed);
    }
    /** @internal */
    async removeFailedNodeInternal(nodeId, reason) {
      const node = this.nodes.getOrThrow(nodeId);
      const task = this.getRemoveFailedNodeTask(node, reason);
      if (task instanceof Promise)
        return task;
      if (reason === import_Inclusion.RemoveNodeReason.SmartStartFailed) {
        delete task.group;
      }
      return this.driver.scheduler.queueTask(task);
    }
    getRemoveFailedNodeTask(node, reason) {
      const existingTask = this.driver.scheduler.findTask((t) => t.tag?.id === "remove-failed-node" && t.tag.nodeId === node.id);
      if (existingTask)
        return existingTask;
      const self = this;
      return {
        // The priority must be high, so it can be nested in the inclusion task when necessary
        priority: import_Task.TaskPriority.High,
        tag: { id: "remove-failed-node", nodeId: node.id },
        group: {
          id: "inclusion-exclusion"
        },
        task: /* @__PURE__ */ __name(async function* removeFailedNodeTask() {
          yield* (0, import_waddle.waitFor)(self.pauseSmartStart());
          self.setInclusionState(import_Inclusion.InclusionState.Busy);
          let didFail = false;
          const MAX_ATTEMPTS = 3;
          for (let attempt = 1; attempt <= MAX_ATTEMPTS; attempt++) {
            const pingResult = yield* (0, import_waddle.waitFor)(node.ping());
            if (pingResult) {
              if (attempt < MAX_ATTEMPTS)
                yield* (0, import_waddle.waitFor)((0, import_async.wait)(2e3));
              continue;
            }
            didFail = true;
            break;
          }
          if (!didFail) {
            throw new import_core.ZWaveError(`The node removal process could not be started because the node responded to a ping.`, import_core.ZWaveErrorCodes.RemoveFailedNode_Failed);
          }
          const result = await self.driver.sendMessage(new import_serialapi.RemoveFailedNodeRequest({
            failedNodeId: node.id
          }));
          if (result instanceof import_serialapi.RemoveFailedNodeResponse) {
            let message = `The node removal process could not be started due to the following reasons:`;
            if (!!(result.removeStatus & import_serialapi.RemoveFailedNodeStartFlags.NotPrimaryController)) {
              message += "\n\xB7 This controller is not the primary controller";
            }
            if (!!(result.removeStatus & import_serialapi.RemoveFailedNodeStartFlags.NodeNotFound)) {
              message += `
\xB7 Node ${node.id} is not in the list of failed nodes`;
            }
            if (!!(result.removeStatus & import_serialapi.RemoveFailedNodeStartFlags.RemoveProcessBusy)) {
              message += `
\xB7 The node removal process is currently busy`;
            }
            if (!!(result.removeStatus & import_serialapi.RemoveFailedNodeStartFlags.RemoveFailed)) {
              message += `
\xB7 The controller is busy or the node has responded`;
            }
            throw new import_core.ZWaveError(message, import_core.ZWaveErrorCodes.RemoveFailedNode_Failed);
          } else {
            switch (result.removeStatus) {
              case import_serialapi.RemoveFailedNodeStatus.NodeOK:
                throw new import_core.ZWaveError(`The node could not be removed because it has responded`, import_core.ZWaveErrorCodes.RemoveFailedNode_NodeOK);
              case import_serialapi.RemoveFailedNodeStatus.NodeNotRemoved:
                throw new import_core.ZWaveError(`The removal process could not be completed`, import_core.ZWaveErrorCodes.RemoveFailedNode_Failed);
              default:
                self.emit("node removed", node, reason);
                self._nodes.delete(node.id);
                return;
            }
          }
        }, "removeFailedNodeTask"),
        // eslint-disable-next-line @typescript-eslint/require-await
        cleanup: /* @__PURE__ */ __name(async () => {
          if (reason !== import_Inclusion.RemoveNodeReason.SmartStartFailed) {
            this.setInclusionState(import_Inclusion.InclusionState.Idle);
          }
        }, "cleanup")
      };
    }
    /**
     * Replace a failed node from the controller's memory. If the process fails, this will throw an exception with the details why.
     * @param nodeId The id of the node to replace
     * @param options Defines the inclusion strategy to use for the replacement node
     */
    async replaceFailedNode(nodeId, options = {
      strategy: import_Inclusion.InclusionStrategy.Insecure
    }) {
      if (this._inclusionState === import_Inclusion.InclusionState.Including || this._inclusionState === import_Inclusion.InclusionState.Excluding || this._inclusionState === import_Inclusion.InclusionState.Busy) {
        return false;
      }
      const node = this._nodes.getOrThrow(nodeId);
      const startedPromise = (0, import_deferred_promise.createDeferredPromise)();
      void this.driver.scheduler.queueTask(this.getReplaceFailedNodeTask(startedPromise, node, options)).catch(import_shared.noop);
      await startedPromise;
      return true;
    }
    /**
     * Returns the task to handle the complete exclusion process
     */
    getReplaceFailedNodeTask(startedPromise, node, options) {
      const self = this;
      const abortWaiting = new AbortController();
      return {
        priority: import_Task.TaskPriority.Normal,
        tag: { id: "replace-failed-node", nodeId: node.id },
        group: { id: "inclusion-exclusion" },
        task: /* @__PURE__ */ __name(async function* () {
          yield* self.replaceFailedNodeTask(startedPromise, node, options, abortWaiting.signal);
        }, "task"),
        // eslint-disable-next-line @typescript-eslint/require-await
        async cleanup() {
          abortWaiting.abort();
        }
      };
    }
    async *replaceFailedNodeTask(startedPromise, node, options, abortWaiting) {
      const self = this;
      yield* (0, import_waddle.waitFor)(self.pauseSmartStart());
      self.setInclusionState(import_Inclusion.InclusionState.Busy);
      self.driver.controllerLog.print(`starting replace failed node process...`);
      if (await node.ping()) {
        self.setInclusionState(import_Inclusion.InclusionState.Idle);
        startedPromise.reject(new import_core.ZWaveError(`The node replace process could not be started because the node responded to a ping.`, import_core.ZWaveErrorCodes.ReplaceFailedNode_Failed));
        return;
      }
      const startResult = yield* (0, import_waddle.waitFor)(self.driver.sendMessage(new import_serialapi.ReplaceFailedNodeRequest({
        failedNodeId: node.id
      })));
      if (!startResult.isOK()) {
        let message = `The node replace process could not be started due to the following reasons:`;
        if (!!(startResult.replaceStatus & import_serialapi.ReplaceFailedNodeStartFlags.NotPrimaryController)) {
          message += "\n\xB7 This controller is not the primary controller";
        }
        if (!!(startResult.replaceStatus & import_serialapi.ReplaceFailedNodeStartFlags.NodeNotFound)) {
          message += `
\xB7 Node ${node.id} is not in the list of failed nodes`;
        }
        if (!!(startResult.replaceStatus & import_serialapi.ReplaceFailedNodeStartFlags.ReplaceProcessBusy)) {
          message += `
\xB7 The node replace process is currently busy`;
        }
        if (!!(startResult.replaceStatus & import_serialapi.ReplaceFailedNodeStartFlags.ReplaceFailed)) {
          message += `
\xB7 The controller is busy or the node has responded`;
        }
        self.setInclusionState(import_Inclusion.InclusionState.Idle);
        startedPromise.reject(new import_core.ZWaveError(message, import_core.ZWaveErrorCodes.ReplaceFailedNode_Failed));
        return;
      }
      async function* awaitStatusReport() {
        const msg = yield* (0, import_waddle.waitFor)(self.driver.waitForMessage(
          (msg2) => msg2 instanceof import_serialapi.ReplaceFailedNodeRequestStatusReport,
          void 0,
          // Wait indefinitely
          void 0,
          abortWaiting
        ));
        if (msg.replaceStatus === import_serialapi.ReplaceFailedNodeStatus.NodeOK) {
          startedPromise.reject(new import_core.ZWaveError(`The node could not be replaced because it has responded`, import_core.ZWaveErrorCodes.ReplaceFailedNode_NodeOK));
          self.setInclusionState(import_Inclusion.InclusionState.Idle);
          self.emit("inclusion failed");
          return;
        }
        if (msg.replaceStatus === import_serialapi.ReplaceFailedNodeStatus.FailedNodeReplaceFailed) {
          startedPromise.reject(new import_core.ZWaveError(`The failed node has not been replaced`, import_core.ZWaveErrorCodes.ReplaceFailedNode_Failed));
          self.setInclusionState(import_Inclusion.InclusionState.Idle);
          self.emit("inclusion failed");
          return;
        }
        return msg;
      }
      __name(awaitStatusReport, "awaitStatusReport");
      {
        const msg = yield* awaitStatusReport();
        if (!msg)
          return;
        if (msg.replaceStatus !== import_serialapi.ReplaceFailedNodeStatus.FailedNodeReplace) {
          return;
        }
        self.driver.controllerLog.print(`The failed node is ready to be replaced, inclusion started...`);
        self.emit("inclusion started", options.strategy);
        self.setInclusionState(import_Inclusion.InclusionState.Including);
        startedPromise.resolve();
      }
      {
        const msg = yield* awaitStatusReport();
        if (!msg)
          return;
        if (msg.replaceStatus !== import_serialapi.ReplaceFailedNodeStatus.FailedNodeReplaceDone) {
          return;
        }
      }
      self.driver.controllerLog.print(`The failed node was replaced`);
      self.emit("inclusion stopped");
      this.emit("node removed", node, import_Inclusion.RemoveNodeReason.Replaced);
      this._nodes.delete(node.id);
      this.setInclusionState(import_Inclusion.InclusionState.Busy);
      const newNode = new import_Node.ZWaveNode(
        node.id,
        this.driver,
        void 0,
        void 0,
        void 0,
        // Create an empty value DB and specify that it contains no values
        // to avoid indexing the existing values
        this.createValueDBForNode(node.id, /* @__PURE__ */ new Set())
      );
      this._nodes.set(newNode.id, newNode);
      this.emit("node found", {
        id: newNode.id
      });
      newNode.markAsAlive();
      if (newNode.protocol == import_core.Protocols.ZWave) {
        newNode.hasSUCReturnRoute = await this.assignSUCReturnRoutes(newNode.id);
      }
      const strategy = options.strategy;
      let bootstrapFailure;
      if (strategy === import_Inclusion.InclusionStrategy.Security_S2) {
        bootstrapFailure = await this.secureBootstrapS2(newNode, options, true);
        if (bootstrapFailure == void 0) {
          const actualSecurityClass = newNode.getHighestSecurityClass();
          if (actualSecurityClass == void 0 || actualSecurityClass < import_core.SecurityClass.S2_Unauthenticated) {
            bootstrapFailure = import_Inclusion.SecurityBootstrapFailure.Unknown;
          }
        }
      } else if (strategy === import_Inclusion.InclusionStrategy.Security_S0) {
        bootstrapFailure = await this.secureBootstrapS0(
          newNode,
          // When replacing a node, we don't receive NIF, so we have to make
          // some assumptions, just like we do for Security S2 above.
          // We don't know if the node is a controller, so just assume it is not.
          false,
          // Also we must assume that the node supports S0, because we
          // don't know any better at this point.
          true
        );
        if (bootstrapFailure == void 0) {
          const actualSecurityClass = newNode.getHighestSecurityClass();
          if (actualSecurityClass == void 0 || actualSecurityClass < import_core.SecurityClass.S0_Legacy) {
            bootstrapFailure = import_Inclusion.SecurityBootstrapFailure.Unknown;
          }
        }
      } else {
        for (const secClass of import_core.securityClassOrder) {
          newNode.securityClasses.set(secClass, false);
        }
      }
      const inclusionResult = bootstrapFailure != void 0 ? {
        lowSecurity: true,
        lowSecurityReason: bootstrapFailure
      } : { lowSecurity: false };
      this.setInclusionState(import_Inclusion.InclusionState.Idle);
      this.emit("node added", newNode, inclusionResult);
    }
    /** Configure the RF region at the Z-Wave API Module */
    async setRFRegion(region) {
      if (region === import_core.RFRegion["Default (EU)"])
        region = import_core.RFRegion.Europe;
      if (this.driver.options.rf?.preferLRRegion !== false) {
        region = this.tryGetLRCapableRegion(region);
      }
      const prevRegion = this.rfRegion ?? import_core.RFRegion.Unknown;
      const result = await this.setRFRegionInternal(region, true);
      const isRegionActuallyDifferent = this.tryGetLRCapableRegion(prevRegion) !== this.tryGetLRCapableRegion(region);
      if (result && isRegionActuallyDifferent) {
        await this.applyLegalPowerlevelLimits(region, this.driver.options.rf?.txPower?.powerlevel === "auto", this.driver.options.rf?.maxLongRangePowerlevel === "auto");
      }
      return result;
    }
    /** Configure the RF region at the Z-Wave API Module */
    async setRFRegionInternal(region, softReset = true) {
      const result = await this.driver.sendMessage(new import_serialapi.SerialAPISetup_SetRFRegionRequest({ region }));
      if (result instanceof import_serialapi.SerialAPISetup_CommandUnsupportedResponse) {
        throw new import_core.ZWaveError(`Your hardware does not support setting the RF region!`, import_core.ZWaveErrorCodes.Driver_NotSupported);
      }
      if (softReset && result.success)
        await this.driver.trySoftReset();
      this._rfRegion = region;
      return result.success;
    }
    /** Request the current RF region configured at the Z-Wave API Module */
    async getRFRegion() {
      const result = await this.driver.sendMessage(new import_serialapi.SerialAPISetup_GetRFRegionRequest());
      if (result instanceof import_serialapi.SerialAPISetup_CommandUnsupportedResponse) {
        throw new import_core.ZWaveError(`Your hardware does not support getting the RF region!`, import_core.ZWaveErrorCodes.Driver_NotSupported);
      }
      this._rfRegion = result.region;
      return result.region;
    }
    /**
     * Query the supported regions of the Z-Wave API Module
     *
     * **Note:** Applications should prefer using {@link getSupportedRFRegions} instead
     */
    async querySupportedRFRegions() {
      const result = await this.driver.sendMessage(new import_serialapi.SerialAPISetup_GetSupportedRegionsRequest());
      if (result instanceof import_serialapi.SerialAPISetup_CommandUnsupportedResponse) {
        throw new import_core.ZWaveError(`Your hardware does not support getting the supported RF regions!`, import_core.ZWaveErrorCodes.Driver_NotSupported);
      }
      return result.supportedRegions;
    }
    /**
     * Query the supported regions of the Z-Wave API Module
     *
     * **Note:** Applications should prefer reading the cached value from {@link supportedRFRegions} instead
     */
    async queryRFRegionInfo(region) {
      const result = await this.driver.sendMessage(new import_serialapi.SerialAPISetup_GetRegionInfoRequest({ region }));
      if (result instanceof import_serialapi.SerialAPISetup_CommandUnsupportedResponse) {
        throw new import_core.ZWaveError(`Your hardware does not support getting the RF region info!`, import_core.ZWaveErrorCodes.Driver_NotSupported);
      }
      return (0, import_shared.pick)(result, [
        "region",
        "supportsZWave",
        "supportsLongRange",
        "includesRegion"
      ]);
    }
    /**
     * Returns the RF regions supported by this controller, or `undefined` if the information is not known yet.
     *
     * @param filterSubsets Whether to exclude regions that are subsets of other regions,
     * for example `USA` which is a subset of `USA (Long Range)`
     */
    getSupportedRFRegions(filterSubsets = true) {
      if (this.isSerialAPISetupCommandSupported(import_serialapi.SerialAPISetupCommand.GetSupportedRegions)) {
        if (this._supportedRegions == import_core.NOT_KNOWN)
          return import_core.NOT_KNOWN;
        const allRegions = new Set(this._supportedRegions.keys());
        if (filterSubsets) {
          for (const region of this._supportedRegions.values()) {
            if (region.includesRegion != void 0) {
              allRegions.delete(region.includesRegion);
            }
          }
        }
        return [...allRegions].sort((a, b) => a - b);
      }
      const ret = /* @__PURE__ */ new Set([
        // Always supported
        import_core.RFRegion.Europe,
        import_core.RFRegion.USA,
        import_core.RFRegion["Australia/New Zealand"],
        import_core.RFRegion["Hong Kong"],
        import_core.RFRegion.India,
        import_core.RFRegion.Israel,
        import_core.RFRegion.Russia,
        import_core.RFRegion.China,
        import_core.RFRegion.Japan,
        import_core.RFRegion.Korea,
        import_core.RFRegion["Default (EU)"]
      ]);
      if (this.isLongRangeCapable()) {
        ret.add(import_core.RFRegion["USA (Long Range)"]);
        if (filterSubsets)
          ret.delete(import_core.RFRegion.USA);
      }
      if (this.isEULongRangeCapable()) {
        ret.add(import_core.RFRegion["Europe (Long Range)"]);
        if (filterSubsets)
          ret.delete(import_core.RFRegion.Europe);
      }
      return [...ret].sort((a, b) => a - b);
    }
    async applyLegalPowerlevelLimits(region, mesh, longRange) {
      if (!mesh && !longRange) {
        return;
      }
      const desiredTXPowerlevelMesh = (0, import_core.getLegalPowerlevelMesh)(region);
      if (mesh && desiredTXPowerlevelMesh !== void 0) {
        this.driver.controllerLog.print("Applying legal TX powerlevel for Z-Wave Classic");
        await this.applyDesiredPowerlevelMesh(desiredTXPowerlevelMesh);
      }
      const desiredTXPowerlevelLR = (0, import_core.getLegalPowerlevelLR)(region);
      if (longRange && desiredTXPowerlevelLR !== void 0) {
        this.driver.controllerLog.print("Applying legal TX powerlevel for Z-Wave Long Range");
        await this.applyDesiredPowerlevelLR(desiredTXPowerlevelLR);
      }
    }
    /** Configure the Powerlevel setting of the Z-Wave API */
    async setPowerlevel(powerlevel, measured0dBm) {
      let request;
      if (this.supportedSerialAPISetupCommands?.includes(import_serialapi.SerialAPISetupCommand.SetPowerlevel16Bit)) {
        request = new import_serialapi.SerialAPISetup_SetPowerlevel16BitRequest({
          powerlevel,
          measured0dBm
        });
      } else {
        request = new import_serialapi.SerialAPISetup_SetPowerlevelRequest({
          powerlevel,
          measured0dBm
        });
      }
      const result = await this.driver.sendMessage(request);
      if (result instanceof import_serialapi.SerialAPISetup_CommandUnsupportedResponse) {
        throw new import_core.ZWaveError(`Your hardware does not support setting the powerlevel!`, import_core.ZWaveErrorCodes.Driver_NotSupported);
      }
      if (result.success) {
        this._txPower = powerlevel;
        this._powerlevelCalibration = measured0dBm;
      }
      return result.success;
    }
    /** Request the Powerlevel setting of the Z-Wave API */
    async getPowerlevel() {
      let request;
      if (this.supportedSerialAPISetupCommands?.includes(import_serialapi.SerialAPISetupCommand.GetPowerlevel16Bit)) {
        request = new import_serialapi.SerialAPISetup_GetPowerlevel16BitRequest();
      } else {
        request = new import_serialapi.SerialAPISetup_GetPowerlevelRequest();
      }
      const result = await this.driver.sendMessage(request);
      if (result instanceof import_serialapi.SerialAPISetup_CommandUnsupportedResponse) {
        throw new import_core.ZWaveError(`Your hardware does not support getting the powerlevel!`, import_core.ZWaveErrorCodes.Driver_NotSupported);
      }
      this._txPower = result.powerlevel;
      this._powerlevelCalibration = result.measured0dBm;
      return (0, import_shared.pick)(result, ["powerlevel", "measured0dBm"]);
    }
    /** Configure the maximum TX powerlevel for Z-Wave Long Range */
    async setMaxLongRangePowerlevel(limit) {
      const request = new import_serialapi.SerialAPISetup_SetLongRangeMaximumTxPowerRequest({
        limit
      });
      const result = await this.driver.sendMessage(request);
      if (result instanceof import_serialapi.SerialAPISetup_CommandUnsupportedResponse) {
        throw new import_core.ZWaveError(`Your hardware does not support setting the max. Long Range powerlevel!`, import_core.ZWaveErrorCodes.Driver_NotSupported);
      }
      if (result.success) {
        this._maxLongRangePowerlevel = limit;
      }
      return result.success;
    }
    /** Request the maximum TX powerlevel setting for Z-Wave Long Range */
    async getMaxLongRangePowerlevel() {
      const request = new import_serialapi.SerialAPISetup_GetLongRangeMaximumTxPowerRequest();
      const result = await this.driver.sendMessage(request);
      if (result instanceof import_serialapi.SerialAPISetup_CommandUnsupportedResponse) {
        throw new import_core.ZWaveError(`Your hardware does not support getting the max. Long Range powerlevel!`, import_core.ZWaveErrorCodes.Driver_NotSupported);
      }
      this._maxLongRangePowerlevel = result.limit;
      return result.limit;
    }
    async applyDesiredPowerlevelMesh(powerlevel) {
      if (!this.isSerialAPISetupCommandSupported(import_serialapi.SerialAPISetupCommand.SetPowerlevel) || this._txPower == void 0 || this._powerlevelCalibration == void 0) {
        return;
      }
      const desired = {
        powerlevel,
        measured0dBm: this.driver.options.rf?.txPower?.measured0dBm
      };
      const current = {
        powerlevel: this._txPower,
        measured0dBm: this._powerlevelCalibration
      };
      if (current.powerlevel !== desired.powerlevel || desired.measured0dBm != void 0 && current.measured0dBm !== desired.measured0dBm) {
        this.driver.controllerLog.print(`Current powerlevel ${current.powerlevel} dBm (${current.measured0dBm} dBm) differs from desired powerlevel ${desired.powerlevel} dBm (${desired.measured0dBm ?? current.measured0dBm} dBm), configuring it...`);
        const resp = await this.setPowerlevel(desired.powerlevel, desired.measured0dBm ?? current.measured0dBm).catch((e) => e.message);
        if (resp === true) {
          this.driver.controllerLog.print(`Powerlevel updated`);
        } else {
          this.driver.controllerLog.print(`Changing the powerlevel failed!${resp ? ` Reason: ${resp}` : ""}`, "warn");
        }
      }
    }
    async applyDesiredPowerlevelLR(powerlevel) {
      if (!this.isSerialAPISetupCommandSupported(import_serialapi.SerialAPISetupCommand.SetLongRangeMaximumTxPower)) {
        return;
      }
      if (this.maxLongRangePowerlevel === powerlevel) {
        return;
      }
      this.driver.controllerLog.print(`Current max. Long Range powerlevel ${this.maxLongRangePowerlevel?.toFixed(1)} dBm differs from desired powerlevel ${powerlevel} dBm, configuring it...`);
      const resp = await this.setMaxLongRangePowerlevel(powerlevel).catch((e) => e.message);
      if (resp === true) {
        this.driver.controllerLog.print(`max. Long Range powerlevel updated`);
      } else {
        this.driver.controllerLog.print(`Changing the max. Long Range powerlevel failed!${resp ? ` Reason: ${resp}` : ""}`, "warn");
      }
    }
    /**
     * Configure channel to use for Z-Wave Long Range.
     */
    async setLongRangeChannel(channel) {
      if (!this._supportsLongRangeAutoChannelSelection && channel === import_core.LongRangeChannel.Auto) {
        throw new import_core.ZWaveError(`Your hardware does not support automatic Long Range channel selection!`, import_core.ZWaveErrorCodes.Driver_NotSupported);
      }
      const result = await this.driver.sendMessage(new import_serialapi.SetLongRangeChannelRequest({ channel }));
      if (result.success) {
        this._longRangeChannel = channel;
      }
      return result.success;
    }
    /** Request the channel setting and capabilities for Z-Wave Long Range */
    async getLongRangeChannel() {
      const result = await this.driver.sendMessage(new import_serialapi.GetLongRangeChannelRequest());
      const channel = result.autoChannelSelectionActive && result.supportsAutoChannelSelection ? import_core.LongRangeChannel.Auto : result.channel;
      this._longRangeChannel = channel;
      this._supportsLongRangeAutoChannelSelection = result.supportsAutoChannelSelection;
      return {
        channel,
        supportsAutoChannelSelection: result.supportsAutoChannelSelection
      };
    }
    /**
     * @internal
     * Configure whether the Z-Wave API should use short (8 bit) or long (16 bit) Node IDs
     */
    async setNodeIDType(nodeIdType) {
      this.driver.controllerLog.print(`Switching serial API to ${nodeIdType === import_core.NodeIDType.Short ? 8 : 16}-bit node IDs...`);
      const result = await this.driver.sendMessage(new import_serialapi.SerialAPISetup_SetNodeIDTypeRequest({
        nodeIdType
      }));
      if (result instanceof import_serialapi.SerialAPISetup_CommandUnsupportedResponse) {
        throw new import_core.ZWaveError(`Your hardware does not support switching between short and long node IDs!`, import_core.ZWaveErrorCodes.Driver_NotSupported);
      } else {
        this.driver.controllerLog.print(`Switching to ${nodeIdType === import_core.NodeIDType.Short ? 8 : 16}-bit node IDs ${result.success ? "successful" : "failed"}`);
        if (result.success) {
          this._nodeIdType = nodeIdType;
        }
      }
      return result.success;
    }
    async trySetNodeIDType(nodeIdType) {
      if (this.isSerialAPISetupCommandSupported(import_serialapi.SerialAPISetupCommand.SetNodeIDType)) {
        try {
          return await this.setNodeIDType(nodeIdType);
        } catch {
        }
      }
      return false;
    }
    /**
     * @internal
     * Request the maximum payload that the Z-Wave API Module can accept for transmitting Z-Wave frames. This value depends on the RF Profile
     */
    async getMaxPayloadSize() {
      const result = await this.driver.sendMessage(new import_serialapi.SerialAPISetup_GetMaximumPayloadSizeRequest(), {
        supportCheck: false
      });
      if (result instanceof import_serialapi.SerialAPISetup_CommandUnsupportedResponse) {
        throw new import_core.ZWaveError(`Your hardware does not support getting the max. payload size!`, import_core.ZWaveErrorCodes.Driver_NotSupported);
      }
      return result.maxPayloadSize;
    }
    /**
     * @internal
     * Request the maximum payload that the Z-Wave API Module can accept for transmitting Z-Wave Long Range frames. This value depends on the RF Profile
     */
    async getMaxPayloadSizeLongRange() {
      const result = await this.driver.sendMessage(new import_serialapi.SerialAPISetup_GetLongRangeMaximumPayloadSizeRequest());
      if (result instanceof import_serialapi.SerialAPISetup_CommandUnsupportedResponse) {
        throw new import_core.ZWaveError(`Your hardware does not support getting the max. long range payload size!`, import_core.ZWaveErrorCodes.Driver_NotSupported);
      }
      return result.maxPayloadSize;
    }
    /**
     * Instructs a node to (re-)discover its neighbors.
     *
     * **WARNING:** On some controllers, this can cause new SUC return routes to be assigned.
     *
     * @returns `true` if the update was successful and the new neighbors can be retrieved using
     * {@link getNodeNeighbors}. `false` if the update failed.
     */
    async discoverNodeNeighbors(nodeId) {
      if (nodeId === this._ownNodeId) {
        throw new import_core.ZWaveError(`Discovering neighbors for the controller itself is not possible!`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      const discoveryTimeout = (0, import_serialapi.computeNeighborDiscoveryTimeout)(
        this.driver,
        // Controllers take longer, just assume the worst case here
        import_core.NodeType.Controller
      );
      const resp = await this.driver.sendMessage(new import_serialapi.RequestNodeNeighborUpdateRequest({
        nodeId,
        discoveryTimeout
      }));
      const success = resp.updateStatus === import_serialapi.NodeNeighborUpdateStatus.UpdateDone;
      if (success) {
        this.setCustomSUCReturnRoutesCached(nodeId, void 0);
      }
      return success;
    }
    /**
     * Returns the known list of neighbors for a node.
     *
     * Throws when the node is a Long Range node.
     */
    async getNodeNeighbors(nodeId, onlyRepeaters = false) {
      if ((0, import_core.isLongRangeNodeId)(nodeId)) {
        throw new import_core.ZWaveError(`Cannot request node neighbors for Long Range node ${nodeId}`, import_core.ZWaveErrorCodes.Controller_NotSupportedForLongRange);
      }
      this.driver.controllerLog.logNode(nodeId, {
        message: "requesting node neighbors...",
        direction: "outbound"
      });
      try {
        const resp = await this.driver.sendMessage(new import_serialapi.GetRoutingInfoRequest({
          nodeId,
          removeBadLinks: false,
          removeNonRepeaters: onlyRepeaters
        }));
        this.driver.controllerLog.logNode(nodeId, {
          message: `node neighbors received: ${resp.nodeIds.join(", ")}`,
          direction: "inbound"
        });
        return resp.nodeIds;
      } catch (e) {
        this.driver.controllerLog.logNode(nodeId, `requesting the node neighbors failed: ${(0, import_shared.getErrorMessage)(e)}`, "error");
        throw e;
      }
    }
    /**
     * Returns the known routes the controller will use to communicate with the nodes.
     *
     * This information is dynamically built using TX status reports and may not be accurate at all times.
     * Also, it may not be available immediately after startup or at all if the controller doesn't support this feature.
     *
     * **Note:** To keep information returned by this method updated, use the information contained in each node's `"statistics"` event.
     */
    getKnownLifelineRoutes() {
      const ret = /* @__PURE__ */ new Map();
      for (const node of this.nodes.values()) {
        if (node.isControllerNode)
          continue;
        ret.set(node.id, {
          lwr: node.statistics.lwr,
          nlwr: node.statistics.nlwr
        });
      }
      return ret;
    }
    /** Request additional information about the controller/Z-Wave chip */
    async getSerialApiInitData() {
      this.driver.controllerLog.print(`querying additional controller information...`);
      const initData = await this.driver.sendMessage(new import_serialapi.GetSerialApiInitDataRequest());
      this.driver.controllerLog.print(`received additional controller information:
  Z-Wave API version:         ${initData.zwaveApiVersion.version} (${initData.zwaveApiVersion.kind})${initData.zwaveChipType ? `
  Z-Wave chip type:           ${typeof initData.zwaveChipType === "string" ? initData.zwaveChipType : `unknown (type: ${(0, import_shared.num2hex)(initData.zwaveChipType.type)}, version: ${(0, import_shared.num2hex)(initData.zwaveChipType.version)})`}` : ""}
  node type                   ${(0, import_shared.getEnumMemberName)(import_core.NodeType, initData.nodeType)}
  controller role:            ${initData.isPrimary ? "primary" : "secondary"}
  controller is the SIS:      ${initData.isSIS}
  controller supports timers: ${initData.supportsTimers}
  Z-Wave Classic nodes:       ${initData.nodeIds.join(", ")}`);
      const ret = {
        ...(0, import_shared.pick)(initData, [
          "zwaveApiVersion",
          "zwaveChipType",
          "isPrimary",
          "isSIS",
          "nodeType",
          "supportsTimers"
        ]),
        nodeIds: [...initData.nodeIds]
        // ignore the initVersion, no clue what to do with it
      };
      this._zwaveApiVersion = initData.zwaveApiVersion;
      this._zwaveChipType = initData.zwaveChipType;
      this._isPrimary = initData.isPrimary;
      this._isSIS = initData.isSIS;
      this._nodeType = initData.nodeType;
      this._supportsTimers = initData.supportsTimers;
      return ret;
    }
    /** Determines the controller's network role/capabilities */
    async getControllerCapabilities() {
      this.driver.controllerLog.print(`querying controller capabilities...`);
      const result = await this.driver.sendMessage(new import_serialapi.GetControllerCapabilitiesRequest(), { supportCheck: false });
      const ret = {
        isSecondary: result.isSecondary,
        isUsingHomeIdFromOtherNetwork: result.isUsingHomeIdFromOtherNetwork,
        isSISPresent: result.isSISPresent,
        wasRealPrimary: result.wasRealPrimary,
        isSUC: result.isStaticUpdateController,
        noNodesIncluded: result.noNodesIncluded
      };
      this._isSecondary = ret.isSecondary;
      this._isUsingHomeIdFromOtherNetwork = ret.isUsingHomeIdFromOtherNetwork;
      this._isSISPresent = ret.isSISPresent;
      this._wasRealPrimary = ret.wasRealPrimary;
      this._isSUC = ret.isSUC;
      this._noNodesIncluded = ret.noNodesIncluded;
      this.driver.controllerLog.print(`received controller capabilities:
  controller role:      ${(0, import_shared.getEnumMemberName)(import_core.ControllerRole, this.role)}
  is the SUC:           ${ret.isSUC}
  started this network: ${!ret.isUsingHomeIdFromOtherNetwork}
  SIS is present:       ${ret.isSISPresent}
  was real primary:     ${ret.wasRealPrimary}`);
      return ret;
    }
    /**
     * @internal
     * Deserializes the controller information and all nodes from the cache.
     */
    async deserialize() {
      if (!this.driver.networkCache)
        return;
      const cache = this.driver.networkCache;
      for (const node of this.nodes.values()) {
        await node.deserialize();
      }
      for (const cacheKey of cache.keys()) {
        const nodeId = import_NetworkCache.cacheKeyUtils.nodeIdFromKey(cacheKey);
        if (nodeId && !this.nodes.has(nodeId)) {
          cache.delete(cacheKey);
        }
      }
    }
    /** Turns the Z-Wave radio on or off */
    async toggleRF(enabled) {
      try {
        this.driver.controllerLog.print(`Turning RF ${enabled ? "on" : "off"}...`);
        const ret = await this.driver.sendMessage(new import_serialapi.SetRFReceiveModeRequest({ enabled }));
        return ret.isOK();
      } catch (e) {
        this.driver.controllerLog.print(`Error turning RF ${enabled ? "on" : "off"}: ${(0, import_shared.getErrorMessage)(e)}`, "error");
        return false;
      }
    }
    _nvm;
    /** Provides access to the controller's non-volatile memory */
    get nvm() {
      if (!this._nvm) {
        if (this.sdkVersionGte("7.0")) {
          const io = new import_nvmedit.BufferedNVMReader(new import_NVMIO.SerialNVMIO700(this));
          const nvm3 = new import_nvmedit.NVM3(io);
          this._nvm = new import_nvmedit.NVM3Adapter(nvm3);
        } else {
          const io = new import_nvmedit.BufferedNVMReader(new import_NVMIO.SerialNVMIO500(this));
          const nvm = new import_nvmedit.NVM500(io);
          this._nvm = new import_nvmedit.NVM500Adapter(nvm);
        }
      }
      return this._nvm;
    }
    /**
     * **Z-Wave 500 series only**
     *
     * Initialize the Firmware Update functionality and determine if the firmware can be updated.
     * @internal
     */
    async firmwareUpdateNVMInit() {
      const ret = await this.driver.sendMessage(new import_serialapi.FirmwareUpdateNVM_InitRequest());
      return ret.supported;
    }
    /**
     * **Z-Wave 500 series only**
     *
     * Set the NEWIMAGE marker in the NVM (to the given value), which is used to signal that a new firmware image is present
     * @internal
     */
    async firmwareUpdateNVMSetNewImage(value = true) {
      await this.driver.sendMessage(new import_serialapi.FirmwareUpdateNVM_SetNewImageRequest({
        newImage: value
      }));
    }
    /**
     * **Z-Wave 500 series only**
     *
     * Return the value of the NEWIMAGE marker in the NVM, which is used to signal that a new firmware image is present
     */
    async firmwareUpdateNVMGetNewImage() {
      const ret = await this.driver.sendMessage(new import_serialapi.FirmwareUpdateNVM_GetNewImageRequest());
      return ret.newImage;
    }
    /**
     * **Z-Wave 500 series only**
     *
     * Calculates the CRC-16 for the specified block of data in the NVM
     */
    async firmwareUpdateNVMUpdateCRC16(offset, blockLength, crcSeed) {
      const ret = await this.driver.sendMessage(new import_serialapi.FirmwareUpdateNVM_UpdateCRC16Request({
        offset,
        blockLength,
        crcSeed
      }));
      return ret.crc16;
    }
    /**
     * **Z-Wave 500 series only**
     *
     * Writes the given data into the firmware update region of the NVM.
     * @internal
     */
    async firmwareUpdateNVMWrite(offset, buffer) {
      await this.driver.sendMessage(new import_serialapi.FirmwareUpdateNVM_WriteRequest({
        offset,
        buffer
      }));
    }
    /**
     * **Z-Wave 500 series only**
     *
     * Checks if the firmware present in the NVM is valid
     * @internal
     */
    async firmwareUpdateNVMIsValidCRC16() {
      const ret = await this.driver.sendMessage(new import_serialapi.FirmwareUpdateNVM_IsValidCRC16Request());
      return ret.isValid;
    }
    /**
     * **Z-Wave 500 series only**
     *
     * Returns information of the controller's external NVM
     */
    async getNVMId() {
      const ret = await this.driver.sendMessage(new import_serialapi.GetNVMIdRequest());
      return (0, import_shared.pick)(ret, ["nvmManufacturerId", "memoryType", "memorySize"]);
    }
    /**
     * **Z-Wave 500 series only**
     *
     * Reads a byte from the external NVM at the given offset
     */
    async externalNVMReadByte(offset) {
      const ret = await this.driver.sendMessage(new import_serialapi.ExtNVMReadLongByteRequest({ offset }));
      return ret.byte;
    }
    /**
     * **Z-Wave 500 series only**
     *
     * Writes a byte to the external NVM at the given offset
     * **WARNING:** This function can write in the full NVM address space and is not offset to start at the application area.
     * Take care not to accidentally overwrite the protocol NVM area!
     *
     * @returns `true` when writing succeeded, `false` otherwise
     */
    async externalNVMWriteByte(offset, data) {
      const ret = await this.driver.sendMessage(new import_serialapi.ExtNVMWriteLongByteRequest({ offset, byte: data }));
      return ret.success;
    }
    /**
     * **Z-Wave 500 series only**
     *
     * Reads a buffer from the external NVM at the given offset
     */
    async externalNVMReadBuffer(offset, length) {
      const ret = await this.driver.sendMessage(new import_serialapi.ExtNVMReadLongBufferRequest({
        offset,
        length
      }));
      return ret.buffer;
    }
    /**
     * **Z-Wave 700+ series only**
     *
     * Reads a buffer from the external NVM at the given offset
     *
     * **Note:** Prefer {@link externalNVMReadBufferExt} if supported, as that command supports larger NVMs than 64 KiB.
     */
    async externalNVMReadBuffer700(offset, length) {
      const ret = await this.driver.sendMessage(new import_serialapi.NVMOperationsReadRequest({
        offset,
        length
      }));
      if (!ret.isOK()) {
        let message = "Could not read from the external NVM";
        if (ret.status === import_serialapi.NVMOperationStatus.Error_OperationInterference) {
          message += ": interference between read and write operation.";
        } else if (ret.status === import_serialapi.NVMOperationStatus.Error_OperationMismatch) {
          message += ": wrong operation requested.";
        }
        throw new import_core.ZWaveError(message, import_core.ZWaveErrorCodes.Controller_CommandError);
      }
      return {
        buffer: ret.buffer,
        endOfFile: ret.status === import_serialapi.NVMOperationStatus.EndOfFile
      };
    }
    /**
     * **Z-Wave 700+ series only**
     *
     * Reads a buffer from the external NVM at the given offset
     *
     * **Note:** If supported, this command should be preferred over {@link externalNVMReadBuffer700} as it supports larger NVMs than 64 KiB.
     */
    async externalNVMReadBufferExt(offset, length) {
      const ret = await this.driver.sendMessage(new import_serialapi.ExtendedNVMOperationsReadRequest({
        offset,
        length
      }));
      if (!ret.isOK()) {
        let message = "Could not read from the external NVM";
        if (ret.status === import_serialapi.ExtendedNVMOperationStatus.Error_OperationInterference) {
          message += ": interference between read and write operation.";
        } else if (ret.status === import_serialapi.ExtendedNVMOperationStatus.Error_OperationMismatch) {
          message += ": wrong operation requested.";
        }
        throw new import_core.ZWaveError(message, import_core.ZWaveErrorCodes.Controller_CommandError);
      }
      return {
        buffer: ret.bufferOrBitmask,
        endOfFile: ret.status === import_serialapi.ExtendedNVMOperationStatus.EndOfFile
      };
    }
    /**
     * **Z-Wave 500 series only**
     *
     * Writes a buffer to the external NVM at the given offset
     * **WARNING:** This function can write in the full NVM address space and is not offset to start at the application area.
     * Take care not to accidentally overwrite the protocol NVM area!
     *
     * @returns `true` when writing succeeded, `false` otherwise
     */
    async externalNVMWriteBuffer(offset, buffer) {
      const ret = await this.driver.sendMessage(new import_serialapi.ExtNVMWriteLongBufferRequest({
        offset,
        buffer
      }));
      return ret.success;
    }
    /**
     * **Z-Wave 700+ series only**
     *
     * Writes a buffer to the external NVM at the given offset
     *
     * **Note:** Prefer {@link externalNVMWriteBufferExt} if supported, as that command supports larger NVMs than 64 KiB.
     *
     * **WARNING:** This function can write in the full NVM address space and is not offset to start at the application area.
     * Take care not to accidentally overwrite the protocol NVM area!
     */
    async externalNVMWriteBuffer700(offset, buffer) {
      const ret = await this.driver.sendMessage(new import_serialapi.NVMOperationsWriteRequest({
        offset,
        buffer
      }));
      if (!ret.isOK()) {
        let message = "Could not write to the external NVM";
        if (ret.status === import_serialapi.NVMOperationStatus.Error_OperationInterference) {
          message += ": interference between read and write operation.";
        } else if (ret.status === import_serialapi.NVMOperationStatus.Error_OperationMismatch) {
          message += ": wrong operation requested.";
        }
        throw new import_core.ZWaveError(message, import_core.ZWaveErrorCodes.Controller_CommandError);
      }
      return {
        endOfFile: ret.status === import_serialapi.NVMOperationStatus.EndOfFile
      };
    }
    /**
     * **Z-Wave 700+ series only**
     *
     * Writes a buffer to the external NVM at the given offset
     *
     * **Note:** If supported, this command should be preferred over {@link externalNVMWriteBuffer700} as it supports larger NVMs than 64 KiB.
     *
     * **WARNING:** This function can write in the full NVM address space and is not offset to start at the application area.
     * Take care not to accidentally overwrite the protocol NVM area!
     */
    async externalNVMWriteBufferExt(offset, buffer) {
      const ret = await this.driver.sendMessage(new import_serialapi.ExtendedNVMOperationsWriteRequest({
        offset,
        buffer
      }));
      if (!ret.isOK()) {
        let message = "Could not write to the external NVM";
        if (ret.status === import_serialapi.ExtendedNVMOperationStatus.Error_OperationInterference) {
          message += ": interference between read and write operation.";
        } else if (ret.status === import_serialapi.ExtendedNVMOperationStatus.Error_OperationMismatch) {
          message += ": wrong operation requested.";
        } else if (ret.status === import_serialapi.ExtendedNVMOperationStatus.Error_SubCommandNotSupported) {
          message += ": sub-command not supported.";
        }
        throw new import_core.ZWaveError(message, import_core.ZWaveErrorCodes.Controller_CommandError);
      }
      return {
        endOfFile: ret.status === import_serialapi.ExtendedNVMOperationStatus.EndOfFile
      };
    }
    /**
     * **Z-Wave 700+ series only**
     *
     * Opens the controller's external NVM for reading/writing and returns the NVM size
     *
     * **Note:** Prefer {@link externalNVMOpenExt} if supported, as that command supports larger NVMs than 64 KiB.
     */
    async externalNVMOpen() {
      const ret = await this.driver.sendMessage(new import_serialapi.NVMOperationsOpenRequest());
      if (!ret.isOK()) {
        throw new import_core.ZWaveError("Failed to open the external NVM", import_core.ZWaveErrorCodes.Controller_CommandError);
      }
      return ret.offsetOrSize;
    }
    /**
     * **Z-Wave 700+ series only**
     *
     * Opens the controller's external NVM for reading/writing and returns the NVM size and supported operations.
     *
     * **Note:** If supported, this command should be preferred over {@link externalNVMOpen} as it supports larger NVMs than 64 KiB.
     */
    async externalNVMOpenExt() {
      const ret = await this.driver.sendMessage(new import_serialapi.ExtendedNVMOperationsOpenRequest());
      if (!ret.isOK()) {
        throw new import_core.ZWaveError("Failed to open the external NVM", import_core.ZWaveErrorCodes.Controller_CommandError);
      }
      const size = ret.offsetOrSize;
      const supportedOperations = (0, import_core.parseBitMask)(ret.bufferOrBitmask, import_serialapi.ExtendedNVMOperationsCommand.Open);
      return {
        size,
        supportedOperations
      };
    }
    /**
     * **Z-Wave 700+ series only**
     *
     * Closes the controller's external NVM
     *
     * **Note:** Prefer {@link externalNVMCloseExt} if supported, as that command supports larger NVMs than 64 KiB.
     */
    async externalNVMClose() {
      const ret = await this.driver.sendMessage(new import_serialapi.NVMOperationsCloseRequest());
      if (!ret.isOK()) {
        throw new import_core.ZWaveError("Failed to close the external NVM", import_core.ZWaveErrorCodes.Controller_CommandError);
      }
    }
    /**
     * **Z-Wave 700+ series only**
     *
     * Closes the controller's external NVM
     *
     * **Note:** If supported, this command should be preferred over {@link externalNVMClose} as it supports larger NVMs than 64 KiB.
     */
    async externalNVMCloseExt() {
      const ret = await this.driver.sendMessage(new import_serialapi.ExtendedNVMOperationsCloseRequest());
      if (!ret.isOK()) {
        throw new import_core.ZWaveError("Failed to close the external NVM", import_core.ZWaveErrorCodes.Controller_CommandError);
      }
    }
    /**
     * Creates a backup of the NVM and returns the raw data as a Buffer. The Z-Wave radio is turned off/on automatically.
     * @param onProgress Can be used to monitor the progress of the operation, which may take several seconds up to a few minutes depending on the NVM size
     * @returns The raw NVM buffer
     */
    async backupNVMRaw(onProgress) {
      this.driver.controllerLog.print("Backing up NVM...");
      if (!await this.toggleRF(false)) {
        throw new import_core.ZWaveError("Could not turn off the Z-Wave radio before creating NVM backup!", import_core.ZWaveErrorCodes.Controller_ResponseNOK);
      }
      await this.stopWatchdog();
      let ret;
      try {
        if (this.sdkVersionGte("7.0")) {
          ret = await this.backupNVMRaw700(onProgress);
          await this.driver.trySoftReset();
        } else {
          ret = await this.backupNVMRaw500(onProgress);
        }
        this.driver.controllerLog.print("NVM backup completed");
      } finally {
        await this.toggleRF(true);
      }
      return ret;
    }
    async backupNVMRaw500(onProgress) {
      const size = (0, import_serialapi.nvmSizeToBufferSize)((await this.getNVMId()).memorySize);
      if (!size) {
        throw new import_core.ZWaveError("Unknown NVM size - cannot backup!", import_core.ZWaveErrorCodes.Controller_NotSupported);
      }
      const ret = new import_shared.Bytes(size);
      let offset = 0;
      const initialChunkSize = this._manufacturerId === 134 && this._productType === 1 && this._productId === 90 ? 48 : 65535;
      let chunkSize = Math.min(initialChunkSize, ret.length);
      while (offset < ret.length) {
        const chunk = await this.externalNVMReadBuffer(offset, Math.min(chunkSize, ret.length - offset));
        if (chunk.length === 0) {
          chunkSize = 48;
          continue;
        }
        ret.set(chunk, offset);
        offset += chunk.length;
        if (chunkSize > chunk.length)
          chunkSize = chunk.length;
        if (onProgress)
          setImmediate(() => onProgress(offset, size));
      }
      return ret;
    }
    async backupNVMRaw700(onProgress) {
      let open;
      let read;
      let close;
      if (this.supportedFunctionTypes?.includes(import_serial.FunctionType.ExtendedNVMOperations)) {
        open = /* @__PURE__ */ __name(async () => {
          const { size: size2 } = await this.externalNVMOpenExt();
          return size2;
        }, "open");
        read = /* @__PURE__ */ __name((offset2, length) => this.externalNVMReadBufferExt(offset2, length), "read");
        close = /* @__PURE__ */ __name(() => this.externalNVMCloseExt(), "close");
      } else {
        open = /* @__PURE__ */ __name(() => this.externalNVMOpen(), "open");
        read = /* @__PURE__ */ __name((offset2, length) => this.externalNVMReadBuffer700(offset2, length), "read");
        close = /* @__PURE__ */ __name(() => this.externalNVMClose(), "close");
      }
      const size = await open();
      const ret = new import_shared.Bytes(size);
      let offset = 0;
      let chunkSize = Math.min(255, ret.length);
      try {
        while (offset < ret.length) {
          const { buffer: chunk, endOfFile } = await read(offset, Math.min(chunkSize, ret.length - offset));
          if (chunkSize === 255 && chunk.length === 0) {
            chunkSize = 48;
            continue;
          }
          ret.set(chunk, offset);
          offset += chunk.length;
          if (chunkSize > chunk.length)
            chunkSize = chunk.length;
          if (onProgress)
            setImmediate(() => onProgress(offset, size));
          if (endOfFile)
            break;
        }
      } finally {
        await close();
      }
      return ret;
    }
    /**
     * Restores an NVM backup that was created with `backupNVMRaw`. The Z-Wave radio is turned off/on automatically.
     * If the given buffer is in a different NVM format, it is converted automatically. If a conversion is required but not supported, the operation will be aborted.
     *
     * **WARNING:** If both the source and target NVM use an an unsupported format, they will NOT be checked for compatibility!
     *
     * **WARNING:** A failure during this process may brick your controller. Use at your own risk!
     *
     * @param nvmData The NVM backup to be restored
     * @param convertProgress Can be used to monitor the progress of the NVM conversion, which may take several seconds up to a few minutes depending on the NVM size
     * @param restoreProgress Can be used to monitor the progress of the restore operation, which may take several seconds up to a few minutes depending on the NVM size
     * @param migrateOptions Influence which data should be preserved during a migration
     */
    async restoreNVM(nvmData, convertProgress, restoreProgress, migrateOptions) {
      if (!await this.toggleRF(false)) {
        throw new import_core.ZWaveError("Could not turn off the Z-Wave radio before restoring NVM backup!", import_core.ZWaveErrorCodes.Controller_ResponseNOK);
      }
      await this.stopWatchdog();
      this.driver.controllerLog.print("Converting NVM to target format...");
      let targetNVM;
      let convertedNVM;
      try {
        if (this.sdkVersionGte("7.0")) {
          targetNVM = await this.backupNVMRaw700(convertProgress);
        } else {
          targetNVM = await this.backupNVMRaw500(convertProgress);
        }
        convertedNVM = await (0, import_nvmedit.migrateNVM)(nvmData, targetNVM, migrateOptions);
      } catch (e) {
        await this.toggleRF(true);
        const message = "Failed to convert NVM to target format: " + e.message;
        this.driver.controllerLog.print(message, "error");
        e.message = message;
        throw e;
      }
      try {
        this.driver.controllerLog.print("Restoring NVM backup...");
        if (this.sdkVersionGte("7.0")) {
          await this.restoreNVMRaw700(convertedNVM, restoreProgress);
        } else {
          await this.restoreNVMRaw500(convertedNVM, restoreProgress);
        }
        this.driver.controllerLog.print("NVM backup restored. Restarting to activate the restored backup...");
      } catch (e) {
        await this.toggleRF(true);
        const message = "Failed to restore NVM backup: " + e.message;
        this.driver.controllerLog.print(message, "error");
        e.message = message;
        throw e;
      }
      this._nodes.clear();
      await this.driver.softResetAndRestart();
    }
    /**
     * Restores an NVM backup that was created with `backupNVMRaw`. The Z-Wave radio is turned off/on automatically.
     *
     * **WARNING:** The given buffer is NOT checked for compatibility with the current stick. To have Z-Wave JS do that, use the {@link restoreNVM} method instead.
     *
     * **WARNING:** A failure during this process may brick your controller. Use at your own risk!
     * @param nvmData The raw NVM backup to be restored
     * @param onProgress Can be used to monitor the progress of the operation, which may take several seconds up to a few minutes depending on the NVM size
     */
    async restoreNVMRaw(nvmData, onProgress) {
      this.driver.controllerLog.print("Restoring NVM...");
      if (!await this.toggleRF(false)) {
        throw new import_core.ZWaveError("Could not turn off the Z-Wave radio before restoring NVM backup!", import_core.ZWaveErrorCodes.Controller_ResponseNOK);
      }
      try {
        if (this.sdkVersionGte("7.0")) {
          await this.restoreNVMRaw700(nvmData, onProgress);
        } else {
          await this.restoreNVMRaw500(nvmData, onProgress);
        }
        this.driver.controllerLog.print("NVM backup restored");
      } finally {
        await this.toggleRF(true);
      }
      this.driver.controllerLog.print("Restarting driver to activate restored NVM backup...");
      this.driver.emit("error", new import_core.ZWaveError("Activating the NVM backup requires a driver restart!", import_core.ZWaveErrorCodes.Driver_Failed));
      await this.driver.destroy();
    }
    async restoreNVMRaw500(nvmData, onProgress) {
      const size = (0, import_serialapi.nvmSizeToBufferSize)((await this.getNVMId()).memorySize);
      if (!size) {
        throw new import_core.ZWaveError("Unknown NVM size - cannot restore!", import_core.ZWaveErrorCodes.Controller_NotSupported);
      } else if (size !== nvmData.length) {
        const actualSize = 1 + import_shared.Bytes.view(nvmData).readUInt16BE(0);
        if (actualSize !== nvmData.length) {
          throw new import_core.ZWaveError("The given data does not match the NVM size - cannot restore!", import_core.ZWaveErrorCodes.Argument_Invalid);
        }
        const firstTwoNVMBytes = import_shared.Bytes.view(await this.externalNVMReadBuffer(0, 2));
        const oldSize = 1 + firstTwoNVMBytes.readUInt16BE(0);
        if (oldSize > actualSize) {
          nvmData = import_shared.Bytes.concat([
            nvmData,
            import_shared.Bytes.alloc(oldSize - actualSize, 255)
          ]);
        }
      }
      const chunkSize = (await this.externalNVMReadBuffer(0, 65535)).length - 5;
      for (let offset = 0; offset < nvmData.length; offset += chunkSize) {
        await this.externalNVMWriteBuffer(offset, nvmData.subarray(offset, offset + chunkSize));
        if (onProgress) {
          setImmediate(() => onProgress(offset, nvmData.length));
        }
      }
    }
    async restoreNVMRaw700(nvmData, onProgress) {
      let open;
      let read;
      let write;
      let close;
      if (this.supportedFunctionTypes?.includes(import_serial.FunctionType.ExtendedNVMOperations)) {
        open = /* @__PURE__ */ __name(async () => {
          const { size: size2 } = await this.externalNVMOpenExt();
          return size2;
        }, "open");
        read = /* @__PURE__ */ __name((offset, length) => this.externalNVMReadBufferExt(offset, length), "read");
        write = /* @__PURE__ */ __name((offset, buffer) => this.externalNVMWriteBufferExt(offset, buffer), "write");
        close = /* @__PURE__ */ __name(() => this.externalNVMCloseExt(), "close");
      } else {
        open = /* @__PURE__ */ __name(() => this.externalNVMOpen(), "open");
        read = /* @__PURE__ */ __name((offset, length) => this.externalNVMReadBuffer700(offset, length), "read");
        write = /* @__PURE__ */ __name((offset, buffer) => this.externalNVMWriteBuffer700(offset, buffer), "write");
        close = /* @__PURE__ */ __name(() => this.externalNVMClose(), "close");
      }
      const size = await open();
      if (size !== nvmData.length) {
        throw new import_core.ZWaveError("The given data does not match the NVM size - cannot restore!", import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      const chunkSize = (await read(0, 255)).buffer.length || 48;
      await close();
      await open();
      for (let offset = 0; offset < nvmData.length; offset += chunkSize) {
        const { endOfFile } = await write(offset, nvmData.subarray(offset, offset + chunkSize));
        if (onProgress)
          setImmediate(() => onProgress(offset, size));
        if (endOfFile)
          break;
      }
      await close();
    }
    /**
     * Request the most recent background RSSI levels detected by the controller.
     *
     * **Note:** This only returns useful values if something was transmitted recently.
     */
    async getBackgroundRSSI() {
      const ret = await this.driver.sendMessage(new import_serialapi.GetBackgroundRSSIRequest());
      const rssi = (0, import_shared.pick)(ret, [
        "rssiChannel0",
        "rssiChannel1",
        "rssiChannel2",
        "rssiChannel3"
      ]);
      this.updateStatistics((current) => {
        const updated = { ...current };
        updated.backgroundRSSI = {};
        updated.backgroundRSSI.channel0 = {
          current: rssi.rssiChannel0,
          average: (0, import_core.averageRSSI)(current.backgroundRSSI?.channel0.average, rssi.rssiChannel0, 0.9)
        };
        updated.backgroundRSSI.channel1 = {
          current: rssi.rssiChannel1,
          average: (0, import_core.averageRSSI)(current.backgroundRSSI?.channel1.average, rssi.rssiChannel1, 0.9)
        };
        if (rssi.rssiChannel2 != void 0) {
          updated.backgroundRSSI.channel2 = {
            current: rssi.rssiChannel2,
            average: (0, import_core.averageRSSI)(current.backgroundRSSI?.channel2?.average, rssi.rssiChannel2, 0.9)
          };
        }
        if (rssi.rssiChannel3 != void 0) {
          updated.backgroundRSSI.channel3 = {
            current: rssi.rssiChannel3,
            average: (0, import_core.averageRSSI)(current.backgroundRSSI?.channel3?.average, rssi.rssiChannel3, 0.9)
          };
        }
        updated.backgroundRSSI.timestamp = Date.now();
        return updated;
      });
      return rssi;
    }
    /**
     * Returns whether an OTA firmware update is in progress for any node.
     */
    isAnyOTAFirmwareUpdateInProgress() {
      for (const node of this._nodes.values()) {
        if (!node.isControllerNode && node.isFirmwareUpdateInProgress()) {
          return true;
        }
      }
      return false;
    }
    /**
     * Retrieves the available firmware updates for the given node from the Z-Wave JS firmware update service.
     *
     * **Note:** This requires an API key to be set in the driver options, or passed using the `options` parameter.
     */
    async getAvailableFirmwareUpdates(nodeId, options) {
      const node = this.nodes.getOrThrow(nodeId);
      const { manufacturerId, productType, productId, firmwareVersion } = node;
      if (typeof manufacturerId !== "number" || typeof productType !== "number" || typeof productId !== "number" || typeof firmwareVersion !== "string") {
        throw new import_core.ZWaveError(`Cannot check for firmware updates for node ${nodeId}: fingerprint or firmware version is unknown!`, import_core.ZWaveErrorCodes.FWUpdateService_MissingInformation);
      }
      try {
        const allUpdates = await this.getAllAvailableFirmwareUpdates(options);
        return allUpdates.get(nodeId) || [];
      } catch (e) {
        let message = `Cannot check for firmware updates for node ${nodeId}: `;
        if (e.response) {
          if ((0, import_typeguards.isObject)(e.response.data)) {
            if (typeof e.response.data.error === "string") {
              message += `${e.response.data.error} `;
            } else if (typeof e.response.data.message === "string") {
              message += `${e.response.data.message} `;
            }
          }
          message += `[${e.response.status} ${e.response.statusText}]`;
        } else if (typeof e.message === "string") {
          message += e.message;
        } else {
          message += `Failed to download update information!`;
        }
        throw new import_core.ZWaveError(message, import_core.ZWaveErrorCodes.FWUpdateService_RequestError);
      }
    }
    /**
     * Retrieves the available firmware updates for all ready nodes from the Z-Wave JS firmware update service.
     *
     * **Note:** This requires an API key to be set in the driver options, or passed using the `options` parameter.
     *
     * @returns A map where the keys are node IDs and the values are available firmware updates. Devices missing from the map are unknown to the firmware update service.
     */
    async getAllAvailableFirmwareUpdates(options) {
      const deviceIds = [];
      const nodeIdMap = new import_shared.ObjectKeyMap();
      for (const node of this.nodes.values()) {
        const { manufacturerId, productType, productId, firmwareVersion } = node;
        if (typeof manufacturerId !== "number" || typeof productType !== "number" || typeof productId !== "number" || typeof firmwareVersion !== "string") {
          continue;
        }
        const deviceId = {
          manufacturerId,
          productType,
          productId,
          firmwareVersion
        };
        deviceIds.push(deviceId);
        if (!nodeIdMap.has(deviceId)) {
          nodeIdMap.set(deviceId, []);
        }
        nodeIdMap.get(deviceId).push(node.id);
      }
      if (deviceIds.length === 0) {
        return /* @__PURE__ */ new Map();
      }
      const rfRegion = (
        // Prefer the actual region...
        this.rfRegion ?? options?.rfRegion ?? this.driver.options.rf?.region
      );
      try {
        const bulkResult = await (0, import_FirmwareUpdateService.getAvailableFirmwareUpdatesBulk)(deviceIds, {
          userAgent: this.driver.getUserAgentStringWithComponents(options?.additionalUserAgentComponents),
          apiKey: options?.apiKey ?? this.driver.options.apiKeys?.firmwareUpdateService,
          rfRegion
        });
        const result = /* @__PURE__ */ new Map();
        for (const [deviceKey, updates] of bulkResult) {
          const nodeIds = nodeIdMap.get(deviceKey) ?? [];
          const filteredUpdates = options?.includePrereleases ? updates : updates.filter((u) => u.channel === "stable");
          for (const nodeId of nodeIds) {
            result.set(nodeId, filteredUpdates);
          }
        }
        return result;
      } catch (e) {
        let message = `Cannot check for firmware updates: `;
        if (e.response) {
          if ((0, import_typeguards.isObject)(e.response.data)) {
            if (typeof e.response.data.error === "string") {
              message += `${e.response.data.error} `;
            } else if (typeof e.response.data.message === "string") {
              message += `${e.response.data.message} `;
            }
          }
          message += `[${e.response.status} ${e.response.statusText}]`;
        } else if (typeof e.message === "string") {
          message += e.message;
        } else {
          message += `Failed to download update information!`;
        }
        throw new import_core.ZWaveError(message, import_core.ZWaveErrorCodes.FWUpdateService_RequestError);
      }
    }
    /** Ensures that the device ID used to request a firmware update matches the device the firmware update is for */
    async ensureFirmwareDeviceIdMatches(node, deviceId) {
      if (deviceId.rfRegion !== void 0 && this.rfRegion !== import_core.NOT_KNOWN && deviceId.rfRegion !== this.rfRegion) {
        throw new import_core.ZWaveError(`Cannot update firmware for node ${node.id}: The firmware update is for a different region!`, import_core.ZWaveErrorCodes.FWUpdateService_DeviceMismatch);
      }
      const manufacturerResponse = await node.commandClasses["Manufacturer Specific"].get();
      if (!manufacturerResponse) {
        throw new import_core.ZWaveError(`Cannot check for firmware updates for node ${node.id}: Failed to query fingerprint from the node!`, import_core.ZWaveErrorCodes.FWUpdateService_MissingInformation);
      }
      const versionResponse = await node.commandClasses.Version.get();
      if (!versionResponse) {
        throw new import_core.ZWaveError(`Cannot check for firmware updates for node ${node.id}: Failed to query firmware version from the node!`, import_core.ZWaveErrorCodes.FWUpdateService_MissingInformation);
      }
      if (node.commandClasses.Version.supportsCommand(import_cc.VersionCommand.ZWaveSoftwareGet)) {
        const softwareResponse = await node.commandClasses.Version.getZWaveSoftware();
        if (!softwareResponse) {
          throw new import_core.ZWaveError(`Cannot check for firmware updates for node ${node.id}: Failed to query firmware version from the node!`, import_core.ZWaveErrorCodes.FWUpdateService_MissingInformation);
        }
      }
      if (node.manufacturerId !== deviceId.manufacturerId || node.productType !== deviceId.productType || node.productId !== deviceId.productId) {
        throw new import_core.ZWaveError(`Cannot update firmware for node ${node.id}: The firmware update is for a different device!`, import_core.ZWaveErrorCodes.FWUpdateService_DeviceMismatch);
      } else if (node.firmwareVersion !== deviceId.firmwareVersion) {
        throw new import_core.ZWaveError(`Cannot update firmware for node ${node.id}: The update is for a different original firmware version!`, import_core.ZWaveErrorCodes.FWUpdateService_DeviceMismatch);
      }
    }
    /**
     * Downloads the desired firmware update(s) from the Z-Wave JS firmware update service and updates the firmware of the given node.
     * @param updateInfo The desired entry from the updates array that was returned by {@link getAvailableFirmwareUpdates}.
     * Before applying the update, Z-Wave JS will check whether the device IDs, firmware version and region match.
     *
     * The return value indicates whether the update was successful.
     * **WARNING:** This method will throw instead of returning `false` if invalid arguments are passed or downloading files or starting an update fails.
     */
    async firmwareUpdateOTA(nodeId, updateInfo, options) {
      if (this.isAnyOTAFirmwareUpdateInProgress()) {
        const message = `Failed to start the update: A firmware update is already in progress on this network!`;
        this.driver.controllerLog.print(message, "error");
        throw new import_core.ZWaveError(message, import_core.ZWaveErrorCodes.FirmwareUpdateCC_NetworkBusy);
      }
      if (this.driver.isOTWFirmwareUpdateInProgress()) {
        const message = `Failed to start the update: The controller is currently being updated!`;
        this.driver.controllerLog.print(message, "error");
        throw new import_core.ZWaveError(message, import_core.ZWaveErrorCodes.FirmwareUpdateCC_NetworkBusy);
      }
      const files = updateInfo.files;
      const validateDeviceId = updateInfo.device;
      if (files?.length === 0) {
        throw new import_core.ZWaveError(`At least one update must be provided`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      const node = this.nodes.getOrThrow(nodeId);
      this.driver.controllerLog.logNode(nodeId, `OTA firmware update started, downloading ${files.length} updates...`);
      const loglevel = this.driver.getLogConfig().level;
      const firmwares = [];
      for (let i = 0; i < files.length; i++) {
        const update = files[i];
        let logMessage = `Downloading firmware update ${i} of ${files.length}...`;
        if (loglevel === "silly") {
          logMessage += `
  URL:       ${update.url}
  integrity: ${update.integrity}`;
        }
        this.driver.controllerLog.logNode(nodeId, logMessage);
        try {
          const firmware = await (0, import_FirmwareUpdateService.downloadFirmwareUpdate)(update);
          firmwares.push(firmware);
        } catch (e) {
          let message = `Downloading the firmware update for node ${nodeId} failed:
`;
          if ((0, import_core.isZWaveError)(e)) {
            throw new import_core.ZWaveError(message + e.message, e.code);
          } else if (e.response) {
            if ((0, import_typeguards.isObject)(e.response.data) && typeof e.response.data.message === "string") {
              message += `${e.response.data.message} `;
            }
            message += `[${e.response.status} ${e.response.statusText}]`;
          } else if (typeof e.message === "string") {
            message += e.message;
          } else {
            message += `Failed to download firmware update!`;
          }
          throw new import_core.ZWaveError(message, import_core.ZWaveErrorCodes.FWUpdateService_RequestError);
        }
      }
      if (validateDeviceId) {
        this.driver.controllerLog.logNode(nodeId, `All updates downloaded, validating device IDs...`);
        await this.ensureFirmwareDeviceIdMatches(node, validateDeviceId);
        this.driver.controllerLog.logNode(nodeId, `Device IDs match, installing firmware updates...`);
      } else {
        this.driver.controllerLog.logNode(nodeId, `All updates downloaded, installing...`);
      }
      return node.updateFirmware(firmwares, options);
    }
    _currentLearnMode;
    _joinNetworkOptions;
    async beginJoiningNetwork(options) {
      if (this._currentLearnMode != void 0) {
        return import_Inclusion.JoinNetworkResult.Error_Busy;
      } else if (!this.isLearnModePermitted) {
        return import_Inclusion.JoinNetworkResult.Error_NotPermitted;
      }
      try {
        const result = await this.driver.sendMessage(new import_serialapi.SetLearnModeRequest({
          intent: import_serialapi.LearnModeIntent.Inclusion
        }));
        if (result.isOK()) {
          this._currentLearnMode = import_serialapi.LearnModeIntent.Inclusion;
          this._joinNetworkOptions = options;
          return import_Inclusion.JoinNetworkResult.OK;
        }
      } catch (e) {
        this.driver.controllerLog.print(`Joining a network failed: ${(0, import_shared.getErrorMessage)(e)}`, "error");
      }
      this._currentLearnMode = void 0;
      return import_Inclusion.JoinNetworkResult.Error_Failed;
    }
    async stopJoiningNetwork() {
      if (this._currentLearnMode !== import_serialapi.LearnModeIntent.LegacyInclusionExclusion && this._currentLearnMode !== import_serialapi.LearnModeIntent.Inclusion) {
        return false;
      }
      try {
        const result = await this.driver.sendMessage(new import_serialapi.SetLearnModeRequest({
          // TODO: We should be using .Stop here for the non-legacy
          // inclusion/exclusion, but that command results in a
          // negative response on current firmwares, even though it works.
          // Using LegacyStop avoids that, but results in an unexpected
          // LearnModeFailed callback.
          intent: import_serialapi.LearnModeIntent.LegacyStop
        }));
        if (result.isOK()) {
          this._currentLearnMode = void 0;
          this._joinNetworkOptions = void 0;
          return true;
        }
      } catch (e) {
        this.driver.controllerLog.print(`Failed to stop joining a network: ${(0, import_shared.getErrorMessage)(e)}`, "error");
      }
      return false;
    }
    async beginLeavingNetwork() {
      if (this._currentLearnMode != void 0) {
        return import_Inclusion.LeaveNetworkResult.Error_Busy;
      } else if (!this.isLearnModePermitted) {
        return import_Inclusion.LeaveNetworkResult.Error_NotPermitted;
      }
      try {
        const result = await this.driver.sendMessage(new import_serialapi.SetLearnModeRequest({
          intent: import_serialapi.LearnModeIntent.NetworkWideExclusion
        }));
        if (result.isOK()) {
          this._currentLearnMode = import_serialapi.LearnModeIntent.NetworkWideExclusion;
          return import_Inclusion.LeaveNetworkResult.OK;
        }
      } catch (e) {
        this.driver.controllerLog.print(`Leaving the current network failed: ${(0, import_shared.getErrorMessage)(e)}`, "error");
      }
      this._currentLearnMode = void 0;
      return import_Inclusion.LeaveNetworkResult.Error_Failed;
    }
    async stopLeavingNetwork() {
      if (this._currentLearnMode !== import_serialapi.LearnModeIntent.LegacyInclusionExclusion && this._currentLearnMode !== import_serialapi.LearnModeIntent.LegacyNetworkWideExclusion && this._currentLearnMode !== import_serialapi.LearnModeIntent.DirectExclusion && this._currentLearnMode !== import_serialapi.LearnModeIntent.NetworkWideExclusion) {
        return false;
      }
      try {
        const result = await this.driver.sendMessage(new import_serialapi.SetLearnModeRequest({
          // TODO: We should be using .Stop here for the non-legacy
          // inclusion/exclusion, but that command results in a
          // negative response on current firmwares, even though it works.
          // Using LegacyStop avoids that, but results in an unexpected
          // LearnModeFailed callback.
          intent: import_serialapi.LearnModeIntent.LegacyStop
        }));
        if (result.isOK()) {
          this._currentLearnMode = void 0;
          return true;
        }
      } catch (e) {
        this.driver.controllerLog.print(`Failed to stop leaving a network: ${(0, import_shared.getErrorMessage)(e)}`, "error");
      }
      return false;
    }
    /**
     * Is called when a RemoveNode request is received from the controller.
     * Handles and controls the exclusion process.
     */
    async handleLearnModeCallback(msg) {
      if (this._currentLearnMode == void 0)
        return false;
      const wasJoining = this._currentLearnMode === import_serialapi.LearnModeIntent.Inclusion || this._currentLearnMode === import_serialapi.LearnModeIntent.SmartStart || this._currentLearnMode === import_serialapi.LearnModeIntent.LegacyNetworkWideInclusion || this._currentLearnMode === import_serialapi.LearnModeIntent.LegacyInclusionExclusion && this.role === import_core.ControllerRole.Primary;
      const wasLeaving = this._currentLearnMode === import_serialapi.LearnModeIntent.DirectExclusion || this._currentLearnMode === import_serialapi.LearnModeIntent.NetworkWideExclusion || this._currentLearnMode === import_serialapi.LearnModeIntent.LegacyNetworkWideExclusion || this._currentLearnMode === import_serialapi.LearnModeIntent.LegacyInclusionExclusion && this.role !== import_core.ControllerRole.Primary;
      if (msg.status === import_serialapi.LearnModeStatus.Started) {
        return true;
      } else if (msg.status === import_serialapi.LearnModeStatus.Failed) {
        if (wasJoining) {
          this._currentLearnMode = void 0;
          this._joinNetworkOptions = void 0;
          this.emit("joining network failed");
          return true;
        } else if (wasLeaving) {
          this._currentLearnMode = void 0;
          this.emit("leaving network failed");
          return true;
        }
      } else if (msg.status === import_serialapi.LearnModeStatus.Completed || this._currentLearnMode >= import_serialapi.LearnModeIntent.Inclusion && msg.status === import_serialapi.LearnModeStatus.ProtocolDone) {
        if (wasJoining) {
          this._currentLearnMode = void 0;
          this.driver["_securityManager"] = void 0;
          this.driver["_securityManager2"] = await import_core.SecurityManager2.create();
          this.driver["_securityManagerLR"] = await import_core.SecurityManager2.create();
          this._nodes.clear();
          process.nextTick(() => this.afterJoiningNetwork().catch(import_shared.noop));
          return true;
        } else if (wasLeaving) {
          this._currentLearnMode = void 0;
          this.emit("network left");
          return true;
        }
      }
      return false;
    }
    async expectSecurityBootstrapS0(bootstrappingNode) {
      for (const secClass of import_core.securityClassOrder) {
        if (secClass !== import_core.SecurityClass.S0_Legacy) {
          bootstrappingNode.securityClasses.set(secClass, false);
        }
      }
      const unGrantSecurityClass = /* @__PURE__ */ __name(() => {
        this.driver["_securityManager"] = void 0;
        bootstrappingNode.securityClasses.set(import_core.SecurityClass.S0_Legacy, false);
      }, "unGrantSecurityClass");
      const abortTimeout = /* @__PURE__ */ __name(() => {
        this.driver.controllerLog.logNode(bootstrappingNode.id, {
          message: `Security S0 bootstrapping failed: a secure inclusion timer has elapsed`,
          level: "warn"
        });
        unGrantSecurityClass();
        return import_Inclusion.SecurityBootstrapFailure.Timeout;
      }, "abortTimeout");
      try {
        const api = bootstrappingNode.commandClasses.Security;
        this.driver["_securityManager"] = new import_core.SecurityManager({
          ownNodeId: this._ownNodeId,
          networkKey: new Uint8Array(16).fill(0),
          nonceTimeout: this.driver.options.timeouts.nonce
        });
        await api.reportSecurityScheme(false);
        let nonceGet = await this.driver.waitForCommand((cc) => cc instanceof import_cc.SecurityCCNonceGet, 1e4).catch(() => "timeout");
        if (nonceGet === "timeout")
          return abortTimeout();
        await api.sendNonce();
        const networkKeySet = await this.driver.waitForCommand((cc) => cc instanceof import_cc.SecurityCCNetworkKeySet, 1e4).catch(() => "timeout");
        if (networkKeySet === "timeout")
          return abortTimeout();
        this.driver["_securityManager"] = new import_core.SecurityManager({
          ownNodeId: this._ownNodeId,
          networkKey: networkKeySet.networkKey,
          nonceTimeout: this.driver.options.timeouts.nonce
        });
        let nonce = await api.withOptions({ reportTimeoutMs: 1e4 }).getNonce();
        if (!nonce)
          return abortTimeout();
        await api.verifyNetworkKey();
        nonceGet = await this.driver.waitForCommand((cc) => cc instanceof import_cc.SecurityCCNonceGet, 1e4).catch(() => "timeout");
        if (nonceGet === "timeout")
          return abortTimeout();
        await api.sendNonce();
        const schemeInherit = await this.driver.waitForCommand((cc) => cc instanceof import_cc.SecurityCCSchemeInherit, 1e4).catch(() => "timeout");
        if (schemeInherit === "timeout")
          return abortTimeout();
        nonce = await api.withOptions({ reportTimeoutMs: 1e4 }).getNonce();
        if (!nonce)
          return abortTimeout();
        await api.reportSecurityScheme(true);
        bootstrappingNode.securityClasses.set(import_core.SecurityClass.S0_Legacy, true);
        this.driver.cacheSet(import_NetworkCache.cacheKeys.controller.securityKeys(import_core.SecurityClass.S0_Legacy), networkKeySet.networkKey);
        this.driver.driverLog.print(`Security S0 bootstrapping successful`);
      } catch (e) {
        let errorMessage = `Security S0 bootstrapping failed`;
        let result = import_Inclusion.SecurityBootstrapFailure.Unknown;
        if (!(0, import_core.isZWaveError)(e)) {
          errorMessage += `: ${e}`;
        } else if (e.code === import_core.ZWaveErrorCodes.Controller_MessageExpired) {
          errorMessage += ": a secure inclusion timer has elapsed.";
          result = import_Inclusion.SecurityBootstrapFailure.Timeout;
        } else if (e.code !== import_core.ZWaveErrorCodes.Controller_MessageDropped && e.code !== import_core.ZWaveErrorCodes.Controller_NodeTimeout) {
          errorMessage += `: ${e.message}`;
        }
        this.driver.controllerLog.logNode(bootstrappingNode.id, errorMessage, "warn");
        unGrantSecurityClass();
        return result;
      }
    }
    async expectSecurityBootstrapS2(bootstrappingNode, requested, userCallbacks = this.driver.options.joinNetworkUserCallbacks) {
      const api = bootstrappingNode.commandClasses["Security 2"].withOptions({
        // Do not wait for Nonce Reports after SET-type commands.
        // Timing is critical here
        s2VerifyDelivery: false
      });
      const unGrantSecurityClasses = /* @__PURE__ */ __name(() => {
        for (const secClass of import_core.securityClassOrder) {
          bootstrappingNode.securityClasses.set(secClass, false);
        }
      }, "unGrantSecurityClasses");
      const securityManager = (0, import_core.isLongRangeNodeId)(this._ownNodeId) ? this.driver.securityManagerLR : this.driver.securityManager2;
      if (!securityManager) {
        unGrantSecurityClasses();
        return import_Inclusion.SecurityBootstrapFailure.NoKeysConfigured;
      }
      const receivedKeys = /* @__PURE__ */ new Map();
      const deleteTempKey = /* @__PURE__ */ __name(() => {
        securityManager.deleteNonce(bootstrappingNode.id);
        securityManager.tempKeys.delete(bootstrappingNode.id);
      }, "deleteTempKey");
      let dskHidden = false;
      const applicationHideDSK = /* @__PURE__ */ __name(() => {
        if (dskHidden)
          return;
        dskHidden = true;
        try {
          userCallbacks?.done();
        } catch {
        }
      }, "applicationHideDSK");
      const abort = /* @__PURE__ */ __name(async (failType) => {
        applicationHideDSK();
        if (failType != void 0) {
          try {
            await api.abortKeyExchange(failType);
          } catch {
          }
        }
        unGrantSecurityClasses();
        deleteTempKey();
      }, "abort");
      const abortTimeout = /* @__PURE__ */ __name(async () => {
        this.driver.controllerLog.logNode(bootstrappingNode.id, {
          message: `Security S2 bootstrapping failed: a secure inclusion timer has elapsed`,
          level: "warn"
        });
        await abort();
        return import_Inclusion.SecurityBootstrapFailure.Timeout;
      }, "abortTimeout");
      const abortCanceled = /* @__PURE__ */ __name(async () => {
        this.driver.controllerLog.logNode(bootstrappingNode.id, {
          message: `The including node canceled the Security S2 bootstrapping.`,
          direction: "inbound",
          level: "warn"
        });
        await abort();
        return import_Inclusion.SecurityBootstrapFailure.NodeCanceled;
      }, "abortCanceled");
      try {
        await api.requestKeys({
          requestedKeys: requested.securityClasses,
          requestCSA: false,
          supportedECDHProfiles: [import_cc.ECDHProfiles.Curve25519],
          supportedKEXSchemes: [import_cc.KEXSchemes.KEXScheme1]
        });
        const kexSet = await this.driver.waitForCommand((cc) => cc instanceof import_cc.Security2CCKEXSet || cc instanceof import_cc.Security2CCKEXFail, import_cc.inclusionTimeouts.TB2).catch(() => "timeout");
        if (kexSet === "timeout")
          return abortTimeout();
        if (kexSet instanceof import_cc.Security2CCKEXFail) {
          return abortCanceled();
        }
        if (kexSet.echo) {
          this.driver.controllerLog.logNode(bootstrappingNode.id, {
            message: `Security S2 bootstrapping failed: KEX Set unexpectedly has the echo flag set.`,
            level: "warn"
          });
          await abort(import_cc.KEXFailType.NoVerify);
          return import_Inclusion.SecurityBootstrapFailure.ParameterMismatch;
        } else if (kexSet.selectedKEXScheme !== import_cc.KEXSchemes.KEXScheme1) {
          this.driver.controllerLog.logNode(bootstrappingNode.id, {
            message: `Security S2 bootstrapping failed: Unsupported key exchange scheme.`,
            level: "warn"
          });
          await abort(import_cc.KEXFailType.NoSupportedScheme);
          return import_Inclusion.SecurityBootstrapFailure.ParameterMismatch;
        } else if (kexSet.selectedECDHProfile !== import_cc.ECDHProfiles.Curve25519) {
          this.driver.controllerLog.logNode(bootstrappingNode.id, {
            message: `Security S2 bootstrapping failed: Unsupported ECDH profile.`,
            level: "warn"
          });
          await abort(import_cc.KEXFailType.NoSupportedCurve);
          return import_Inclusion.SecurityBootstrapFailure.ParameterMismatch;
        } else if (kexSet.permitCSA !== false) {
          this.driver.controllerLog.logNode(bootstrappingNode.id, {
            message: `Security S2 bootstrapping failed: CSA granted but not requested.`,
            level: "warn"
          });
          await abort(import_cc.KEXFailType.BootstrappingCanceled);
          return import_Inclusion.SecurityBootstrapFailure.ParameterMismatch;
        }
        const matchingKeys = kexSet.grantedKeys.filter((k) => import_core.securityClassOrder.includes(k) && requested.securityClasses.includes(k));
        if (!matchingKeys.length) {
          this.driver.controllerLog.logNode(bootstrappingNode.id, {
            message: `Security S2 bootstrapping failed: None of the requested security classes are granted.`,
            level: "warn"
          });
          await abort(import_cc.KEXFailType.NoKeyMatch);
          return import_Inclusion.SecurityBootstrapFailure.ParameterMismatch;
        }
        const highestGranted = (0, import_core.getHighestSecurityClass)(matchingKeys);
        const requiresAuthentication = highestGranted === import_core.SecurityClass.S2_AccessControl || highestGranted === import_core.SecurityClass.S2_Authenticated;
        const keyPair = requiresAuthentication ? await this.driver.getLearnModeAuthenticatedKeyPair() : await (0, import_core.generateECDHKeyPair)();
        const transmittedPublicKey = import_shared.Bytes.from(keyPair.publicKey);
        if (requiresAuthentication) {
          transmittedPublicKey.writeUInt16BE(0, 0);
          const dsk = (0, import_core.dskToString)(keyPair.publicKey.subarray(0, 16));
          try {
            userCallbacks?.showDSK(dsk);
          } catch {
          }
        }
        await api.sendPublicKey(transmittedPublicKey, false);
        const pubKeyReport = await this.driver.waitForCommand((cc) => cc instanceof import_cc.Security2CCPublicKeyReport || cc instanceof import_cc.Security2CCKEXFail, import_cc.inclusionTimeouts.TB3).catch(() => "timeout");
        if (pubKeyReport === "timeout")
          return abortTimeout();
        if (pubKeyReport instanceof import_cc.Security2CCKEXFail) {
          return abortCanceled();
        }
        const includingNodePubKey = pubKeyReport.publicKey;
        const sharedSecret = await (0, import_core.deriveSharedECDHSecret)({
          publicKey: includingNodePubKey,
          privateKey: keyPair.privateKey
        });
        const tempKeys = await (0, import_core.deriveTempKeys)(await (0, import_core.computePRK)(sharedSecret, includingNodePubKey, keyPair.publicKey));
        securityManager.deleteNonce(bootstrappingNode.id);
        securityManager.tempKeys.set(bootstrappingNode.id, {
          keyCCM: tempKeys.tempKeyCCM,
          personalizationString: tempKeys.tempPersonalizationString
        });
        const confirmKeysStartTime = Date.now();
        let kexReportEcho;
        for (let i = 0; i <= 25; i++) {
          try {
            kexReportEcho = await api.withOptions({
              reportTimeoutMs: 1e4
            }).confirmGrantedKeys({
              grantedKeys: kexSet.grantedKeys,
              permitCSA: kexSet.permitCSA,
              selectedECDHProfile: kexSet.selectedECDHProfile,
              selectedKEXScheme: kexSet.selectedKEXScheme,
              _reserved: kexSet._reserved
            });
          } catch {
          }
          if (kexReportEcho != void 0)
            break;
          if (Date.now() - confirmKeysStartTime > 24e4)
            break;
        }
        if (!kexReportEcho || kexReportEcho === "timeout") {
          return abortTimeout();
        } else if (kexReportEcho instanceof import_cc.Security2CCKEXFail) {
          return abortCanceled();
        }
        applicationHideDSK();
        if (!kexReportEcho.echo) {
          this.driver.controllerLog.logNode(bootstrappingNode.id, {
            message: `Security S2 bootstrapping failed: KEXReport received without echo flag`,
            direction: "inbound",
            level: "warn"
          });
          await abort(import_cc.KEXFailType.WrongSecurityLevel);
          return import_Inclusion.SecurityBootstrapFailure.NodeCanceled;
        } else if (kexReportEcho.requestCSA !== false) {
          this.driver.controllerLog.logNode(bootstrappingNode.id, {
            message: `Security S2 bootstrapping failed: Invalid KEXReport received`,
            level: "warn"
          });
          await abort(import_cc.KEXFailType.WrongSecurityLevel);
          return import_Inclusion.SecurityBootstrapFailure.NodeCanceled;
        } else if (kexReportEcho._reserved !== 0) {
          this.driver.controllerLog.logNode(bootstrappingNode.id, {
            message: `Security S2 bootstrapping failed: Invalid KEXReport received`,
            direction: "inbound",
            level: "warn"
          });
          await abort(import_cc.KEXFailType.WrongSecurityLevel);
          return import_Inclusion.SecurityBootstrapFailure.NodeCanceled;
        } else if (!kexReportEcho.isEncapsulatedWith(import_core.CommandClasses["Security 2"], import_cc.Security2Command.MessageEncapsulation)) {
          this.driver.controllerLog.logNode(bootstrappingNode.id, {
            message: `Security S2 bootstrapping failed: Command received without encryption`,
            direction: "inbound",
            level: "warn"
          });
          await abort(import_cc.KEXFailType.WrongSecurityLevel);
          return import_Inclusion.SecurityBootstrapFailure.S2WrongSecurityLevel;
        } else if (kexReportEcho.requestedKeys.length !== requested.securityClasses.length || !kexReportEcho.requestedKeys.every((k) => requested.securityClasses.includes(k))) {
          this.driver.controllerLog.logNode(bootstrappingNode.id, {
            message: `Security S2 bootstrapping failed: Granted key mismatch.`,
            level: "warn"
          });
          await abort(import_cc.KEXFailType.WrongSecurityLevel);
          return import_Inclusion.SecurityBootstrapFailure.S2WrongSecurityLevel;
        }
        for (const key of kexSet.grantedKeys) {
          const keyReportPromise = this.driver.waitForCommand((cc) => cc instanceof import_cc.Security2CCNetworkKeyReport || cc instanceof import_cc.Security2CCKEXFail, import_cc.inclusionTimeouts.TB4).catch(() => "timeout");
          await api.requestNetworkKey(key);
          const keyReport = await keyReportPromise;
          if (keyReport === "timeout")
            return abortTimeout();
          if (keyReport instanceof import_cc.Security2CCKEXFail) {
            return abortCanceled();
          }
          if (!keyReport.isEncapsulatedWith(import_core.CommandClasses["Security 2"], import_cc.Security2Command.MessageEncapsulation)) {
            this.driver.controllerLog.logNode(bootstrappingNode.id, {
              message: `Security S2 bootstrapping failed: Command received without encryption`,
              direction: "inbound",
              level: "warn"
            });
            await abort(import_cc.KEXFailType.WrongSecurityLevel);
            return import_Inclusion.SecurityBootstrapFailure.S2WrongSecurityLevel;
          }
          if (!securityManager.hasUsedSecurityClass(bootstrappingNode.id, import_core.SecurityClass.Temporary)) {
            this.driver.controllerLog.logNode(bootstrappingNode.id, {
              message: `Security S2 bootstrapping failed: Node used wrong key to communicate.`,
              level: "warn"
            });
            await abort(import_cc.KEXFailType.WrongSecurityLevel);
            return import_Inclusion.SecurityBootstrapFailure.S2WrongSecurityLevel;
          }
          const securityClass = keyReport.grantedKey;
          if (securityClass !== key) {
            this.driver.controllerLog.logNode(bootstrappingNode.id, {
              message: `Security S2 bootstrapping failed: Received key for wrong security class`,
              direction: "inbound",
              level: "warn"
            });
            await abort(import_cc.KEXFailType.DifferentKey);
            return import_Inclusion.SecurityBootstrapFailure.ParameterMismatch;
          }
          receivedKeys.set(securityClass, keyReport.networkKey);
          await securityManager.setKey(securityClass, keyReport.networkKey);
          if (securityClass === import_core.SecurityClass.S0_Legacy) {
            this.driver["_securityManager"] = new import_core.SecurityManager({
              ownNodeId: this._ownNodeId,
              networkKey: keyReport.networkKey,
              nonceTimeout: this.driver.options.timeouts.nonce
            });
          }
          securityManager.deleteNonce(bootstrappingNode.id);
          await api.withOptions({
            s2OverrideSecurityClass: securityClass
          }).verifyNetworkKey();
          securityManager.deleteNonce(bootstrappingNode.id);
          const transferEnd = await this.driver.waitForCommand((cc) => cc instanceof import_cc.Security2CCTransferEnd || cc instanceof import_cc.Security2CCKEXFail, import_cc.inclusionTimeouts.TB5).catch(() => "timeout");
          if (transferEnd === "timeout")
            return abortTimeout();
          if (transferEnd instanceof import_cc.Security2CCKEXFail) {
            return abortCanceled();
          }
          if (!keyReport.isEncapsulatedWith(import_core.CommandClasses["Security 2"], import_cc.Security2Command.MessageEncapsulation)) {
            this.driver.controllerLog.logNode(bootstrappingNode.id, {
              message: `Security S2 bootstrapping failed: Command received without encryption`,
              direction: "inbound",
              level: "warn"
            });
            await abort(import_cc.KEXFailType.WrongSecurityLevel);
            return import_Inclusion.SecurityBootstrapFailure.S2WrongSecurityLevel;
          } else if (!transferEnd.keyVerified || transferEnd.keyRequestComplete) {
            this.driver.controllerLog.logNode(bootstrappingNode.id, {
              message: `Security S2 bootstrapping failed: Invalid TransferEnd received`,
              direction: "inbound",
              level: "warn"
            });
            await abort(import_cc.KEXFailType.WrongSecurityLevel);
            return import_Inclusion.SecurityBootstrapFailure.NodeCanceled;
          }
        }
        await api.endKeyExchange();
        for (const securityClass of import_core.securityClassOrder) {
          bootstrappingNode.securityClasses.set(securityClass, kexSet.grantedKeys.includes(securityClass));
        }
        for (const [secClass, key] of receivedKeys) {
          this.driver.cacheSet(import_NetworkCache.cacheKeys.controller.securityKeys(secClass), key);
        }
        this.driver.driverLog.print(`Security S2 bootstrapping successful with these security classes:${[
          ...bootstrappingNode.securityClasses.entries()
        ].filter(([, v]) => v).map(([k]) => `
\xB7 ${(0, import_shared.getEnumMemberName)(import_core.SecurityClass, k)}`).join("")}`);
      } catch (e) {
        let errorMessage = `Security S2 bootstrapping failed, no S2 security classes were granted`;
        let result = import_Inclusion.SecurityBootstrapFailure.Unknown;
        if (!(0, import_core.isZWaveError)(e)) {
          errorMessage += `: ${e}`;
        } else if (e.code === import_core.ZWaveErrorCodes.Controller_MessageExpired) {
          errorMessage += ": a secure inclusion timer has elapsed.";
          result = import_Inclusion.SecurityBootstrapFailure.Timeout;
        } else if (e.code !== import_core.ZWaveErrorCodes.Controller_MessageDropped && e.code !== import_core.ZWaveErrorCodes.Controller_NodeTimeout) {
          errorMessage += `: ${e.message}`;
        }
        this.driver.controllerLog.logNode(bootstrappingNode.id, errorMessage, "warn");
        unGrantSecurityClasses();
        bootstrappingNode.removeCC(import_core.CommandClasses["Security 2"]);
        return result;
      } finally {
        deleteTempKey();
      }
    }
    async afterJoiningNetwork() {
      this.driver.driverLog.print("waiting for security bootstrapping...");
      const bootstrapInitStart = Date.now();
      const supportedCCs = (0, import_NodeInformationFrame.determineNIF)().supportedCCs;
      const supportsS0 = supportedCCs.includes(import_core.CommandClasses.Security);
      const supportsS2 = supportedCCs.includes(import_core.CommandClasses["Security 2"]);
      let initTimeout;
      let initPredicate;
      if (supportsS0 && supportsS2) {
        initTimeout = import_cc.inclusionTimeouts.TB1;
        initPredicate = /* @__PURE__ */ __name((cc) => cc instanceof import_cc.SecurityCCSchemeGet || cc instanceof import_cc.Security2CCKEXGet, "initPredicate");
      } else if (supportsS2) {
        initTimeout = import_cc.inclusionTimeouts.TB1;
        initPredicate = /* @__PURE__ */ __name((cc) => cc instanceof import_cc.Security2CCKEXGet, "initPredicate");
      } else if (supportsS0) {
        initTimeout = 1e4;
        initPredicate = /* @__PURE__ */ __name((cc) => cc instanceof import_cc.SecurityCCSchemeGet, "initPredicate");
      } else {
        initTimeout = 0;
        initPredicate = /* @__PURE__ */ __name(() => false, "initPredicate");
      }
      const bootstrapInitPromise = this.driver.waitForCommand(initPredicate, initTimeout).catch(() => "timeout");
      const identifySelf = /* @__PURE__ */ __name(async () => {
        await this.identify().catch(import_shared.noop);
        this.emit("network found", this._homeId, this._ownNodeId);
        await this.getControllerCapabilities().catch(import_shared.noop);
        const { nodeIds } = await this.getSerialApiInitData();
        await this.initNodes(nodeIds, [], () => Promise.resolve());
      }, "identifySelf");
      const [bootstrapInit] = await Promise.all([
        bootstrapInitPromise,
        identifySelf()
      ]);
      if (bootstrapInit === "timeout") {
        this.driver.controllerLog.print("No security bootstrapping command received, continuing without encryption...");
      } else if (bootstrapInit instanceof import_cc.SecurityCCSchemeGet) {
        const nodeId = bootstrapInit.nodeId;
        const bootstrappingNode = this.nodes.get(nodeId);
        if (!bootstrappingNode) {
          this.driver.controllerLog.logNode(nodeId, {
            message: "Received S2 bootstrap initiation from unknown node, ignoring...",
            level: "warn"
          });
        } else if (Date.now() - bootstrapInitStart > 1e4) {
          this.driver.controllerLog.print("Security S0 bootstrapping command received too late, continuing without encryption...");
        } else {
          bootstrappingNode.addCC(import_core.CommandClasses.Security, {
            secure: true,
            isSupported: true
          });
          this.driver.controllerLog.logNode(nodeId, {
            message: `Received S0 bootstrap initiation`
          });
          const bootstrapResult = await this.expectSecurityBootstrapS0(bootstrappingNode);
          if (bootstrapResult !== void 0) {
            bootstrappingNode.removeCC(import_core.CommandClasses.Security);
          }
        }
      } else if (bootstrapInit instanceof import_cc.Security2CCKEXGet) {
        const nodeId = bootstrapInit.nodeId;
        const bootstrappingNode = this.nodes.get(nodeId);
        if (!bootstrappingNode) {
          this.driver.controllerLog.logNode(nodeId, {
            message: "Received S2 bootstrap initiation from unknown node, ignoring...",
            level: "warn"
          });
        } else {
          bootstrappingNode.addCC(import_core.CommandClasses["Security 2"], {
            secure: true,
            isSupported: true
          });
          let grant;
          switch (this._joinNetworkOptions?.strategy) {
            // case JoinNetworkStrategy.Security_S2: {
            // 	grant = this._joinNetworkOptions.requested;
            // 	break;
            // }
            // case JoinNetworkStrategy.SmartStart:
            case import_Inclusion.JoinNetworkStrategy.Default:
            default: {
              grant = {
                securityClasses: [...import_core.securityClassOrder],
                clientSideAuth: false
              };
              break;
            }
          }
          if (grant) {
            this.driver.controllerLog.logNode(nodeId, {
              message: `Received S2 bootstrap initiation, requesting keys: ${grant.securityClasses.map((sc) => `
\xB7 ${(0, import_shared.getEnumMemberName)(import_core.SecurityClass, sc)}
`).join("")}
  client-side auth: ${grant.clientSideAuth}`
            });
            const bootstrapResult = await this.expectSecurityBootstrapS2(bootstrappingNode, grant, this._joinNetworkOptions?.userCallbacks);
            if (bootstrapResult !== void 0) {
              bootstrappingNode.removeCC(import_core.CommandClasses["Security 2"]);
            }
          }
        }
      }
      this._joinNetworkOptions = void 0;
      for (const node of this.nodes.values()) {
        if (node.isControllerNode)
          continue;
        await node["queryProtocolInfo"]();
      }
      this.emit("network joined");
    }
    _proprietary;
    /** Provides access to hardware-specific Serial API functionality */
    get proprietary() {
      if (!this._proprietary) {
        this._proprietary = (0, import_Proprietary.getControllerProprietary)(this.driver, this);
      }
      return this._proprietary;
    }
    destroy() {
      this._nodes.forEach((node) => node.destroy());
      this._nodes.clear();
      this.removeAllListeners();
    }
  };
  return ZWaveController2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ZWaveController
});
//# sourceMappingURL=Controller.js.map
