"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var node_exports = {};
__export(node_exports, {
  discoverRemoteSerialPorts: () => discoverRemoteSerialPorts
});
module.exports = __toCommonJS(node_exports);
var import_shared = require("@zwave-js/shared");
var import_typeguards = require("alcalzone-shared/typeguards");
const domain = "_zwave._tcp.local";
async function discoverRemoteSerialPorts(timeout = 1e3) {
  const { default: createMDNSServer } = await import("mdns-server");
  const mdns = createMDNSServer({
    reuseAddr: true,
    loopback: false,
    noInit: true,
    ttl: 10
  });
  let timer;
  return new Promise((resolve, reject) => {
    mdns.on("response", (resp) => {
      const matches = resp.answers.filter((n) => n.type === "PTR" && n.name === domain && typeof n.data === "string").map(({ data }) => {
        return {
          txt: resp.answers.find((n) => n.type === "TXT" && n.name === data) ?? resp.additionals.find((n) => n.type === "TXT" && n.name === data),
          srv: resp.answers.find((n) => n.type === "SRV" && n.name === data) ?? resp.additionals.find((n) => n.type === "SRV" && n.name === data)
        };
      }).filter(({ srv }) => !!srv && (0, import_typeguards.isObject)(srv.data) && typeof srv.data.target === "string" && typeof srv.data.port === "number").map(({ txt, srv }) => {
        const info = {};
        if (!!txt && (0, import_typeguards.isArray)(txt.data)) {
          const strings = txt.data.filter((d) => (0, import_shared.isUint8Array)(d)).map((d) => import_shared.Bytes.view(d).toString("utf8")).filter((d) => d.includes("="));
          for (const string of strings) {
            const [key, value] = string.split("=", 2);
            info[key] = value;
          }
        }
        const addr = srv.data;
        const protocol = info.protocol?.toLowerCase() === "esphome" ? "esphome" : "tcp";
        const port = `${protocol}://${addr.target}:${addr.port}`;
        return {
          port,
          info
        };
      });
      if (matches.length) {
        clearTimeout(timer);
        resolve(matches);
      }
    });
    mdns.on("ready", () => {
      mdns.query([
        { name: domain, type: "PTR" },
        { name: domain, type: "SRV" },
        { name: domain, type: "TXT" }
      ]);
    });
    mdns.on("error", reject);
    mdns.initServer();
    if (typeof timeout === "number" && timeout > 0) {
      timer = setTimeout(() => {
        mdns.destroy();
        resolve(void 0);
      }, timeout);
    }
  });
}
__name(discoverRemoteSerialPorts, "discoverRemoteSerialPorts");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  discoverRemoteSerialPorts
});
//# sourceMappingURL=node.js.map
