"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Zniffer_exports = {};
__export(Zniffer_exports, {
  ZNIFFER_LABEL: () => ZNIFFER_LABEL,
  ZnifferLogger: () => ZnifferLogger
});
module.exports = __toCommonJS(Zniffer_exports);
var import_cc = require("@zwave-js/cc");
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
const ZNIFFER_LABEL = "ZNIFFR";
const ZNIFFER_LOGLEVEL = "info";
class ZnifferLogger extends import_core.ZWaveLoggerBase {
  static {
    __name(this, "ZnifferLogger");
  }
  zniffer;
  constructor(zniffer, loggers) {
    super(loggers, ZNIFFER_LABEL);
    this.zniffer = zniffer;
  }
  isLogVisible() {
    return this.container.isLoglevelVisible(ZNIFFER_LOGLEVEL);
  }
  /**
   * Logs a message
   * @param msg The message to output
   */
  print(message, level) {
    const actualLevel = level || ZNIFFER_LOGLEVEL;
    if (!this.container.isLoglevelVisible(actualLevel))
      return;
    this.logger.log({
      level: actualLevel,
      message,
      direction: (0, import_core.getDirectionPrefix)("none"),
      context: { source: "zniffer", direction: "none" }
    });
  }
  crcError(frame, rssi) {
    if (!this.isLogVisible())
      return;
    const logEntry = {
      tags: ["CRC ERROR"],
      message: {
        channel: frame.channel,
        "protocol/data rate": (0, import_core.znifferProtocolDataRateToString)(frame.protocolDataRate),
        RSSI: rssi != void 0 ? (0, import_core.rssiToString)(rssi) : frame.rssiRaw.toString(),
        payload: (0, import_shared.buffer2hex)(frame.payload)
      }
    };
    const msg = [(0, import_core.tagify)(logEntry.tags)];
    msg.push(...(0, import_core.messageRecordToLines)(logEntry.message).map((line) => "  " + line));
    try {
      this.logger.log({
        level: "warn",
        message: msg,
        direction: (0, import_core.getDirectionPrefix)("inbound"),
        context: { source: "zniffer", direction: "inbound" }
      });
    } catch {
    }
  }
  mpdu(mpdu, payloadCC) {
    if (!this.isLogVisible())
      return;
    const hasPayload = !!payloadCC || mpdu.payload.length > 0;
    const logEntry = mpdu.toLogEntry();
    let msg = [(0, import_core.tagify)(logEntry.tags)];
    if (logEntry.message) {
      msg.push(...(0, import_core.messageRecordToLines)(logEntry.message).map((line) => (hasPayload ? "\u2502 " : "  ") + line));
    }
    try {
      if (!!payloadCC) {
        msg = msg.filter((line) => !line.startsWith("\u2502 payload:"));
        const logCC = /* @__PURE__ */ __name((cc, indent = 0) => {
          const isEncapCC = (0, import_cc.isEncapsulatingCommandClass)(cc) || (0, import_cc.isMultiEncapsulatingCommandClass)(cc);
          const loggedCC = cc.toLogEntry(this.zniffer);
          msg.push(" ".repeat(indent * 2) + "\u2514\u2500" + (0, import_core.tagify)(loggedCC.tags));
          indent++;
          if (loggedCC.message) {
            msg.push(...(0, import_core.messageRecordToLines)(loggedCC.message).map((line) => `${" ".repeat(indent * 2)}${isEncapCC ? "\u2502 " : "  "}${line}`));
          }
          if ((0, import_cc.isEncapsulatingCommandClass)(cc)) {
            logCC(cc.encapsulated, indent);
          } else if ((0, import_cc.isMultiEncapsulatingCommandClass)(cc)) {
            for (const encap of cc.encapsulated) {
              logCC(encap, indent);
            }
          }
        }, "logCC");
        logCC(payloadCC);
      }
      const homeId = mpdu.homeId.toString(16).padStart(8, "0").toLowerCase();
      this.logger.log({
        level: ZNIFFER_LOGLEVEL,
        secondaryTags: (0, import_core.tagify)([homeId]),
        message: msg,
        direction: (0, import_core.getDirectionPrefix)("inbound"),
        context: { source: "zniffer", direction: "inbound" }
      });
    } catch {
    }
  }
  beam(beam) {
    if (!this.isLogVisible())
      return;
    const logEntry = beam.toLogEntry();
    const msg = [(0, import_core.tagify)(logEntry.tags)];
    if (logEntry.message) {
      msg.push(...(0, import_core.messageRecordToLines)(logEntry.message).map((line) => "  " + line));
    }
    try {
      let secondaryTags;
      if ("homeIdHash" in beam && beam.homeIdHash) {
        secondaryTags = (0, import_core.tagify)([`hash: ${(0, import_shared.num2hex)(beam.homeIdHash)}`]);
      }
      this.logger.log({
        level: ZNIFFER_LOGLEVEL,
        secondaryTags,
        message: msg,
        direction: (0, import_core.getDirectionPrefix)("inbound"),
        context: { source: "zniffer", direction: "inbound" }
      });
    } catch {
    }
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ZNIFFER_LABEL,
  ZnifferLogger
});
//# sourceMappingURL=Zniffer.js.map
