"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var CentralSceneCC_exports = {};
__export(CentralSceneCC_exports, {
  getDefaultCentralSceneHandlerStore: () => getDefaultCentralSceneHandlerStore,
  handleCentralSceneNotification: () => handleCentralSceneNotification
});
module.exports = __toCommonJS(CentralSceneCC_exports);
var import_cc = require("@zwave-js/cc");
var import_shared = require("@zwave-js/shared");
function getDefaultCentralSceneHandlerStore() {
  return {
    keyHeldDownContext: void 0,
    lastSequenceNumber: void 0,
    forcedKeyUp: false
  };
}
__name(getDefaultCentralSceneHandlerStore, "getDefaultCentralSceneHandlerStore");
function handleCentralSceneNotification(ctx, node, command, store) {
  if (command.sequenceNumber === store.lastSequenceNumber) {
    return;
  } else {
    store.lastSequenceNumber = command.sequenceNumber;
  }
  const setSceneValue = /* @__PURE__ */ __name((sceneNumber, key) => {
    const valueId = import_cc.CentralSceneCCValues.scene(sceneNumber).id;
    node.valueDB.setValue(valueId, key, { stateful: false });
  }, "setSceneValue");
  const forceKeyUp = /* @__PURE__ */ __name(() => {
    store.forcedKeyUp = true;
    setSceneValue(store.keyHeldDownContext.sceneNumber, import_cc.CentralSceneKeys.KeyReleased);
    store.keyHeldDownContext?.timeout?.clear();
    store.keyHeldDownContext = void 0;
  }, "forceKeyUp");
  if (store.keyHeldDownContext && store.keyHeldDownContext.sceneNumber !== command.sceneNumber) {
    forceKeyUp();
  }
  const slowRefreshValueId = import_cc.CentralSceneCCValues.slowRefresh.endpoint(command.endpointIndex);
  if (command.keyAttribute === import_cc.CentralSceneKeys.KeyHeldDown) {
    store.forcedKeyUp = false;
    store.keyHeldDownContext?.timeout?.clear();
    const slowRefresh = command.slowRefresh || node.valueDB.getValue(slowRefreshValueId);
    store.keyHeldDownContext = {
      sceneNumber: command.sceneNumber,
      // Unref'ing long running timers allows the process to exit mid-timeout
      timeout: (0, import_shared.setTimer)(forceKeyUp, slowRefresh ? 6e4 : 400).unref()
    };
  } else if (command.keyAttribute === import_cc.CentralSceneKeys.KeyReleased) {
    if (store.keyHeldDownContext) {
      store.keyHeldDownContext.timeout.clear();
      store.keyHeldDownContext = void 0;
    } else if (store.forcedKeyUp) {
      node.valueDB.setValue(slowRefreshValueId, true);
      return;
    }
  }
  setSceneValue(command.sceneNumber, command.keyAttribute);
  ctx.logNode(node.id, {
    message: `received CentralScene notification ${(0, import_shared.stringify)(command)}`,
    direction: "inbound"
  });
}
__name(handleCentralSceneNotification, "handleCentralSceneNotification");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  getDefaultCentralSceneHandlerStore,
  handleCentralSceneNotification
});
//# sourceMappingURL=CentralSceneCC.js.map
