"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var MultilevelSwitchCC_exports = {};
__export(MultilevelSwitchCC_exports, {
  handleMultilevelSwitchCommand: () => handleMultilevelSwitchCommand
});
module.exports = __toCommonJS(MultilevelSwitchCC_exports);
var import_cc = require("@zwave-js/cc");
var import_core = require("@zwave-js/core");
function handleMultilevelSwitchCommand(ctx, node, command) {
  const endpoint = node.getEndpoint(command.endpointIndex ?? 0) ?? node;
  if (command instanceof import_cc.MultilevelSwitchCCSet) {
    ctx.logNode(node.id, {
      endpoint: command.endpointIndex,
      message: "treating MultiLevelSwitchCCSet::Set as a value event"
    });
    node.valueDB.setValue(import_cc.MultilevelSwitchCCValues.compatEvent.endpoint(command.endpointIndex), command.targetValue, {
      stateful: false
    });
  } else if (command instanceof import_cc.MultilevelSwitchCCStartLevelChange) {
    ctx.logNode(node.id, {
      endpoint: command.endpointIndex,
      message: "treating MultilevelSwitchCC::StartLevelChange as a notification"
    });
    node.emit("notification", endpoint, import_core.CommandClasses["Multilevel Switch"], {
      eventType: import_cc.MultilevelSwitchCommand.StartLevelChange,
      eventTypeLabel: "Start level change",
      direction: command.direction
    });
  } else if (command instanceof import_cc.MultilevelSwitchCCStopLevelChange) {
    ctx.logNode(node.id, {
      endpoint: command.endpointIndex,
      message: "treating MultilevelSwitchCC::StopLevelChange as a notification"
    });
    node.emit("notification", endpoint, import_core.CommandClasses["Multilevel Switch"], {
      eventType: import_cc.MultilevelSwitchCommand.StopLevelChange,
      eventTypeLabel: "Stop level change"
    });
  }
}
__name(handleMultilevelSwitchCommand, "handleMultilevelSwitchCommand");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handleMultilevelSwitchCommand
});
//# sourceMappingURL=MultilevelSwitchCC.js.map
