"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var WakeUpCC_exports = {};
__export(WakeUpCC_exports, {
  getDefaultWakeUpHandlerStore: () => getDefaultWakeUpHandlerStore,
  handleWakeUpNotification: () => handleWakeUpNotification
});
module.exports = __toCommonJS(WakeUpCC_exports);
var import_cc = require("@zwave-js/cc");
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_typeguards = require("alcalzone-shared/typeguards");
function getDefaultWakeUpHandlerStore() {
  return {
    lastWakeUp: void 0
  };
}
__name(getDefaultWakeUpHandlerStore, "getDefaultWakeUpHandlerStore");
function handleWakeUpNotification(ctx, node, _command, store) {
  ctx.logNode(node.id, {
    message: `received wakeup notification`,
    direction: "inbound"
  });
  if (node.getCCVersion(import_core.CommandClasses["Wake Up"]) === 0) {
    node.addCC(import_core.CommandClasses["Wake Up"], {
      isSupported: true,
      version: 1
    });
  }
  node.markAsAwake();
  const now = Date.now();
  if (store.lastWakeUp) {
    const wakeUpInterval = node.getValue(import_cc.WakeUpCCValues.wakeUpInterval.id) ?? 1;
    if (wakeUpInterval > 0 && (now - store.lastWakeUp) / 1e3 > wakeUpInterval + 5 * 60) {
      node.commandClasses["Wake Up"].getInterval().catch(() => {
      });
    }
  }
  store.lastWakeUp = now;
  if (node.deviceConfig?.compat?.queryOnWakeup) {
    void compatDoWakeupQueries(ctx, node);
  } else if (!node.deviceConfig?.compat?.disableAutoRefresh) {
    void node.autoRefreshValues().catch(() => {
    });
  }
}
__name(handleWakeUpNotification, "handleWakeUpNotification");
async function compatDoWakeupQueries(ctx, node) {
  if (!node.deviceConfig?.compat?.queryOnWakeup)
    return;
  ctx.logNode(node.id, {
    message: `expects some queries after wake up, so it shall receive`,
    direction: "none"
  });
  for (const [ccName, apiMethod, ...args] of node.deviceConfig.compat.queryOnWakeup) {
    ctx.logNode(node.id, {
      message: `compat query "${ccName}"::${apiMethod}(${args.map((arg) => JSON.stringify(arg)).join(", ")})`,
      direction: "none"
    });
    let API;
    try {
      API = node.commandClasses[ccName].withOptions({
        // Tag the resulting transactions as compat queries
        tag: "compat",
        // Do not retry them or they may cause congestion if the node is asleep again
        maxSendAttempts: 1,
        // This is for a sleeping node - there's no point in keeping the transactions when the node is asleep
        expire: 1e4
      });
    } catch {
      ctx.logNode(node.id, {
        message: `could not access API, skipping query`,
        direction: "none",
        level: "warn"
      });
      continue;
    }
    if (!API.isSupported()) {
      ctx.logNode(node.id, {
        message: `API not supported, skipping query`,
        direction: "none",
        level: "warn"
      });
      continue;
    } else if (!API[apiMethod]) {
      ctx.logNode(node.id, {
        message: `method ${apiMethod} not found on API, skipping query`,
        direction: "none",
        level: "warn"
      });
      continue;
    }
    const method = API[apiMethod].bind(API);
    const methodArgs = args.map((arg) => {
      if ((0, import_typeguards.isObject)(arg)) {
        const valueId = {
          commandClass: API.ccId,
          ...arg
        };
        return node.getValue(valueId);
      }
      return arg;
    });
    try {
      await method(...methodArgs);
      ctx.logNode(node.id, {
        message: `API call successful`,
        direction: "none"
      });
    } catch (e) {
      ctx.logNode(node.id, {
        message: `error during API call: ${(0, import_shared.getErrorMessage)(e)}`,
        direction: "none",
        level: "warn"
      });
      if ((0, import_core.isZWaveError)(e) && e.code === import_core.ZWaveErrorCodes.Controller_MessageExpired) {
        return;
      }
    }
  }
}
__name(compatDoWakeupQueries, "compatDoWakeupQueries");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  getDefaultWakeUpHandlerStore,
  handleWakeUpNotification
});
//# sourceMappingURL=WakeUpCC.js.map
