"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ZWavePlusCC_exports = {};
__export(ZWavePlusCC_exports, {
  handleZWavePlusGet: () => handleZWavePlusGet
});
module.exports = __toCommonJS(ZWavePlusCC_exports);
var import_cc = require("@zwave-js/cc");
var import_core = require("@zwave-js/core");
async function handleZWavePlusGet(ctx, node, command, vendorInfo) {
  const endpoint = node.getEndpoint(command.endpointIndex) ?? node;
  await endpoint.createAPI(import_core.CommandClasses["Z-Wave Plus Info"], false).withOptions({
    // Answer with the same encapsulation as asked, but omit
    // Supervision as it shouldn't be used for Get-Report flows
    encapsulationFlags: command.encapsulationFlags & ~import_core.EncapsulationFlags.Supervision
  }).sendReport({
    zwavePlusVersion: 2,
    roleType: import_cc.ZWavePlusRoleType.CentralStaticController,
    nodeType: import_cc.ZWavePlusNodeType.Node,
    installerIcon: vendorInfo?.installerIcon ?? 1280,
    // Generic Gateway
    userIcon: vendorInfo?.userIcon ?? 1280
    // Generic Gateway
  });
}
__name(handleZWavePlusGet, "handleZWavePlusGet");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handleZWavePlusGet
});
//# sourceMappingURL=ZWavePlusCC.js.map
