"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var NetworkRole_exports = {};
__export(NetworkRole_exports, {
  NetworkRoleMixin: () => NetworkRoleMixin
});
module.exports = __toCommonJS(NetworkRole_exports);
var import_core = require("@zwave-js/core");
var import_NetworkCache = require("../../driver/NetworkCache.js");
var import_Base = require("./00_Base.js");
class NetworkRoleMixin extends import_Base.ZWaveNodeBase {
  static {
    __name(this, "NetworkRoleMixin");
  }
  get isListening() {
    return this.driver.cacheGet(import_NetworkCache.cacheKeys.node(this.id).isListening);
  }
  set isListening(value) {
    this.driver.cacheSet(import_NetworkCache.cacheKeys.node(this.id).isListening, value);
  }
  get isFrequentListening() {
    return this.driver.cacheGet(import_NetworkCache.cacheKeys.node(this.id).isFrequentListening);
  }
  set isFrequentListening(value) {
    this.driver.cacheSet(import_NetworkCache.cacheKeys.node(this.id).isFrequentListening, value);
  }
  get canSleep() {
    if (this.isControllerNode)
      return false;
    if (this.isListening == import_core.NOT_KNOWN)
      return import_core.NOT_KNOWN;
    if (this.isFrequentListening == import_core.NOT_KNOWN)
      return import_core.NOT_KNOWN;
    return !this.isListening && !this.isFrequentListening;
  }
  get isRouting() {
    return this.driver.cacheGet(import_NetworkCache.cacheKeys.node(this.id).isRouting);
  }
  set isRouting(value) {
    this.driver.cacheSet(import_NetworkCache.cacheKeys.node(this.id).isRouting, value);
  }
  get supportedDataRates() {
    return this.driver.cacheGet(import_NetworkCache.cacheKeys.node(this.id).supportedDataRates);
  }
  set supportedDataRates(value) {
    this.driver.cacheSet(import_NetworkCache.cacheKeys.node(this.id).supportedDataRates, value);
  }
  get maxDataRate() {
    if (this.supportedDataRates) {
      return Math.max(...this.supportedDataRates);
    }
  }
  get protocolVersion() {
    return this.driver.cacheGet(import_NetworkCache.cacheKeys.node(this.id).protocolVersion);
  }
  set protocolVersion(value) {
    this.driver.cacheSet(import_NetworkCache.cacheKeys.node(this.id).protocolVersion, value);
  }
  get nodeType() {
    return this.driver.cacheGet(import_NetworkCache.cacheKeys.node(this.id).nodeType);
  }
  set nodeType(value) {
    this.driver.cacheSet(import_NetworkCache.cacheKeys.node(this.id).nodeType, value);
  }
  get supportsSecurity() {
    return this.driver.cacheGet(import_NetworkCache.cacheKeys.node(this.id).supportsSecurity);
  }
  set supportsSecurity(value) {
    this.driver.cacheSet(import_NetworkCache.cacheKeys.node(this.id).supportsSecurity, value);
  }
  get supportsBeaming() {
    return this.driver.cacheGet(import_NetworkCache.cacheKeys.node(this.id).supportsBeaming);
  }
  set supportsBeaming(value) {
    this.driver.cacheSet(import_NetworkCache.cacheKeys.node(this.id).supportsBeaming, value);
  }
  get protocol() {
    return (0, import_core.isLongRangeNodeId)(this.id) ? import_core.Protocols.ZWaveLongRange : import_core.Protocols.ZWave;
  }
  get isControllerNode() {
    return this.id === this.driver.controller.ownNodeId;
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  NetworkRoleMixin
});
//# sourceMappingURL=01_NetworkRole.js.map
