"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Wakeup_exports = {};
__export(Wakeup_exports, {
  NodeWakeupMixin: () => NodeWakeupMixin
});
module.exports = __toCommonJS(Wakeup_exports);
var import_core = require("@zwave-js/core");
var import_Status = require("./20_Status.js");
class NodeWakeupMixin extends import_Status.NodeStatusMixin {
  static {
    __name(this, "NodeWakeupMixin");
  }
  waitForWakeup() {
    if (!this.canSleep || !this.supportsCC(import_core.CommandClasses["Wake Up"])) {
      throw new import_core.ZWaveError(`Node ${this.id} does not support wakeup!`, import_core.ZWaveErrorCodes.CC_NotSupported);
    } else if (this.status === import_core.NodeStatus.Awake) {
      return Promise.resolve();
    }
    return new Promise((resolve) => {
      this._once("wake up", () => resolve());
    });
  }
  isSendingNoMoreInformation = false;
  async sendNoMoreInformation() {
    if (this.keepAwake)
      return false;
    if (this.isSendingNoMoreInformation)
      return false;
    this.isSendingNoMoreInformation = true;
    let msgSent = false;
    if (this.status === import_core.NodeStatus.Awake && this.interviewStage === import_core.InterviewStage.Complete) {
      this.driver.controllerLog.logNode(this.id, {
        message: "Sending node back to sleep...",
        direction: "outbound"
      });
      try {
        await this.commandClasses["Wake Up"].sendNoMoreInformation();
        msgSent = true;
      } catch {
      } finally {
        this.markAsAsleep();
      }
    }
    this.isSendingNoMoreInformation = false;
    return msgSent;
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  NodeWakeupMixin
});
//# sourceMappingURL=30_Wakeup.js.map
