"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Values_exports = {};
__export(Values_exports, {
  NodeValuesMixin: () => NodeValuesMixin
});
module.exports = __toCommonJS(Values_exports);
var import_cc = require("@zwave-js/cc");
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var nodeUtils = __toESM(require("../utils.js"), 1);
var import_Wakeup = require("./30_Wakeup.js");
class NodeValuesMixin extends import_Wakeup.NodeWakeupMixin {
  static {
    __name(this, "NodeValuesMixin");
  }
  constructor(nodeId, driver, endpointIndex, deviceClass, supportedCCs, valueDB) {
    super(nodeId, driver, endpointIndex, deviceClass, supportedCCs);
    this._valueDB = valueDB ?? new import_core.ValueDB(nodeId, driver.valueDB, driver.metadataDB);
    for (const event of [
      "value added",
      "value updated",
      "value removed",
      "value notification",
      "metadata updated"
    ]) {
      this._valueDB.on(event, this.translateValueEvent.bind(this, event));
    }
  }
  _valueDB;
  get valueDB() {
    return this._valueDB;
  }
  getValue(valueId) {
    return this._valueDB.getValue(valueId);
  }
  getValueTimestamp(valueId) {
    return this._valueDB.getTimestamp(valueId);
  }
  getValueMetadata(valueId) {
    const definedCCValues = (0, import_cc.getCCValues)(valueId.commandClass);
    let valueOptions;
    let meta;
    if (definedCCValues) {
      const value = Object.values(definedCCValues).find((v) => v?.is(valueId));
      if (value) {
        if (typeof value !== "function") {
          meta = value.meta;
        }
        valueOptions = value.options;
      }
    }
    const existingMetadata = this._valueDB.getMetadata(valueId);
    return {
      // The priority for returned metadata is valueDB > defined value > Any (default)
      ...existingMetadata ?? meta ?? import_core.ValueMetadata.Any,
      // ...except for these flags, which are taken from defined values:
      stateful: valueOptions?.stateful ?? import_cc.defaultCCValueOptions.stateful,
      secret: valueOptions?.secret ?? import_cc.defaultCCValueOptions.secret
    };
  }
  /**
   * Enhances the raw event args of the ValueDB so it can be consumed better by applications
   */
  translateValueEvent(eventName, arg) {
    const outArg = nodeUtils.translateValueID(this.driver, this, arg);
    if ("source" in outArg)
      delete outArg.source;
    const loglevel = this.driver.getLogConfig().level;
    if ("metadata" in outArg) {
      outArg.metadata = this.getValueMetadata(arg);
    }
    const ccInstance = import_cc.CommandClass.createInstanceUnchecked(this, arg.commandClass);
    const isInternalValue = !!ccInstance?.isInternalValue(arg);
    const isSecretValue = !!ccInstance?.isSecretValue(arg);
    if (loglevel === "silly") {
      this.driver.controllerLog.logNode(this.id, {
        message: `[translateValueEvent: ${eventName}]
  commandClass: ${(0, import_core.getCCName)(arg.commandClass)}
  endpoint:     ${arg.endpoint}
  property:     ${arg.property}
  propertyKey:  ${arg.propertyKey}
  internal:     ${isInternalValue}
  secret:       ${isSecretValue}
  event source: ${arg.source}`,
        level: "silly"
      });
    }
    if (!isSecretValue && arg.source !== "driver") {
      const [changeTarget, changeType] = eventName.split(" ");
      const logArgument = {
        ...outArg,
        nodeId: this.id,
        internal: isInternalValue
      };
      if (changeTarget === "value") {
        this.driver.controllerLog.value(changeType, logArgument);
      } else if (changeTarget === "metadata") {
        this.driver.controllerLog.metadataUpdated(logArgument);
      }
    }
    if (isInternalValue)
      return;
    if (loglevel === "silly") {
      this.driver.controllerLog.logNode(this.id, {
        message: `[translateValueEvent: ${eventName}]
  is root endpoint:        ${!arg.endpoint}
  is application CC:       ${import_core.applicationCCs.includes(arg.commandClass)}
  should hide root values: ${nodeUtils.shouldHideRootApplicationCCValues(this.driver, this.id)}`,
        level: "silly"
      });
    }
    if (
      // Only root endpoint values need to be filtered
      !arg.endpoint && import_core.applicationCCs.includes(arg.commandClass) && nodeUtils.shouldHideRootApplicationCCValues(this.driver, this.id)
    ) {
      for (const endpoint of nodeUtils.getEndpointIndizes(this.driver, this.id)) {
        const possiblyMirroredValueID = {
          // same CC, property and key
          ...(0, import_shared.pick)(arg, ["commandClass", "property", "propertyKey"]),
          // but different endpoint
          endpoint
        };
        if (this.valueDB.hasValue(possiblyMirroredValueID)) {
          if (loglevel === "silly") {
            this.driver.controllerLog.logNode(this.id, {
              message: `[translateValueEvent: ${eventName}] found mirrored value ID on different endpoint, ignoring event:
  commandClass: ${(0, import_core.getCCName)(possiblyMirroredValueID.commandClass)}
  endpoint:     ${possiblyMirroredValueID.endpoint}
  property:     ${possiblyMirroredValueID.property}
  propertyKey:  ${possiblyMirroredValueID.propertyKey}`,
              level: "silly"
            });
          }
          return;
        }
      }
    }
    this._emit(eventName, this, outArg);
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  NodeValuesMixin
});
//# sourceMappingURL=40_Values.js.map
