"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ScheduledPoll_exports = {};
__export(ScheduledPoll_exports, {
  SchedulePollMixin: () => SchedulePollMixin
});
module.exports = __toCommonJS(ScheduledPoll_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_Endpoints = require("./50_Endpoints.js");
class SchedulePollMixin extends import_Endpoints.EndpointsMixin {
  static {
    __name(this, "SchedulePollMixin");
  }
  constructor(nodeId, driver, endpointIndex, deviceClass, supportedCCs, valueDB) {
    super(nodeId, driver, endpointIndex, deviceClass, supportedCCs, valueDB);
    for (const event of ["value updated", "value removed"]) {
      this.valueDB.on(event, (args) => {
        if ("source" in args && args.source === "driver")
          return;
        if (this.cancelScheduledPoll(args, args.newValue)) {
          this.driver.controllerLog.logNode(this.id, "Scheduled poll canceled because expected value was received", "verbose");
        }
      });
    }
  }
  /**
   * All polls that are currently scheduled for this node
   */
  _scheduledPolls = new import_shared.ObjectKeyMap();
  hasScheduledPolls() {
    return this._scheduledPolls.size > 0;
  }
  schedulePoll(valueId, options = {}) {
    const { timeoutMs = this.driver.options.timeouts.refreshValue, expectedValue } = options;
    valueId = (0, import_core.normalizeValueID)(valueId);
    const endpointInstance = this.getEndpoint(valueId.endpoint || 0);
    if (!endpointInstance)
      return false;
    const api = endpointInstance.commandClasses[valueId.commandClass].withOptions({
      // We do not want to delay more important communication by polling, so give it
      // the lowest priority and don't retry unless overwritten by the options
      maxSendAttempts: 1,
      priority: import_core.MessagePriority.Poll
    });
    if (!api.pollValue)
      return false;
    this.cancelScheduledPoll(valueId);
    const timeout = (0, import_shared.setTimer)(async () => {
      this.cancelScheduledPoll(valueId);
      try {
        await api.pollValue.call(api, valueId);
      } catch {
      }
    }, timeoutMs).unref();
    this._scheduledPolls.set(valueId, { timeout, expectedValue });
    return true;
  }
  cancelScheduledPoll(valueId, actualValue) {
    valueId = (0, import_core.normalizeValueID)(valueId);
    const poll = this._scheduledPolls.get(valueId);
    if (!poll)
      return false;
    if (actualValue !== void 0 && poll.expectedValue !== void 0 && !(0, import_core.valueEquals)(poll.expectedValue, actualValue)) {
      return false;
    }
    poll.timeout.clear();
    this._scheduledPolls.delete(valueId);
    return true;
  }
  cancelAllScheduledPolls() {
    for (const valueId of this._scheduledPolls.keys()) {
      this.cancelScheduledPoll(valueId);
    }
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  SchedulePollMixin
});
//# sourceMappingURL=60_ScheduledPoll.js.map
