"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var MultilevelSensor_exports = {};
__export(MultilevelSensor_exports, {
  MultilevelSensorCCBehaviors: () => MultilevelSensorCCBehaviors
});
module.exports = __toCommonJS(MultilevelSensor_exports);
var import_cc = require("@zwave-js/cc");
var import_core = require("@zwave-js/core");
const defaultCapabilities = {
  sensors: {}
  // none
};
const respondToMultilevelSensorGetSupportedSensor = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_cc.MultilevelSensorCCGetSupportedSensor) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Multilevel Sensor"], receivedCC.endpointIndex)
      };
      const cc = new import_cc.MultilevelSensorCCSupportedSensorReport({
        nodeId: controller.ownNodeId,
        supportedSensorTypes: Object.keys(capabilities.sensors).map((t) => parseInt(t))
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToMultilevelSensorGetSupportedScale = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_cc.MultilevelSensorCCGetSupportedScale) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Multilevel Sensor"], receivedCC.endpointIndex)
      };
      const sensorType = receivedCC.sensorType;
      const supportedScales = capabilities.sensors[sensorType]?.supportedScales ?? [];
      const cc = new import_cc.MultilevelSensorCCSupportedScaleReport({
        nodeId: controller.ownNodeId,
        sensorType,
        supportedScales
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToMultilevelSensorGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_cc.MultilevelSensorCCGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Multilevel Sensor"], receivedCC.endpointIndex)
      };
      const firstSupportedSensorType = Object.keys(capabilities.sensors).length > 0 ? parseInt(Object.keys(capabilities.sensors)[0]) : void 0;
      const sensorType = receivedCC.sensorType ?? firstSupportedSensorType ?? 1;
      const scale = receivedCC.scale ?? capabilities.sensors[sensorType].supportedScales[0] ?? 0;
      const value = capabilities.getValue?.(sensorType, scale) ?? 0;
      const cc = new import_cc.MultilevelSensorCCReport({
        nodeId: controller.ownNodeId,
        type: sensorType,
        scale,
        value
      });
      return { action: "sendCC", cc };
    }
  }
};
const MultilevelSensorCCBehaviors = [
  respondToMultilevelSensorGetSupportedSensor,
  respondToMultilevelSensorGetSupportedScale,
  respondToMultilevelSensorGet
];
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  MultilevelSensorCCBehaviors
});
//# sourceMappingURL=MultilevelSensor.js.map
