"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ScheduleEntryLock_exports = {};
__export(ScheduleEntryLock_exports, {
  ScheduleEntryLockCCBehaviors: () => ScheduleEntryLockCCBehaviors
});
module.exports = __toCommonJS(ScheduleEntryLock_exports);
var import_cc = require("@zwave-js/cc");
var import_ScheduleEntryLockCC = require("@zwave-js/cc/ScheduleEntryLockCC");
var import_core = require("@zwave-js/core");
var import_UserCode = require("./UserCode.js");
const defaultCapabilities = {
  numWeekDaySlots: 1,
  numYearDaySlots: 0,
  numDailyRepeatingSlots: 0
};
const STATE_KEY_PREFIX = "ScheduleEntryLock_";
const StateKeys = {
  standardOffset: `${STATE_KEY_PREFIX}standardOffset`,
  dstOffset: `${STATE_KEY_PREFIX}dstOffset`,
  schedule: /* @__PURE__ */ __name((userId, slotId, kind) => `${STATE_KEY_PREFIX}schedule_${userId}_${slotId}_${kind}`, "schedule")
};
const respondToScheduleEntryLockSupportedGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ScheduleEntryLockCC.ScheduleEntryLockCCSupportedGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Schedule Entry Lock"], receivedCC.endpointIndex)
      };
      const cc = new import_ScheduleEntryLockCC.ScheduleEntryLockCCSupportedReport({
        nodeId: controller.ownNodeId,
        ...capabilities
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToScheduleEntryLockTimeOffsetSet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ScheduleEntryLockCC.ScheduleEntryLockCCTimeOffsetSet) {
      self.state.set(StateKeys.standardOffset, receivedCC.standardOffset);
      self.state.set(StateKeys.dstOffset, receivedCC.dstOffset);
      return { action: "ok" };
    }
  }
};
const respondToScheduleEntryLockTimeOffsetGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ScheduleEntryLockCC.ScheduleEntryLockCCTimeOffsetGet) {
      const cc = new import_ScheduleEntryLockCC.ScheduleEntryLockCCTimeOffsetReport({
        nodeId: controller.ownNodeId,
        standardOffset: self.state.get(StateKeys.standardOffset) ?? 0,
        dstOffset: self.state.get(StateKeys.dstOffset) ?? 0
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToScheduleEntryLockEnableSet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ScheduleEntryLockCC.ScheduleEntryLockCCEnableSet) {
      return { action: "ok" };
    }
  }
};
const respondToScheduleEntryLockEnableAllSet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ScheduleEntryLockCC.ScheduleEntryLockCCEnableAllSet) {
      return { action: "ok" };
    }
  }
};
const respondToScheduleEntryLockWeekDayScheduleSet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ScheduleEntryLockCC.ScheduleEntryLockCCWeekDayScheduleSet) {
      const userCodeCapabilities = {
        ...import_UserCode.defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["User Code"], receivedCC.endpointIndex)
      };
      const userId = receivedCC.userId;
      if (userId > userCodeCapabilities.numUsers) {
        return { action: "fail" };
      }
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Schedule Entry Lock"], receivedCC.endpointIndex)
      };
      const slotId = receivedCC.slotId;
      if (slotId > capabilities.numWeekDaySlots) {
        return { action: "fail" };
      }
      const kind = import_cc.ScheduleEntryLockScheduleKind.WeekDay;
      const schedule = receivedCC.action === import_cc.ScheduleEntryLockSetAction.Set ? {
        weekday: receivedCC.weekday,
        startHour: receivedCC.startHour,
        startMinute: receivedCC.startMinute,
        stopHour: receivedCC.stopHour,
        stopMinute: receivedCC.stopMinute
      } : void 0;
      self.state.set(StateKeys.schedule(userId, slotId, kind), schedule);
      return { action: "ok" };
    }
  }
};
const respondToScheduleEntryLockWeekDayScheduleGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ScheduleEntryLockCC.ScheduleEntryLockCCWeekDayScheduleGet) {
      const userCodeCapabilities = {
        ...import_UserCode.defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["User Code"], receivedCC.endpointIndex)
      };
      const userId = receivedCC.userId;
      if (userId > userCodeCapabilities.numUsers) {
        return { action: "fail" };
      }
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Schedule Entry Lock"], receivedCC.endpointIndex)
      };
      const slotId = receivedCC.slotId;
      if (slotId > capabilities.numWeekDaySlots) {
        return { action: "fail" };
      }
      const kind = import_cc.ScheduleEntryLockScheduleKind.WeekDay;
      const schedule = self.state.get(StateKeys.schedule(userId, slotId, kind)) ?? {};
      const cc = new import_ScheduleEntryLockCC.ScheduleEntryLockCCWeekDayScheduleReport({
        nodeId: controller.ownNodeId,
        userId,
        slotId,
        ...schedule
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToScheduleEntryLockYearDayScheduleSet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ScheduleEntryLockCC.ScheduleEntryLockCCYearDayScheduleSet) {
      const userCodeCapabilities = {
        ...import_UserCode.defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["User Code"], receivedCC.endpointIndex)
      };
      const userId = receivedCC.userId;
      if (userId > userCodeCapabilities.numUsers) {
        return { action: "fail" };
      }
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Schedule Entry Lock"], receivedCC.endpointIndex)
      };
      const slotId = receivedCC.slotId;
      if (slotId > capabilities.numYearDaySlots) {
        return { action: "fail" };
      }
      const kind = import_cc.ScheduleEntryLockScheduleKind.YearDay;
      const schedule = receivedCC.action === import_cc.ScheduleEntryLockSetAction.Set ? {
        startYear: receivedCC.startYear,
        startMonth: receivedCC.startMonth,
        startDay: receivedCC.startDay,
        startHour: receivedCC.startHour,
        startMinute: receivedCC.startMinute,
        stopYear: receivedCC.stopYear,
        stopMonth: receivedCC.stopMonth,
        stopDay: receivedCC.stopDay,
        stopHour: receivedCC.stopHour,
        stopMinute: receivedCC.stopMinute
      } : void 0;
      self.state.set(StateKeys.schedule(userId, slotId, kind), schedule);
      return { action: "ok" };
    }
  }
};
const respondToScheduleEntryLockYearDayScheduleGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ScheduleEntryLockCC.ScheduleEntryLockCCYearDayScheduleGet) {
      const userCodeCapabilities = {
        ...import_UserCode.defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["User Code"], receivedCC.endpointIndex)
      };
      const userId = receivedCC.userId;
      if (userId > userCodeCapabilities.numUsers) {
        return { action: "fail" };
      }
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Schedule Entry Lock"], receivedCC.endpointIndex)
      };
      const slotId = receivedCC.slotId;
      if (slotId > capabilities.numYearDaySlots) {
        return { action: "fail" };
      }
      const kind = import_cc.ScheduleEntryLockScheduleKind.YearDay;
      const schedule = self.state.get(StateKeys.schedule(userId, slotId, kind)) ?? {};
      const cc = new import_ScheduleEntryLockCC.ScheduleEntryLockCCYearDayScheduleReport({
        nodeId: controller.ownNodeId,
        userId,
        slotId,
        ...schedule
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToScheduleEntryLockDailyRepeatingScheduleSet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ScheduleEntryLockCC.ScheduleEntryLockCCDailyRepeatingScheduleSet) {
      const userCodeCapabilities = {
        ...import_UserCode.defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["User Code"], receivedCC.endpointIndex)
      };
      const userId = receivedCC.userId;
      if (userId > userCodeCapabilities.numUsers) {
        return { action: "fail" };
      }
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Schedule Entry Lock"], receivedCC.endpointIndex)
      };
      const slotId = receivedCC.slotId;
      if (slotId > capabilities.numDailyRepeatingSlots) {
        return { action: "fail" };
      }
      const kind = import_cc.ScheduleEntryLockScheduleKind.DailyRepeating;
      const schedule = receivedCC.action === import_cc.ScheduleEntryLockSetAction.Set ? {
        weekdays: receivedCC.weekdays,
        startHour: receivedCC.startHour,
        startMinute: receivedCC.startMinute,
        durationHour: receivedCC.durationHour,
        durationMinute: receivedCC.durationMinute
      } : void 0;
      self.state.set(StateKeys.schedule(userId, slotId, kind), schedule);
      return { action: "ok" };
    }
  }
};
const respondToScheduleEntryLockDailyRepeatingScheduleGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ScheduleEntryLockCC.ScheduleEntryLockCCDailyRepeatingScheduleGet) {
      const userCodeCapabilities = {
        ...import_UserCode.defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["User Code"], receivedCC.endpointIndex)
      };
      const userId = receivedCC.userId;
      if (userId > userCodeCapabilities.numUsers) {
        return { action: "fail" };
      }
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Schedule Entry Lock"], receivedCC.endpointIndex)
      };
      const slotId = receivedCC.slotId;
      if (slotId > capabilities.numDailyRepeatingSlots) {
        return { action: "fail" };
      }
      const kind = import_cc.ScheduleEntryLockScheduleKind.DailyRepeating;
      const schedule = self.state.get(StateKeys.schedule(userId, slotId, kind)) ?? {};
      const cc = new import_ScheduleEntryLockCC.ScheduleEntryLockCCDailyRepeatingScheduleReport({
        nodeId: controller.ownNodeId,
        userId,
        slotId,
        ...schedule
      });
      return { action: "sendCC", cc };
    }
  }
};
const ScheduleEntryLockCCBehaviors = [
  respondToScheduleEntryLockSupportedGet,
  respondToScheduleEntryLockTimeOffsetSet,
  respondToScheduleEntryLockTimeOffsetGet,
  respondToScheduleEntryLockEnableSet,
  respondToScheduleEntryLockEnableAllSet,
  respondToScheduleEntryLockWeekDayScheduleSet,
  respondToScheduleEntryLockWeekDayScheduleGet,
  respondToScheduleEntryLockYearDayScheduleSet,
  respondToScheduleEntryLockYearDayScheduleGet,
  respondToScheduleEntryLockDailyRepeatingScheduleSet,
  respondToScheduleEntryLockDailyRepeatingScheduleGet
];
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ScheduleEntryLockCCBehaviors
});
//# sourceMappingURL=ScheduleEntryLock.js.map
