"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ThermostatSetpoint_exports = {};
__export(ThermostatSetpoint_exports, {
  ThermostatSetpointCCBehaviors: () => ThermostatSetpointCCBehaviors
});
module.exports = __toCommonJS(ThermostatSetpoint_exports);
var import_cc = require("@zwave-js/cc");
var import_ThermostatSetpointCC = require("@zwave-js/cc/ThermostatSetpointCC");
var import_core = require("@zwave-js/core");
const defaultCapabilities = {
  setpoints: {
    [import_cc.ThermostatSetpointType.Heating]: {
      minValue: 0,
      maxValue: 100,
      scale: "\xB0C"
    }
  }
};
const STATE_KEY_PREFIX = "ThermostatSetpoint_";
const StateKeys = {
  setpoint: /* @__PURE__ */ __name((type) => `${STATE_KEY_PREFIX}setpoint_${type}`, "setpoint"),
  scale: /* @__PURE__ */ __name((type) => `${STATE_KEY_PREFIX}scale_${type}`, "scale")
};
const respondToThermostatSetpointSet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ThermostatSetpointCC.ThermostatSetpointCCSet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Thermostat Setpoint"], receivedCC.endpointIndex)
      };
      const setpointCaps = capabilities.setpoints[receivedCC.setpointType];
      if (!setpointCaps)
        return { action: "fail" };
      const value = receivedCC.value;
      if (value > setpointCaps.minValue || value > setpointCaps.maxValue) {
        return { action: "fail" };
      }
      self.state.set(StateKeys.setpoint(receivedCC.setpointType), value);
      self.state.set(StateKeys.scale(receivedCC.setpointType), receivedCC.scale);
      return { action: "ok" };
    }
  }
};
const respondToThermostatSetpointGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ThermostatSetpointCC.ThermostatSetpointCCGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Thermostat Setpoint"], receivedCC.endpointIndex)
      };
      const setpointType = receivedCC.setpointType;
      const setpointCaps = capabilities.setpoints[setpointType];
      let value = self.state.get(StateKeys.setpoint(setpointType));
      let scale = self.state.get(StateKeys.scale(setpointType));
      if (setpointCaps) {
        if (value === void 0) {
          value = setpointCaps.defaultValue ?? setpointCaps.minValue;
        }
        if (scale === void 0) {
          scale = setpointCaps.scale === "\xB0F" ? 1 : 0;
        }
      }
      let cc;
      if (value !== void 0) {
        cc = new import_ThermostatSetpointCC.ThermostatSetpointCCReport({
          nodeId: controller.ownNodeId,
          type: setpointType,
          value,
          scale: scale ?? 0
        });
      } else {
        cc = new import_ThermostatSetpointCC.ThermostatSetpointCCReport({
          nodeId: controller.ownNodeId,
          type: import_cc.ThermostatSetpointType["N/A"],
          scale: 0,
          value: 0
        });
      }
      return { action: "sendCC", cc };
    }
  }
};
const respondToThermostatSetpointSupportedGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ThermostatSetpointCC.ThermostatSetpointCCSupportedGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Thermostat Setpoint"], receivedCC.endpointIndex)
      };
      const cc = new import_ThermostatSetpointCC.ThermostatSetpointCCSupportedReport({
        nodeId: controller.ownNodeId,
        supportedSetpointTypes: Object.keys(capabilities.setpoints).map((k) => parseInt(k))
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToThermostatSetpointCapabilitiesGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_ThermostatSetpointCC.ThermostatSetpointCCCapabilitiesGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Thermostat Setpoint"], receivedCC.endpointIndex)
      };
      const setpointType = receivedCC.setpointType;
      const setpointCaps = capabilities.setpoints[setpointType];
      let cc;
      if (setpointCaps) {
        cc = new import_ThermostatSetpointCC.ThermostatSetpointCCCapabilitiesReport({
          nodeId: controller.ownNodeId,
          type: setpointType,
          minValue: setpointCaps.minValue,
          maxValue: setpointCaps.maxValue,
          minValueScale: setpointCaps.scale === "\xB0C" ? 0 : 1,
          maxValueScale: setpointCaps.scale === "\xB0C" ? 0 : 1
        });
      } else {
        cc = new import_ThermostatSetpointCC.ThermostatSetpointCCCapabilitiesReport({
          nodeId: controller.ownNodeId,
          type: import_cc.ThermostatSetpointType["N/A"],
          minValue: 0,
          maxValue: 0,
          minValueScale: 0,
          maxValueScale: 0
        });
      }
      return { action: "sendCC", cc };
    }
  }
};
const ThermostatSetpointCCBehaviors = [
  respondToThermostatSetpointGet,
  respondToThermostatSetpointSet,
  respondToThermostatSetpointSupportedGet,
  respondToThermostatSetpointCapabilitiesGet
];
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ThermostatSetpointCCBehaviors
});
//# sourceMappingURL=ThermostatSetpoint.js.map
