"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var UserCode_exports = {};
__export(UserCode_exports, {
  UserCodeCCBehaviors: () => UserCodeCCBehaviors,
  defaultCapabilities: () => defaultCapabilities
});
module.exports = __toCommonJS(UserCode_exports);
var import_cc = require("@zwave-js/cc");
var import_UserCodeCC = require("@zwave-js/cc/UserCodeCC");
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
const defaultCapabilities = {
  numUsers: 1,
  supportedASCIIChars: "0123456789",
  supportsAdminCode: true,
  supportsAdminCodeDeactivation: true,
  supportsUserCodeChecksum: true,
  supportedKeypadModes: [import_cc.KeypadMode.Normal],
  supportedUserIDStatuses: [
    import_cc.UserIDStatus.Available,
    import_cc.UserIDStatus.Enabled,
    import_cc.UserIDStatus.Disabled
  ]
};
const STATE_KEY_PREFIX = "UserCode_";
const StateKeys = {
  userCode: /* @__PURE__ */ __name((userId) => `${STATE_KEY_PREFIX}userCode_${userId}`, "userCode"),
  userIdStatus: /* @__PURE__ */ __name((userId) => `${STATE_KEY_PREFIX}userIdStatus_${userId}`, "userIdStatus"),
  adminCode: `${STATE_KEY_PREFIX}adminCode`,
  keypadMode: `${STATE_KEY_PREFIX}keypadMode`
};
const respondToUsersNumberGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_UserCodeCC.UserCodeCCUsersNumberGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["User Code"], receivedCC.endpointIndex)
      };
      const cc = new import_UserCodeCC.UserCodeCCUsersNumberReport({
        nodeId: controller.ownNodeId,
        supportedUsers: capabilities.numUsers ?? 1
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToUserGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_UserCodeCC.UserCodeCCGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["User Code"], receivedCC.endpointIndex)
      };
      const userId = receivedCC.userId;
      let cc;
      if (capabilities.numUsers >= userId) {
        cc = new import_UserCodeCC.UserCodeCCReport({
          nodeId: controller.ownNodeId,
          userId,
          userIdStatus: self.state.get(StateKeys.userIdStatus(userId)) ?? import_cc.UserIDStatus.Available,
          userCode: self.state.get(StateKeys.userCode(userId))
        });
      } else {
        cc = new import_UserCodeCC.UserCodeCCReport({
          nodeId: controller.ownNodeId,
          userId,
          userIdStatus: import_cc.UserIDStatus.StatusNotAvailable
        });
      }
      return { action: "sendCC", cc };
    }
  }
};
const respondToUserCodeSet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_UserCodeCC.UserCodeCCSet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["User Code"], receivedCC.endpointIndex)
      };
      const userId = receivedCC.userId;
      const userIdStatus = receivedCC.userIdStatus;
      if (capabilities.numUsers >= userId) {
        self.state.set(StateKeys.userIdStatus(userId), userIdStatus);
        const code = userIdStatus !== import_cc.UserIDStatus.Available && userIdStatus !== import_cc.UserIDStatus.StatusNotAvailable ? receivedCC.userCode : void 0;
        self.state.set(StateKeys.userCode(userId), code);
        return { action: "ok" };
      }
      return { action: "fail" };
    }
  }
};
const respondToUserCodeCapabilitiesGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_UserCodeCC.UserCodeCCCapabilitiesGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["User Code"], receivedCC.endpointIndex)
      };
      const cc = new import_UserCodeCC.UserCodeCCCapabilitiesReport({
        nodeId: controller.ownNodeId,
        supportsAdminCode: capabilities.supportsAdminCode,
        supportsAdminCodeDeactivation: capabilities.supportsAdminCodeDeactivation,
        supportsUserCodeChecksum: capabilities.supportsUserCodeChecksum,
        supportsMultipleUserCodeReport: false,
        supportsMultipleUserCodeSet: false,
        supportedUserIDStatuses: capabilities.supportedUserIDStatuses,
        supportedKeypadModes: capabilities.supportedKeypadModes,
        supportedASCIIChars: capabilities.supportedASCIIChars
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToUserCodeKeypadModeGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_UserCodeCC.UserCodeCCKeypadModeGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["User Code"], receivedCC.endpointIndex)
      };
      const cc = new import_UserCodeCC.UserCodeCCKeypadModeReport({
        nodeId: controller.ownNodeId,
        keypadMode: self.state.get(StateKeys.keypadMode) ?? capabilities.supportedKeypadModes?.[0] ?? import_cc.KeypadMode.Normal
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToUserCodeKeypadModeSet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_UserCodeCC.UserCodeCCKeypadModeSet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["User Code"], receivedCC.endpointIndex)
      };
      if (capabilities.supportedKeypadModes?.includes(receivedCC.keypadMode)) {
        self.state.set(StateKeys.keypadMode, receivedCC.keypadMode);
        return { action: "ok" };
      }
      return { action: "fail" };
    }
  }
};
const respondToUserCodeAdminCodeSet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_UserCodeCC.UserCodeCCAdminCodeSet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["User Code"], receivedCC.endpointIndex)
      };
      const adminCode = receivedCC.adminCode;
      if (capabilities.supportsAdminCode) {
        if (adminCode.length > 0 || capabilities.supportsAdminCodeDeactivation) {
          self.state.set(StateKeys.adminCode, receivedCC.adminCode);
          return { action: "ok" };
        }
      }
      return { action: "fail" };
    }
  }
};
const respondToUserCodeAdminCodeGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_UserCodeCC.UserCodeCCAdminCodeGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["User Code"], receivedCC.endpointIndex)
      };
      let adminCode;
      if (capabilities.supportsAdminCode) {
        adminCode = self.state.get(StateKeys.adminCode);
      }
      const cc = new import_UserCodeCC.UserCodeCCAdminCodeReport({
        nodeId: controller.ownNodeId,
        adminCode: adminCode ?? ""
      });
      return { action: "sendCC", cc };
    }
  }
};
const respondToUserCodeUserCodeChecksumGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_UserCodeCC.UserCodeCCUserCodeChecksumGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["User Code"], receivedCC.endpointIndex)
      };
      if (capabilities.supportsUserCodeChecksum) {
        let data = new import_shared.Bytes();
        for (let i = 1; i <= capabilities.numUsers; i++) {
          const status = self.state.get(StateKeys.userIdStatus(i));
          let code = self.state.get(StateKeys.userCode(i)) ?? "";
          if (status === void 0 || status === import_cc.UserIDStatus.Available || code.length === 0) {
            continue;
          }
          const tmp = new import_shared.Bytes(3 + code.length);
          tmp.writeUInt16BE(i, 0);
          tmp[2] = status;
          if (typeof code === "string") {
            code = import_shared.Bytes.from(code, "ascii");
          }
          tmp.set(code, 3);
          data = import_shared.Bytes.concat([data, tmp]);
        }
        const checksum = data.length > 0 ? (0, import_core.CRC16_CCITT)(data) : 0;
        const cc = new import_UserCodeCC.UserCodeCCUserCodeChecksumReport({
          nodeId: controller.ownNodeId,
          userCodeChecksum: checksum
        });
        return { action: "sendCC", cc };
      }
      return { action: "stop" };
    }
  }
};
const UserCodeCCBehaviors = [
  respondToUsersNumberGet,
  respondToUserGet,
  respondToUserCodeSet,
  respondToUserCodeCapabilitiesGet,
  respondToUserCodeKeypadModeGet,
  respondToUserCodeKeypadModeSet,
  respondToUserCodeAdminCodeGet,
  respondToUserCodeAdminCodeSet,
  respondToUserCodeUserCodeChecksumGet
];
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  UserCodeCCBehaviors,
  defaultCapabilities
});
//# sourceMappingURL=UserCode.js.map
