"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var WindowCovering_exports = {};
__export(WindowCovering_exports, {
  WindowCoveringCCBehaviors: () => WindowCoveringCCBehaviors
});
module.exports = __toCommonJS(WindowCovering_exports);
var import_WindowCoveringCC = require("@zwave-js/cc/WindowCoveringCC");
var import_core = require("@zwave-js/core");
const defaultCapabilities = {
  supportedParameters: []
};
const respondToWindowCoveringSupportedGet = {
  handleCC(controller, self, receivedCC) {
    if (receivedCC instanceof import_WindowCoveringCC.WindowCoveringCCSupportedGet) {
      const capabilities = {
        ...defaultCapabilities,
        ...self.getCCCapabilities(import_core.CommandClasses["Window Covering"], receivedCC.endpointIndex)
      };
      const cc = new import_WindowCoveringCC.WindowCoveringCCSupportedReport({
        nodeId: controller.ownNodeId,
        supportedParameters: capabilities.supportedParameters
      });
      return { action: "sendCC", cc };
    }
  }
};
const WindowCoveringCCBehaviors = [respondToWindowCoveringSupportedGet];
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  WindowCoveringCCBehaviors
});
//# sourceMappingURL=WindowCovering.js.map
