"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var utils_exports = {};
__export(utils_exports, {
  endpointCountIsDynamic: () => endpointCountIsDynamic,
  endpointsHaveIdenticalCapabilities: () => endpointsHaveIdenticalCapabilities,
  filterRootApplicationCCValueIDs: () => filterRootApplicationCCValueIDs,
  getAggregatedEndpointCount: () => getAggregatedEndpointCount,
  getAllEndpoints: () => getAllEndpoints,
  getDefinedValueIDs: () => getDefinedValueIDs,
  getDefinedValueIDsInternal: () => getDefinedValueIDsInternal,
  getEndpointCount: () => getEndpointCount,
  getEndpointIndizes: () => getEndpointIndizes,
  getIndividualEndpointCount: () => getIndividualEndpointCount,
  getSupportedNotificationEvents: () => getSupportedNotificationEvents,
  isMultiChannelInterviewComplete: () => isMultiChannelInterviewComplete,
  setAggregatedEndpointCount: () => setAggregatedEndpointCount,
  setEndpointIndizes: () => setEndpointIndizes,
  setIndividualEndpointCount: () => setIndividualEndpointCount,
  setMultiChannelInterviewComplete: () => setMultiChannelInterviewComplete,
  shouldHideRootApplicationCCValues: () => shouldHideRootApplicationCCValues,
  translateValueID: () => translateValueID
});
module.exports = __toCommonJS(utils_exports);
var import_cc = require("@zwave-js/cc");
var import_MultiChannelCC = require("@zwave-js/cc/MultiChannelCC");
var import_core = require("@zwave-js/core");
function getValue(ctx, nodeId, valueId) {
  return ctx.getValueDB(nodeId).getValue(valueId);
}
__name(getValue, "getValue");
function setValue(ctx, nodeId, valueId, value, options) {
  return ctx.getValueDB(nodeId).setValue(valueId, value, options);
}
__name(setValue, "setValue");
function endpointCountIsDynamic(ctx, nodeId) {
  return getValue(ctx, nodeId, import_MultiChannelCC.MultiChannelCCValues.endpointCountIsDynamic.id);
}
__name(endpointCountIsDynamic, "endpointCountIsDynamic");
function endpointsHaveIdenticalCapabilities(ctx, nodeId) {
  return getValue(ctx, nodeId, import_MultiChannelCC.MultiChannelCCValues.endpointsHaveIdenticalCapabilities.id);
}
__name(endpointsHaveIdenticalCapabilities, "endpointsHaveIdenticalCapabilities");
function getIndividualEndpointCount(ctx, nodeId) {
  return getValue(ctx, nodeId, import_MultiChannelCC.MultiChannelCCValues.individualEndpointCount.id);
}
__name(getIndividualEndpointCount, "getIndividualEndpointCount");
function getAggregatedEndpointCount(ctx, nodeId) {
  return getValue(ctx, nodeId, import_MultiChannelCC.MultiChannelCCValues.aggregatedEndpointCount.id);
}
__name(getAggregatedEndpointCount, "getAggregatedEndpointCount");
function getEndpointCount(ctx, nodeId) {
  return (getIndividualEndpointCount(ctx, nodeId) || 0) + (getAggregatedEndpointCount(ctx, nodeId) || 0);
}
__name(getEndpointCount, "getEndpointCount");
function setIndividualEndpointCount(ctx, nodeId, count) {
  setValue(ctx, nodeId, import_MultiChannelCC.MultiChannelCCValues.individualEndpointCount.id, count);
}
__name(setIndividualEndpointCount, "setIndividualEndpointCount");
function setAggregatedEndpointCount(ctx, nodeId, count) {
  setValue(ctx, nodeId, import_MultiChannelCC.MultiChannelCCValues.aggregatedEndpointCount.id, count);
}
__name(setAggregatedEndpointCount, "setAggregatedEndpointCount");
function getEndpointIndizes(ctx, nodeId) {
  let ret = getValue(ctx, nodeId, import_MultiChannelCC.MultiChannelCCValues.endpointIndizes.id);
  if (!ret) {
    ret = [];
    for (let i = 1; i <= getEndpointCount(ctx, nodeId); i++) {
      ret.push(i);
    }
  }
  return ret;
}
__name(getEndpointIndizes, "getEndpointIndizes");
function setEndpointIndizes(ctx, nodeId, indizes) {
  setValue(ctx, nodeId, import_MultiChannelCC.MultiChannelCCValues.endpointIndizes.id, indizes);
}
__name(setEndpointIndizes, "setEndpointIndizes");
function isMultiChannelInterviewComplete(ctx, nodeId) {
  return !!getValue(ctx, nodeId, {
    commandClass: import_core.CommandClasses["Multi Channel"],
    endpoint: 0,
    property: "interviewComplete"
  });
}
__name(isMultiChannelInterviewComplete, "isMultiChannelInterviewComplete");
function setMultiChannelInterviewComplete(ctx, nodeId, complete) {
  setValue(ctx, nodeId, {
    commandClass: import_core.CommandClasses["Multi Channel"],
    endpoint: 0,
    property: "interviewComplete"
  }, complete);
}
__name(setMultiChannelInterviewComplete, "setMultiChannelInterviewComplete");
function getAllEndpoints(ctx, node) {
  const ret = [node];
  if (isMultiChannelInterviewComplete(ctx, node.nodeId)) {
    for (const i of getEndpointIndizes(ctx, node.nodeId)) {
      const endpoint = node.getEndpoint(i);
      if (endpoint)
        ret.push(endpoint);
    }
  }
  return ret;
}
__name(getAllEndpoints, "getAllEndpoints");
function shouldHideRootApplicationCCValues(ctx, nodeId) {
  const compatConfig = ctx.getDeviceConfig?.(nodeId)?.compat;
  if (compatConfig?.preserveRootApplicationCCValueIDs)
    return false;
  const endpointIndizes = getEndpointIndizes(ctx, nodeId);
  if (endpointIndizes.length === 0)
    return false;
  const preserveEndpoints = compatConfig?.preserveEndpoints;
  if (preserveEndpoints != void 0 && preserveEndpoints !== "*" && preserveEndpoints.length !== endpointIndizes.length) {
    return false;
  }
  return true;
}
__name(shouldHideRootApplicationCCValues, "shouldHideRootApplicationCCValues");
function translateValueID(ctx, endpoint, valueId) {
  const commandClassName = (0, import_core.getCCName)(valueId.commandClass);
  const ret = {
    commandClassName,
    ...valueId
  };
  const ccInstance = import_cc.CommandClass.createInstanceUnchecked(endpoint, valueId.commandClass);
  if (!ccInstance) {
    throw new import_core.ZWaveError(`Cannot translate a value ID for the non-implemented CC ${(0, import_core.getCCName)(valueId.commandClass)}`, import_core.ZWaveErrorCodes.CC_NotImplemented);
  }
  ret.propertyName = ccInstance.translateProperty(ctx, valueId.property, valueId.propertyKey);
  if (valueId.propertyKey != void 0) {
    const propertyKey = ccInstance.translatePropertyKey(ctx, valueId.property, valueId.propertyKey);
    ret.propertyKeyName = propertyKey;
  }
  return ret;
}
__name(translateValueID, "translateValueID");
function filterRootApplicationCCValueIDs(allValueIds) {
  const shouldHideRootValueID = /* @__PURE__ */ __name((valueId, allValueIds2) => {
    if (!!valueId.endpoint)
      return false;
    if (!import_core.applicationCCs.includes(valueId.commandClass))
      return false;
    const valueExistsOnAnotherEndpoint = allValueIds2.some((other) => (
      // same CC
      other.commandClass === valueId.commandClass && !!other.endpoint && other.property === valueId.property && other.propertyKey === valueId.propertyKey
    ));
    return valueExistsOnAnotherEndpoint;
  }, "shouldHideRootValueID");
  return allValueIds.filter((vid) => !shouldHideRootValueID(vid, allValueIds));
}
__name(filterRootApplicationCCValueIDs, "filterRootApplicationCCValueIDs");
function getDefinedValueIDs(ctx, node) {
  return getDefinedValueIDsInternal(ctx, node, false);
}
__name(getDefinedValueIDs, "getDefinedValueIDs");
function getDefinedValueIDsInternal(ctx, node, includeInternal = false) {
  if (node.id === ctx.ownNodeId)
    return [];
  let ret = [];
  const allowControlled = [
    import_core.CommandClasses["Scene Activation"]
  ];
  for (const endpoint of getAllEndpoints(ctx, node)) {
    for (const cc of import_core.allCCs) {
      if (
        // Create values only for supported CCs
        endpoint.supportsCC(cc) || endpoint.controlsCC(cc) && allowControlled.includes(cc) || cc === import_core.CommandClasses.Basic
      ) {
        const ccInstance = import_cc.CommandClass.createInstanceUnchecked(endpoint, cc);
        if (ccInstance) {
          ret.push(...ccInstance.getDefinedValueIDs(ctx, includeInternal));
        }
      }
    }
  }
  if (shouldHideRootApplicationCCValues(ctx, node.id)) {
    ret = filterRootApplicationCCValueIDs(ret);
  }
  return ret.map((id) => translateValueID(ctx, node, id));
}
__name(getDefinedValueIDsInternal, "getDefinedValueIDsInternal");
function getSupportedNotificationEvents(ctx, node) {
  const ret = [];
  const valueDB = ctx.getValueDB(node.id);
  for (const endpoint of getAllEndpoints(ctx, node)) {
    if (endpoint.supportsCC(import_core.CommandClasses["Entry Control"])) {
      const eventTypes = valueDB.getValue(import_cc.EntryControlCCValues.supportedEventTypes.endpoint(endpoint.index));
      if (eventTypes) {
        const capability = {
          commandClass: import_core.CommandClasses["Entry Control"],
          endpoint: endpoint.index,
          supportedEventTypes: Object.fromEntries(eventTypes.map((et) => [
            et,
            import_cc.entryControlEventTypeLabels[et]
          ]))
        };
        ret.push(capability);
      }
    }
    if (endpoint.supportsCC(import_core.CommandClasses.Notification)) {
      const notificationTypes = valueDB.getValue(import_cc.NotificationCCValues.supportedNotificationTypes.endpoint(endpoint.index)) ?? [];
      const capability = {
        commandClass: import_core.CommandClasses.Notification,
        endpoint: endpoint.index,
        supportedNotificationTypes: {}
      };
      let hasEvent = false;
      for (const notificationType of notificationTypes) {
        const notification = (0, import_core.getNotification)(notificationType);
        if (!notification)
          continue;
        const notificationEvents = valueDB.getValue(import_cc.NotificationCCValues.supportedNotificationEvents(notificationType).endpoint(endpoint.index))?.map((e) => notification.events.get(e)).filter((e) => e != void 0);
        if (!notificationEvents || notificationEvents.length === 0) {
          continue;
        }
        capability.supportedNotificationTypes[notificationType] = {
          label: notification.name,
          supportedEvents: Object.fromEntries(notificationEvents.map((e) => [e.value, e.label]))
        };
        hasEvent = true;
      }
      if (hasEvent)
        ret.push(capability);
    }
  }
  return ret;
}
__name(getSupportedNotificationEvents, "getSupportedNotificationEvents");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  endpointCountIsDynamic,
  endpointsHaveIdenticalCapabilities,
  filterRootApplicationCCValueIDs,
  getAggregatedEndpointCount,
  getAllEndpoints,
  getDefinedValueIDs,
  getDefinedValueIDsInternal,
  getEndpointCount,
  getEndpointIndizes,
  getIndividualEndpointCount,
  getSupportedNotificationEvents,
  isMultiChannelInterviewComplete,
  setAggregatedEndpointCount,
  setEndpointIndizes,
  setIndividualEndpointCount,
  setMultiChannelInterviewComplete,
  shouldHideRootApplicationCCValues,
  translateValueID
});
//# sourceMappingURL=utils.js.map
