"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var statistics_exports = {};
__export(statistics_exports, {
  compileStatistics: () => compileStatistics,
  sendStatistics: () => sendStatistics
});
module.exports = __toCommonJS(statistics_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_typeguards = require("alcalzone-shared/typeguards");
const apiToken = "ef58278d935ccb26307800279458484d";
const statisticsUrl = `https://stats.zwave-js.io/statistics`;
async function compileStatistics(driver, appInfo) {
  const salt = await driver.getUUID();
  const hashInput = import_shared.Bytes.from(driver.controller.homeId.toString(16) + salt);
  const hash = import_shared.Bytes.view(await (0, import_core.digest)("sha-256", hashInput)).toString("hex");
  return {
    id: hash,
    ...appInfo,
    devices: [...driver.controller.nodes.values()].map((node) => ({
      manufacturerId: node.manufacturerId != void 0 ? (0, import_shared.formatId)(node.manufacturerId) : "",
      productType: node.productType != void 0 ? (0, import_shared.formatId)(node.productType) : "",
      productId: node.productId != void 0 ? (0, import_shared.formatId)(node.productId) : "",
      firmwareVersion: node.firmwareVersion ?? ""
    }))
  };
}
__name(compileStatistics, "compileStatistics");
async function sendStatistics(statistics) {
  const { default: ky } = await import("ky");
  try {
    const data = await ky.post(statisticsUrl, {
      json: { data: [statistics] },
      headers: { "x-api-token": apiToken }
    }).json();
    if ((0, import_typeguards.isObject)(data) && typeof data.success === "boolean") {
      return data.success;
    }
    return false;
  } catch (e) {
    if ((0, import_typeguards.isObject)(e.response) && e.response.status === 429) {
      if ((0, import_typeguards.isObject)(e.response.headers) && "retry-after" in e.response.headers) {
        const retryAfter = parseInt(e.response.headers["retry-after"]);
        if (Number.isInteger(retryAfter))
          return retryAfter;
      }
    }
    return false;
  }
}
__name(sendStatistics, "sendStatistics");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  compileStatistics,
  sendStatistics
});
//# sourceMappingURL=statistics.js.map
