export function getDefaultHailHandlerStore() {
    return {
        busyPolling: false,
    };
}
/** Handles the receipt of a Hail */
export async function handleHail(ctx, node, _command, store) {
    // treat this as a sign that the node is awake
    node.markAsAwake();
    if (store.busyPolling) {
        ctx.logNode(node.id, {
            message: `Hail received from node, but still busy with previous one...`,
        });
        return;
    }
    ctx.logNode(node.id, {
        message: `Hail received from node, refreshing actuator and sensor values...`,
    });
    try {
        store.busyPolling = true;
        await node.refreshValues();
    }
    catch {
        // ignore
    }
    finally {
        store.busyPolling = false;
    }
}
//# sourceMappingURL=HailCC.js.map