import { ThermostatModeCCSet, ThermostatModeCCValues, } from "@zwave-js/cc";
/** Handles the receipt of a ThermostatModeCC Set */
export function handleThermostatModeCommand(ctx, node, command) {
    if (command instanceof ThermostatModeCCSet
        && node.deviceConfig?.compat?.treatSetAsReport?.has(command.constructor.name)) {
        ctx.logNode(node.id, {
            endpoint: command.endpointIndex,
            message: "treating ThermostatModeCC::Set as a report",
        });
        node.valueDB.setValue(ThermostatModeCCValues.thermostatMode.endpoint(command.endpointIndex), command.mode);
    }
}
//# sourceMappingURL=ThermostatModeCC.js.map