import { StateMachine, } from "@zwave-js/core";
function to(state) {
    return { newState: state };
}
export function createNodeReadyMachine() {
    const initialState = {
        value: "notReady",
        maybeDead: true,
    };
    const READY = { value: "ready", done: true };
    const transitions = (state) => (input) => {
        switch (state.value) {
            case "notReady": {
                switch (input.value) {
                    case "NOT_DEAD":
                        return to({ ...state, maybeDead: false });
                    case "MAYBE_DEAD":
                        return to({ ...state, maybeDead: true });
                    case "RESTART_FROM_CACHE":
                        if (state.maybeDead) {
                            return to({ value: "readyIfNotDead" });
                        }
                        else {
                            return to(READY);
                        }
                    case "INTERVIEW_DONE":
                        return to(READY);
                }
                break;
            }
            case "readyIfNotDead": {
                if (input.value === "NOT_DEAD")
                    return to(READY);
                break;
            }
        }
    };
    return new StateMachine(initialState, transitions);
}
//# sourceMappingURL=NodeReadyMachine.js.map